/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SizedIntegerDocument
extends PlainDocument {
    JTextField textField;
    long minVal;
    long maxVal;

    public SizedIntegerDocument(JTextField tf, int max) {
        this(tf, 0, max);
    }

    public SizedIntegerDocument(JTextField tf, int min, int max) {
        this(tf, (long)min, (long)max);
    }

    public SizedIntegerDocument(JTextField tf, long max) {
        this(tf, 0L, max);
    }

    public SizedIntegerDocument(JTextField tf, long min, long max) {
        this.textField = tf;
        this.minVal = min;
        this.maxVal = max;
    }

    public void setRange(long min, long max) {
        this.minVal = min;
        this.maxVal = max;
        if (this.textField.getText().trim().length() == 0) {
            return;
        }
        try {
            long longVal = Long.parseLong(this.textField.getText());
            if (longVal < this.minVal) {
                this.textField.setText(String.valueOf(this.minVal));
            } else if (longVal > this.maxVal) {
                this.textField.setText(String.valueOf(this.maxVal));
            }
        }
        catch (NumberFormatException e) {
            this.textField.setText(String.valueOf(this.minVal));
            return;
        }
    }

    public void setMin(long min) {
        this.minVal = min;
    }

    public void setMax(long max) {
        this.maxVal = max;
    }

    public void insertString(int offset, String s, AttributeSet aSet) throws BadLocationException {
        StringBuffer buf = new StringBuffer(this.textField.getText());
        buf.insert(offset, s);
        if (!buf.toString().equals("-") || this.minVal >= 0L) {
            try {
                long longVal = Long.parseLong(buf.toString());
                if (this.minVal != this.maxVal && (longVal < this.minVal || longVal > this.maxVal)) {
                    return;
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        super.insertString(offset, s, aSet);
    }
}

