/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.wbemservices.wbem.apps.common.LAYOUT_ALIGNMENT;
import org.wbemservices.wbem.apps.common.RowLayout;

public class ToolBarPanel
extends JPanel
implements MouseListener {
    private Vector icons;
    private Color bgColor;

    public ToolBarPanel() {
        this.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.bgColor = this.getBackground();
        this.icons = new Vector();
        this.barLayout();
    }

    public void addComponent(Component c) {
        this.icons.addElement(c);
        this.barLayout();
    }

    public void setBackground(Color c) {
        this.bgColor = c;
        super.setBackground(c);
    }

    public void barLayout() {
        this.removeAll();
        this.add(Box.createVerticalStrut(30));
        Enumeration e = this.icons.elements();
        while (e.hasMoreElements()) {
            this.add((Component)e.nextElement());
        }
        this.add(Box.createHorizontalGlue());
        this.invalidate();
        this.validate();
    }

    public JButton createButton(Icon i, String tt, ActionListener al) {
        return this.createButton(i, tt, tt, al);
    }

    public JButton createButton(Icon i, String tt, String ac, ActionListener al) {
        JButton newButton = new JButton(i);
        newButton.setToolTipText(tt);
        newButton.setActionCommand(ac);
        newButton.addActionListener(al);
        this.addButton(newButton);
        return newButton;
    }

    public void addButton(JButton newButton) {
        newButton.setBorderPainted(false);
        newButton.setBackground(this.bgColor);
        newButton.addMouseListener(this);
        this.addComponent(newButton);
    }

    public JLabel createLabel(String text) {
        JLabel addMe = new JLabel(text);
        this.addLabel(addMe);
        return addMe;
    }

    public JLabel createLabel(Icon i) {
        JLabel addMe = new JLabel(i);
        this.addLabel(addMe);
        return addMe;
    }

    public void addLabel(JLabel l) {
        this.addComponent(l);
    }

    public void createSpace(int space) {
        this.addComponent(Box.createHorizontalStrut(space));
    }

    public void mouseEntered(MouseEvent evt) {
        Component c = evt.getComponent();
        if (c instanceof JButton) {
            ((JButton)c).setBorderPainted(true);
        }
    }

    public void mouseExited(MouseEvent evt) {
        Component c = evt.getComponent();
        if (c instanceof JButton) {
            ((JButton)c).setBorderPainted(false);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }
}

