/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMObjectPath;

public class Util {
    public static final Cursor waitCursor = new Cursor(3);
    public static final Cursor defaultCursor = new Cursor(0);
    private static URLClassLoader urlCL = null;
    static /* synthetic */ Class class$java$awt$Window;

    public static void setClassLoader(URLClassLoader cl) {
        urlCL = cl;
    }

    public static URLClassLoader getClassLoader() {
        return urlCL;
    }

    public static void positionWindow(Window w, Component parent) {
        Point wloc;
        Dimension psize;
        Point ploc;
        if (w == null) {
            return;
        }
        Window pw = (Window)Util.findParentOfType(parent, class$java$awt$Window == null ? (class$java$awt$Window = Util.class$("java.awt.Window")) : class$java$awt$Window);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (pw == null && parent == null) {
            ploc = new Point(0, 0);
            psize = screen;
        } else if (pw == null) {
            ploc = parent.getLocationOnScreen();
            psize = parent.getSize();
        } else {
            ploc = pw.getLocation();
            psize = pw.getSize();
        }
        Dimension wsize = w.getSize();
        int almost = 50;
        if (psize.width - almost >= wsize.width || psize.height - almost >= wsize.height) {
            ploc.x += psize.width / 2;
            ploc.y += psize.height / 2;
            wloc = new Point();
            wloc.x = ploc.x - wsize.width / 2;
            wloc.y = ploc.y - wsize.height / 2;
            if (wloc.x + wsize.width > screen.width) {
                wloc.x = screen.width - wsize.width;
            }
            if (wloc.y + wsize.height > screen.height) {
                wloc.y = screen.height - wsize.height;
            }
            if (wloc.x < 0) {
                wloc.x = 0;
            }
            if (wloc.y < 0) {
                wloc.y = 0;
            }
        } else {
            int offset = 30;
            wloc = new Point();
            wloc.x = ploc.x + offset;
            wloc.y = ploc.y + offset;
            if (wloc.x + wsize.width > screen.width) {
                wloc.x -= screen.width - wsize.width;
            }
            if (wloc.y + wsize.height > screen.height) {
                wloc.y -= screen.height - wsize.height;
            }
        }
        w.setLocation(wloc);
    }

    public static boolean isPopupTrigger(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            return true;
        }
        return (evt.getModifiers() & 4) > 0;
    }

    public static String createURLString(String urlstring) {
        char fs = System.getProperty("file.separator").charAt(0);
        StringBuffer sb = new StringBuffer("file:");
        sb.append(urlstring);
        String retval = sb.toString();
        if (fs != '/') {
            retval = retval.replace('/', fs);
        }
        return retval;
    }

    public static Enumeration sortEnumeration(Enumeration enumeration) {
        Vector list = Util.enumToVector(enumeration);
        Util.sortVector(list);
        return list.elements();
    }

    public static void sortVector(Vector list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return obj1.toString().compareToIgnoreCase(obj2.toString());
            }
        });
    }

    public static Object findParentOfType(Component c, Class type) {
        if (c == null) {
            return null;
        }
        if (type.isInstance(c)) {
            return c;
        }
        return Util.findParentOfType(c.getParent(), type);
    }

    public static void setCursor(Component component, Cursor cursor) {
        Util.getWindow(component).setCursor(cursor);
    }

    public static void setWaitCursor(Component c) {
        Util.getWindow(c).setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setDefaultCursor(Component c) {
        Util.getWindow(c).setCursor(Cursor.getPredefinedCursor(0));
    }

    public static Window getWindow(Component component) {
        Component c = component;
        if (c instanceof Window) {
            return (Window)c;
        }
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Window)) continue;
            return (Window)c;
        }
        return new Window(Util.getFrame(component));
    }

    public static Frame getFrame(Component component) {
        Component c = component;
        if (c instanceof Frame) {
            return (Frame)c;
        }
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return new Frame();
    }

    public static Vector enumToVector(Enumeration e) {
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return v;
    }

    public static ArrayList enumToList(Enumeration e) {
        ArrayList list = new ArrayList();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    public static Point getCenterPoint(Component parent, Component child) {
        Point p = new Point();
        Rectangle parentRect = parent.getBounds();
        Rectangle childRect = child.getBounds();
        p.x = parentRect.x + parentRect.width / 2 - childRect.width / 2;
        p.y = parentRect.y + parentRect.height / 2 - childRect.height / 2;
        return p;
    }

    public static String wrapText(String textString, int numColumns) {
        String NEWLINE = "\n";
        StringTokenizer stringTokenizer = new StringTokenizer(textString, " \t\n", true);
        StringBuffer buff = new StringBuffer();
        int stringLength = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String word = stringTokenizer.nextToken();
            if (word.equals(NEWLINE)) {
                stringLength = 0;
            } else if (stringLength + word.length() > numColumns) {
                buff.append(NEWLINE);
                stringLength = 0;
            }
            if (word.equals(" ") && buff.toString().endsWith(NEWLINE)) continue;
            buff.append(word);
            stringLength += word.length();
        }
        return buff.toString();
    }

    public static String wrapText(String textString) {
        return Util.wrapText(textString, 40);
    }

    public static ImageIcon loadImageIcon(String filename) {
        return Util.loadImageIcon(filename, "");
    }

    public static ImageIcon loadImageIcon(String filename, String description) {
        if (urlCL != null) {
            URL url = urlCL.findResource("org/wbemservices/wbem/apps/images/" + filename);
            return new ImageIcon(url, description);
        }
        return null;
    }

    public static CIMObjectPath getRelativeObjectPath(CIMObjectPath op) {
        CIMObjectPath relOP = new CIMObjectPath();
        if (op == null) {
            return null;
        }
        relOP.setObjectName(op.getObjectName());
        relOP.setKeys(op.getKeys());
        return relOP;
    }

    public static String getDataTypeString(CIMDataType cdt) {
        StringBuffer buff = new StringBuffer(cdt.toString());
        if (cdt.isArrayType()) {
            buff.append("[]");
        }
        return buff.toString();
    }

    public static String cleanNameSpaceString(String nsString) {
        CIMObjectPath op = new CIMObjectPath("", nsString);
        String nSpace = op.getNameSpace();
        if (nSpace.startsWith("//") || nSpace.startsWith("\\\\")) {
            nSpace = nSpace.substring(2);
        } else if (nSpace.startsWith("/") || nSpace.startsWith("\\")) {
            nSpace = nSpace.substring(1);
        }
        return '/' + nSpace;
    }

    public static void waitOn(Component c) {
        Component rootPane = SwingUtilities.getRoot(c);
        rootPane.setEnabled(false);
        rootPane.setCursor(waitCursor);
    }

    public static void waitOff(Component c) {
        Component rootPane = SwingUtilities.getRoot(c);
        rootPane.setEnabled(true);
        rootPane.setCursor(defaultCursor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

