/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.apps.common;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumField
extends JTextField {
    public Toolkit toolkit;
    public WholeNumField wholeNumField = this;
    public int numCols;
    public int maxVal;
    public boolean integerField = false;

    public WholeNumField(int defVal, int numCols) {
        this(defVal, numCols, Integer.MAX_VALUE);
    }

    public WholeNumField(int defVal, int numCols, int maxVal) {
        super(numCols);
        this.wholeNumField.numCols = numCols;
        this.wholeNumField.maxVal = maxVal;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.setValue(defVal);
    }

    public WholeNumField(int defVal, int numCols, int maxVal, boolean intDocument) {
        super(numCols);
        this.wholeNumField.integerField = intDocument;
        this.wholeNumField.numCols = numCols;
        this.wholeNumField.maxVal = maxVal;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.setValue(defVal);
    }

    public void setValue(int value) {
        this.setText("");
        if (value >= 0 && (this.wholeNumField.maxVal < 0 || this.wholeNumField.maxVal >= 0 && value <= this.wholeNumField.maxVal)) {
            String strVal = new Integer(value).toString();
            this.setText(strVal);
        }
    }

    public int getValue() {
        String current = this.getText();
        if (current.length() > 0) {
            Integer i = new Integer(current);
            int returnVal = i;
            return returnVal;
        }
        return -1;
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    class WholeNumberDocument
    extends PlainDocument {
        WholeNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i]) || WholeNumField.this.wholeNumField.integerField && i == 0 && source[i] == '-') {
                    result[j++] = source[i];
                    continue;
                }
                WholeNumField.this.toolkit.beep();
            }
            String newVal = WholeNumField.this.wholeNumField.getText().substring(0, offs);
            newVal = newVal + new String(result, 0, j);
            if ((newVal = newVal + WholeNumField.this.wholeNumField.getText().substring(offs)).length() > 0) {
                Integer newInteger;
                try {
                    newInteger = new Integer(newVal);
                }
                catch (NumberFormatException nfe) {
                    WholeNumField.this.toolkit.beep();
                    return;
                }
                if (WholeNumField.this.wholeNumField.maxVal == -1 || WholeNumField.this.wholeNumField.maxVal >= 0 && newInteger <= WholeNumField.this.wholeNumField.maxVal) {
                    super.insertString(offs, new String(result, 0, j), a);
                } else {
                    WholeNumField.this.toolkit.beep();
                }
            }
        }
    }
}

