/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMInstanceException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMInstanceRlogEntry;
import org.wbemservices.wbem.repository.CIMNameSpaceRlogEntry;
import org.wbemservices.wbem.repository.InstanceNameUtils;
import org.wbemservices.wbem.repository.PSRlogImpl;

class CIMAssocInstanceRlogEntry
extends CIMInstanceRlogEntry {
    private static final long serialVersionUID = -2882512481198693722L;
    private CIMObjectPath sp;
    private AssocInsRole[] roles = new AssocInsRole[0];

    public CIMAssocInstanceRlogEntry(CIMNameSpaceRlogEntry nsentry, String name) {
        super(nsentry, name);
    }

    public void createAssciations(CIMInstance ci) throws CIMException {
        this.sp = new CIMObjectPath(ci.getClassName(), ci.getKeys());
        this.sp.setNameSpace(this.nsentry.getName());
        this.roles = this.createAssociationInsPropList(ci);
    }

    private AssocInsRole[] createAssociationInsPropList(CIMInstance ci) throws CIMException {
        ArrayList<AssocInsRole> v = new ArrayList<AssocInsRole>();
        try {
            Enumeration e = ci.getProperties().elements();
            while (e.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)e.nextElement();
                CIMValue cv = pe.getValue();
                if (!pe.isReference()) continue;
                if (cv == null || cv.getValue() == null) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)pe);
                }
                Object op = cv.getValue();
                if (!(op instanceof CIMObjectPath)) continue;
                String ccstr = ((CIMObjectPath)op).getObjectName();
                String ns = ((CIMObjectPath)op).getNameSpace();
                if (ns.charAt(0) != '/') {
                    ns = '/' + ns;
                }
                CIMNameSpaceRlogEntry nsentryTMP = PSRlogImpl.getNameSpaceEntryFromMap(ns);
                CIMClassRlogEntry cctemp = nsentryTMP.getClass(ccstr);
                CIMClass cc = (CIMClass)PSRlogImpl.deserialize(cctemp.getValue());
                CIMInstance nci = cc.newInstance();
                nci.updatePropertyValues(((CIMObjectPath)op).getKeys());
                v.add(new AssocInsRole(cctemp, InstanceNameUtils.getInstanceNameKey(nci), pe.getName(), (CIMObjectPath)op));
            }
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e.toString());
        }
        AssocInsRole[] arr = new AssocInsRole[v.size()];
        v.toArray(arr);
        return arr;
    }

    public void validateInstanceAssociations() throws CIMException {
        for (int i = 0; i < this.roles.length; ++i) {
            CIMInstanceRlogEntry citemp = this.roles[i].ccentry.getInstance(this.roles[i].ci);
            if (citemp != null) continue;
            throw new CIMInstanceException("CIM_ERR_NOT_FOUND", (Object)this.roles[i].ci);
        }
    }

    public void addInstanceAssociations(String assoc, CIMAssocInstanceRlogEntry ciref) throws CIMException {
        this.validateInstanceAssociations();
        for (int i = 0; i < this.roles.length; ++i) {
            CIMInstanceRlogEntry citemp = this.roles[i].ccentry.getInstance(this.roles[i].ci);
            citemp.addAssociations(assoc, ciref);
        }
    }

    public void removeInstanceAssociations(String assoc, String iname) throws CIMException {
        this.validateInstanceAssociations();
        for (int i = 0; i < this.roles.length; ++i) {
            CIMInstanceRlogEntry citemp = this.roles[i].ccentry.getInstance(this.roles[i].ci);
            citemp.removeAssociations(assoc, iname);
        }
    }

    public CIMObjectPath matchAssociator(String iname, String role, String resultRole) {
        boolean roleMatch = false;
        boolean resultRoleMatch = false;
        if (resultRole == null || resultRole.length() == 0) {
            resultRoleMatch = true;
        }
        for (int i = 0; i < this.roles.length; ++i) {
            if (!roleMatch && this.roles[i].ci.equals(iname)) {
                if (role == null || role.length() == 0) {
                    roleMatch = true;
                }
                if (!roleMatch && this.roles[i].role.equalsIgnoreCase(role)) {
                    roleMatch = true;
                }
            }
            if (resultRoleMatch || !this.roles[i].role.equalsIgnoreCase(resultRole)) continue;
            resultRoleMatch = true;
        }
        if (roleMatch && resultRoleMatch) {
            CIMObjectPath tempOp = new CIMObjectPath(this.sp.getObjectName(), this.sp.getNameSpace());
            tempOp.setKeys(this.sp.getKeys());
            return tempOp;
        }
        return null;
    }

    public ArrayList matchRole(String iname, String role, String resultRole) {
        ArrayList<CIMObjectPath> v = new ArrayList<CIMObjectPath>();
        ArrayList<String> arr = new ArrayList<String>();
        boolean isReflective = false;
        boolean match = false;
        boolean rolematch = false;
        for (int k = 0; k < this.roles.length; ++k) {
            if (!this.roles[k].ci.equals(iname)) continue;
            if (role != null && role.length() != 0) {
                if (this.roles[k].role.equalsIgnoreCase(role)) {
                    rolematch = true;
                }
            } else {
                rolematch = true;
            }
            if (match) {
                isReflective = true;
            }
            match = true;
        }
        if (!match || !rolematch) {
            return v;
        }
        match = false;
        for (int i = 0; i < this.roles.length; ++i) {
            if (!isReflective && this.roles[i].ci.equals(iname) || resultRole != null && resultRole.length() != 0 && !this.roles[i].role.equalsIgnoreCase(resultRole)) continue;
            boolean exist = false;
            for (int k = 0; k < arr.size(); ++k) {
                if (!this.roles[i].ci.equals(arr.get(k))) continue;
                exist = true;
            }
            if (exist) continue;
            arr.add(this.roles[i].ci);
            v.add(this.roles[i].op);
        }
        return v;
    }

    private static class AssocInsRole
    implements Serializable {
        public CIMClassRlogEntry ccentry;
        public String ci;
        public String role;
        public CIMObjectPath op;

        public AssocInsRole(CIMClassRlogEntry ccentry, String ci, String role, CIMObjectPath op) {
            this.ccentry = ccentry;
            this.ci = ci;
            this.role = role;
            this.op = op;
        }
    }
}

