/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMQualifierTypeRlogEntry;
import org.wbemservices.wbem.repository.CIMRlogEntry;

class CIMNameSpaceRlogEntry
extends CIMRlogEntry {
    private static final long serialVersionUID = 8598716484732411839L;
    private HashMap subnspaces = new HashMap();
    private HashMap qualifiers = new HashMap();
    private HashMap classes = new HashMap();

    public CIMNameSpaceRlogEntry(String namespace) {
        super(namespace);
    }

    public Collection getSubNameSpaceCollection() {
        return this.subnspaces.values();
    }

    public Collection getQualifierCollection() {
        return this.qualifiers.values();
    }

    public Collection getClassCollection() {
        return this.classes.values();
    }

    public void addSubNameSpace(CIMNameSpaceRlogEntry nsentry) {
        this.subnspaces.put(nsentry.getNameKey(), nsentry);
    }

    public CIMNameSpaceRlogEntry removeSubNameSpace(String name) {
        return (CIMNameSpaceRlogEntry)this.subnspaces.remove(CIMRlogEntry.toNameKey(name));
    }

    public CIMNameSpaceRlogEntry getSubNameSpace(String name) {
        return (CIMNameSpaceRlogEntry)this.subnspaces.get(CIMRlogEntry.toNameKey(name));
    }

    public void addQualifierType(CIMQualifierTypeRlogEntry qtentry) {
        this.qualifiers.put(qtentry.getNameKey(), qtentry);
    }

    public CIMQualifierTypeRlogEntry removeQualifierType(String name) {
        CIMQualifierTypeRlogEntry qtentry = (CIMQualifierTypeRlogEntry)this.qualifiers.remove(CIMRlogEntry.toNameKey(name));
        qtentry.delete();
        return qtentry;
    }

    public CIMQualifierTypeRlogEntry getQualifierType(String name) {
        return (CIMQualifierTypeRlogEntry)this.qualifiers.get(CIMRlogEntry.toNameKey(name));
    }

    public void addClass(CIMClassRlogEntry cc) {
        this.classes.put(cc.getNameKey(), cc);
    }

    public CIMClassRlogEntry removeClass(String name) {
        CIMClassRlogEntry ccentry = (CIMClassRlogEntry)this.classes.remove(CIMRlogEntry.toNameKey(name));
        ccentry.delete();
        return ccentry;
    }

    public CIMClassRlogEntry getClass(String name) {
        return (CIMClassRlogEntry)this.classes.get(CIMRlogEntry.toNameKey(name));
    }

    public void delete() {
        this.deleteEntries(this.classes);
        this.deleteEntries(this.qualifiers);
    }

    private void deleteEntries(HashMap map) {
        Collection c = map.values();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            CIMRlogEntry entry = (CIMRlogEntry)iter.next();
            if (entry instanceof CIMClassRlogEntry && entry.getName().equals("top")) continue;
            entry.delete();
        }
    }
}

