/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.Debug;
import javax.wbem.query.SelectExp;
import org.wbemservices.wbem.cimom.EventService;
import org.wbemservices.wbem.cimom.ReadersWriter;

public class EventHelper {
    public static boolean verbose = false;
    private Map classIndicationMap = Collections.synchronizedMap(new HashMap());
    private ReadersWriter concurrentObj;
    Set additionTriggerSet = new TreeSet();
    Set deletionTriggerSet = new TreeSet();
    Set modificationTriggerSet = new TreeSet();

    public EventHelper(ReadersWriter concurrentObj) {
        this.concurrentObj = concurrentObj;
    }

    public void classCreation(String namespace, CIMClass cc) {
        try {
            if (this.classIndicationMap.get(namespace + "::" + "cim_classcreation") != null) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName("cim_classcreation");
                CIMProperty cp = new CIMProperty();
                cp.setName("ClassDefinition");
                cp.setValue(new CIMValue((Object)cc));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                cp = new CIMProperty();
                cp.setName("IndicationTime");
                cp.setType(CIMDataType.getPredefinedType((int)12));
                v.addElement(cp);
                indication.setProperties(v);
                EventService.eventService.deliverEvent(namespace, indication);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("classCreation Event Exception:\n" + e.getMessage()));
        }
    }

    public void classDeletion(String namespace, CIMClass cc) {
        try {
            if (this.classIndicationMap.get(namespace + "::" + "cim_classdeletion") != null) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName("cim_classdeletion");
                CIMProperty cp = new CIMProperty();
                cp.setName("ClassDefinition");
                cp.setValue(new CIMValue((Object)cc));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                cp = new CIMProperty();
                cp.setName("IndicationTime");
                cp.setType(CIMDataType.getPredefinedType((int)12));
                v.addElement(cp);
                indication.setProperties(v);
                EventService.eventService.deliverEvent(namespace, indication);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("classDeletion Event Exception:\n" + e.getMessage()));
        }
    }

    public void classModification(String namespace, CIMClass oldcc, CIMClass cc) {
        try {
            if (this.classIndicationMap.get(namespace + "::" + "cim_classmodification") != null) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName("cim_classmodification");
                CIMProperty cp = new CIMProperty();
                cp.setName("ClassDefinition");
                cp.setValue(new CIMValue((Object)cc));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                cp = new CIMProperty();
                cp.setName("IndicationTime");
                cp.setType(CIMDataType.getPredefinedType((int)12));
                v.addElement(cp);
                cp = new CIMProperty();
                cp.setName("PreviousClassDefinition");
                cp.setValue(new CIMValue((Object)oldcc));
                v.addElement(cp);
                indication.setProperties(v);
                EventService.eventService.deliverEvent(namespace, indication);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("classModification Event Exception:\n" + e.getMessage()));
        }
    }

    public void instanceRead(String namespace, CIMInstance ci) {
        try {
            if (ci != null && this.classIndicationMap.get(namespace + ":" + ci.getClassName().toLowerCase() + ":" + "cim_instread") != null) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName("cim_instread");
                CIMProperty cp = new CIMProperty();
                cp.setName("SourceInstance");
                cp.setValue(new CIMValue((Object)ci));
                cp.setType(CIMDataType.getPredefinedType((int)8));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                indication.setProperties(v);
                EventService.eventService.deliverEvent(namespace, indication);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("instanceRead Event Exception:\n" + e.getMessage()));
        }
    }

    public void instanceEnumerate(CIMObjectPath op, final Vector instanceList) {
        try {
            final String localns = op.getNameSpace().toLowerCase();
            if (this.classIndicationMap.get(localns + ":" + op.getObjectName().toLowerCase() + ":" + "cim_instread") != null) {
                new Thread(){

                    public void run() {
                        Enumeration e1 = instanceList.elements();
                        while (e1.hasMoreElements()) {
                            CIMInstance ci = (CIMInstance)e1.nextElement();
                            EventHelper.this.instanceRead(localns, ci);
                        }
                    }
                }.start();
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("instanceEnumerate Event Exception:\n" + e.getMessage()));
        }
    }

    public void instanceAddition(String namespace, CIMInstance ci) {
        try {
            if (this.additionTriggerSet.contains(namespace + ":" + ci.getClassName().toLowerCase())) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName("cim_instcreation");
                CIMProperty cp = new CIMProperty();
                cp.setName("SourceInstance");
                cp.setValue(new CIMValue((Object)ci));
                cp.setType(CIMDataType.getPredefinedType((int)8));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                indication.setProperties(v);
                EventService.eventService.deliverEvent(namespace, indication);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("instanceAddition Event Exception:\n" + e.getMessage()));
        }
    }

    public void instanceDeletion(String namespace, CIMInstance ci) {
        try {
            if (this.deletionTriggerSet.contains(namespace + ":" + ci.getClassName().toLowerCase())) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName("cim_instdeletion");
                CIMProperty cp = new CIMProperty();
                cp.setName("SourceInstance");
                cp.setValue(new CIMValue((Object)ci));
                cp.setType(CIMDataType.getPredefinedType((int)8));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                indication.setProperties(v);
                EventService.eventService.deliverEvent(namespace, indication);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("instanceDeletion Event Exception:\n" + e.getMessage()));
        }
    }

    public void instanceModification(String namespace, CIMInstance oldci, CIMInstance ci) {
        try {
            if (this.modificationTriggerSet.contains(namespace + ":" + ci.getClassName().toLowerCase())) {
                CIMInstance indication = new CIMInstance();
                indication.setClassName("cim_instmodification");
                CIMProperty cp = new CIMProperty();
                cp.setName("SourceInstance");
                cp.setValue(new CIMValue((Object)ci));
                cp.setType(CIMDataType.getPredefinedType((int)8));
                Vector<CIMProperty> v = new Vector<CIMProperty>();
                v.addElement(cp);
                cp = new CIMProperty();
                cp.setName("PreviousInstance");
                cp.setValue(new CIMValue((Object)oldci));
                cp.setType(CIMDataType.getPredefinedType((int)8));
                v.addElement(cp);
                indication.setProperties(v);
                EventService.eventService.deliverEvent(namespace, indication);
            }
        }
        catch (Exception e) {
            Debug.trace2((String)("instanceModification Event Exception:\n" + e.getMessage()));
        }
    }

    public void additionTriggerActivate(String namespace, String className) {
        this.concurrentObj.writeLock();
        this.additionTriggerSet.add(namespace + ":" + className);
        this.concurrentObj.writeUnlock();
    }

    public void deletionTriggerActivate(String namespace, String className) {
        this.concurrentObj.writeLock();
        this.deletionTriggerSet.add(namespace + ":" + className);
        this.concurrentObj.writeUnlock();
    }

    public void modificationTriggerActivate(String namespace, String className) {
        this.concurrentObj.writeLock();
        this.modificationTriggerSet.add(namespace + ":" + className);
        this.concurrentObj.writeUnlock();
    }

    public void additionTriggerDeActivate(String namespace, String className) {
        this.concurrentObj.writeLock();
        this.additionTriggerSet.remove(namespace + ":" + className);
        this.concurrentObj.writeUnlock();
    }

    public void deletionTriggerDeActivate(String namespace, String className) {
        this.concurrentObj.writeLock();
        this.deletionTriggerSet.remove(namespace + ":" + className);
        this.concurrentObj.writeUnlock();
    }

    public void modificationTriggerDeActivate(String namespace, String className) {
        this.concurrentObj.writeLock();
        this.modificationTriggerSet.remove(namespace + ":" + className);
        this.concurrentObj.writeUnlock();
    }

    public void authorizeFilter(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) throws CIMException {
    }

    public boolean mustPoll(SelectExp filter, String eventType, CIMObjectPath classPath) throws CIMException {
        return false;
    }

    public void activateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean firstActivation) throws CIMException {
        if (firstActivation) {
            this.classIndicationMap.put(classPath.getNameSpace() + ":" + classPath.getObjectName().toLowerCase() + ":" + eventType, "");
        }
    }

    public void deActivateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean lastActivation) throws CIMException {
        if (lastActivation) {
            this.classIndicationMap.remove(classPath.getNameSpace() + ":" + classPath.getObjectName() + ":" + eventType);
        }
    }
}

