/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class InstanceNameUtils {
    public static String getNameForElement(CIMElement element) {
        if (element instanceof CIMInstance) {
            return InstanceNameUtils.getInstanceNameKey((CIMInstance)element);
        }
        return element.getName();
    }

    static String getInstanceNameKey(CIMInstance ci) {
        String name = ci.getClassName().toLowerCase();
        Enumeration e = ci.getProperties().elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (!pe.isKey() || pe.getOverridingProperty() != null) continue;
            CIMValue cv = pe.getValue();
            if (cv == null) {
                name = name.concat(":" + pe.getName().toLowerCase() + "=null");
                continue;
            }
            name = name.concat(":" + pe.getName().toLowerCase() + "=" + InstanceNameUtils.toString(cv));
        }
        return name;
    }

    private static String toString(CIMValue cv) {
        String s = "null";
        Object o = cv.getValue();
        if (o != null) {
            if (cv.isArrayValue()) {
                throw new IllegalArgumentException(o.toString());
            }
            String q = "";
            if (new CIMDataType(8).equals((Object)cv.getType())) {
                q = "\"";
            }
            s = q + InstanceNameUtils.values(o) + q;
        }
        return s;
    }

    private static String values(Object o) {
        if (o instanceof CIMObjectPath) {
            return InstanceNameUtils.toString((CIMObjectPath)o);
        }
        if (o instanceof CIMDateTime) {
            return InstanceNameUtils.toString((CIMDateTime)o);
        }
        if (o instanceof CIMInstance) {
            throw new IllegalArgumentException(o.toString());
        }
        return o.toString();
    }

    private static String toString(CIMDateTime cdt) {
        return cdt.toString();
    }

    private static String toString(CIMObjectPath op) {
        Vector keys = op.getKeys();
        String nameSpace = op.getNameSpace();
        String objectName = op.getObjectName();
        if (keys == null || keys.size() == 0) {
            if (objectName != null && objectName.length() != 0) {
                return nameSpace + '/' + objectName;
            }
            return nameSpace;
        }
        String s = "";
        int i = 0;
        Enumeration e = keys.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (pe == null) continue;
            s = s + pe.getName().toLowerCase() + "=" + InstanceNameUtils.toString(pe.getValue()) + ":";
            ++i;
        }
        if (i > 0) {
            return nameSpace + '/' + objectName + ":" + s.substring(0, s.lastIndexOf(":"));
        }
        return nameSpace + '/' + objectName;
    }
}

