/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.io.IOException;
import java.io.InputStream;
import org.wbemservices.wbem.repository.LogException;

public class LogInputStream
extends InputStream {
    private InputStream in;
    private int length;

    public LogInputStream(InputStream in, int length) throws IOException {
        this.in = in;
        this.length = length;
    }

    private void badRead(int numBytes) throws LogException {
        throw new LogException("length=" + String.valueOf(this.length) + ", numBytes=" + String.valueOf(numBytes));
    }

    public int read() throws IOException, LogException {
        if (this.length < 1) {
            this.badRead(1);
        }
        --this.length;
        return this.in.read();
    }

    public int read(byte[] b) throws IOException, LogException {
        if (this.length < b.length) {
            this.badRead(b.length);
        }
        int len = this.in.read(b);
        this.length -= len;
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException, LogException {
        if (this.length < len) {
            this.badRead(len);
        }
        len = this.in.read(b, off, len);
        this.length -= len;
        return len;
    }

    public long skip(long n) throws IOException, LogException {
        if ((long)this.length < n) {
            this.badRead((int)n);
        }
        n = this.in.skip(n);
        this.length -= (int)n;
        return n;
    }

    public int available() {
        return this.length;
    }

    public void close() {
        this.length = 0;
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

