/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.ConnectionTimer;
import javax.wbem.client.adapter.http.transport.Executor;
import javax.wbem.client.adapter.http.transport.GetThreadPoolAction;
import javax.wbem.client.adapter.http.transport.HttpServerConnection;
import javax.wbem.client.adapter.http.transport.HttpSettings;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import javax.wbem.client.adapter.http.transport.ServerEndpointListener;

public final class HttpServerEndpoint {
    private static final String HTTP_PORT = "HTTP_PORT";
    private static final String SIMULATED_CIMOM_PROPERTIES = "san_simulator_cimom.properties";
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction());
    private static final ConnectionTimer connTimer;
    private final String h;
    private int p;
    private boolean useSSL = false;

    static {
        HttpSettings hs = HttpSettings.getHttpSettings();
        connTimer = new ConnectionTimer(hs.getConnectionTimeout(15000L));
    }

    public HttpServerEndpoint(String host, int port) {
        this(host, port, false);
    }

    public HttpServerEndpoint(String host, int port, boolean ssl) {
        this.useSSL = ssl;
        if (this.useSSL) {
            Debug.trace3("HttpServerEndpoint: using SSL");
        }
        if (host == null) {
            throw new NullPointerException();
        }
        Properties sanSimulatorProp = new Properties();
        String httpPort = new Integer(port).toString();
        this.h = host;
        try {
            String installationPath = System.getProperty("propdir");
            sanSimulatorProp.load(new FileInputStream(String.valueOf(installationPath) + File.separator + SIMULATED_CIMOM_PROPERTIES));
            httpPort = sanSimulatorProp.getProperty(HTTP_PORT);
            this.p = Integer.parseInt(httpPort);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.p = port;
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port number out of range: " + port);
        }
        System.out.println("Port number set to : " + this.p);
    }

    public String getHost() {
        return this.h;
    }

    public int getPort() {
        return this.p;
    }

    public ServerEndpointListener listen(RequestHandler handler) throws IOException {
        ServerSocket ssock;
        if (handler == null) {
            throw new NullPointerException();
        }
        if (this.useSSL) {
            ServerSocketFactory ssf = SSLServerSocketFactory.getDefault();
            ssock = ssf.createServerSocket(this.p);
        } else {
            ssock = new ServerSocket(this.p);
        }
        Listener listener = new Listener(handler, ssock);
        systemThreadPool.execute(listener, "HttpServerEndpoint Accept (port " + this.p + ")");
        return listener;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HttpServerEndpoint) {
            HttpServerEndpoint other = (HttpServerEndpoint)obj;
            return this.h.equals(other.h) && this.p == other.p;
        }
        return false;
    }

    public String toString() {
        return "HttpServerEndpoint[" + this.h + ":" + this.p + "]";
    }

    private final class Listener
    implements Runnable,
    ServerEndpointListener {
        private final RequestHandler handler;
        private final ServerSocket ssock;
        private boolean closed = false;
        private final Set connections = new HashSet(5);

        private Listener(RequestHandler handler, ServerSocket ssock) {
            this.handler = handler;
            this.ssock = ssock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object[] conns;
            Set set = this.connections;
            synchronized (set) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                conns = this.connections.toArray();
            }
            try {
                this.ssock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int i = 0;
            while (i < conns.length) {
                ((Connection)conns[i]).shutdown(true);
                ++i;
            }
        }

        public void run() {
            this.executeAcceptLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void executeAcceptLoop() {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    sock = this.ssock.accept();
                    try {
                        sock.setTcpNoDelay(true);
                    }
                    catch (SocketException var2_4) {
                        // empty catch block
                    }
                    try {
                        sock.setKeepAlive(true);
                    }
                    catch (SocketException var2_5) {
                        // empty catch block
                    }
                    var2_3 = this.connections;
                    synchronized (var2_3) {
                        if (this.closed) {
                            try {
                                sock.close();
                            }
                            catch (IOException var3_6) {}
                        } else {
                            this.connections.add(new Connection(sock, this.handler, this));
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable th) {}
            {
                return;
            }
            {
                ** while (true)
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connectionClosed(Connection conn) {
            Set set = this.connections;
            synchronized (set) {
                this.connections.remove(conn);
            }
        }

        public int getLocalPort() {
            return this.ssock.getLocalPort();
        }
    }

    private final class Connection
    extends HttpServerConnection {
        Listener listener;

        Connection(Socket sock, RequestHandler handler, Listener listener) throws IOException {
            super(sock, handler);
            this.listener = listener;
            this.start();
        }

        protected void checkPermissions() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                String host = this.sock.getInetAddress().getHostAddress();
                sm.checkAccept(host, this.sock.getPort());
            }
        }

        protected String getClientHost() {
            InetAddress addr = this.sock.getInetAddress();
            return addr != null ? addr.getHostAddress() : "0.0.0.0";
        }

        protected void idle() {
            connTimer.scheduleTimeout(this, false);
        }

        protected void busy() {
            connTimer.cancelTimeout(this);
        }

        public boolean shutdown(boolean force) {
            if (super.shutdown(force)) {
                connTimer.cancelTimeout(this);
                this.listener.connectionClosed(this);
            }
            return false;
        }
    }
}

