/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import org.wbemservices.wbem.cimom.util.DynClassLoader;

public class StartWBEMServices {
    private static final String CIMOM_CLASS = "org.wbemservices.wbem.cimom.WBEMServices";
    private static boolean running = false;
    private static String[] classpaths = null;
    public static final String WBEM_SERVICE = "WBEMServices";
    public static final String DEBUG_LEVEL = "DebugLevel";
    public static final String DEBUG_DEVICE = "DebugDevice";
    public static final String BASEDIR = "BaseDir";
    public static final String PROPDIR = "propdir";
    public static final String INSTALLDIR = "InstallDir";
    public static final String LOGDIR = "logdir";
    public static final String LOGPARENT = "logparent";
    public static final String LIBWBEMDIR = "libwbemdir";
    public static final String SYSTEM_DEBUG_LEVEL = "wbem.debug.level";
    public static final String SYSTEM_DEBUG_DEVICE = "wbem.debug.device";
    static /* synthetic */ Class class$org$wbemservices$wbem$bootstrap$StartWBEMServices;
    static /* synthetic */ Class array$Ljava$lang$String;

    private StartWBEMServices() {
    }

    private static void setDirs(Properties props) {
        String installdir;
        String libwbemdir;
        String logparent;
        String logdir;
        String propdir;
        String basedir = System.getProperty(BASEDIR);
        if (basedir == null) {
            basedir = props.getProperty(BASEDIR, "");
            System.setProperty(BASEDIR, basedir);
        }
        if ((propdir = System.getProperty(PROPDIR)) == null && (propdir = props.getProperty(PROPDIR)) != null) {
            System.setProperty(PROPDIR, propdir);
        }
        if ((logdir = System.getProperty(LOGDIR)) == null && (logdir = props.getProperty(LOGDIR)) != null) {
            System.setProperty(LOGDIR, logdir);
        }
        if ((logparent = System.getProperty(LOGPARENT)) == null && (logparent = props.getProperty(LOGPARENT)) != null) {
            System.setProperty(LOGPARENT, logparent);
        }
        if ((libwbemdir = System.getProperty(LIBWBEMDIR)) == null && (libwbemdir = props.getProperty(LIBWBEMDIR)) != null) {
            System.setProperty(LIBWBEMDIR, libwbemdir);
        }
        if ((installdir = System.getProperty(INSTALLDIR)) == null && (installdir = props.getProperty(INSTALLDIR)) != null) {
            System.setProperty(INSTALLDIR, installdir);
        }
    }

    private static String[] getClassPaths(Properties props) {
        String[] ret = new String[]{};
        String val = props.getProperty("classpath");
        if (val != null) {
            int count = 0;
            StringTokenizer tok = new StringTokenizer(val, File.pathSeparator, false);
            ret = new String[tok.countTokens()];
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                ret[count] = "file:" + path;
                ++count;
            }
        }
        return ret;
    }

    private static void setDebug(Properties props) {
        String level = props.getProperty(DEBUG_LEVEL);
        if (level != null) {
            System.setProperty(SYSTEM_DEBUG_LEVEL, level);
            String device = props.getProperty(DEBUG_DEVICE);
            if (device == null) {
                device = "stdout";
            }
            System.setProperty(SYSTEM_DEBUG_DEVICE, device);
        }
    }

    private static void loadPropertyFile(String pName) throws Exception {
        Properties props = new Properties();
        props.load(new FileInputStream(pName));
        classpaths = StartWBEMServices.getClassPaths(props);
        StartWBEMServices.setDebug(props);
        StartWBEMServices.setDirs(props);
    }

    public static synchronized Object startWBEM(String[] args) throws Exception {
        if (running) {
            throw new Exception("WBEMServices has already been executed");
        }
        String wbemProps = System.getProperty(WBEM_SERVICE);
        if (wbemProps == null) {
            if (args.length < 1 || !args[0].endsWith(".properties")) {
                System.out.println("Invalid command line.");
                System.out.println("Need location of properties file.\n");
                System.out.print("java -DWBEMService=/usr/sadm/lib/wbem/");
                System.out.println("WBEMServices.properties " + (class$org$wbemservices$wbem$bootstrap$StartWBEMServices == null ? (class$org$wbemservices$wbem$bootstrap$StartWBEMServices = StartWBEMServices.class$("org.wbemservices.wbem.bootstrap.StartWBEMServices")) : class$org$wbemservices$wbem$bootstrap$StartWBEMServices).getName());
                System.out.println("\nor\n");
                System.out.print("java " + (class$org$wbemservices$wbem$bootstrap$StartWBEMServices == null ? (class$org$wbemservices$wbem$bootstrap$StartWBEMServices = StartWBEMServices.class$("org.wbemservices.wbem.bootstrap.StartWBEMServices")) : class$org$wbemservices$wbem$bootstrap$StartWBEMServices).getName());
                System.out.println("/usr/sadm/lib/wbem/WBEMServices.properties");
                System.exit(1);
            }
            wbemProps = args[0];
        }
        StartWBEMServices.loadPropertyFile(wbemProps);
        DynClassLoader dcl = new DynClassLoader(classpaths, ClassLoader.getSystemClassLoader());
        Class<?> c = dcl.loadClass(CIMOM_CLASS);
        Class[] Args = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = StartWBEMServices.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        Method method = c.getMethod("StartCIMOM", Args);
        Object ret = method.invoke(null, new Object[]{args});
        if (ret != null) {
            running = true;
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            StartWBEMServices.startWBEM(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

