/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS8K;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;

public class DS8KCIMOMDataGenerator {
    public static final String CONFIG_FILE = "c:\\DRPlanner\\Simulator\\conf\\DS8K-requirement.config";
    private static final int NUM_CLUSTERS = 2;
    private static final int NUM_FCPORTS = 16;
    private static final int NUM_PHYSICAL_PACKAGE = 4;
    private static final int NUM_STORAGE_PROCESSOR_CARD = 2;
    private static final int NUM_STORAGE_CLIENT_SETTING_DATA = 33;
    private String subsystemName = null;
    private String subsystemNameWithModel = null;
    private String ipAddressCIMOM = null;
    private String ipAddressSubsystem = null;
    private String wwn = null;
    private String machineSignature = null;
    private String[] hostAdapters = null;
    private String[] deviceAdapters = null;
    private String pools = null;
    private String extents = null;
    private String volumes = null;

    public DS8KCIMOMDataGenerator() throws Exception {
        this.initialize();
        CIMInstance cIMInstance = this.get_ibmtsess_storage_system();
        System.out.println("Instance = " + cIMInstance);
        this.populateProfiles(cIMInstance);
    }

    private void initialize() throws Exception {
        this.subsystemName = IDGenerator.generateStorageSystemName(1);
        this.subsystemNameWithModel = IDGenerator.generateStorageSystemNameWithModel(this.subsystemName);
        this.ipAddressCIMOM = IDGenerator.generateIPAddress(20);
        this.ipAddressSubsystem = IDGenerator.generateIPAddress(20);
        this.wwn = IDGenerator.generateWWN();
        this.machineSignature = IDGenerator.generateMachineSignature(1);
        this.hostAdapters = IDGenerator.generateHostAdapters(4);
        this.deviceAdapters = new String[2];
        this.deviceAdapters[0] = this.hostAdapters[0];
        this.deviceAdapters[0] = this.deviceAdapters[0].substring(0, this.deviceAdapters[0].length() - 1) + "3";
        this.deviceAdapters[1] = this.hostAdapters[1];
        this.deviceAdapters[1] = this.deviceAdapters[1].substring(0, this.deviceAdapters[1].length() - 1) + "6";
        Properties properties = new Properties();
        properties.load(new FileInputStream(CONFIG_FILE));
        String string = properties.getProperty("SUBSYSTEM");
        if (string != null && string.equals("DS8K")) {
            this.pools = properties.getProperty("STORAGE_POOLS");
            this.extents = properties.getProperty("STORAGE_EXTENTS");
            this.volumes = properties.getProperty("STORAGE_VOLUMES");
            System.out.println("p=" + this.pools + ", e=" + this.extents + ", v=" + this.volumes);
        }
    }

    private void populateProfiles(CIMInstance cIMInstance) throws Exception {
        CIMInstance cIMInstance2;
        int n;
        CIMInstance cIMInstance3 = this.get_ibmts_registered_profile();
        System.out.println("Instance = " + cIMInstance3);
        CIMInstance cIMInstance4 = this.get_ibmtsess_registered_profile();
        System.out.println("Instance = " + cIMInstance4);
        CIMInstance[] cIMInstanceArray = this.get_ibmtsess_registered_sub_profile();
        for (int i = 0; i < cIMInstanceArray.length; ++i) {
            System.out.println("Instance = " + cIMInstanceArray[i]);
        }
        CIMInstance cIMInstance5 = this.get_ibmts_object_manager();
        System.out.println("Instance = " + cIMInstance5);
        CIMInstance cIMInstance6 = this.get_ibmts_namespace();
        System.out.println("Instance = " + cIMInstance6);
        CIMInstance cIMInstance7 = this.get_ibmts_account();
        System.out.println("Instance = " + cIMInstance7);
        CIMInstance cIMInstance8 = this.get_ibmts_account_management_service();
        System.out.println("Instance = " + cIMInstance8);
        CIMInstance cIMInstance9 = this.get_ibmts_system();
        System.out.println("Instance = " + cIMInstance9);
        CIMInstance cIMInstance10 = this.get_ibmts_certificate();
        System.out.println("Instance = " + cIMInstance10);
        if (cIMInstance10 != null) {
            // empty if block
        }
        CIMInstance cIMInstance11 = this.get_certificate_setting();
        System.out.println("Instance = " + cIMInstance11);
        CIMInstance cIMInstance12 = this.get_cimxml_communication_mechanism();
        System.out.println("Instance = " + cIMInstance12);
        CIMInstance[] cIMInstanceArray2 = this.get_indication_filter();
        for (int i = 0; i < cIMInstanceArray2.length; ++i) {
            System.out.println("Instance = " + cIMInstanceArray2[i]);
        }
        CIMInstance cIMInstance13 = this.get_ibmts_truststore();
        System.out.println("Instance = " + cIMInstance13);
        if (cIMInstance13 != null) {
            // empty if block
        }
        CIMInstance cIMInstance14 = this.get_ibmts_truststore_management_service();
        System.out.println("Instance = " + cIMInstance14);
        if (cIMInstance14 != null) {
            // empty if block
        }
        CIMInstance cIMInstance15 = this.get_ibmtsess_provider();
        System.out.println("Instance = " + cIMInstance15);
        if (cIMInstance15 != null) {
            // empty if block
        }
        CIMInstance cIMInstance16 = this.get_ibmts_namespace_in_manager(cIMInstance5, cIMInstance6);
        System.out.println("Instance = " + cIMInstance16);
        if (cIMInstance16 != null) {
            // empty if block
        }
        CIMInstance cIMInstance17 = this.get_ibmts_account_management_service_for_system(cIMInstance8, cIMInstance5);
        System.out.println("Instance = " + cIMInstance17);
        if (cIMInstance17 != null) {
            // empty if block
        }
        CIMInstance cIMInstance18 = this.get_ibmts_account_on_cimom(cIMInstance5, cIMInstance7);
        System.out.println("Instance = " + cIMInstance18);
        if (cIMInstance18 != null) {
            // empty if block
        }
        CIMInstance cIMInstance19 = this.get_ibmts_comm_mechanism_for_manager(cIMInstance5, cIMInstance12);
        System.out.println("Instance = " + cIMInstance19);
        if (cIMInstance19 != null) {
            // empty if block
        }
        CIMInstance cIMInstance20 = this.get_ibmts_hosted_access_point(cIMInstance9, cIMInstance12);
        System.out.println("Instance = " + cIMInstance20);
        if (cIMInstance20 != null) {
            // empty if block
        }
        CIMInstance cIMInstance21 = this.get_ibmts_element_conforms_to_profile(cIMInstance3, cIMInstance5);
        System.out.println("Instance = " + cIMInstance21);
        if (cIMInstance21 != null) {
            // empty if block
        }
        CIMInstance cIMInstance22 = this.get_ibmts_hosted_service(cIMInstance9, cIMInstance5);
        System.out.println("Instance = " + cIMInstance22);
        if (cIMInstance22 != null) {
            // empty if block
        }
        for (n = 0; n < cIMInstanceArray2.length; ++n) {
            cIMInstance2 = this.get_ibmts_indication_filters_conforms_to_profile(cIMInstance3, cIMInstanceArray2[n]);
            System.out.println("Instance = " + cIMInstance2);
            if (cIMInstance2 == null) continue;
        }
        for (n = 0; n < cIMInstanceArray.length; ++n) {
            cIMInstance2 = this.get_ibmtsess_sub_profile_requires_profile(cIMInstance4, cIMInstanceArray[n]);
            System.out.println("Instance = " + cIMInstance2);
            if (cIMInstance2 == null) continue;
        }
        CIMInstance[] cIMInstanceArray3 = new CIMInstance[2];
        for (int i = 0; i < 2; ++i) {
            String string = "";
            switch (i) {
                case 0: {
                    string = "00";
                    break;
                }
                case 1: {
                    string = "01";
                }
            }
            cIMInstanceArray3[i] = this.get_ibmtsess_storage_cluster(string);
            System.out.println("Instance = " + cIMInstanceArray3[i]);
        }
        CIMInstance[] cIMInstanceArray4 = new CIMInstance[2];
        for (int i = 0; i < 2; ++i) {
            cIMInstanceArray4[i] = this.get_ibmtsess_component_cs(cIMInstance, cIMInstanceArray3[i]);
            System.out.println("Instance = " + cIMInstanceArray4[i]);
        }
        CIMInstance[] cIMInstanceArray5 = new CIMInstance[16];
        for (int i = 0; i < 16; ++i) {
            cIMInstanceArray5[i] = this.get_ibmtsess_fcport(i);
            System.out.println("Instance = " + cIMInstanceArray5[i]);
        }
        CIMInstance cIMInstance23 = this.get_ibmtsess_product();
        System.out.println("Instance = " + cIMInstance23);
        CIMInstance cIMInstance24 = this.get_ibmtsess_chassis();
        System.out.println("Instance = " + cIMInstance24);
        CIMInstance cIMInstance25 = this.get_ibmtsess_location();
        System.out.println("Instance = " + cIMInstance25);
        CIMInstance[] cIMInstanceArray6 = new CIMInstance[4];
        for (int i = 0; i < 4; ++i) {
            cIMInstanceArray6[i] = this.get_ibmtsess_physical_package(i);
            System.out.println("Instance = " + cIMInstanceArray6[i]);
        }
        CIMInstance cIMInstance26 = this.get_ibmtsess_software_identity();
        System.out.println("Instance = " + cIMInstance26);
        CIMInstance cIMInstance27 = this.get_ibmtsess_computer_system_package(cIMInstance24, cIMInstance);
        System.out.println("Instance = " + cIMInstance27);
        CIMInstance[] cIMInstanceArray7 = new CIMInstance[2];
        for (int i = 0; i < 2; ++i) {
            cIMInstanceArray7[i] = this.get_ibmtsess_storage_processor_card(i);
            System.out.println("Instance = " + cIMInstanceArray7[i]);
        }
        CIMInstance[] cIMInstanceArray8 = new CIMInstance[2];
        for (int i = 0; i < 2; ++i) {
            cIMInstanceArray8[i] = this.get_ibmtsess_computer_system_package_card(cIMInstanceArray7[i], cIMInstance);
            System.out.println("Instance = " + cIMInstanceArray7[i]);
        }
        CIMInstance[] cIMInstanceArray9 = new CIMInstance[4];
        for (int i = 0; i < 4; ++i) {
            cIMInstanceArray9[i] = this.get_ibmtsess_computer_system_physical_package(cIMInstanceArray6[i], cIMInstance);
            System.out.println("Instance = " + cIMInstanceArray9[i]);
        }
        CIMInstance cIMInstance28 = this.get_ibmtsess_controller_configuration_service();
        System.out.println("Instance = " + cIMInstance28);
        CIMInstance cIMInstance29 = this.get_ibmtsess_device_masking_capabilities();
        System.out.println("Instance = " + cIMInstance29);
        CIMInstance[] cIMInstanceArray10 = new CIMInstance[16];
        for (int i = 0; i < 16; ++i) {
            cIMInstanceArray10[i] = this.get_ibmtsess_storage_system_to_port(cIMInstance, cIMInstanceArray5[i]);
            System.out.println("Instance = " + cIMInstanceArray10[i]);
        }
        CIMInstance cIMInstance30 = this.get_ibmtsess_storage_capabilities();
        System.out.println("Instance = " + cIMInstance30);
        CIMInstance[] cIMInstanceArray11 = new CIMInstance[33];
        for (int i = 0; i < 33; ++i) {
            cIMInstanceArray11[i] = this.get_ibmtsess_storage_client_setting_data(i);
            System.out.println("Instance = " + cIMInstanceArray11[i]);
        }
        CIMInstance cIMInstance31 = this.get_ibmtsess_element_capabilities_masking(cIMInstance29, cIMInstance28);
        System.out.println("Instance = " + cIMInstance31);
        CIMInstance cIMInstance32 = this.get_ibmtsess_element_conforms_to_profile(cIMInstance4, cIMInstance);
        System.out.println("Instance = " + cIMInstance31);
        CIMInstance cIMInstance33 = this.get_ibmtsess_remote_service_access_point();
        System.out.println("Instance = " + cIMInstance33);
        CIMInstance cIMInstance34 = this.get_ibmtsess_hosted_access_point(cIMInstance9, cIMInstance33);
        System.out.println("Instance = " + cIMInstance34);
        CIMInstance cIMInstance35 = this.get_ibmtsess_storage_configuration_service();
        System.out.println("Instance = " + cIMInstance35);
        CIMInstance cIMInstance36 = this.get_ibmtsess_hosted_service(cIMInstance, cIMInstance35);
        System.out.println("Instance = " + cIMInstance34);
        CIMInstance cIMInstance37 = this.get_ibmtsess_lun_mask_privilege_service();
        System.out.println("Instance = " + cIMInstance37);
        CIMInstance cIMInstance38 = this.get_ibmtsess_hosted_service2(cIMInstance, cIMInstance37);
        System.out.println("Instance = " + cIMInstance38);
        CIMInstance cIMInstance39 = this.get_ibmtsess_performance_statistics_service();
        System.out.println("Instance = " + cIMInstance39);
        CIMInstance cIMInstance40 = this.get_ibmtsess_storage_configuration_capabilities();
        System.out.println("Instance = " + cIMInstance40);
        CIMInstance cIMInstance41 = this.get_ibmtsess_storage_hardware_id_management_service();
        System.out.println("Instance = " + cIMInstance41);
        CIMInstance cIMInstance42 = this.get_ibmtsess_stg_config_srv_elt_capabilities(cIMInstance40, cIMInstance35);
        System.out.println("Instance = " + cIMInstance42);
        CIMInstance cIMInstance43 = this.get_ibmtsess_hosted_service3(cIMInstance, cIMInstance41);
        System.out.println("Instance = " + cIMInstance43);
        CIMInstance cIMInstance44 = this.get_ibmtsess_hosted_service4(cIMInstance, cIMInstance28);
        System.out.println("Instance = " + cIMInstance44);
        CIMInstance cIMInstance45 = this.get_ibmtsess_hosted_service6(cIMInstance, cIMInstance39);
        System.out.println("Instance = " + cIMInstance45);
        CIMInstance cIMInstance46 = this.get_ibmtsess_installed_software_identity(cIMInstance26, cIMInstance);
        System.out.println("Instance = " + cIMInstance46);
        CIMInstance cIMInstance47 = this.get_ibmtsess_protocol_controller_masking_capabilities();
        System.out.println("Instance = " + cIMInstance47);
        CIMInstance cIMInstance48 = this.get_ibmtsess_pcm_elt_capabilities(cIMInstance47, cIMInstance);
        System.out.println("Instance = " + cIMInstance48);
        CIMInstance cIMInstance49 = this.get_ibmtsess_product_physical_component(cIMInstance23, cIMInstance24);
        System.out.println("Instance = " + cIMInstance49);
        CIMInstance cIMInstance50 = this.get_ibmtsess_SAP_available_for_element(cIMInstance23, cIMInstance);
        System.out.println("Instance = " + cIMInstance50);
        int n2 = this.count(this.extents);
        for (int i = 0; i < n2; ++i) {
            CIMInstance cIMInstance51;
            for (int j = 0; j < 8; ++j) {
                cIMInstance51 = this.get_ibmtsess_disk_drive(i, j);
                System.out.println("Instance = " + cIMInstance51);
            }
            CIMInstance cIMInstance52 = this.get_ibmtsess_v8_pack(i);
            cIMInstance51 = this.get_ibmtsess_storage_extent(i);
        }
    }

    private int count(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray = stringTokenizer.nextToken().split("\\,");
            n += stringArray.length;
        }
        return n;
    }

    private CIMInstance get_ibmtsess_volume(int n, int n2, int n3) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_Volume");
        cIMInstance.setName("IBMTSESS_Volume");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n4 = 59;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n4];
        cIMPropertyArray[0] = new CIMProperty("Access");
        cIMPropertyArray[0].setName("Access");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)2));
        Object var8_8 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var8_8));
        cIMPropertyArray[1] = new CIMProperty("AdditionalAvailability");
        cIMPropertyArray[1].setName("AdditionalAvailability");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[1].setValue(new CIMValue(vector2));
        cIMPropertyArray[2] = new CIMProperty("Availability");
        cIMPropertyArray[2].setName("Availability");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)2));
        Object var10_10 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var10_10));
        cIMPropertyArray[3] = new CIMProperty("BlockSize");
        cIMPropertyArray[3].setName("BlockSize");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt64 = new UnsignedInt64("512");
        cIMPropertyArray[3].setValue(new CIMValue((Object)unsignedInt64));
        cIMPropertyArray[4] = new CIMProperty("Caption");
        cIMPropertyArray[4].setName("Caption");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var12_12 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var12_12));
        cIMPropertyArray[5] = new CIMProperty("ConfigState");
        cIMPropertyArray[5].setName("ConfigState");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        String string = "Normal";
        cIMPropertyArray[5].setValue(new CIMValue((Object)string));
        cIMPropertyArray[6] = new CIMProperty("ConsumableBlocks");
        cIMPropertyArray[6].setName("ConsumableBlocks");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt642 = new UnsignedInt64("0");
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt642));
        cIMPropertyArray[7] = new CIMProperty("Controlled");
        cIMPropertyArray[7].setName("Controlled");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[7].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[8] = new CIMProperty("CreationClassName");
        cIMPropertyArray[8].setName("CreationClassName");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[8].setKey(true);
        cIMPropertyArray[8].setValue(new CIMValue((Object)"IBMTSESS_Volume"));
        cIMPropertyArray[9] = new CIMProperty("DataOrganization");
        cIMPropertyArray[9].setName("DataOrganization");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[9].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[10] = new CIMProperty("DataRedundancy");
        cIMPropertyArray[10].setName("DataRedundancy");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(1);
        cIMPropertyArray[10].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[11] = new CIMProperty("DeltaReservation");
        cIMPropertyArray[11].setName("DeltaReservation");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)0));
        UnsignedInt8 unsignedInt8 = new UnsignedInt8("100");
        cIMPropertyArray[11].setValue(new CIMValue((Object)unsignedInt8));
        cIMPropertyArray[12] = new CIMProperty("DataState");
        cIMPropertyArray[12].setName("DataState");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "Normal";
        cIMPropertyArray[12].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[13] = new CIMProperty("DeltaReservation");
        cIMPropertyArray[13].setName("DeltaReservation");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)0));
        UnsignedInt8 unsignedInt82 = new UnsignedInt8("100");
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt82));
        cIMPropertyArray[14] = new CIMProperty("Description");
        cIMPropertyArray[14].setName("Description");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var21_21 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var21_21));
        cIMPropertyArray[15] = new CIMProperty("DeviceID");
        cIMPropertyArray[15].setName("DeviceID");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[15].setKey(true);
        String string3 = Integer.toString(n3);
        cIMPropertyArray[15].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[16] = new CIMProperty("ElementName");
        cIMPropertyArray[16].setName("ElementName");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = Integer.toString(n) + Integer.toString(n3);
        cIMPropertyArray[16].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[17] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[17].setName("EnabledDefault");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(2);
        cIMPropertyArray[17].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[18] = new CIMProperty("EnabledState");
        cIMPropertyArray[18].setName("EnabledState");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(2);
        cIMPropertyArray[18].setValue(new CIMValue((Object)unsignedInt164));
        cIMPropertyArray[19] = new CIMProperty("ErrorCleared");
        cIMPropertyArray[19].setName("ErrorCleared");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)9));
        Object var26_26 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var26_26));
        cIMPropertyArray[20] = new CIMProperty("ErrorDescription");
        cIMPropertyArray[20].setName("ErrorDescription");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)16));
        Object var27_27 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var27_27));
        cIMPropertyArray[21] = new CIMProperty("ErrorMethodology");
        cIMPropertyArray[21].setName("ErrorMethodology");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        Object var28_28 = null;
        cIMPropertyArray[21].setValue(new CIMValue(var28_28));
        cIMPropertyArray[22] = new CIMProperty("ExtentStatus");
        cIMPropertyArray[22].setName("ExtentStatus");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        vector3.add(new UnsignedInt16(2));
        cIMPropertyArray[22].setValue(new CIMValue(vector3));
        cIMPropertyArray[23] = new CIMProperty("IdentifyingDescriptions");
        cIMPropertyArray[23].setName("IdentifyingDescriptions");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector4 = new Vector<String>();
        vector4.add("Serial");
        cIMPropertyArray[23].setValue(new CIMValue(vector4));
        cIMPropertyArray[24] = new CIMProperty("InstallDate");
        cIMPropertyArray[24].setName("InstallDate");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)12));
        Object var31_31 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var31_31));
        cIMPropertyArray[25] = new CIMProperty("IsBasedOnUnderlyingRedundancy");
        cIMPropertyArray[25].setName("IsBasedOnUnderlyingRedundancy");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(true);
        cIMPropertyArray[25].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[26] = new CIMProperty("LastErrorCode");
        cIMPropertyArray[26].setName("LastErrorCode");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)4));
        Object var33_33 = null;
        cIMPropertyArray[26].setValue(new CIMValue(var33_33));
        cIMPropertyArray[27] = new CIMProperty("MaxQuiesceTime");
        cIMPropertyArray[27].setName("MaxQuiesceTime");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)6));
        Object var34_34 = null;
        cIMPropertyArray[27].setValue(new CIMValue(var34_34));
        cIMPropertyArray[28] = new CIMProperty("Name");
        cIMPropertyArray[28].setName("Name");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = Integer.toString(n3);
        cIMPropertyArray[28].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[29] = new CIMProperty("NameFormat");
        cIMPropertyArray[29].setName("NameFormat");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt165 = new UnsignedInt16(6);
        cIMPropertyArray[29].setValue(new CIMValue((Object)unsignedInt165));
        cIMPropertyArray[30] = new CIMProperty("NameNamespace");
        cIMPropertyArray[30].setName("NameNamespace");
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)2));
        Object var37_37 = null;
        cIMPropertyArray[30].setValue(new CIMValue(var37_37));
        cIMPropertyArray[31] = new CIMProperty("NoSinglePointOfFailure");
        cIMPropertyArray[31].setName("NoSinglePointOfFailure");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl3 = new Boolean(true);
        cIMPropertyArray[31].setValue(new CIMValue((Object)bl3));
        cIMPropertyArray[32] = new CIMProperty("NumberOfBlocks");
        cIMPropertyArray[32].setName("NumberOfBlocks");
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt643 = new UnsignedInt64("2097152");
        cIMPropertyArray[32].setValue(new CIMValue((Object)unsignedInt643));
        cIMPropertyArray[33] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[33].setName("OperationalStatus");
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector5 = new Vector<UnsignedInt16>();
        vector5.add(new UnsignedInt16(2));
        cIMPropertyArray[33].setValue(new CIMValue(vector5));
        cIMPropertyArray[34] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[34].setName("OtherEnabledState");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)8));
        Object var41_41 = null;
        cIMPropertyArray[34].setValue(new CIMValue(var41_41));
        cIMPropertyArray[35] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[35].setName("OtherIdentifyingInfo");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector6 = new Vector<String>();
        vector6.add("13002714600");
        cIMPropertyArray[35].setValue(new CIMValue(vector6));
        cIMPropertyArray[36] = new CIMProperty("OtherNameFormat");
        cIMPropertyArray[36].setName("OtherNameFormat");
        cIMPropertyArray[36].setType(CIMDataType.getPredefinedType((int)8));
        Object var43_43 = null;
        cIMPropertyArray[36].setValue(new CIMValue(var43_43));
        cIMPropertyArray[37] = new CIMProperty("OtherNameNamespace");
        cIMPropertyArray[37].setName("OtherNameNamespace");
        cIMPropertyArray[37].setType(CIMDataType.getPredefinedType((int)8));
        Object var44_44 = null;
        cIMPropertyArray[37].setValue(new CIMValue(var44_44));
        cIMPropertyArray[38] = new CIMProperty("PackageRedundancy");
        cIMPropertyArray[38].setName("PackageRedundancy");
        cIMPropertyArray[38].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt166 = new UnsignedInt16(1);
        cIMPropertyArray[38].setValue(new CIMValue((Object)unsignedInt166));
        cIMPropertyArray[39] = new CIMProperty("PowerManagementCapabilities");
        cIMPropertyArray[39].setName("PowerManagementCapabilities");
        cIMPropertyArray[39].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector7 = new Vector();
        cIMPropertyArray[39].setValue(new CIMValue(vector7));
        cIMPropertyArray[40] = new CIMProperty("PowerManagementSupported");
        cIMPropertyArray[40].setName("PowerManagementSupported");
        cIMPropertyArray[40].setType(CIMDataType.getPredefinedType((int)9));
        Object var47_47 = null;
        cIMPropertyArray[40].setValue(new CIMValue(var47_47));
        cIMPropertyArray[41] = new CIMProperty("PowerOnHours");
        cIMPropertyArray[41].setName("PowerOnHours");
        cIMPropertyArray[41].setType(CIMDataType.getPredefinedType((int)6));
        Object var48_48 = null;
        cIMPropertyArray[41].setValue(new CIMValue(var48_48));
        cIMPropertyArray[42] = new CIMProperty("Primordial");
        cIMPropertyArray[42].setName("Primordial");
        cIMPropertyArray[42].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl4 = new Boolean(false);
        cIMPropertyArray[42].setValue(new CIMValue((Object)bl4));
        cIMPropertyArray[43] = new CIMProperty("Purpose");
        cIMPropertyArray[43].setName("Purpose");
        cIMPropertyArray[43].setType(CIMDataType.getPredefinedType((int)8));
        Object var50_50 = null;
        cIMPropertyArray[43].setValue(new CIMValue(var50_50));
        cIMPropertyArray[44] = new CIMProperty("RequestedState");
        cIMPropertyArray[44].setName("RequestedState");
        cIMPropertyArray[44].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt167 = new UnsignedInt16(2);
        cIMPropertyArray[44].setValue(new CIMValue((Object)unsignedInt167));
        cIMPropertyArray[45] = new CIMProperty("SequentialAccess");
        cIMPropertyArray[45].setName("SequentialAccess");
        cIMPropertyArray[45].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl5 = new Boolean(false);
        cIMPropertyArray[45].setValue(new CIMValue((Object)bl5));
        cIMPropertyArray[46] = new CIMProperty("SpindleRedundancy");
        cIMPropertyArray[46].setName("SpindleRedundancy");
        cIMPropertyArray[46].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt168 = new UnsignedInt16(2);
        cIMPropertyArray[46].setValue(new CIMValue((Object)unsignedInt168));
        cIMPropertyArray[47] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[47].setName("StatusDescriptions");
        cIMPropertyArray[47].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector8 = new Vector<String>();
        vector8.add("OK");
        cIMPropertyArray[47].setValue(new CIMValue(vector8));
        cIMPropertyArray[48] = new CIMProperty("StatusInfo");
        cIMPropertyArray[48].setName("StatusInfo");
        cIMPropertyArray[48].setType(CIMDataType.getPredefinedType((int)2));
        Object var55_55 = null;
        cIMPropertyArray[48].setValue(new CIMValue(var55_55));
        cIMPropertyArray[49] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[49].setName("SystemCreationClassName");
        cIMPropertyArray[49].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[49].setKey(true);
        cIMPropertyArray[49].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[50] = new CIMProperty("SystemName");
        cIMPropertyArray[50].setName("SystemName");
        cIMPropertyArray[50].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[50].setKey(true);
        cIMPropertyArray[50].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[51] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[51].setName("TimeOfLastStateChange");
        cIMPropertyArray[51].setType(CIMDataType.getPredefinedType((int)12));
        Object var56_56 = null;
        cIMPropertyArray[51].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[52] = new CIMProperty("TotalPowerOnHours");
        cIMPropertyArray[52].setName("TotalPowerOnHours");
        cIMPropertyArray[52].setType(CIMDataType.getPredefinedType((int)6));
        Object var57_57 = null;
        cIMPropertyArray[52].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[53] = new CIMProperty("cap");
        cIMPropertyArray[53].setName("cap");
        cIMPropertyArray[53].setType(CIMDataType.getPredefinedType((int)10));
        Float f = new Float(1.07374182E9);
        cIMPropertyArray[53].setValue(new CIMValue((Object)f));
        cIMPropertyArray[54] = new CIMProperty("format");
        cIMPropertyArray[54].setName("format");
        cIMPropertyArray[54].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = "Block512";
        cIMPropertyArray[54].setValue(new CIMValue((Object)string6));
        cIMPropertyArray[55] = new CIMProperty("lss");
        cIMPropertyArray[55].setName("lss");
        cIMPropertyArray[55].setType(CIMDataType.getPredefinedType((int)8));
        String string7 = "11";
        cIMPropertyArray[55].setValue(new CIMValue((Object)string7));
        cIMPropertyArray[56] = new CIMProperty("ss");
        cIMPropertyArray[56].setName("ss");
        cIMPropertyArray[56].setType(CIMDataType.getPredefinedType((int)8));
        String string8 = "FF11";
        cIMPropertyArray[56].setValue(new CIMValue((Object)string8));
        cIMPropertyArray[57] = new CIMProperty("status");
        cIMPropertyArray[57].setName("status");
        cIMPropertyArray[57].setType(CIMDataType.getPredefinedType((int)8));
        Object var62_62 = null;
        cIMPropertyArray[57].setValue(new CIMValue(var62_62));
        cIMPropertyArray[58] = new CIMProperty("unit");
        cIMPropertyArray[58].setName("unit");
        cIMPropertyArray[58].setType(CIMDataType.getPredefinedType((int)8));
        String string9 = "bytes";
        cIMPropertyArray[58].setValue(new CIMValue((Object)string9));
        cIMPropertyArray[59] = new CIMProperty("vs");
        cIMPropertyArray[59].setName("vs");
        cIMPropertyArray[59].setType(CIMDataType.getPredefinedType((int)8));
        String string10 = "vs" + n;
        cIMPropertyArray[59].setValue(new CIMValue((Object)string10));
        for (int i = 0; i < n4; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_volume_space(int n) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_VolumeSpace");
        cIMInstance.setName("IBMTSESS_VolumeSpace");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n2 = 27;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n2];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var6_6));
        cIMPropertyArray[1] = new CIMProperty("Description");
        cIMPropertyArray[1].setName("Description");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var7_7));
        cIMPropertyArray[2] = new CIMProperty("ElementName");
        cIMPropertyArray[2].setName("ElementName");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        String string = "VS" + Integer.toString(n);
        cIMPropertyArray[2].setValue(new CIMValue((Object)string));
        cIMPropertyArray[3] = new CIMProperty("InstallDate");
        cIMPropertyArray[3].setName("InstallDate");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)12));
        Object var9_9 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var9_9));
        cIMPropertyArray[4] = new CIMProperty("InstanceID");
        cIMPropertyArray[4].setName("InstanceID");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = this.subsystemNameWithModel + "-vs" + n;
        cIMPropertyArray[4].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[5] = new CIMProperty("Name");
        cIMPropertyArray[5].setName("Name");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var11_11));
        cIMPropertyArray[6] = new CIMProperty("NumOfvols");
        cIMPropertyArray[6].setName("NumOfvols");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(0);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[7] = new CIMProperty("NumRanks");
        cIMPropertyArray[7].setName("NumRanks");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(1);
        cIMPropertyArray[7].setValue(new CIMValue((Object)"IBMTSESS_StorageExtent"));
        cIMPropertyArray[8] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[8].setName("OperationalStatus");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(2));
        cIMPropertyArray[8].setValue(new CIMValue(vector2));
        cIMPropertyArray[9] = new CIMProperty("PoolID");
        cIMPropertyArray[9].setName("PoolID");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "vs" + n;
        cIMPropertyArray[9].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[10] = new CIMProperty("PoolName");
        cIMPropertyArray[10].setName("PoolName");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var16_16));
        cIMPropertyArray[11] = new CIMProperty("Primordial");
        cIMPropertyArray[11].setName("Primordial");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(false);
        cIMPropertyArray[11].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[12] = new CIMProperty("RankID");
        cIMPropertyArray[12].setName("RankID");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("0");
        cIMPropertyArray[12].setValue(new CIMValue(vector3));
        cIMPropertyArray[13] = new CIMProperty("RemainingManagedSpace");
        cIMPropertyArray[13].setName("RemainingManagedSpace");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)6));
        Object var19_19 = null;
        cIMPropertyArray[13].setValue(new CIMValue(var19_19));
        cIMPropertyArray[14] = new CIMProperty("ReservedManagedSpace");
        cIMPropertyArray[14].setName("ReservedManagedSpace");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt64 = new UnsignedInt64("0");
        cIMPropertyArray[14].setValue(new CIMValue((Object)unsignedInt64));
        cIMPropertyArray[15] = new CIMProperty("Status");
        cIMPropertyArray[15].setName("Status");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "Operational";
        cIMPropertyArray[15].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[16] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[16].setName("StatusDescriptions");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector4 = new Vector();
        cIMPropertyArray[16].setValue(new CIMValue(vector4));
        cIMPropertyArray[17] = new CIMProperty("StorageType");
        cIMPropertyArray[17].setName("StorageType");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "FB";
        cIMPropertyArray[17].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[18] = new CIMProperty("SystemName");
        cIMPropertyArray[18].setName("SystemName");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[18].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[19] = new CIMProperty("TotalManagedSpace");
        cIMPropertyArray[19].setName("TotalManagedSpace");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt642 = new UnsignedInt64("1254130450432");
        cIMPropertyArray[19].setValue(new CIMValue((Object)unsignedInt642));
        cIMPropertyArray[20] = new CIMProperty("basedon");
        cIMPropertyArray[20].setName("basedon");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector5 = new Vector();
        cIMPropertyArray[20].setValue(new CIMValue(vector5));
        cIMPropertyArray[21] = new CIMProperty("format");
        cIMPropertyArray[21].setName("format");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = "FB";
        cIMPropertyArray[21].setValue(new CIMValue((Object)string6));
        cIMPropertyArray[22] = new CIMProperty("logicalCap");
        cIMPropertyArray[22].setName("logicalCap");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt643 = new UnsignedInt64("836444880896");
        cIMPropertyArray[22].setValue(new CIMValue((Object)unsignedInt643));
        cIMPropertyArray[23] = new CIMProperty("logicalFree");
        cIMPropertyArray[23].setName("logicalFree");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt644 = new UnsignedInt64("4294967296");
        cIMPropertyArray[23].setValue(new CIMValue((Object)unsignedInt644));
        cIMPropertyArray[24] = new CIMProperty("lss");
        cIMPropertyArray[24].setName("lss");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)8));
        Object var29_29 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var29_29));
        cIMPropertyArray[25] = new CIMProperty("redundancy");
        cIMPropertyArray[25].setName("redundancy");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector6 = new Vector<String>();
        vector6.add("raid5");
        cIMPropertyArray[25].setValue(new CIMValue(vector6));
        cIMPropertyArray[26] = new CIMProperty("ssID");
        cIMPropertyArray[26].setName("ssID");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)8));
        String string7 = "";
        cIMPropertyArray[26].setValue(new CIMValue((Object)string7));
        for (int i = 0; i < n2; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_storage_extent(int n) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageExtent");
        cIMInstance.setName("IBMTSESS_StorageExtent");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n2 = 54;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n2];
        cIMPropertyArray[0] = new CIMProperty("Access");
        cIMPropertyArray[0].setName("Access");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)2));
        Object var6_6 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var6_6));
        cIMPropertyArray[1] = new CIMProperty("AdditionalAvailability");
        cIMPropertyArray[1].setName("AdditionalAvailability");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[1].setValue(new CIMValue(vector2));
        cIMPropertyArray[2] = new CIMProperty("ArrayIDs");
        cIMPropertyArray[2].setName("ArrayIDs");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add(Integer.toString(n));
        cIMPropertyArray[2].setValue(new CIMValue(vector3));
        cIMPropertyArray[3] = new CIMProperty("Availability");
        cIMPropertyArray[3].setName("Availability");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)2));
        Object var9_9 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var9_9));
        cIMPropertyArray[4] = new CIMProperty("BlockSize");
        cIMPropertyArray[4].setName("BlockSize");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt64 = new UnsignedInt64("1");
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt64));
        cIMPropertyArray[5] = new CIMProperty("Caption");
        cIMPropertyArray[5].setName("Caption");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var11_11));
        cIMPropertyArray[6] = new CIMProperty("ConsumableBlocks");
        cIMPropertyArray[6].setName("ConsumableBlocks");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt642 = new UnsignedInt64("0");
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt642));
        cIMPropertyArray[7] = new CIMProperty("CreationClassName");
        cIMPropertyArray[7].setName("CreationClassName");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[7].setKey(true);
        cIMPropertyArray[7].setValue(new CIMValue((Object)"IBMTSESS_StorageExtent"));
        cIMPropertyArray[8] = new CIMProperty("DAPairs");
        cIMPropertyArray[8].setName("DAPairs");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        Vector<String> vector4 = new Vector<String>();
        vector4.add(Integer.toString(n));
        cIMPropertyArray[8].setValue(new CIMValue(vector4));
        cIMPropertyArray[9] = new CIMProperty("DataOrganization");
        cIMPropertyArray[9].setName("DataOrganization");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)2));
        Object var14_14 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var14_14));
        cIMPropertyArray[10] = new CIMProperty("DataRedundancy");
        cIMPropertyArray[10].setName("DataRedundancy");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)2));
        Object var15_15 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var15_15));
        cIMPropertyArray[11] = new CIMProperty("DeltaReservation");
        cIMPropertyArray[11].setName("DeltaReservation");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)0));
        Object var16_16 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var16_16));
        cIMPropertyArray[12] = new CIMProperty("Description");
        cIMPropertyArray[12].setName("Description");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var17_17 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var17_17));
        cIMPropertyArray[13] = new CIMProperty("DeviceID");
        cIMPropertyArray[13].setName("DeviceID");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[13].setKey(true);
        cIMPropertyArray[13].setValue(new CIMValue((Object)Integer.toString(n)));
        cIMPropertyArray[14] = new CIMProperty("ElementName");
        cIMPropertyArray[14].setName("ElementName");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        String string = "Rank " + Integer.toString(n);
        cIMPropertyArray[14].setValue(new CIMValue((Object)string));
        cIMPropertyArray[15] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[15].setName("EnabledDefault");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[15].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[16] = new CIMProperty("EnabledState");
        cIMPropertyArray[16].setName("EnabledState");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[16].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[17] = new CIMProperty("ErrorCleared");
        cIMPropertyArray[17].setName("ErrorCleared");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)9));
        Object var21_21 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var21_21));
        cIMPropertyArray[18] = new CIMProperty("ErrorDescription");
        cIMPropertyArray[18].setName("ErrorDescription");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        Object var22_22 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var22_22));
        cIMPropertyArray[19] = new CIMProperty("ErrorMethodology");
        cIMPropertyArray[19].setName("ErrorMethodology");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        Object var23_23 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var23_23));
        cIMPropertyArray[20] = new CIMProperty("ExtentStatus");
        cIMPropertyArray[20].setName("ExtentStatus");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector5 = new Vector<UnsignedInt16>();
        vector5.add(new UnsignedInt16(2));
        cIMPropertyArray[20].setValue(new CIMValue(vector5));
        cIMPropertyArray[21] = new CIMProperty("IdentifyingDescriptions");
        cIMPropertyArray[21].setName("IdentifyingDescriptions");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector6 = new Vector();
        cIMPropertyArray[21].setValue(new CIMValue(vector6));
        cIMPropertyArray[22] = new CIMProperty("InstallDate");
        cIMPropertyArray[22].setName("InstallDate");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)12));
        Object var26_26 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var26_26));
        cIMPropertyArray[23] = new CIMProperty("IsBasedOnUnderlyingRedundancy");
        cIMPropertyArray[23].setName("IsBasedOnUnderlyingRedundancy");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)9));
        Object var27_27 = null;
        cIMPropertyArray[23].setValue(new CIMValue(var27_27));
        cIMPropertyArray[24] = new CIMProperty("LastErrorCode");
        cIMPropertyArray[24].setName("LastErrorCode");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)4));
        Object var28_28 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var28_28));
        cIMPropertyArray[25] = new CIMProperty("MaxQuiesceTime");
        cIMPropertyArray[25].setName("MaxQuiesceTime");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)6));
        Object var29_29 = null;
        cIMPropertyArray[25].setValue(new CIMValue(var29_29));
        cIMPropertyArray[26] = new CIMProperty("Name");
        cIMPropertyArray[26].setName("Name");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "Rank " + Integer.toString(n);
        cIMPropertyArray[26].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[27] = new CIMProperty("NoSinglePointOfFailure");
        cIMPropertyArray[27].setName("NoSinglePointOfFailure");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)9));
        Object var31_31 = null;
        cIMPropertyArray[27].setValue(new CIMValue(var31_31));
        cIMPropertyArray[28] = new CIMProperty("SKU");
        cIMPropertyArray[28].setName("SKU");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)8));
        Object var32_32 = null;
        cIMPropertyArray[28].setValue(new CIMValue(var32_32));
        cIMPropertyArray[29] = new CIMProperty("NumOfDataDisks");
        cIMPropertyArray[29].setName("NumOfDataDisks");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector7 = new Vector<UnsignedInt16>();
        vector7.add(new UnsignedInt16(6));
        cIMPropertyArray[29].setValue(new CIMValue(vector7));
        cIMPropertyArray[30] = new CIMProperty("NumberOfBlocks");
        cIMPropertyArray[30].setName("NumberOfBlocks");
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt643 = new UnsignedInt64("836444880896");
        cIMPropertyArray[30].setValue(new CIMValue((Object)unsignedInt643));
        cIMPropertyArray[31] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[31].setName("OperationalStatus");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector8 = new Vector<UnsignedInt16>();
        vector8.add(new UnsignedInt16(2));
        cIMPropertyArray[31].setValue(new CIMValue(vector8));
        cIMPropertyArray[32] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[32].setName("OtherEnabledState");
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)8));
        Object var36_36 = null;
        cIMPropertyArray[32].setValue(new CIMValue(var36_36));
        cIMPropertyArray[33] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[33].setName("OtherIdentifyingInfo");
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector9 = new Vector();
        cIMPropertyArray[33].setValue(new CIMValue(vector9));
        cIMPropertyArray[34] = new CIMProperty("PackageRedundancy");
        cIMPropertyArray[34].setName("PackageRedundancy");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)2));
        Object var38_38 = null;
        cIMPropertyArray[34].setValue(new CIMValue(var38_38));
        cIMPropertyArray[35] = new CIMProperty("PowerManagementCapabilities");
        cIMPropertyArray[35].setName("PowerManagementCapabilities");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector10 = new Vector();
        cIMPropertyArray[35].setValue(new CIMValue(vector10));
        cIMPropertyArray[36] = new CIMProperty("PowerManagementSupported");
        cIMPropertyArray[36].setName("PowerManagementSupported");
        cIMPropertyArray[36].setType(CIMDataType.getPredefinedType((int)9));
        Object var40_40 = null;
        cIMPropertyArray[36].setValue(new CIMValue(var40_40));
        cIMPropertyArray[37] = new CIMProperty("PowerOnHours");
        cIMPropertyArray[37].setName("PowerOnHours");
        cIMPropertyArray[37].setType(CIMDataType.getPredefinedType((int)6));
        Object var41_41 = null;
        cIMPropertyArray[37].setValue(new CIMValue(var41_41));
        cIMPropertyArray[38] = new CIMProperty("Primordial");
        cIMPropertyArray[38].setName("Primordial");
        cIMPropertyArray[38].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(false);
        cIMPropertyArray[38].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[39] = new CIMProperty("Purpose");
        cIMPropertyArray[39].setName("Purpose");
        cIMPropertyArray[39].setType(CIMDataType.getPredefinedType((int)8));
        Object var43_43 = null;
        cIMPropertyArray[39].setValue(new CIMValue(var43_43));
        cIMPropertyArray[40] = new CIMProperty("RankGroup");
        cIMPropertyArray[40].setName("RankGroup");
        cIMPropertyArray[40].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = Integer.toString(n);
        cIMPropertyArray[40].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[41] = new CIMProperty("Redundancy");
        cIMPropertyArray[41].setName("Redundancy");
        cIMPropertyArray[41].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "raid5";
        cIMPropertyArray[41].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[42] = new CIMProperty("RequestedState");
        cIMPropertyArray[42].setName("RequestedState");
        cIMPropertyArray[42].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[42].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[43] = new CIMProperty("SequentialAccess");
        cIMPropertyArray[43].setName("SequentialAccess");
        cIMPropertyArray[43].setType(CIMDataType.getPredefinedType((int)9));
        Object var47_47 = null;
        cIMPropertyArray[43].setValue(new CIMValue(var47_47));
        cIMPropertyArray[44] = new CIMProperty("Status");
        cIMPropertyArray[44].setName("Status");
        cIMPropertyArray[44].setType(CIMDataType.getPredefinedType((int)8));
        Object var48_48 = null;
        cIMPropertyArray[44].setValue(new CIMValue(var48_48));
        cIMPropertyArray[45] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[45].setName("StatusDescriptions");
        cIMPropertyArray[45].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector11 = new Vector();
        cIMPropertyArray[45].setValue(new CIMValue(vector11));
        cIMPropertyArray[46] = new CIMProperty("StatusInfo");
        cIMPropertyArray[46].setName("StatusInfo");
        cIMPropertyArray[46].setType(CIMDataType.getPredefinedType((int)2));
        Object var50_50 = null;
        cIMPropertyArray[46].setValue(new CIMValue(var50_50));
        cIMPropertyArray[47] = new CIMProperty("StoragePoolNumber");
        cIMPropertyArray[47].setName("StoragePoolNumber");
        cIMPropertyArray[47].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "0";
        cIMPropertyArray[47].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[48] = new CIMProperty("StorageType");
        cIMPropertyArray[48].setName("StorageType");
        cIMPropertyArray[48].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = "FB";
        cIMPropertyArray[48].setValue(new CIMValue((Object)string6));
        cIMPropertyArray[49] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[49].setName("SystemCreationClassName");
        cIMPropertyArray[49].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[49].setKey(true);
        cIMPropertyArray[49].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[50] = new CIMProperty("SystemName");
        cIMPropertyArray[50].setName("SystemName");
        cIMPropertyArray[50].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[50].setKey(true);
        cIMPropertyArray[50].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[51] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[51].setName("TimeOfLastStateChange");
        cIMPropertyArray[51].setType(CIMDataType.getPredefinedType((int)12));
        Object var53_53 = null;
        cIMPropertyArray[51].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[52] = new CIMProperty("TotalPowerOnHours");
        cIMPropertyArray[52].setName("TotalPowerOnHours");
        cIMPropertyArray[52].setType(CIMDataType.getPredefinedType((int)6));
        Object var54_54 = null;
        cIMPropertyArray[52].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[53] = new CIMProperty("Volumes");
        cIMPropertyArray[53].setName("Volumes");
        cIMPropertyArray[53].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector12 = new Vector();
        cIMPropertyArray[53].setValue(new CIMValue(vector12));
        cIMPropertyArray[54] = new CIMProperty("diskGrpStatus");
        cIMPropertyArray[54].setName("diskGrpStatus");
        cIMPropertyArray[54].setType(CIMDataType.getPredefinedType((int)8));
        String string7 = "Normal";
        cIMPropertyArray[54].setValue(new CIMValue((Object)string7));
        for (int i = 0; i < n2; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_v8_pack(int n) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_V8Pack");
        cIMInstance.setName("IBMTSESS_V8Pack");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n2 = 41;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n2];
        cIMPropertyArray[0] = new CIMProperty("CanBeFRUed");
        cIMPropertyArray[0].setName("CanBeFRUed");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[0].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[1] = new CIMProperty("Capacity");
        cIMPropertyArray[1].setName("Capacity");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)6));
        Object var7_7 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var7_7));
        cIMPropertyArray[2] = new CIMProperty("CleanerMedia");
        cIMPropertyArray[2].setName("CleanerMedia");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)9));
        Object var8_8 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var8_8));
        cIMPropertyArray[3] = new CIMProperty("CreationClassName");
        cIMPropertyArray[3].setName("CreationClassName");
        cIMPropertyArray[3].setKey(true);
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[3].setValue(new CIMValue((Object)"IBMTSESS_V8Pack"));
        cIMPropertyArray[4] = new CIMProperty("Description");
        cIMPropertyArray[4].setName("Description");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var9_9));
        cIMPropertyArray[5] = new CIMProperty("DualSided");
        cIMPropertyArray[5].setName("DualSided");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)9));
        Object var10_10 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var10_10));
        cIMPropertyArray[6] = new CIMProperty("ElementName");
        cIMPropertyArray[6].setName("ElementName");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[6].setValue(new CIMValue((Object)"CreationClassName"));
        cIMPropertyArray[7] = new CIMProperty("HotSwappable");
        cIMPropertyArray[7].setName("HotSwappable");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(false);
        cIMPropertyArray[7].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[8] = new CIMProperty("InstallDate");
        cIMPropertyArray[8].setName("InstallDate");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)12));
        Object var13_13 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var13_13));
        cIMPropertyArray[9] = new CIMProperty("LabelFormats");
        cIMPropertyArray[9].setName("LabelFormats");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[9].setValue(new CIMValue(vector2));
        cIMPropertyArray[10] = new CIMProperty("LabelStates");
        cIMPropertyArray[10].setName("LabelStates");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector3 = new Vector();
        cIMPropertyArray[10].setValue(new CIMValue(vector3));
        cIMPropertyArray[11] = new CIMProperty("ManufactureDate");
        cIMPropertyArray[11].setName("ManufactureDate");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)12));
        Object var16_16 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var16_16));
        cIMPropertyArray[12] = new CIMProperty("Manufacturer");
        cIMPropertyArray[12].setName("Manufacturer");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[12].setValue(new CIMValue((Object)"IBM"));
        cIMPropertyArray[13] = new CIMProperty("MaxMounts");
        cIMPropertyArray[13].setName("MaxMounts");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)6));
        Object var17_17 = null;
        cIMPropertyArray[13].setValue(new CIMValue(var17_17));
        cIMPropertyArray[14] = new CIMProperty("MediaDescription");
        cIMPropertyArray[14].setName("MediaDescription");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("MediaSize");
        cIMPropertyArray[15].setName("MediaSize");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)10));
        Object var19_19 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var19_19));
        cIMPropertyArray[16] = new CIMProperty("MediaType");
        cIMPropertyArray[16].setName("MediaType");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)2));
        Object var20_20 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var20_20));
        cIMPropertyArray[17] = new CIMProperty("Model");
        cIMPropertyArray[17].setName("Model");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        Object var21_21 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var21_21));
        cIMPropertyArray[18] = new CIMProperty("MountCount");
        cIMPropertyArray[18].setName("MountCount");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)6));
        Object var22_22 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var22_22));
        cIMPropertyArray[19] = new CIMProperty("Name");
        cIMPropertyArray[19].setName("Name");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        Object var23_23 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var23_23));
        cIMPropertyArray[20] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[20].setName("OperationalStatus");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector4 = new Vector();
        cIMPropertyArray[20].setValue(new CIMValue(vector4));
        cIMPropertyArray[21] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[21].setName("OtherIdentifyingInfo");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        Object var25_25 = null;
        cIMPropertyArray[21].setValue(new CIMValue(var25_25));
        cIMPropertyArray[22] = new CIMProperty("PartNumber");
        cIMPropertyArray[22].setName("PartNumber");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)8));
        Object var26_26 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var26_26));
        cIMPropertyArray[23] = new CIMProperty("PhysicalLabels");
        cIMPropertyArray[23].setName("PhysicalLabels");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)22));
        Object var27_27 = null;
        cIMPropertyArray[23].setValue(new CIMValue(var27_27));
        cIMPropertyArray[24] = new CIMProperty("PoweredOn");
        cIMPropertyArray[24].setName("PoweredOn");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl3 = new Boolean(true);
        cIMPropertyArray[24].setValue(new CIMValue((Object)bl3));
        cIMPropertyArray[25] = new CIMProperty("Removable");
        cIMPropertyArray[25].setName("Removable");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl4 = new Boolean(false);
        cIMPropertyArray[25].setValue(new CIMValue((Object)bl4));
        cIMPropertyArray[26] = new CIMProperty("RemovalConditions");
        cIMPropertyArray[26].setName("RemovalConditions");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[26].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[27] = new CIMProperty("Replaceable");
        cIMPropertyArray[27].setName("Replaceable");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl5 = new Boolean(false);
        cIMPropertyArray[27].setValue(new CIMValue((Object)bl5));
        cIMPropertyArray[28] = new CIMProperty("SKU");
        cIMPropertyArray[28].setName("SKU");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)8));
        Object var32_32 = null;
        cIMPropertyArray[28].setValue(new CIMValue(var32_32));
        cIMPropertyArray[29] = new CIMProperty("SerialNumber");
        cIMPropertyArray[29].setName("SerialNumber");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)8));
        Object var33_33 = null;
        cIMPropertyArray[29].setValue(new CIMValue(var33_33));
        cIMPropertyArray[30] = new CIMProperty("Status");
        cIMPropertyArray[30].setName("Status");
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)8));
        Object var34_34 = null;
        cIMPropertyArray[30].setValue(new CIMValue(var34_34));
        cIMPropertyArray[31] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[31].setName("StatusDescriptions");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector5 = new Vector();
        cIMPropertyArray[31].setValue(new CIMValue(vector5));
        cIMPropertyArray[32] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[32].setName("SystemCreationClassName");
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)8));
        Object var36_36 = null;
        cIMPropertyArray[32].setValue(new CIMValue(var36_36));
        cIMPropertyArray[33] = new CIMProperty("Tag");
        cIMPropertyArray[33].setName("Tag");
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[33].setKey(true);
        String string = this.subsystemNameWithModel + "-" + n;
        cIMPropertyArray[33].setValue(new CIMValue((Object)string));
        cIMPropertyArray[34] = new CIMProperty("TimeOfLastMount");
        cIMPropertyArray[34].setName("TimeOfLastMount");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)12));
        Object var38_38 = null;
        cIMPropertyArray[34].setValue(new CIMValue(var38_38));
        cIMPropertyArray[35] = new CIMProperty("TotalMountTime");
        cIMPropertyArray[35].setName("TotalMountTime");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)6));
        Object var39_39 = null;
        cIMPropertyArray[35].setValue(new CIMValue(var39_39));
        cIMPropertyArray[36] = new CIMProperty("UserTracking");
        cIMPropertyArray[36].setName("UserTracking");
        cIMPropertyArray[36].setType(CIMDataType.getPredefinedType((int)8));
        Object var40_40 = null;
        cIMPropertyArray[36].setValue(new CIMValue(var40_40));
        cIMPropertyArray[37] = new CIMProperty("VendorEquipmentType");
        cIMPropertyArray[37].setName("VendorEquipmentType");
        cIMPropertyArray[37].setType(CIMDataType.getPredefinedType((int)8));
        Object var41_41 = null;
        cIMPropertyArray[37].setValue(new CIMValue(var41_41));
        cIMPropertyArray[38] = new CIMProperty("version");
        cIMPropertyArray[38].setName("version");
        cIMPropertyArray[38].setType(CIMDataType.getPredefinedType((int)8));
        Object var42_42 = null;
        cIMPropertyArray[38].setValue(new CIMValue(var42_42));
        cIMPropertyArray[39] = new CIMProperty("WriteProtectOn");
        cIMPropertyArray[39].setName("WriteProtectOn");
        cIMPropertyArray[39].setType(CIMDataType.getPredefinedType((int)9));
        Object var43_43 = null;
        cIMPropertyArray[39].setValue(new CIMValue(var43_43));
        cIMPropertyArray[40] = new CIMProperty("Caption");
        cIMPropertyArray[40].setName("Caption");
        cIMPropertyArray[40].setType(CIMDataType.getPredefinedType((int)8));
        Object var44_44 = null;
        cIMPropertyArray[40].setValue(new CIMValue(var44_44));
        for (int i = 0; i < n2; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_disk_drive(int n, int n2) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_DiskDrive");
        cIMInstance.setName("IBMTSESS_DiskDrive");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n3 = 59;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n3];
        cIMPropertyArray[0] = new CIMProperty("AdditionalAvailability");
        cIMPropertyArray[0].setName("AdditionalAvailability");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)2));
        Object var7_7 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var7_7));
        cIMPropertyArray[1] = new CIMProperty("Availability");
        cIMPropertyArray[1].setName("Availability");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)2));
        Object var8_8 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var8_8));
        cIMPropertyArray[2] = new CIMProperty("Capabilities");
        cIMPropertyArray[2].setName("Capabilities");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(3));
        cIMPropertyArray[2].setValue(new CIMValue(vector2));
        cIMPropertyArray[3] = new CIMProperty("CapabilityDescriptions");
        cIMPropertyArray[3].setName("CapabilityDescriptions");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("146 GB Disk Drive");
        cIMPropertyArray[3].setValue(new CIMValue(vector3));
        cIMPropertyArray[4] = new CIMProperty("Caption");
        cIMPropertyArray[4].setName("Caption");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var11_11));
        cIMPropertyArray[5] = new CIMProperty("CompressionMethod");
        cIMPropertyArray[5].setName("CompressionMethod");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        Object var12_12 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var12_12));
        cIMPropertyArray[6] = new CIMProperty("CreationClassName");
        cIMPropertyArray[6].setName("CreationClassName");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[6].setKey(true);
        Object var13_13 = null;
        cIMPropertyArray[6].setValue(new CIMValue((Object)"CreationClassName"));
        cIMPropertyArray[7] = new CIMProperty("DefaultBlockSize");
        cIMPropertyArray[7].setName("DefaultBlockSize");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt64 = new UnsignedInt64("512");
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt64));
        cIMPropertyArray[8] = new CIMProperty("Description");
        cIMPropertyArray[8].setName("Description");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var15_15));
        cIMPropertyArray[9] = new CIMProperty("DeviceID");
        cIMPropertyArray[9].setName("DeviceID");
        cIMPropertyArray[9].setKey(true);
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string = IDGenerator.generateWWN();
        cIMPropertyArray[9].setValue(new CIMValue((Object)string));
        cIMPropertyArray[10] = new CIMProperty("ECLevel");
        cIMPropertyArray[10].setName("ECLevel");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "H24353";
        cIMPropertyArray[10].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[11] = new CIMProperty("ElementName");
        cIMPropertyArray[11].setName("ElementName");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "DiskDrive" + n + " on " + n2;
        cIMPropertyArray[11].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[12] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[12].setName("EnabledDefault");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[12].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[13] = new CIMProperty("EnabledState");
        cIMPropertyArray[13].setName("EnabledState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[14] = new CIMProperty("ErrorCleared");
        cIMPropertyArray[14].setName("ErrorCleared");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)9));
        Object var21_21 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var21_21));
        cIMPropertyArray[15] = new CIMProperty("ErrorDescription");
        cIMPropertyArray[15].setName("ErrorDescription");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        Object var22_22 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var22_22));
        cIMPropertyArray[16] = new CIMProperty("ErrorMethodology");
        cIMPropertyArray[16].setName("ErrorMethodology");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        Object var23_23 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var23_23));
        cIMPropertyArray[17] = new CIMProperty("FirmwareLevel");
        cIMPropertyArray[17].setName("FirmwareLevel");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "3603";
        cIMPropertyArray[17].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[18] = new CIMProperty("IdentifyingDescriptions");
        cIMPropertyArray[18].setName("IdentifyingDescriptions");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector4 = new Vector();
        cIMPropertyArray[18].setValue(new CIMValue(vector4));
        cIMPropertyArray[19] = new CIMProperty("InstallDate");
        cIMPropertyArray[19].setName("InstallDate");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)12));
        Object var26_26 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var26_26));
        cIMPropertyArray[20] = new CIMProperty("LastCleaned");
        cIMPropertyArray[20].setName("LastCleaned");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)12));
        Object var27_27 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var27_27));
        cIMPropertyArray[21] = new CIMProperty("LastErrorCode");
        cIMPropertyArray[21].setName("LastErrorCode");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)4));
        Object var28_28 = null;
        cIMPropertyArray[21].setValue(new CIMValue(var28_28));
        cIMPropertyArray[22] = new CIMProperty("LoadTime");
        cIMPropertyArray[22].setName("LoadTime");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)6));
        Object var29_29 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var29_29));
        cIMPropertyArray[23] = new CIMProperty("Manufacturer");
        cIMPropertyArray[23].setName("Manufacturer");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "Seagate";
        cIMPropertyArray[23].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[24] = new CIMProperty("MaxAccessTime");
        cIMPropertyArray[24].setName("MaxAccessTime");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)6));
        Object var31_31 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var31_31));
        cIMPropertyArray[25] = new CIMProperty("MaxBlockSize");
        cIMPropertyArray[25].setName("MaxBlockSize");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt642 = new UnsignedInt64("512");
        cIMPropertyArray[25].setValue(new CIMValue((Object)unsignedInt642));
        cIMPropertyArray[26] = new CIMProperty("MaxMediaSize");
        cIMPropertyArray[26].setName("MaxMediaSize");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt643 = new UnsignedInt64("146000000");
        cIMPropertyArray[26].setValue(new CIMValue((Object)unsignedInt643));
        cIMPropertyArray[27] = new CIMProperty("MaxQuiesceTime");
        cIMPropertyArray[27].setName("MaxQuiesceTime");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)6));
        Object var34_34 = null;
        cIMPropertyArray[27].setValue(new CIMValue(var34_34));
        cIMPropertyArray[28] = new CIMProperty("MaxUnitsBeforeCleaning");
        cIMPropertyArray[28].setName("MaxUnitsBeforeCleaning");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)6));
        Object var35_35 = null;
        cIMPropertyArray[28].setValue(new CIMValue(var35_35));
        cIMPropertyArray[29] = new CIMProperty("MediaIsLocked");
        cIMPropertyArray[29].setName("MediaIsLocked");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(false);
        cIMPropertyArray[29].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[30] = new CIMProperty("MinBlockSize");
        cIMPropertyArray[30].setName("MinBlockSize");
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt644 = new UnsignedInt64("512");
        cIMPropertyArray[30].setValue(new CIMValue((Object)unsignedInt644));
        cIMPropertyArray[31] = new CIMProperty("Model");
        cIMPropertyArray[31].setName("Model");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = "S0AE146";
        cIMPropertyArray[31].setValue(new CIMValue((Object)string6));
        cIMPropertyArray[32] = new CIMProperty("MountCount");
        cIMPropertyArray[32].setName("MountCount");
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)6));
        Object var39_39 = null;
        cIMPropertyArray[32].setValue(new CIMValue(var39_39));
        cIMPropertyArray[33] = new CIMProperty("Name");
        cIMPropertyArray[33].setName("Name");
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)8));
        String string7 = "Disk Drive " + string;
        cIMPropertyArray[33].setValue(new CIMValue((Object)string7));
        cIMPropertyArray[34] = new CIMProperty("NeedsCleaning");
        cIMPropertyArray[34].setName("NeedsCleaning");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(false);
        cIMPropertyArray[34].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[35] = new CIMProperty("NumberOfMediaSupported");
        cIMPropertyArray[35].setName("NumberOfMediaSupported");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)4));
        UnsignedInt32 unsignedInt32 = new UnsignedInt32("1");
        cIMPropertyArray[35].setValue(new CIMValue((Object)unsignedInt32));
        cIMPropertyArray[36] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[36].setName("OperationalStatus");
        cIMPropertyArray[36].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt32> vector5 = new Vector<UnsignedInt32>();
        vector5.add(new UnsignedInt32(2L));
        cIMPropertyArray[36].setValue(new CIMValue(vector5));
        cIMPropertyArray[37] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[37].setName("OtherEnabledState");
        cIMPropertyArray[37].setType(CIMDataType.getPredefinedType((int)8));
        Object var44_44 = null;
        cIMPropertyArray[37].setValue(new CIMValue(var44_44));
        cIMPropertyArray[38] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[38].setName("OtherIdentifyingInfo");
        cIMPropertyArray[38].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector6 = new Vector();
        cIMPropertyArray[38].setValue(new CIMValue(vector6));
        cIMPropertyArray[39] = new CIMProperty("PowerManagementCapabilities");
        cIMPropertyArray[39].setName("PowerManagementCapabilities");
        cIMPropertyArray[39].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector7 = new Vector();
        cIMPropertyArray[39].setValue(new CIMValue(vector7));
        cIMPropertyArray[40] = new CIMProperty("PowerManagementSupported");
        cIMPropertyArray[40].setName("PowerManagementSupported");
        cIMPropertyArray[40].setType(CIMDataType.getPredefinedType((int)9));
        Object var47_47 = null;
        cIMPropertyArray[40].setValue(new CIMValue(var47_47));
        cIMPropertyArray[41] = new CIMProperty("PowerOnHours");
        cIMPropertyArray[41].setName("PowerOnHours");
        cIMPropertyArray[41].setType(CIMDataType.getPredefinedType((int)6));
        Object var48_48 = null;
        cIMPropertyArray[41].setValue(new CIMValue(var48_48));
        cIMPropertyArray[42] = new CIMProperty("RankID");
        cIMPropertyArray[42].setName("RankID");
        cIMPropertyArray[42].setType(CIMDataType.getPredefinedType((int)8));
        String string8 = Integer.toString(n);
        cIMPropertyArray[42].setValue(new CIMValue((Object)string8));
        cIMPropertyArray[43] = new CIMProperty("RequestedState");
        cIMPropertyArray[43].setName("RequestedState");
        cIMPropertyArray[43].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[43].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[44] = new CIMProperty("Security");
        cIMPropertyArray[44].setName("Security");
        cIMPropertyArray[44].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(1);
        cIMPropertyArray[44].setValue(new CIMValue((Object)unsignedInt164));
        cIMPropertyArray[45] = new CIMProperty("Status");
        cIMPropertyArray[45].setName("Status");
        cIMPropertyArray[45].setType(CIMDataType.getPredefinedType((int)8));
        Object var52_52 = null;
        cIMPropertyArray[45].setValue(new CIMValue(var52_52));
        cIMPropertyArray[46] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[46].setName("StatusDescriptions");
        cIMPropertyArray[46].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector8 = new Vector();
        cIMPropertyArray[46].setValue(new CIMValue(vector8));
        cIMPropertyArray[47] = new CIMProperty("StatusInfo");
        cIMPropertyArray[47].setName("StatusInfo");
        cIMPropertyArray[47].setType(CIMDataType.getPredefinedType((int)2));
        Object var54_54 = null;
        cIMPropertyArray[47].setValue(new CIMValue(var54_54));
        cIMPropertyArray[48] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[48].setName("SystemCreationClassName");
        cIMPropertyArray[48].setKey(true);
        cIMPropertyArray[48].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[48].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[49] = new CIMProperty("SystemName");
        cIMPropertyArray[49].setName("SystemName");
        cIMPropertyArray[49].setKey(true);
        cIMPropertyArray[49].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[49].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        cIMPropertyArray[50] = new CIMProperty("TimeOfLastMount");
        cIMPropertyArray[50].setName("TimeOfLastMount");
        cIMPropertyArray[50].setType(CIMDataType.getPredefinedType((int)12));
        Object var55_55 = null;
        cIMPropertyArray[50].setValue(new CIMValue(var55_55));
        cIMPropertyArray[51] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[51].setName("TimeOfLastStateChange");
        cIMPropertyArray[51].setType(CIMDataType.getPredefinedType((int)12));
        Object var56_56 = null;
        cIMPropertyArray[51].setValue(new CIMValue(var56_56));
        cIMPropertyArray[52] = new CIMProperty("TotalMountTime");
        cIMPropertyArray[52].setName("TotalMountTime");
        cIMPropertyArray[52].setType(CIMDataType.getPredefinedType((int)6));
        Object var57_57 = null;
        cIMPropertyArray[52].setValue(new CIMValue(var57_57));
        cIMPropertyArray[53] = new CIMProperty("TotalPowerOnHours");
        cIMPropertyArray[53].setName("TotalPowerOnHours");
        cIMPropertyArray[53].setType(CIMDataType.getPredefinedType((int)6));
        Object var58_58 = null;
        cIMPropertyArray[53].setValue(new CIMValue(var58_58));
        cIMPropertyArray[54] = new CIMProperty("UncompressedDataRate");
        cIMPropertyArray[54].setName("UncompressedDataRate");
        cIMPropertyArray[54].setType(CIMDataType.getPredefinedType((int)4));
        Object var59_59 = null;
        cIMPropertyArray[54].setValue(new CIMValue(var59_59));
        cIMPropertyArray[55] = new CIMProperty("UnitsDescription");
        cIMPropertyArray[55].setName("UnitsDescription");
        cIMPropertyArray[55].setType(CIMDataType.getPredefinedType((int)8));
        Object var60_60 = null;
        cIMPropertyArray[55].setValue(new CIMValue(var60_60));
        cIMPropertyArray[56] = new CIMProperty("UnitsUsed");
        cIMPropertyArray[56].setName("UnitsUsed");
        cIMPropertyArray[56].setType(CIMDataType.getPredefinedType((int)6));
        Object var61_61 = null;
        cIMPropertyArray[56].setValue(new CIMValue(var61_61));
        cIMPropertyArray[57] = new CIMProperty("UnloadTime");
        cIMPropertyArray[57].setName("UnloadTime");
        cIMPropertyArray[57].setType(CIMDataType.getPredefinedType((int)6));
        Object var62_62 = null;
        cIMPropertyArray[57].setValue(new CIMValue(var62_62));
        cIMPropertyArray[58] = new CIMProperty("physicalPackage");
        cIMPropertyArray[58].setName("physicalPackage");
        cIMPropertyArray[58].setType(CIMDataType.getPredefinedType((int)8));
        String string9 = Integer.toString(n);
        cIMPropertyArray[58].setValue(new CIMValue((Object)string9));
        for (int i = 0; i < n3; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_SAP_available_for_element(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_SAPAvailableForElement");
        cIMInstance3.setName("IBMTSESS_SAPAvailableForElement");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("AvailableSAP");
        cIMProperty.setName("GroupComponent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_SAPAvailableForElement"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("ManagedElement");
        cIMProperty2.setName("PartComponent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_product_physical_component(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_ProductPhysicalComponent");
        cIMInstance3.setName("IBMTSESS_ProductPhysicalComponent");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("GroupComponent");
        cIMProperty.setName("GroupComponent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_Product"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("PartComponent");
        cIMProperty2.setName("PartComponent");
        cIMProperty2.setType(new CIMDataType("IBMTS_Chassis"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_pcm_elt_capabilities(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_PCMEltCapabilities");
        cIMInstance3.setName("IBMTSESS_PCMEltCapabilities");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Capabilities");
        cIMProperty.setName("Capabilities");
        cIMProperty.setType(new CIMDataType("IBMTSESS_ProtocolControllerMaskingCapabilities"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("ManagedElement");
        cIMProperty2.setName("ManagedElement");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_protocol_controller_masking_capabilities() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_ProtocolControllerMaskingCapabilities");
        cIMInstance.setName("IBMTSESS_ProtocolControllerMaskingCapabilities");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 15;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("AttachDeviceSupported");
        cIMPropertyArray[0].setName("AttachDeviceSupported");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[0].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("ClientSelectableDeviceNumbers");
        cIMPropertyArray[2].setName("ClientSelectableDeviceNumbers");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(true);
        cIMPropertyArray[2].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var8_8 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var8_8));
        cIMPropertyArray[4] = new CIMProperty("InstanceID");
        cIMPropertyArray[4].setName("InstanceID");
        cIMPropertyArray[4].setKey(true);
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string = "ProtocolControllerMaskingCapabilities";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string));
        cIMPropertyArray[5] = new CIMProperty("OneHardwareIDPerView");
        cIMPropertyArray[5].setName("OneHardwareIDPerView");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl3 = new Boolean(true);
        cIMPropertyArray[5].setValue(new CIMValue((Object)bl3));
        cIMPropertyArray[6] = new CIMProperty("OtherValidHardwareIDTypes");
        cIMPropertyArray[6].setName("OtherValidHardwareIDTypes");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector2 = new Vector();
        cIMPropertyArray[6].setValue(new CIMValue(vector2));
        cIMPropertyArray[7] = new CIMProperty("PortsPerView");
        cIMPropertyArray[7].setName("PortsPerView");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(3);
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[8] = new CIMProperty("PrivilegeDeniedSupported");
        cIMPropertyArray[8].setName("PrivilegeDeniedSupported");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl4 = new Boolean(false);
        cIMPropertyArray[8].setValue(new CIMValue((Object)bl4));
        cIMPropertyArray[9] = new CIMProperty("ProtocolControllerRequiresAuthorizedIdentity");
        cIMPropertyArray[9].setName("ProtocolControllerRequiresAuthorizedIdentity");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl5 = new Boolean(true);
        cIMPropertyArray[9].setValue(new CIMValue((Object)bl5));
        cIMPropertyArray[10] = new CIMProperty("ProtocolControllerSupportsCollections");
        cIMPropertyArray[10].setName("ProtocolControllerSupportsCollections");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl6 = new Boolean(false);
        cIMPropertyArray[10].setValue(new CIMValue((Object)bl6));
        cIMPropertyArray[11] = new CIMProperty("UniqueUnitNumbersPerPort");
        cIMPropertyArray[11].setName("UniqueUnitNumbersPerPort");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl7 = new Boolean(false);
        cIMPropertyArray[11].setValue(new CIMValue((Object)bl7));
        cIMPropertyArray[12] = new CIMProperty("ValidHardwareIdTypes");
        cIMPropertyArray[12].setName("ValidHardwareIdTypes");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        vector3.add(new UnsignedInt16(2));
        cIMPropertyArray[12].setValue(new CIMValue(vector3));
        cIMPropertyArray[13] = new CIMProperty("OnePortPerView");
        cIMPropertyArray[13].setName("OnePortPerView");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl8 = new Boolean(false);
        cIMPropertyArray[13].setValue(new CIMValue((Object)bl8));
        cIMPropertyArray[14] = new CIMProperty("ElementName");
        cIMPropertyArray[14].setName("ElementName");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "ProtocolControllerMaskingCapabilities";
        cIMPropertyArray[14].setValue(new CIMValue((Object)string2));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_installed_software_identity(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_InstalledSoftwareIdentity");
        cIMInstance3.setName("IBMTSESS_InstalledSoftwareIdentity");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("InstalledSoftware");
        cIMProperty.setName("InstalledSoftware");
        cIMProperty.setType(new CIMDataType("IBMTSESS_SoftwareIdentity"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("System");
        cIMProperty2.setName("System");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_hosted_service6(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_HostedService6");
        cIMInstance3.setName("IBMTSESS_HostedService6");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_PerformanceStatisticService"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_hosted_service4(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_HostedService4");
        cIMInstance3.setName("IBMTSESS_HostedService4");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_ControllerConfigurationService"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_hosted_service3(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_HostedService3");
        cIMInstance3.setName("IBMTSESS_HostedService3");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageHardwareIDManagementService"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_stg_config_srv_elt_capabilities(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_StgConfigSrvEltCapabilities");
        cIMInstance3.setName("IBMTSESS_StgConfigSrvEltCapabilities");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Capabilities");
        cIMProperty.setName("Capabilities");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageConfigurationCapabilities"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("ManagedElement");
        cIMProperty2.setName("ManagedElement");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageConfigurationService"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_storage_hardware_id_management_service() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageHardwareIDManagementService");
        cIMInstance.setName("IBMTSESS_StorageHardwareIDManagementService");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 20;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[0].setName("PrimaryOwnerContact");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_StorageHardwareIDManagementService"));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var7_7));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string = "StorageHardwareIDManagementService";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string));
        cIMPropertyArray[5] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[5].setName("EnabledDefault");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[6] = new CIMProperty("EnabledState");
        cIMPropertyArray[6].setName("EnabledState");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[7] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[7].setName("PrimaryOwnerName");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var11_11));
        cIMPropertyArray[8] = new CIMProperty("InstallDate");
        cIMPropertyArray[8].setName("InstallDate");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)12));
        Object var12_12 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var12_12));
        cIMPropertyArray[9] = new CIMProperty("Name");
        cIMPropertyArray[9].setName("Name");
        cIMPropertyArray[9].setKey(true);
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "StorageHardwareIDManagementService";
        cIMPropertyArray[9].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[10] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[10].setName("OperationalStatus");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[10].setValue(new CIMValue(vector2));
        cIMPropertyArray[11] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[11].setName("OtherEnabledState");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("StartMode");
        cIMPropertyArray[12].setName("StartMode");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var16_16));
        cIMPropertyArray[13] = new CIMProperty("RequestedState");
        cIMPropertyArray[13].setName("RequestedState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[14] = new CIMProperty("Status");
        cIMPropertyArray[14].setName("Status");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[15].setName("StatusDescriptions");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector3));
        cIMPropertyArray[16] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[16].setName("SystemCreationClassName");
        cIMPropertyArray[16].setKey(true);
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[17] = new CIMProperty("SystemName");
        cIMPropertyArray[17].setName("SystemName");
        cIMPropertyArray[17].setKey(true);
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[18] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[18].setName("TimeOfLastStateChange");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)12));
        Object var20_20 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var20_20));
        cIMPropertyArray[19] = new CIMProperty("Started");
        cIMPropertyArray[19].setName("Started");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)9));
        Object var21_21 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var21_21));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_storage_configuration_capabilities() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageConfigurationCapabilities");
        cIMInstance.setName("IBMTSESS_StorageConfigurationCapabilities");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 11;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("InstanceID");
        cIMPropertyArray[0].setName("InstanceID");
        cIMPropertyArray[0].setKey(true);
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        String string = "StorageConfigurationCapabilities";
        cIMPropertyArray[0].setValue(new CIMValue((Object)string));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("InitialReplicationState");
        cIMPropertyArray[2].setName("InitialReplicationState");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var8_8 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var8_8));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "StorageConfigurationCapabilities";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[5] = new CIMProperty("SupportedAsynchronousActions");
        cIMPropertyArray[5].setName("SupportedAsynchronousActions");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(10));
        cIMPropertyArray[5].setValue(new CIMValue(vector2));
        cIMPropertyArray[6] = new CIMProperty("SupportedCopyTypes");
        cIMPropertyArray[6].setName("SupportedCopyTypes");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        vector3.add(new UnsignedInt16(2));
        vector3.add(new UnsignedInt16(3));
        vector3.add(new UnsignedInt16(4));
        vector3.add(new UnsignedInt16(5));
        cIMPropertyArray[6].setValue(new CIMValue(vector3));
        cIMPropertyArray[7] = new CIMProperty("SupportedStorageElementFeatures");
        cIMPropertyArray[7].setName("SupportedStorageElementFeatures");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        vector4.add(new UnsignedInt16(3));
        vector4.add(new UnsignedInt16(6));
        cIMPropertyArray[7].setValue(new CIMValue(vector4));
        cIMPropertyArray[8] = new CIMProperty("SupportedStorageElementTypes");
        cIMPropertyArray[8].setName("SupportedStorageElementTypes");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector5 = new Vector<UnsignedInt16>();
        vector5.add(new UnsignedInt16(2));
        vector5.add(new UnsignedInt16(3));
        cIMPropertyArray[8].setValue(new CIMValue(vector5));
        cIMPropertyArray[9] = new CIMProperty("SupportedStoragePoolFeatures");
        cIMPropertyArray[9].setName("SupportedStoragePoolFeatures");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector6 = new Vector<UnsignedInt16>();
        vector6.add(new UnsignedInt16(2));
        vector6.add(new UnsignedInt16(3));
        cIMPropertyArray[9].setValue(new CIMValue(vector6));
        cIMPropertyArray[10] = new CIMProperty("SupportedSynchronousActions");
        cIMPropertyArray[10].setName("SupportedSynchronousActions");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector7 = new Vector<UnsignedInt16>();
        vector7.add(new UnsignedInt16(2));
        vector7.add(new UnsignedInt16(3));
        vector7.add(new UnsignedInt16(5));
        vector7.add(new UnsignedInt16(9));
        vector7.add(new UnsignedInt16(10));
        cIMPropertyArray[10].setValue(new CIMValue(vector7));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_performance_statistics_service() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_PerformanceStatisticService");
        cIMInstance.setName("IBMTSESS_PerformanceStatisticService");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 24;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[0].setName("PrimaryOwnerContact");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[1].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string = "This service is to query the performance statistic of the ESS.";
        cIMPropertyArray[3].setValue(new CIMValue((Object)string));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[4].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        cIMPropertyArray[5] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[5].setName("EnabledDefault");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[6] = new CIMProperty("EnabledState");
        cIMPropertyArray[6].setName("EnabledState");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(2);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[7] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[7].setName("PrimaryOwnerName");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var9_9));
        cIMPropertyArray[8] = new CIMProperty("InstallDate");
        cIMPropertyArray[8].setName("InstallDate");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)12));
        Object var10_10 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var10_10));
        cIMPropertyArray[9] = new CIMProperty("Name");
        cIMPropertyArray[9].setName("Name");
        cIMPropertyArray[9].setKey(true);
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "LunMaskPrivilegeService";
        cIMPropertyArray[9].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[10] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[10].setName("OperationalStatus");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(2));
        cIMPropertyArray[10].setValue(new CIMValue(vector2));
        cIMPropertyArray[11] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[11].setName("OtherEnabledState");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var13_13 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var13_13));
        cIMPropertyArray[12] = new CIMProperty("StartMode");
        cIMPropertyArray[12].setName("StartMode");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var14_14 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var14_14));
        cIMPropertyArray[13] = new CIMProperty("RequestedState");
        cIMPropertyArray[13].setName("RequestedState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[14] = new CIMProperty("Status");
        cIMPropertyArray[14].setName("Status");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var16_16));
        cIMPropertyArray[15] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[15].setName("StatusDescriptions");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector3));
        cIMPropertyArray[16] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[16].setName("SystemCreationClassName");
        cIMPropertyArray[16].setKey(true);
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[16].setValue(new CIMValue((Object)"IBMTSESS_LunMaskPrivilegeService"));
        cIMPropertyArray[17] = new CIMProperty("SystemName");
        cIMPropertyArray[17].setName("SystemName");
        cIMPropertyArray[17].setKey(true);
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[18] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[18].setName("TimeOfLastStateChange");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)12));
        Object var18_18 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var18_18));
        cIMPropertyArray[19] = new CIMProperty("Started");
        cIMPropertyArray[19].setName("Started");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[19].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[20] = new CIMProperty("EndTime");
        cIMPropertyArray[20].setName("EndTime");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)12));
        Object var20_20 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var20_20));
        cIMPropertyArray[21] = new CIMProperty("Frequency");
        cIMPropertyArray[21].setName("Frequency");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt64 = new UnsignedInt64("5");
        cIMPropertyArray[21].setValue(new CIMValue((Object)unsignedInt64));
        cIMPropertyArray[22] = new CIMProperty("Port");
        cIMPropertyArray[22].setName("Port");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(0);
        cIMPropertyArray[22].setValue(new CIMValue((Object)unsignedInt164));
        cIMPropertyArray[23] = new CIMProperty("StatisticsCollection");
        cIMPropertyArray[23].setName("StatisticsCollection");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "disabled";
        cIMPropertyArray[23].setValue(new CIMValue((Object)string3));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_hosted_service2(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_HostedService2");
        cIMInstance3.setName("IBMTSESS_HostedService2");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_LunMaskPrivilegeService"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_lun_mask_privilege_service() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_LunMaskPrivilegeService");
        cIMInstance.setName("IBMTSESS_LunMaskPrivilegeService");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 20;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[0].setName("PrimaryOwnerContact");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_LunMaskPrivilegeService"));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var7_7));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string = "LunMaskPrivilegeService";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string));
        cIMPropertyArray[5] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[5].setName("EnabledDefault");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[6] = new CIMProperty("EnabledState");
        cIMPropertyArray[6].setName("EnabledState");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[7] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[7].setName("PrimaryOwnerName");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var11_11));
        cIMPropertyArray[8] = new CIMProperty("InstallDate");
        cIMPropertyArray[8].setName("InstallDate");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)12));
        Object var12_12 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var12_12));
        cIMPropertyArray[9] = new CIMProperty("Name");
        cIMPropertyArray[9].setName("Name");
        cIMPropertyArray[9].setKey(true);
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "LunMaskPrivilegeService";
        cIMPropertyArray[9].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[10] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[10].setName("OperationalStatus");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[10].setValue(new CIMValue(vector2));
        cIMPropertyArray[11] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[11].setName("OtherEnabledState");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("StartMode");
        cIMPropertyArray[12].setName("StartMode");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var16_16));
        cIMPropertyArray[13] = new CIMProperty("RequestedState");
        cIMPropertyArray[13].setName("RequestedState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[14] = new CIMProperty("Status");
        cIMPropertyArray[14].setName("Status");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[15].setName("StatusDescriptions");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector3));
        cIMPropertyArray[16] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[16].setName("SystemCreationClassName");
        cIMPropertyArray[16].setKey(true);
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[17] = new CIMProperty("SystemName");
        cIMPropertyArray[17].setName("SystemName");
        cIMPropertyArray[17].setKey(true);
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[18] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[18].setName("TimeOfLastStateChange");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)12));
        Object var20_20 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var20_20));
        cIMPropertyArray[19] = new CIMProperty("Started");
        cIMPropertyArray[19].setName("Started");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)9));
        Object var21_21 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var21_21));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_hosted_service(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_HostedService");
        cIMInstance3.setName("IBMTSESS_HostedService");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageConfigurationService"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_storage_configuration_service() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageConfigurationService");
        cIMInstance.setName("IBMTSESS_StorageConfigurationService");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 20;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[0].setName("PrimaryOwnerContact");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_StorageConfigurationService"));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var7_7));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string = "StorageConfigurationService";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string));
        cIMPropertyArray[5] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[5].setName("EnabledDefault");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[6] = new CIMProperty("EnabledState");
        cIMPropertyArray[6].setName("EnabledState");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[7] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[7].setName("PrimaryOwnerName");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var11_11));
        cIMPropertyArray[8] = new CIMProperty("InstallDate");
        cIMPropertyArray[8].setName("InstallDate");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)12));
        Object var12_12 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var12_12));
        cIMPropertyArray[9] = new CIMProperty("Name");
        cIMPropertyArray[9].setName("Name");
        cIMPropertyArray[9].setKey(true);
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "ConfigService";
        cIMPropertyArray[9].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[10] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[10].setName("OperationalStatus");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[10].setValue(new CIMValue(vector2));
        cIMPropertyArray[11] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[11].setName("OtherEnabledState");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("StartMode");
        cIMPropertyArray[12].setName("StartMode");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var16_16));
        cIMPropertyArray[13] = new CIMProperty("RequestedState");
        cIMPropertyArray[13].setName("RequestedState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[14] = new CIMProperty("Status");
        cIMPropertyArray[14].setName("Status");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[15].setName("StatusDescriptions");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector3));
        cIMPropertyArray[16] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[16].setName("SystemCreationClassName");
        cIMPropertyArray[16].setKey(true);
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[17] = new CIMProperty("SystemName");
        cIMPropertyArray[17].setName("SystemName");
        cIMPropertyArray[17].setKey(true);
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[18] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[18].setName("TimeOfLastStateChange");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)12));
        Object var20_20 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var20_20));
        cIMPropertyArray[19] = new CIMProperty("Started");
        cIMPropertyArray[19].setName("Started");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)9));
        Object var21_21 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var21_21));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_hosted_access_point(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_HostedAccessPoint");
        cIMInstance3.setName("IBMTSESS_HostedAccessPoint");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTS_System"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_RemoteServiceAccessPoint"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_remote_service_access_point() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_RemoteServiceAccessPoint");
        cIMInstance.setName("IBMTSESS_RemoteServiceAccessPoint");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 19;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("AccessInfo");
        cIMPropertyArray[0].setName("AccessInfo");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        String string = "http://" + this.subsystemName + ":8451/DS8000/Login";
        cIMPropertyArray[0].setValue(new CIMValue((Object)string));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_RemoteServiceAccessPoint"));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var7_7));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "System Management URL";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[5] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[5].setName("EnabledDefault");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[6] = new CIMProperty("EnabledState");
        cIMPropertyArray[6].setName("EnabledState");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[7] = new CIMProperty("InfoFormat");
        cIMPropertyArray[7].setName("InfoFormat");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(200);
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[8] = new CIMProperty("InstallDate");
        cIMPropertyArray[8].setName("InstallDate");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)12));
        Object var12_12 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var12_12));
        cIMPropertyArray[9] = new CIMProperty("Name");
        cIMPropertyArray[9].setName("Name");
        cIMPropertyArray[9].setKey(true);
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "RemoteServiceAccessPoint";
        cIMPropertyArray[9].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[10] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[10].setName("OperationalStatus");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[10].setValue(new CIMValue(vector2));
        cIMPropertyArray[11] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[11].setName("OtherEnabledState");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("OtherInfoFormatDescription");
        cIMPropertyArray[12].setName("OtherInfoFormatDescription");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var16_16));
        cIMPropertyArray[13] = new CIMProperty("RequestedState");
        cIMPropertyArray[13].setName("RequestedState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt164));
        cIMPropertyArray[14] = new CIMProperty("Status");
        cIMPropertyArray[14].setName("Status");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[15].setName("StatusDescriptions");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector3));
        cIMPropertyArray[16] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[16].setName("SystemCreationClassName");
        cIMPropertyArray[16].setKey(true);
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[17] = new CIMProperty("SystemName");
        cIMPropertyArray[17].setName("SystemName");
        cIMPropertyArray[17].setKey(true);
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[18] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[18].setName("TimeOfLastStateChange");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)12));
        Object var20_20 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var20_20));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_element_conforms_to_profile(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_ElementConformsToProfile");
        cIMInstance3.setName("IBMTSESS_ElementConformsToProfile");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("ConformantStandard");
        cIMProperty.setName("ConformantStandard");
        cIMProperty.setType(new CIMDataType("IBMTSESS_RegisteredProfile"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("ManagedElement");
        cIMProperty2.setName("ManagedElement");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_element_capabilities_masking(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_ElementCapabilitiesMasking");
        cIMInstance3.setName("IBMTSESS_ElementCapabilitiesMasking");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Capabilities");
        cIMProperty.setName("Capabilities");
        cIMProperty.setType(new CIMDataType("IBMTSESS_DeviceMaskingCapabilities"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("ManagedElement");
        cIMProperty2.setName("ManagedElement");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_ControllerConfigurationService"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_storage_client_setting_data(int n) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageClientSettingData");
        cIMInstance.setName("IBMTSESS_StorageClientSettingData");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n2 = 6;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n2];
        UnsignedInt16 unsignedInt16 = null;
        String string = null;
        String string2 = null;
        Vector<String> vector2 = new Vector<String>();
        switch (n) {
            case 0: {
                unsignedInt16 = new UnsignedInt16(15);
                string = "StorageClientSettingData for Intel-based Servers (Microsoft Windows 2003)";
                string2 = "Win2000";
                vector2.add("win2000");
                break;
            }
            case 1: {
                unsignedInt16 = new UnsignedInt16(16);
                string = "StorageClientSettingData for IBM AS/400 (V5R3 or higher)";
                string2 = "OS400_B";
                vector2.add("os400_b");
                break;
            }
            case 2: {
                unsignedInt16 = new UnsignedInt16(32790);
                string = "StorageClientSettingData for Sun Clustering using MPxIO";
                string2 = "SunMPXIO";
                break;
            }
            case 3: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for IBM iSeries/pSeries Servers (Linux)";
                string2 = "Linux PPC";
                vector2.add("linuxppc");
                break;
            }
            case 4: {
                unsignedInt16 = new UnsignedInt16(13);
                string = "StorageClientSettingData for Cisco iSCSI Gateway";
                string2 = "Cisco iSCSI Storage Router";
                break;
            }
            case 5: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for Intel-based Servers (Linux)";
                string2 = "Linux";
                vector2.add("linux");
                break;
            }
            case 6: {
                unsignedInt16 = new UnsignedInt16(15);
                string = "StorageClientSettingData for Intel-based Servers (Microsoft Windows NT4)";
                string2 = "Microsoft Windows";
                vector2.add("nt4");
                break;
            }
            case 7: {
                unsignedInt16 = new UnsignedInt16(9);
                string = "StorageClientSettingData for IBM SAN File System (AIX MDS)";
                string2 = "SANFileSystemAIX";
                vector2.add("SANFileSystemAIX");
            }
            case 8: {
                unsignedInt16 = new UnsignedInt16(32780);
                string = "StorageClientSettingData for VMware ESX";
                string2 = "VMware";
                break;
            }
            case 9: {
                unsignedInt16 = new UnsignedInt16(32800);
                string = "StorageClientSettingData for Apple Servers";
                string2 = "AppleOSX";
                break;
            }
            case 10: {
                unsignedInt16 = new UnsignedInt16(15);
                string = "StorageClientSettingData for Intel-based Servers (Microsoft Windows 2003)";
                string2 = "Win2003";
                vector2.add("win2003");
                break;
            }
            case 11: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for AMD Servers (Linux Suse)";
                string2 = "AMDLinuxSuse";
                vector2.add("amdlinuxsuse");
            }
            case 12: {
                unsignedInt16 = new UnsignedInt16(3);
                string = "StorageClientSettingData for Solaris 2.51";
                string2 = "Solaris 251";
                vector2.add("solaris251");
            }
            case 13: {
                unsignedInt16 = new UnsignedInt16(7);
                string = "StorageClientSettingData for Intel-based Servers (Novell Netware)";
                string2 = "Netware";
                break;
            }
            case 14: {
                unsignedInt16 = new UnsignedInt16(4);
                string = "StorageClientSettingData for HP Servers (HP-UX)";
                string2 = "HPUX";
                break;
            }
            case 15: {
                unsignedInt16 = new UnsignedInt16(11);
                string = "StorageClientSettingData for IBM NUMA-Q Servers (DYNIX/ptx)";
                string2 = "Dynix";
                break;
            }
            case 16: {
                unsignedInt16 = new UnsignedInt16(12);
                string = "StorageClientSettingData for SGI Origin Servers (IRIX)";
                string2 = "Irix";
                break;
            }
            case 17: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for IBM pSeries, RS/6000 and RS/6000 SP Servers (pLinux)";
                string2 = "PLinux";
                vector2.add("plinux");
                break;
            }
            case 18: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for AMD Servers (Linux RHEL)";
                string2 = "AMDLinuxRhel";
                vector2.add("amdlinuxrhel");
                break;
            }
            case 19: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for Intel-based Servers (Linux Red Flag)";
                string2 = "LinuxRF";
                vector2.add("linuxrf");
            }
            case 20: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for Intel-based Servers (Linux RHEL)";
                string2 = "LinuxRhel";
                vector2.add("linuxrhel");
            }
            case 21: {
                unsignedInt16 = new UnsignedInt16(3);
                string = "StorageClientSettingData for Fujitsu Servers (Solaris)";
                string2 = "Fujitsu";
                vector2.add("fujitsu");
                break;
            }
            case 22: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for IBM SAN File System (Linux MDS)";
                string2 = "SANFileSystemLinux";
                vector2.add("SANFileSystemLinux");
                break;
            }
            case 23: {
                unsignedInt16 = new UnsignedInt16(6);
                string = "StorageClientSettingData for HP AlphaServer (Tru64 UNIX)";
                string2 = "Tru64";
                break;
            }
            case 24: {
                unsignedInt16 = new UnsignedInt16(5);
                string = "StorageClientSettingData for HP AlphaServer (OpenVMS)";
                string2 = "OpenVMS";
                break;
            }
            case 25: {
                unsignedInt16 = new UnsignedInt16(10);
                string = "StorageClientSettingData for DGUX";
                string2 = "DGUX";
                break;
            }
            case 26: {
                unsignedInt16 = new UnsignedInt16(9);
                string = "StorageClientSettingData for IBM pSeries, RS/6000 and RS/6000 SP Servers (AIX)";
                string2 = "AIX";
                vector2.add("AIX");
                break;
            }
            case 27: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for IBM zSeries Servers (Linux)";
                string2 = "Linux 390";
                vector2.add("linux390");
                break;
            }
            case 28: {
                unsignedInt16 = new UnsignedInt16(16);
                string = "StorageClientSettingData for IBM AS/400 (V3R7 to V5R2)";
                string2 = "OS400";
                vector2.add("os400");
                break;
            }
            case 29: {
                unsignedInt16 = new UnsignedInt16(3);
                string = "StorageClientSettingData for Sun Servers (Solaris 2.6 or higher)";
                string2 = "Solaris 26";
                vector2.add("solaris26");
                break;
            }
            case 30: {
                unsignedInt16 = new UnsignedInt16(32770);
                string = "StorageClientSettingData for IBM SAN Volume Controller";
                string2 = "SANVolController";
                break;
            }
            case 31: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for Intel-based Servers (Linux Suse)";
                string2 = "LinuxSuse";
                vector2.add("linuxsuse");
                break;
            }
            case 32: {
                unsignedInt16 = new UnsignedInt16(14);
                string = "StorageClientSettingData for Intel-based Servers (Linux Desktop)";
                string2 = "LinuxDT";
                vector2.add("linuxdt");
            }
        }
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var10_10));
        cIMPropertyArray[1] = new CIMProperty("ClientTypes");
        cIMPropertyArray[1].setName("ClientTypes");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)16));
        cIMPropertyArray[1].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var11_11));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[3].setValue(new CIMValue((Object)string));
        cIMPropertyArray[4] = new CIMProperty("InstanceID");
        cIMPropertyArray[4].setName("InstanceID");
        cIMPropertyArray[4].setKey(true);
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[4].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[5] = new CIMProperty("OtherClientTypeDescriptions");
        cIMPropertyArray[5].setName("OtherClientTypeDescriptions");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)22));
        cIMPropertyArray[5].setValue(new CIMValue(vector2));
        for (int i = 0; i < n2; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_storage_capabilities() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageCapabilities");
        cIMInstance.setName("IBMTSESS_StorageCapabilities");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 16;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("DataRedundancyDefault");
        cIMPropertyArray[1].setName("DataRedundancyDefault");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(1);
        cIMPropertyArray[1].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[2] = new CIMProperty("DataRedundancyMax");
        cIMPropertyArray[2].setName("DataRedundancyMax");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(1);
        cIMPropertyArray[2].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[3] = new CIMProperty("DataRedundancyMin");
        cIMPropertyArray[3].setName("DataRedundancyMin");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(1);
        cIMPropertyArray[3].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[4] = new CIMProperty("DeltaReservationDefault");
        cIMPropertyArray[4].setName("DeltaReservationDefault");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(100);
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt164));
        cIMPropertyArray[5] = new CIMProperty("DeltaReservationMax");
        cIMPropertyArray[5].setName("DeltaReservationMax");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt165 = new UnsignedInt16(100);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt165));
        cIMPropertyArray[6] = new CIMProperty("DeltaReservationMin");
        cIMPropertyArray[6].setName("DeltaReservationMin");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt166 = new UnsignedInt16(100);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt166));
        cIMPropertyArray[7] = new CIMProperty("Description");
        cIMPropertyArray[7].setName("Description");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var12_12 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var12_12));
        cIMPropertyArray[8] = new CIMProperty("ElementName");
        cIMPropertyArray[8].setName("ElementName");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        String string = "Storage Capabilities for VolumeSpace";
        cIMPropertyArray[8].setValue(new CIMValue((Object)string));
        cIMPropertyArray[9] = new CIMProperty("ElementType");
        cIMPropertyArray[9].setName("ElementType");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt167 = new UnsignedInt16(5);
        cIMPropertyArray[9].setValue(new CIMValue((Object)unsignedInt167));
        cIMPropertyArray[10] = new CIMProperty("InstanceID");
        cIMPropertyArray[10].setName("InstanceID");
        cIMPropertyArray[10].setKey(true);
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[10].setValue(new CIMValue((Object)"IBMTSESS"));
        cIMPropertyArray[11] = new CIMProperty("NoSinglePointOfFailure");
        cIMPropertyArray[11].setName("NoSinglePointOfFailure");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[11].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[12] = new CIMProperty("NoSinglePointOfFailureDefault");
        cIMPropertyArray[12].setName("NoSinglePointOfFailureDefault");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(true);
        cIMPropertyArray[12].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[13] = new CIMProperty("PackageRedundancyDefault");
        cIMPropertyArray[13].setName("PackageRedundancyDefault");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt168 = new UnsignedInt16(1);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt168));
        cIMPropertyArray[14] = new CIMProperty("PackageRedundancyMax");
        cIMPropertyArray[14].setName("PackageRedundancyMax");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt169 = new UnsignedInt16(1);
        cIMPropertyArray[14].setValue(new CIMValue((Object)unsignedInt169));
        cIMPropertyArray[15] = new CIMProperty("PackageRedundancyMin");
        cIMPropertyArray[15].setName("PackageRedundancyMin");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt1610 = new UnsignedInt16(1);
        cIMPropertyArray[15].setValue(new CIMValue((Object)unsignedInt1610));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_storage_system_to_port(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_StorageSystemToPort");
        cIMInstance3.setName("IBMTSESS_StorageSystemToPort");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("GroupComponent");
        cIMProperty.setName("GroupComponent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("PartComponent");
        cIMProperty2.setName("PartComponent");
        cIMProperty2.setType(new CIMDataType("IBMTS_FCPort"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_device_masking_capabilities() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_DeviceMaskingCapabilities");
        cIMInstance.setName("IBMTSESS_DeviceMaskingCapabilities");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 15;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("AttachDeviceSupported");
        cIMPropertyArray[0].setName("AttachDeviceSupported");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[0].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        String string = "IBM ESS Masking Capabilities";
        cIMPropertyArray[1].setValue(new CIMValue((Object)string));
        cIMPropertyArray[2] = new CIMProperty("ClientSelectableDeviceNumbers");
        cIMPropertyArray[2].setName("ClientSelectableDeviceNumbers");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(false);
        cIMPropertyArray[2].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "IBM ESS Masking Capabilities";
        cIMPropertyArray[3].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[4] = new CIMProperty("InstanceID");
        cIMPropertyArray[4].setName("InstanceID");
        cIMPropertyArray[4].setKey(true);
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[4].setValue(new CIMValue((Object)"IBMTSESS_DeviceMaskingCapabilities"));
        cIMPropertyArray[5] = new CIMProperty("OneHardwareIDPerView");
        cIMPropertyArray[5].setName("OneHardwareIDPerView");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl3 = new Boolean(true);
        cIMPropertyArray[5].setValue(new CIMValue((Object)bl3));
        cIMPropertyArray[6] = new CIMProperty("OtherValidHardwareIDTypes");
        cIMPropertyArray[6].setName("OtherValidHardwareIDTypes");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector2 = new Vector();
        cIMPropertyArray[6].setValue(new CIMValue(vector2));
        cIMPropertyArray[7] = new CIMProperty("PortsPerView");
        cIMPropertyArray[7].setName("PortsPerView");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(3);
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[8] = new CIMProperty("PrivilegeDeniedSupported");
        cIMPropertyArray[8].setName("PrivilegeDeniedSupported");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl4 = new Boolean(false);
        cIMPropertyArray[8].setValue(new CIMValue((Object)bl4));
        cIMPropertyArray[9] = new CIMProperty("ProtocolControllerRequiresAuthorizedIdentity");
        cIMPropertyArray[9].setName("ProtocolControllerRequiresAuthorizedIdentity");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl5 = new Boolean(true);
        cIMPropertyArray[9].setValue(new CIMValue((Object)bl5));
        cIMPropertyArray[10] = new CIMProperty("ProtocolControllerSupportsCollections");
        cIMPropertyArray[10].setName("ProtocolControllerSupportsCollections");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl6 = new Boolean(true);
        cIMPropertyArray[10].setValue(new CIMValue((Object)bl6));
        cIMPropertyArray[11] = new CIMProperty("UniqueUnitNumbersPerPort");
        cIMPropertyArray[11].setName("UniqueUnitNumbersPerPort");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl7 = new Boolean(false);
        cIMPropertyArray[11].setValue(new CIMValue((Object)bl7));
        cIMPropertyArray[12] = new CIMProperty("ValidHardwareIdTypes");
        cIMPropertyArray[12].setName("ValidHardwareIdTypes");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        vector3.add(new UnsignedInt16(2));
        cIMPropertyArray[12].setValue(new CIMValue(vector3));
        cIMPropertyArray[13] = new CIMProperty("OnePortPerView");
        cIMPropertyArray[13].setName("OnePortPerView");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl8 = new Boolean(false);
        cIMPropertyArray[13].setValue(new CIMValue((Object)bl8));
        cIMPropertyArray[14] = new CIMProperty("ElementName");
        cIMPropertyArray[14].setName("ElementName");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[14].setValue(new CIMValue((Object)"IBMTSESS_DeviceMaskingCapabilities"));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_controller_configuration_service() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_ControllerConfigurationService");
        cIMInstance.setName("IBMTSESS_ControllerConfigurationService");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 20;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("CreationClassName");
        cIMPropertyArray[1].setName("CreationClassName");
        cIMPropertyArray[1].setKey(true);
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[1].setValue(new CIMValue((Object)"IBMTSESS_ControllerConfigurationService"));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var6_6));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string = "ControllerConfigurationService";
        cIMPropertyArray[3].setValue(new CIMValue((Object)string));
        cIMPropertyArray[4] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[4].setName("EnabledDefault");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[5] = new CIMProperty("EnabledState");
        cIMPropertyArray[5].setName("EnabledState");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[6] = new CIMProperty("InstallDate");
        cIMPropertyArray[6].setName("InstallDate");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)12));
        Object var10_10 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var10_10));
        cIMPropertyArray[7] = new CIMProperty("Name");
        cIMPropertyArray[7].setName("Name");
        cIMPropertyArray[7].setKey(true);
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "Controller Configuration Service";
        cIMPropertyArray[7].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[8] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[8].setName("OperationalStatus");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[8].setValue(new CIMValue(vector2));
        cIMPropertyArray[9] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[9].setName("OtherEnabledState");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        Object var13_13 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var13_13));
        cIMPropertyArray[10] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[10].setName("PrimaryOwnerContact");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        Object var14_14 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var14_14));
        cIMPropertyArray[11] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[11].setName("PrimaryOwnerName");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("RequestedState");
        cIMPropertyArray[12].setName("RequestedState");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[12].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[13] = new CIMProperty("StartMode");
        cIMPropertyArray[13].setName("StartMode");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)8));
        Object var17_17 = null;
        cIMPropertyArray[13].setValue(new CIMValue(var17_17));
        cIMPropertyArray[14] = new CIMProperty("Started");
        cIMPropertyArray[14].setName("Started");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)9));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("Status");
        cIMPropertyArray[15].setName("Status");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        Object var19_19 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var19_19));
        cIMPropertyArray[16] = new CIMProperty("SystemName");
        cIMPropertyArray[16].setName("SystemName");
        cIMPropertyArray[16].setKey(true);
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[16].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[17] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[17].setName("StatusDescriptions");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[17].setValue(new CIMValue(vector3));
        cIMPropertyArray[18] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[18].setName("SystemCreationClassName");
        cIMPropertyArray[18].setKey(true);
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[18].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[19] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[19].setName("TimeOfLastStateChange");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)12));
        Object var21_21 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var21_21));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_computer_system_physical_package(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_ComputerSystemPhysicalPackage");
        cIMInstance3.setName("IBMTSESS_ComputerSystemPhysicalPackage");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_PhysicalPackage"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_computer_system_package_card(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_ComputerSystemPackageCard");
        cIMInstance3.setName("IBMTSESS_ComputerSystemPackageCard");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageProcessorCard"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_storage_processor_card(int n) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageProcessorCard");
        cIMInstance.setName("IBMTSESS_StorageProcessorCard");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n2 = 36;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n2];
        cIMPropertyArray[0] = new CIMProperty("CanBeFRUed");
        cIMPropertyArray[0].setName("CanBeFRUed");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        Object var6_6 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var6_6));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var7_7));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_StorageProcessorCard"));
        cIMPropertyArray[3] = new CIMProperty("Depth");
        cIMPropertyArray[3].setName("Depth");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)10));
        Object var8_8 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var8_8));
        cIMPropertyArray[4] = new CIMProperty("Description");
        cIMPropertyArray[4].setName("Description");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var9_9));
        cIMPropertyArray[5] = new CIMProperty("ElementName");
        cIMPropertyArray[5].setName("ElementName");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        String string = null;
        string = n == 0 ? "Cluster One Processor Card" : "Cluster Two Processor Card";
        cIMPropertyArray[5].setValue(new CIMValue((Object)string));
        cIMPropertyArray[6] = new CIMProperty("Height");
        cIMPropertyArray[6].setName("Height");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)10));
        Object var11_11 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var11_11));
        cIMPropertyArray[7] = new CIMProperty("HostingBoard");
        cIMPropertyArray[7].setName("HostingBoard");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)9));
        Object var12_12 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var12_12));
        cIMPropertyArray[8] = new CIMProperty("HotSwappable");
        cIMPropertyArray[8].setName("HotSwappable");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)9));
        Object var13_13 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var13_13));
        cIMPropertyArray[9] = new CIMProperty("InstallDate");
        cIMPropertyArray[9].setName("InstallDate");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)12));
        Object var14_14 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var14_14));
        cIMPropertyArray[10] = new CIMProperty("ManufactureDate");
        cIMPropertyArray[10].setName("ManufactureDate");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)12));
        Object var15_15 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var15_15));
        cIMPropertyArray[11] = new CIMProperty("Manufacturer");
        cIMPropertyArray[11].setName("Manufacturer");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "IBM";
        cIMPropertyArray[11].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[12] = new CIMProperty("Model");
        cIMPropertyArray[12].setName("Model");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[12].setValue(new CIMValue((Object)"2107"));
        cIMPropertyArray[13] = new CIMProperty("Name");
        cIMPropertyArray[13].setName("Name");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[13].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[14] = new CIMProperty("OperatingVoltages");
        cIMPropertyArray[14].setName("OperatingVoltages");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)17));
        Vector vector2 = new Vector();
        cIMPropertyArray[14].setValue(new CIMValue(vector2));
        cIMPropertyArray[15] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[15].setName("OperationalStatus");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector3 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector3));
        cIMPropertyArray[16] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[16].setName("OtherIdentifyingInfo");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        Object var19_19 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var19_19));
        cIMPropertyArray[17] = new CIMProperty("PartNumber");
        cIMPropertyArray[17].setName("PartNumber");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        Object var20_20 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var20_20));
        cIMPropertyArray[18] = new CIMProperty("PoweredOn");
        cIMPropertyArray[18].setName("PoweredOn");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)9));
        Object var21_21 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var21_21));
        cIMPropertyArray[19] = new CIMProperty("Removable");
        cIMPropertyArray[19].setName("Removable");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)9));
        Object var22_22 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var22_22));
        cIMPropertyArray[20] = new CIMProperty("RemovalConditions");
        cIMPropertyArray[20].setName("RemovalConditions");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[20].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[21] = new CIMProperty("Replaceable");
        cIMPropertyArray[21].setName("Replaceable");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)9));
        Object var24_24 = null;
        cIMPropertyArray[21].setValue(new CIMValue(var24_24));
        cIMPropertyArray[22] = new CIMProperty("RequirementsDescription");
        cIMPropertyArray[22].setName("RequirementsDescription");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)9));
        Object var25_25 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var25_25));
        cIMPropertyArray[23] = new CIMProperty("RequiresDaughterBoard");
        cIMPropertyArray[23].setName("RequiresDaughterBoard");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)9));
        Object var26_26 = null;
        cIMPropertyArray[23].setValue(new CIMValue(var26_26));
        cIMPropertyArray[24] = new CIMProperty("SKU");
        cIMPropertyArray[24].setName("SKU");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)8));
        Object var27_27 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var27_27));
        cIMPropertyArray[25] = new CIMProperty("SerialNumber");
        cIMPropertyArray[25].setName("SerialNumber");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)8));
        Object var28_28 = null;
        cIMPropertyArray[25].setValue(new CIMValue(var28_28));
        cIMPropertyArray[26] = new CIMProperty("SlotLayout");
        cIMPropertyArray[26].setName("SlotLayout");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)8));
        Object var29_29 = null;
        cIMPropertyArray[26].setValue(new CIMValue(var29_29));
        cIMPropertyArray[27] = new CIMProperty("SpecialRequirements");
        cIMPropertyArray[27].setName("SpecialRequirements");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)9));
        Object var30_30 = null;
        cIMPropertyArray[27].setValue(new CIMValue(var30_30));
        cIMPropertyArray[28] = new CIMProperty("Status");
        cIMPropertyArray[28].setName("Status");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)8));
        Object var31_31 = null;
        cIMPropertyArray[28].setValue(new CIMValue(var31_31));
        cIMPropertyArray[29] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[29].setName("StatusDescriptions");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector4 = new Vector();
        cIMPropertyArray[29].setValue(new CIMValue(vector4));
        cIMPropertyArray[30] = new CIMProperty("Tag");
        cIMPropertyArray[30].setName("Tag");
        cIMPropertyArray[30].setKey(true);
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = null;
        string3 = n == 0 ? this.subsystemName + " Cluster One" : this.subsystemName + " Cluster Two";
        cIMPropertyArray[30].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[31] = new CIMProperty("UserTracking");
        cIMPropertyArray[31].setName("UserTracking");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)8));
        Object var34_34 = null;
        cIMPropertyArray[31].setValue(new CIMValue(var34_34));
        cIMPropertyArray[32] = new CIMProperty("VendorEquipmentType");
        cIMPropertyArray[32].setName("VendorEquipmentType");
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)8));
        Object var35_35 = null;
        cIMPropertyArray[32].setValue(new CIMValue(var35_35));
        cIMPropertyArray[33] = new CIMProperty("version");
        cIMPropertyArray[33].setName("version");
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)8));
        Object var36_36 = null;
        cIMPropertyArray[33].setValue(new CIMValue(var36_36));
        cIMPropertyArray[34] = new CIMProperty("Weight");
        cIMPropertyArray[34].setName("Weight");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)8));
        Object var37_37 = null;
        cIMPropertyArray[34].setValue(new CIMValue(var37_37));
        cIMPropertyArray[35] = new CIMProperty("Width");
        cIMPropertyArray[35].setName("Width");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)8));
        Object var38_38 = null;
        cIMPropertyArray[35].setValue(new CIMValue(var38_38));
        for (int i = 0; i < n2; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_computer_system_package(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_ComputerSystemPackage");
        cIMInstance3.setName("IBMTSESS_ComputerSystemPackage");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTS_Chassis"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_software_identity() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_SoftwareIdentity");
        cIMInstance.setName("IBMTSESS_SoftwareIdentity");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 20;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("BuildNumber");
        cIMPropertyArray[0].setName("BuildNumber");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)2));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("ClassificationDescriptions");
        cIMPropertyArray[2].setName("ClassificationDescriptions");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector2 = new Vector();
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_PhysicalPackage"));
        cIMPropertyArray[3] = new CIMProperty("Classifications");
        cIMPropertyArray[3].setName("Classifications");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector3 = new Vector();
        cIMPropertyArray[3].setValue(new CIMValue(vector3));
        cIMPropertyArray[4] = new CIMProperty("Description");
        cIMPropertyArray[4].setName("Description");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var9_9));
        cIMPropertyArray[5] = new CIMProperty("ElementName");
        cIMPropertyArray[5].setName("ElementName");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var10_10));
        cIMPropertyArray[6] = new CIMProperty("InstallDate");
        cIMPropertyArray[6].setName("InstallDate");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)12));
        Object var11_11 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var11_11));
        cIMPropertyArray[7] = new CIMProperty("InstanceID");
        cIMPropertyArray[7].setName("InstanceID");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        String string = "IBM:ARC-" + this.subsystemName;
        cIMPropertyArray[7].setValue(new CIMValue((Object)string));
        cIMPropertyArray[8] = new CIMProperty("Languages");
        cIMPropertyArray[8].setName("Languages");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector4 = new Vector();
        cIMPropertyArray[8].setValue(new CIMValue(vector4));
        cIMPropertyArray[9] = new CIMProperty("MajorVersion");
        cIMPropertyArray[9].setName("MajorVersion");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)2));
        Object var14_14 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var14_14));
        cIMPropertyArray[10] = new CIMProperty("MinorVersion");
        cIMPropertyArray[10].setName("MinorVersion");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)2));
        Object var15_15 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var15_15));
        cIMPropertyArray[11] = new CIMProperty("Manufacturer");
        cIMPropertyArray[11].setName("Manufacturer");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "IBM";
        cIMPropertyArray[11].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[12] = new CIMProperty("Name");
        cIMPropertyArray[12].setName("Name");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var17_17 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var17_17));
        cIMPropertyArray[13] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[13].setName("OperationalStatus");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector5 = new Vector();
        cIMPropertyArray[13].setValue(new CIMValue(vector5));
        cIMPropertyArray[14] = new CIMProperty("RevisionNumber");
        cIMPropertyArray[14].setName("RevisionNumber");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)2));
        Object var19_19 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var19_19));
        cIMPropertyArray[15] = new CIMProperty("SerialNumber");
        cIMPropertyArray[15].setName("SerialNumber");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        Object var20_20 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var20_20));
        cIMPropertyArray[16] = new CIMProperty("Status");
        cIMPropertyArray[16].setName("Status");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        Object var21_21 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var21_21));
        cIMPropertyArray[17] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[17].setName("StatusDescriptions");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector6 = new Vector();
        cIMPropertyArray[17].setValue(new CIMValue(vector6));
        cIMPropertyArray[18] = new CIMProperty("TargetOperatingSystems");
        cIMPropertyArray[18].setName("TargetOperatingSystems");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector7 = new Vector();
        cIMPropertyArray[18].setValue(new CIMValue(vector7));
        cIMPropertyArray[19] = new CIMProperty("VersionString");
        cIMPropertyArray[19].setName("VersionString");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        Object var24_24 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var24_24));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_physical_package(int n) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_PhysicalPackage");
        cIMInstance.setName("IBMTSESS_PhysicalPackage");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n2 = 40;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n2];
        cIMPropertyArray[0] = new CIMProperty("CanBeFRUed");
        cIMPropertyArray[0].setName("CanBeFRUed");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        Object var6_6 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var6_6));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var7_7));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTSESS_PhysicalPackage"));
        cIMPropertyArray[3] = new CIMProperty("DAPair");
        cIMPropertyArray[3].setName("DAPair");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string = new String("2");
        cIMPropertyArray[3].setValue(new CIMValue((Object)string));
        cIMPropertyArray[4] = new CIMProperty("DDMCap");
        cIMPropertyArray[4].setName("DDMCap");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)10));
        Float f = new Float("146.0");
        cIMPropertyArray[4].setValue(new CIMValue((Object)f));
        cIMPropertyArray[5] = new CIMProperty("DDMSpeed");
        cIMPropertyArray[5].setName("DDMSpeed");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "10000";
        cIMPropertyArray[5].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[6] = new CIMProperty("Depth");
        cIMPropertyArray[6].setName("Depth");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)10));
        Object var11_11 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var11_11));
        cIMPropertyArray[7] = new CIMProperty("Description");
        cIMPropertyArray[7].setName("Description");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var12_12 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var12_12));
        cIMPropertyArray[8] = new CIMProperty("DeviceAdapters");
        cIMPropertyArray[8].setName("DeviceAdapters");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.deviceAdapters[0]);
        vector2.add(this.deviceAdapters[1]);
        cIMPropertyArray[8].setValue(new CIMValue(vector2));
        cIMPropertyArray[9] = new CIMProperty("ElementName");
        cIMPropertyArray[9].setName("ElementName");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "null on ESS " + this.subsystemName;
        cIMPropertyArray[9].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[10] = new CIMProperty("EnclosureNumbers");
        cIMPropertyArray[10].setName("EnclosureNumbers");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("3");
        vector3.add("2");
        cIMPropertyArray[10].setValue(new CIMValue(vector3));
        cIMPropertyArray[11] = new CIMProperty("Height");
        cIMPropertyArray[11].setName("Height");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)10));
        Object var16_16 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var16_16));
        cIMPropertyArray[12] = new CIMProperty("HotSwappable");
        cIMPropertyArray[12].setName("HotSwappable");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(false);
        cIMPropertyArray[12].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[13] = new CIMProperty("InstallDate");
        cIMPropertyArray[13].setName("InstallDate");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)12));
        Object var18_18 = null;
        cIMPropertyArray[13].setValue(new CIMValue(var18_18));
        cIMPropertyArray[14] = new CIMProperty("ManufactureDate");
        cIMPropertyArray[14].setName("ManufactureDate");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)12));
        Object var19_19 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var19_19));
        cIMPropertyArray[15] = new CIMProperty("Manufacturer");
        cIMPropertyArray[15].setName("Manufacturer");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "IBM";
        cIMPropertyArray[15].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[16] = new CIMProperty("Model");
        cIMPropertyArray[16].setName("Model");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "undefined";
        cIMPropertyArray[16].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[17] = new CIMProperty("Name");
        cIMPropertyArray[17].setName("Name");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[18] = new CIMProperty("NumOfDataDisks");
        cIMPropertyArray[18].setName("NumOfDataDisks");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)2));
        Object var22_22 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var22_22));
        cIMPropertyArray[19] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[19].setName("OperationalStatus");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector4 = new Vector();
        cIMPropertyArray[19].setValue(new CIMValue(vector4));
        cIMPropertyArray[20] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[20].setName("OtherIdentifyingInfo");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = "raid5";
        cIMPropertyArray[20].setValue(new CIMValue((Object)string6));
        cIMPropertyArray[21] = new CIMProperty("PartNumber");
        cIMPropertyArray[21].setName("PartNumber");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        Object var25_25 = null;
        cIMPropertyArray[21].setValue(new CIMValue(var25_25));
        cIMPropertyArray[22] = new CIMProperty("PoweredOn");
        cIMPropertyArray[22].setName("PoweredOn");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(true);
        cIMPropertyArray[22].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[23] = new CIMProperty("RIOLoops");
        cIMPropertyArray[23].setName("RIOLoops");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector5 = new Vector<String>();
        vector5.add("1669");
        vector5.add("1669");
        cIMPropertyArray[23].setValue(new CIMValue(vector5));
        cIMPropertyArray[24] = new CIMProperty("RankID");
        cIMPropertyArray[24].setName("RankID");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)8));
        String string7 = "" + n;
        cIMPropertyArray[24].setValue(new CIMValue((Object)string7));
        cIMPropertyArray[25] = new CIMProperty("Removable");
        cIMPropertyArray[25].setName("Removable");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl3 = new Boolean(false);
        cIMPropertyArray[25].setValue(new CIMValue((Object)bl3));
        cIMPropertyArray[26] = new CIMProperty("RemovalConditions");
        cIMPropertyArray[26].setName("RemovalConditions");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[26].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[27] = new CIMProperty("Replaceable");
        cIMPropertyArray[27].setName("Replaceable");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl4 = new Boolean(true);
        cIMPropertyArray[27].setValue(new CIMValue((Object)bl4));
        cIMPropertyArray[28] = new CIMProperty("SKU");
        cIMPropertyArray[28].setName("SKU");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)8));
        Object var32_32 = null;
        cIMPropertyArray[28].setValue(new CIMValue(var32_32));
        cIMPropertyArray[29] = new CIMProperty("SerialNumber");
        cIMPropertyArray[29].setName("SerialNumber");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)8));
        Object var33_33 = null;
        cIMPropertyArray[29].setValue(new CIMValue(var33_33));
        cIMPropertyArray[30] = new CIMProperty("Status");
        cIMPropertyArray[30].setName("Status");
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)8));
        Object var34_34 = null;
        cIMPropertyArray[30].setValue(new CIMValue(var34_34));
        cIMPropertyArray[31] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[31].setName("StatusDescriptions");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector6 = new Vector();
        cIMPropertyArray[31].setValue(new CIMValue(vector6));
        cIMPropertyArray[32] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[32].setName("SystemCreationClassName");
        cIMPropertyArray[32].setKey(true);
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[32].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[33] = new CIMProperty("Tag");
        cIMPropertyArray[33].setName("Tag");
        cIMPropertyArray[33].setKey(true);
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)8));
        String string8 = this.subsystemName + "-" + (n + 1);
        cIMPropertyArray[33].setValue(new CIMValue((Object)string8));
        cIMPropertyArray[34] = new CIMProperty("UserTracking");
        cIMPropertyArray[34].setName("UserTracking");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)8));
        Object var37_37 = null;
        cIMPropertyArray[34].setValue(new CIMValue(var37_37));
        cIMPropertyArray[35] = new CIMProperty("VendorEquipmentType");
        cIMPropertyArray[35].setName("VendorEquipmentType");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)8));
        Object var38_38 = null;
        cIMPropertyArray[35].setValue(new CIMValue(var38_38));
        cIMPropertyArray[36] = new CIMProperty("version");
        cIMPropertyArray[36].setName("version");
        cIMPropertyArray[36].setType(CIMDataType.getPredefinedType((int)8));
        Object var39_39 = null;
        cIMPropertyArray[36].setValue(new CIMValue(var39_39));
        cIMPropertyArray[37] = new CIMProperty("Weight");
        cIMPropertyArray[37].setName("Weight");
        cIMPropertyArray[37].setType(CIMDataType.getPredefinedType((int)10));
        Object var40_40 = null;
        cIMPropertyArray[37].setValue(new CIMValue(var40_40));
        cIMPropertyArray[38] = new CIMProperty("Width");
        cIMPropertyArray[38].setName("Width");
        cIMPropertyArray[38].setType(CIMDataType.getPredefinedType((int)10));
        Object var41_41 = null;
        cIMPropertyArray[38].setValue(new CIMValue(var41_41));
        cIMPropertyArray[39] = new CIMProperty("location");
        cIMPropertyArray[39].setName("location");
        cIMPropertyArray[39].setType(CIMDataType.getPredefinedType((int)8));
        String string9 = "Adapter Pair 2, Port (loop), Disk Group " + (n + 1);
        cIMPropertyArray[39].setValue(new CIMValue((Object)string9));
        for (int i = 0; i < n2; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_component_cs(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_ComponentCS");
        cIMInstance3.setName("IBMTS_ComponentCS");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("GroupComponent");
        cIMProperty.setName("GroupComponent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("PartComponent");
        cIMProperty2.setName("PartComponent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_Cluster"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmtsess_location() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_Location");
        cIMInstance.setName("IBMTSESS_Location");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 6;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Address");
        cIMPropertyArray[0].setName("Address");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var7_7));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string = new String("DataCenter1");
        cIMPropertyArray[3].setValue(new CIMValue((Object)string));
        cIMPropertyArray[4] = new CIMProperty("Name");
        cIMPropertyArray[4].setName("Name");
        cIMPropertyArray[4].setKey(true);
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[4].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[5] = new CIMProperty("PhysicalPosition");
        cIMPropertyArray[5].setName("PhysicalPosition");
        cIMPropertyArray[5].setKey(true);
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "Some Rack";
        cIMPropertyArray[5].setValue(new CIMValue((Object)string2));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_fcport(int n) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_FCPort");
        cIMInstance.setName("IBMTS_FCPort");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n2 = 56;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n2];
        cIMPropertyArray[0] = new CIMProperty("ActiveCOS");
        cIMPropertyArray[0].setName("ActiveCOS");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)2));
        Object var6_6 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var6_6));
        cIMPropertyArray[1] = new CIMProperty("ActiveFC4Types");
        cIMPropertyArray[1].setName("ActiveFC4Types");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector2 = new Vector();
        cIMPropertyArray[1].setValue(new CIMValue(vector2));
        cIMPropertyArray[2] = new CIMProperty("ActiveMaximumTransmissionUnit");
        cIMPropertyArray[2].setName("ActiveMaximumTransmissionUnit");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)6));
        Object var8_8 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var8_8));
        cIMPropertyArray[3] = new CIMProperty("AdditionalAvailability");
        cIMPropertyArray[3].setName("AdditionalAvailability");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector3 = new Vector();
        cIMPropertyArray[3].setValue(new CIMValue(vector3));
        cIMPropertyArray[4] = new CIMProperty("Caption");
        cIMPropertyArray[4].setName("Caption");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var10_10));
        cIMPropertyArray[5] = new CIMProperty("CreationClassName");
        cIMPropertyArray[5].setName("CreationClassName");
        cIMPropertyArray[5].setKey(true);
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[5].setValue(new CIMValue((Object)"IBMTS_FCPort"));
        cIMPropertyArray[6] = new CIMProperty("Description");
        cIMPropertyArray[6].setName("Description");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var11_11));
        cIMPropertyArray[7] = new CIMProperty("DeviceID");
        cIMPropertyArray[7].setName("DeviceID");
        cIMPropertyArray[7].setKey(true);
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        String string = null;
        string = n < 10 ? "000" + n : "00" + n;
        cIMPropertyArray[7].setValue(new CIMValue((Object)string));
        cIMPropertyArray[8] = new CIMProperty("ElementName");
        cIMPropertyArray[8].setName("ElementName");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "Port" + string;
        cIMPropertyArray[8].setValue(new CIMValue((Object)"IBMTS_Chassis"));
        cIMPropertyArray[9] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[9].setName("EnabledDefault");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[9].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[10] = new CIMProperty("EnabledState");
        cIMPropertyArray[10].setName("EnabledState");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(6);
        cIMPropertyArray[10].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[11] = new CIMProperty("EnclosureNumbers");
        cIMPropertyArray[11].setName("EnclosureNumbers");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = null;
        if (n >= 0 && n <= 3) {
            string3 = "0";
        } else if (n >= 4 && n <= 7) {
            string3 = "1";
        } else if (n >= 8 && n <= 11) {
            string3 = "2";
        } else if (n >= 12 && n <= 15) {
            string3 = "3";
        }
        cIMPropertyArray[11].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[12] = new CIMProperty("ErrorCleared");
        cIMPropertyArray[12].setName("ErrorCleared");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)9));
        Object var17_17 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var17_17));
        cIMPropertyArray[13] = new CIMProperty("ErrorDescription");
        cIMPropertyArray[13].setName("ErrorDescription");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[13].setValue(new CIMValue(var18_18));
        cIMPropertyArray[14] = new CIMProperty("FullDuplex");
        cIMPropertyArray[14].setName("FullDuplex");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)9));
        Object var19_19 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var19_19));
        cIMPropertyArray[15] = new CIMProperty("HostAdapter");
        cIMPropertyArray[15].setName("HostAdapter");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = null;
        if (n >= 0 && n <= 3) {
            string4 = this.hostAdapters[0];
        } else if (n >= 4 && n <= 7) {
            string4 = this.hostAdapters[1];
        } else if (n >= 8 && n <= 11) {
            string4 = this.hostAdapters[2];
        } else if (n >= 12 && n <= 15) {
            string4 = this.hostAdapters[3];
        }
        cIMPropertyArray[15].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[16] = new CIMProperty("IdentifyingDescriptions");
        cIMPropertyArray[16].setName("IdentifyingDescriptions");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector4 = new Vector();
        cIMPropertyArray[16].setValue(new CIMValue(vector4));
        cIMPropertyArray[17] = new CIMProperty("InstallDate");
        cIMPropertyArray[17].setName("InstallDate");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)12));
        Object var22_22 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var22_22));
        cIMPropertyArray[18] = new CIMProperty("LastErrorCode");
        cIMPropertyArray[18].setName("LastErrorCode");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)4));
        Object var23_23 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var23_23));
        cIMPropertyArray[19] = new CIMProperty("LinkTechnology");
        cIMPropertyArray[19].setName("LinkTechnology");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)2));
        Object var24_24 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var24_24));
        cIMPropertyArray[20] = new CIMProperty("MaxQuiesceTime");
        cIMPropertyArray[20].setName("MaxQuiesceTime");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)6));
        Object var25_25 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var25_25));
        cIMPropertyArray[21] = new CIMProperty("Name");
        cIMPropertyArray[21].setName("Name");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        Object var26_26 = null;
        cIMPropertyArray[21].setValue(new CIMValue(var26_26));
        cIMPropertyArray[22] = new CIMProperty("NetworkAddresses");
        cIMPropertyArray[22].setName("NetworkAddresses");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector5 = new Vector();
        cIMPropertyArray[22].setValue(new CIMValue(vector5));
        cIMPropertyArray[23] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[23].setName("OperationalStatus");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector6 = new Vector<UnsignedInt16>();
        vector6.add(new UnsignedInt16(2));
        cIMPropertyArray[23].setValue(new CIMValue(vector6));
        cIMPropertyArray[24] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[24].setName("OtherEnabledState");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)8));
        Object var29_29 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var29_29));
        cIMPropertyArray[25] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[25].setName("OtherIdentifyingInfo");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector7 = new Vector();
        cIMPropertyArray[25].setValue(new CIMValue(vector7));
        cIMPropertyArray[26] = new CIMProperty("OtherLinkTechnology");
        cIMPropertyArray[26].setName("OtherLinkTechnology");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)8));
        Object var31_31 = null;
        cIMPropertyArray[26].setValue(new CIMValue(var31_31));
        cIMPropertyArray[27] = new CIMProperty("OtherNetworkPortType");
        cIMPropertyArray[27].setName("OtherNetworkPortType");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)8));
        Object var32_32 = null;
        cIMPropertyArray[27].setValue(new CIMValue(var32_32));
        cIMPropertyArray[28] = new CIMProperty("PermanentAddress");
        cIMPropertyArray[28].setName("PermanentAddress");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[28].setValue(new CIMValue((Object)this.wwn));
        cIMPropertyArray[29] = new CIMProperty("PortNumber");
        cIMPropertyArray[29].setName("PortNumber");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)2));
        Object var33_33 = null;
        cIMPropertyArray[29].setValue(new CIMValue(var33_33));
        cIMPropertyArray[30] = new CIMProperty("PortType");
        cIMPropertyArray[30].setName("PortType");
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(11);
        cIMPropertyArray[30].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[31] = new CIMProperty("PowerManagementCapabilities");
        cIMPropertyArray[31].setName("PowerManagementCapabilities");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector8 = new Vector();
        cIMPropertyArray[31].setValue(new CIMValue(vector8));
        cIMPropertyArray[32] = new CIMProperty("PowerManagementSupported");
        cIMPropertyArray[32].setName("PowerManagementSupported");
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)9));
        Object var36_36 = null;
        cIMPropertyArray[32].setValue(new CIMValue(var36_36));
        cIMPropertyArray[33] = new CIMProperty("PoweredOnHours");
        cIMPropertyArray[33].setName("PoweredOnHours");
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)6));
        Object var37_37 = null;
        cIMPropertyArray[33].setValue(new CIMValue(var37_37));
        cIMPropertyArray[34] = new CIMProperty("RIOLoop");
        cIMPropertyArray[34].setName("RIOLoop");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "1669";
        cIMPropertyArray[34].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[35] = new CIMProperty("RequestedSpeed");
        cIMPropertyArray[35].setName("RequestedSpeed");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)6));
        Object var39_39 = null;
        cIMPropertyArray[35].setValue(new CIMValue(var39_39));
        cIMPropertyArray[36] = new CIMProperty("RequestedState");
        cIMPropertyArray[36].setName("RequestedState");
        cIMPropertyArray[36].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(5);
        cIMPropertyArray[36].setValue(new CIMValue((Object)unsignedInt164));
        cIMPropertyArray[37] = new CIMProperty("Speed");
        cIMPropertyArray[37].setName("Speed");
        cIMPropertyArray[37].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 unsignedInt64 = new UnsignedInt64("2000000000");
        cIMPropertyArray[37].setValue(new CIMValue((Object)unsignedInt64));
        cIMPropertyArray[38] = new CIMProperty("Status");
        cIMPropertyArray[38].setName("Status");
        cIMPropertyArray[38].setType(CIMDataType.getPredefinedType((int)8));
        Object var42_42 = null;
        cIMPropertyArray[38].setValue(new CIMValue(var42_42));
        cIMPropertyArray[39] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[39].setName("StatusDescriptions");
        cIMPropertyArray[39].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector9 = new Vector();
        cIMPropertyArray[39].setValue(new CIMValue(vector9));
        cIMPropertyArray[40] = new CIMProperty("StatusInfo");
        cIMPropertyArray[40].setName("StatusInfo");
        cIMPropertyArray[40].setType(CIMDataType.getPredefinedType((int)2));
        Object var44_44 = null;
        cIMPropertyArray[40].setValue(new CIMValue(var44_44));
        cIMPropertyArray[41] = new CIMProperty("SupportedCOS");
        cIMPropertyArray[41].setName("SupportedCOS");
        cIMPropertyArray[41].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[41].setValue(new CIMValue((Object)"IBM Enterprise System Server"));
        cIMPropertyArray[42] = new CIMProperty("SupportedFC4Types");
        cIMPropertyArray[42].setName("SupportedFC4Types");
        cIMPropertyArray[42].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector10 = new Vector();
        cIMPropertyArray[42].setValue(new CIMValue(vector10));
        cIMPropertyArray[43] = new CIMProperty("SupportedMaximumTransmissionUnit");
        cIMPropertyArray[43].setName("SupportedMaximumTransmissionUnit");
        cIMPropertyArray[43].setType(CIMDataType.getPredefinedType((int)6));
        Object var46_46 = null;
        cIMPropertyArray[43].setValue(new CIMValue(var46_46));
        cIMPropertyArray[44] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[44].setName("SystemCreationClassName");
        cIMPropertyArray[44].setKey(true);
        cIMPropertyArray[44].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[44].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[45] = new CIMProperty("SystemName");
        cIMPropertyArray[45].setName("SystemName");
        cIMPropertyArray[45].setKey(true);
        cIMPropertyArray[45].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[45].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[46] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[46].setName("TimeOfLastStateChange");
        cIMPropertyArray[46].setType(CIMDataType.getPredefinedType((int)12));
        Object var47_47 = null;
        cIMPropertyArray[46].setValue(new CIMValue(var47_47));
        cIMPropertyArray[47] = new CIMProperty("TotalPowerOnHours");
        cIMPropertyArray[47].setName("TotalPowerOnHours");
        cIMPropertyArray[47].setType(CIMDataType.getPredefinedType((int)6));
        Object var48_48 = null;
        cIMPropertyArray[47].setValue(new CIMValue(var48_48));
        cIMPropertyArray[48] = new CIMProperty("UsageRestriction");
        cIMPropertyArray[48].setName("UsageRestriction");
        cIMPropertyArray[48].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt165 = new UnsignedInt16(2);
        cIMPropertyArray[48].setValue(new CIMValue((Object)unsignedInt165));
        cIMPropertyArray[49] = new CIMProperty("loc");
        cIMPropertyArray[49].setName("loc");
        cIMPropertyArray[49].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = null;
        if (n >= 0 && n <= 3) {
            string6 = this.hostAdapters[0] + "-T" + n % 4;
        } else if (n >= 4 && n <= 7) {
            string6 = this.hostAdapters[0] + "-T" + n % 4;
        } else if (n >= 8 && n <= 11) {
            string6 = this.hostAdapters[0] + "-T" + n % 4;
        } else if (n >= 12 && n <= 15) {
            string6 = this.hostAdapters[0] + "-T" + n % 4;
        }
        cIMPropertyArray[49].setValue(new CIMValue(string6));
        cIMPropertyArray[50] = new CIMProperty("topology");
        cIMPropertyArray[50].setName("topology");
        cIMPropertyArray[50].setType(CIMDataType.getPredefinedType((int)8));
        if (n >= 0 || n <= 7) {
            cIMPropertyArray[50].setValue(new CIMValue((Object)"Unknown"));
        } else {
            cIMPropertyArray[50].setValue(new CIMValue((Object)"SCSIFcp"));
        }
        cIMPropertyArray[51] = new CIMProperty("Type");
        cIMPropertyArray[51].setName("Type");
        cIMPropertyArray[51].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[51].setValue(new CIMValue((Object)"FIBRE"));
        cIMPropertyArray[52] = new CIMProperty("Type");
        cIMPropertyArray[52].setName("Type");
        cIMPropertyArray[52].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[52].setValue(new CIMValue((Object)"FIBRE"));
        cIMPropertyArray[53] = new CIMProperty("wwn");
        cIMPropertyArray[53].setName("wwn");
        cIMPropertyArray[53].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[53].setValue(new CIMValue((Object)this.wwn));
        cIMPropertyArray[54] = new CIMProperty("AutoSense");
        cIMPropertyArray[54].setName("AutoSense");
        cIMPropertyArray[54].setType(CIMDataType.getPredefinedType((int)9));
        Object var51_51 = null;
        cIMPropertyArray[54].setValue(new CIMValue(var51_51));
        cIMPropertyArray[55] = new CIMProperty("Availability");
        cIMPropertyArray[55].setName("Availability");
        cIMPropertyArray[55].setType(CIMDataType.getPredefinedType((int)2));
        Object var52_52 = null;
        cIMPropertyArray[55].setValue(new CIMValue(var52_52));
        for (int i = 0; i < n2; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_chassis() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_Chassis");
        cIMInstance.setName("IBMTS_Chassis");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 48;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("AudibleAlarm");
        cIMPropertyArray[0].setName("AudibleAlarm");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("BreachDescription");
        cIMPropertyArray[1].setName("BreachDescription");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("CableManagementStrategy");
        cIMPropertyArray[2].setName("CableManagementStrategy");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var7_7));
        cIMPropertyArray[3] = new CIMProperty("CanBeFRUed");
        cIMPropertyArray[3].setName("CanBeFRUed");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)9));
        Object var8_8 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var8_8));
        cIMPropertyArray[4] = new CIMProperty("Caption");
        cIMPropertyArray[4].setName("Caption");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var9_9));
        cIMPropertyArray[5] = new CIMProperty("ChassisPackageType");
        cIMPropertyArray[5].setName("ChassisPackageType");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        Object var10_10 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var10_10));
        cIMPropertyArray[6] = new CIMProperty("ChassisTypeDescription");
        cIMPropertyArray[6].setName("ChassisTypeDescription");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var11_11));
        cIMPropertyArray[7] = new CIMProperty("ChassisTypes");
        cIMPropertyArray[7].setName("ChassisTypes");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(22));
        cIMPropertyArray[7].setValue(new CIMValue(vector2));
        cIMPropertyArray[8] = new CIMProperty("CreationClassName");
        cIMPropertyArray[8].setName("CreationClassName");
        cIMPropertyArray[8].setKey(true);
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[8].setValue(new CIMValue((Object)"IBMTS_Chassis"));
        cIMPropertyArray[9] = new CIMProperty("CurrentRequiredOrProduced");
        cIMPropertyArray[9].setName("CurrentRequiredOrProduced");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)3));
        Short s = new Short("-1");
        cIMPropertyArray[9].setValue(new CIMValue((Object)s));
        cIMPropertyArray[10] = new CIMProperty("Depth");
        cIMPropertyArray[10].setName("Depth");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)10));
        Object var14_14 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var14_14));
        cIMPropertyArray[11] = new CIMProperty("Description");
        cIMPropertyArray[11].setName("Description");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("ElementName");
        cIMPropertyArray[12].setName("ElementName");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        String string = "Chassis";
        cIMPropertyArray[12].setValue(new CIMValue((Object)string));
        cIMPropertyArray[13] = new CIMProperty("HeatGeneration");
        cIMPropertyArray[13].setName("HeatGeneration");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(0);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[14] = new CIMProperty("Height");
        cIMPropertyArray[14].setName("Height");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)10));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("HotSwappable");
        cIMPropertyArray[15].setName("HotSwappable");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)9));
        Object var19_19 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var19_19));
        cIMPropertyArray[16] = new CIMProperty("InstallDate");
        cIMPropertyArray[16].setName("InstallDate");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)12));
        Object var20_20 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var20_20));
        cIMPropertyArray[17] = new CIMProperty("IsLocked");
        cIMPropertyArray[17].setName("IsLocked");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)9));
        Object var21_21 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var21_21));
        cIMPropertyArray[18] = new CIMProperty("LockPresent");
        cIMPropertyArray[18].setName("LockPresent");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)9));
        Object var22_22 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var22_22));
        cIMPropertyArray[19] = new CIMProperty("ManufactureDate");
        cIMPropertyArray[19].setName("ManufactureDate");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)12));
        Object var23_23 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var23_23));
        cIMPropertyArray[20] = new CIMProperty("Manufacturer");
        cIMPropertyArray[20].setName("Manufacturer");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[20].setValue(new CIMValue((Object)"IBM"));
        cIMPropertyArray[21] = new CIMProperty("Model");
        cIMPropertyArray[21].setName("Model");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[21].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[22] = new CIMProperty("MultipleSystemSupport");
        cIMPropertyArray[22].setName("MultipleSystemSupport");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)2));
        Object var24_24 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var24_24));
        cIMPropertyArray[23] = new CIMProperty("Name");
        cIMPropertyArray[23].setName("Name");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)8));
        Object var25_25 = null;
        cIMPropertyArray[23].setValue(new CIMValue(var25_25));
        cIMPropertyArray[24] = new CIMProperty("NumberOfPowerCords");
        cIMPropertyArray[24].setName("NumberOfPowerCords");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(2);
        cIMPropertyArray[24].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[25] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[25].setName("OperationalStatus");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector3 = new Vector();
        cIMPropertyArray[25].setValue(new CIMValue(vector3));
        cIMPropertyArray[26] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[26].setName("OtherIdentifyingInfo");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)8));
        Object var28_28 = null;
        cIMPropertyArray[26].setValue(new CIMValue(var28_28));
        cIMPropertyArray[27] = new CIMProperty("PartNumber");
        cIMPropertyArray[27].setName("PartNumber");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)8));
        Object var29_29 = null;
        cIMPropertyArray[27].setValue(new CIMValue(var29_29));
        cIMPropertyArray[28] = new CIMProperty("PoweredOn");
        cIMPropertyArray[28].setName("PoweredOn");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)9));
        Object var30_30 = null;
        cIMPropertyArray[28].setValue(new CIMValue(var30_30));
        cIMPropertyArray[29] = new CIMProperty("RackMountable");
        cIMPropertyArray[29].setName("RackMountable");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)2));
        Object var31_31 = null;
        cIMPropertyArray[29].setValue(new CIMValue(var31_31));
        cIMPropertyArray[30] = new CIMProperty("Removable");
        cIMPropertyArray[30].setName("Removable");
        cIMPropertyArray[30].setType(CIMDataType.getPredefinedType((int)9));
        Object var32_32 = null;
        cIMPropertyArray[30].setValue(new CIMValue(var32_32));
        cIMPropertyArray[31] = new CIMProperty("RemovalConditions");
        cIMPropertyArray[31].setName("RemovalConditions");
        cIMPropertyArray[31].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(2);
        cIMPropertyArray[31].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[32] = new CIMProperty("Replaceable");
        cIMPropertyArray[32].setName("Replaceable");
        cIMPropertyArray[32].setType(CIMDataType.getPredefinedType((int)9));
        Object var34_34 = null;
        cIMPropertyArray[32].setValue(new CIMValue(var34_34));
        cIMPropertyArray[33] = new CIMProperty("SKU");
        cIMPropertyArray[33].setName("SKU");
        cIMPropertyArray[33].setType(CIMDataType.getPredefinedType((int)8));
        Object var35_35 = null;
        cIMPropertyArray[33].setValue(new CIMValue(var35_35));
        cIMPropertyArray[34] = new CIMProperty("SecurityBreach");
        cIMPropertyArray[34].setName("SecurityBreach");
        cIMPropertyArray[34].setType(CIMDataType.getPredefinedType((int)2));
        Object var36_36 = null;
        cIMPropertyArray[34].setValue(new CIMValue(var36_36));
        cIMPropertyArray[35] = new CIMProperty("SerialNumber");
        cIMPropertyArray[35].setName("SerialNumber");
        cIMPropertyArray[35].setType(CIMDataType.getPredefinedType((int)8));
        Object var37_37 = null;
        cIMPropertyArray[35].setValue(new CIMValue(var37_37));
        cIMPropertyArray[36] = new CIMProperty("ServiceDescriptions");
        cIMPropertyArray[36].setName("ServiceDescriptions");
        cIMPropertyArray[36].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector4 = new Vector();
        cIMPropertyArray[36].setValue(new CIMValue(vector4));
        cIMPropertyArray[37] = new CIMProperty("ServicePhilosophy");
        cIMPropertyArray[37].setName("ServicePhilosophy");
        cIMPropertyArray[37].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector5 = new Vector();
        cIMPropertyArray[37].setValue(new CIMValue(vector5));
        cIMPropertyArray[38] = new CIMProperty("Status");
        cIMPropertyArray[38].setName("Status");
        cIMPropertyArray[38].setType(CIMDataType.getPredefinedType((int)8));
        Object var40_40 = null;
        cIMPropertyArray[38].setValue(new CIMValue(var40_40));
        cIMPropertyArray[39] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[39].setName("StatusDescriptions");
        cIMPropertyArray[39].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector6 = new Vector();
        cIMPropertyArray[39].setValue(new CIMValue(vector6));
        cIMPropertyArray[40] = new CIMProperty("Tag");
        cIMPropertyArray[40].setName("Tag");
        cIMPropertyArray[40].setKey(true);
        cIMPropertyArray[40].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[40].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[41] = new CIMProperty("TypeDescriptions");
        cIMPropertyArray[41].setName("TypeDescriptions");
        cIMPropertyArray[41].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[41].setValue(new CIMValue((Object)"IBM Enterprise System Server"));
        cIMPropertyArray[42] = new CIMProperty("UserTracking");
        cIMPropertyArray[42].setName("UserTracking");
        cIMPropertyArray[42].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[42].setValue(new CIMValue((Object)"IBM Enterprise System Server"));
        cIMPropertyArray[43] = new CIMProperty("version");
        cIMPropertyArray[43].setName("version");
        cIMPropertyArray[43].setType(CIMDataType.getPredefinedType((int)8));
        Object var42_42 = null;
        cIMPropertyArray[43].setValue(new CIMValue(var42_42));
        cIMPropertyArray[44] = new CIMProperty("VisibleAlarm");
        cIMPropertyArray[44].setName("VisibleAlarm");
        cIMPropertyArray[44].setType(CIMDataType.getPredefinedType((int)9));
        Object var43_43 = null;
        cIMPropertyArray[44].setValue(new CIMValue(var43_43));
        cIMPropertyArray[45] = new CIMProperty("Weight");
        cIMPropertyArray[45].setName("Weight");
        cIMPropertyArray[45].setType(CIMDataType.getPredefinedType((int)10));
        Object var44_44 = null;
        cIMPropertyArray[45].setValue(new CIMValue(var44_44));
        cIMPropertyArray[46] = new CIMProperty("Width");
        cIMPropertyArray[46].setName("Width");
        cIMPropertyArray[46].setType(CIMDataType.getPredefinedType((int)10));
        Object var45_45 = null;
        cIMPropertyArray[46].setValue(new CIMValue(var45_45));
        cIMPropertyArray[47] = new CIMProperty("VendorEquipmentType");
        cIMPropertyArray[47].setName("VendorEquipmentType");
        cIMPropertyArray[47].setType(CIMDataType.getPredefinedType((int)8));
        Object var46_46 = null;
        cIMPropertyArray[47].setValue(new CIMValue(var46_46));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_product() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_Product");
        cIMInstance.setName("IBMTSESS_Product");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 10;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("Description");
        cIMPropertyArray[1].setName("Description");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("ElementName");
        cIMPropertyArray[2].setName("ElementName");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        String string = "IBM Product 5.0.500.123";
        cIMPropertyArray[2].setValue(new CIMValue((Object)string));
        cIMPropertyArray[3] = new CIMProperty("IdentifyingNumber");
        cIMPropertyArray[3].setName("IdentifyingNumber");
        cIMPropertyArray[3].setKey(true);
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[3].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[4] = new CIMProperty("Name");
        cIMPropertyArray[4].setName("Name");
        cIMPropertyArray[4].setKey(true);
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[4].setValue(new CIMValue((Object)"IBM TotalStorage DS8000"));
        cIMPropertyArray[5] = new CIMProperty("SKUNumber");
        cIMPropertyArray[5].setName("SKUNumber");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        Object var8_8 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var8_8));
        cIMPropertyArray[6] = new CIMProperty("Vendor");
        cIMPropertyArray[6].setName("Vendor");
        cIMPropertyArray[6].setKey(true);
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[6].setValue(new CIMValue((Object)"IBM"));
        cIMPropertyArray[7] = new CIMProperty("version");
        cIMPropertyArray[7].setName("version");
        cIMPropertyArray[7].setKey(true);
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[7].setValue(new CIMValue((Object)"5.0.500.123"));
        cIMPropertyArray[8] = new CIMProperty("WarrantyDuration");
        cIMPropertyArray[8].setName("WarrantyDuration");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)4));
        Object var9_9 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var9_9));
        cIMPropertyArray[9] = new CIMProperty("WarrantyStartDate");
        cIMPropertyArray[9].setName("WarrantyStartDate");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)12));
        Object var10_10 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var10_10));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_storage_cluster(String string) throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_Cluster");
        cIMInstance.setName("IBMTSESS_Cluster");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 30;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("CreationClassName");
        cIMPropertyArray[0].setName("CreationClassName");
        cIMPropertyArray[0].setKey(true);
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[0].setValue(new CIMValue((Object)"IBMTSESS_Cluster"));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("Name");
        cIMPropertyArray[2].setName("Name");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = this.subsystemName + "-" + string;
        cIMPropertyArray[2].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[3] = new CIMProperty("Dedicated");
        cIMPropertyArray[3].setName("Dedicated");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{new UnsignedInt16(3), new UnsignedInt16(15)};
        vector2.add(unsignedInt16Array[0]);
        vector2.add(unsignedInt16Array[1]);
        cIMPropertyArray[3].setValue(new CIMValue(vector2));
        cIMPropertyArray[4] = new CIMProperty("Description");
        cIMPropertyArray[4].setName("Description");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[5] = new CIMProperty("ElementName");
        cIMPropertyArray[5].setName("ElementName");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "Cluster on SHARK";
        cIMPropertyArray[5].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[6] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[6].setName("EnabledDefault");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[7] = new CIMProperty("EnabledState");
        cIMPropertyArray[7].setName("EnabledState");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[8] = new CIMProperty("IdentifyingDescriptions");
        cIMPropertyArray[8].setName("IdentifyingDescriptions");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[8].setValue(new CIMValue(vector3));
        cIMPropertyArray[9] = new CIMProperty("InstallDate");
        cIMPropertyArray[9].setName("InstallDate");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)12));
        Object var15_15 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var15_15));
        cIMPropertyArray[10] = new CIMProperty("Interconnect");
        cIMPropertyArray[10].setName("Interconnect");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var16_16));
        cIMPropertyArray[11] = new CIMProperty("NameFormat");
        cIMPropertyArray[11].setName("NameFormat");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[11].setValue(new CIMValue((Object)"Other"));
        cIMPropertyArray[12] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[12].setName("OperationalStatus");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        UnsignedInt16[] unsignedInt16Array2 = new UnsignedInt16[]{new UnsignedInt16(2)};
        vector4.add(unsignedInt16Array[0]);
        cIMPropertyArray[12].setValue(new CIMValue(vector4));
        cIMPropertyArray[13] = new CIMProperty("OtherDedicatedDescriptions");
        cIMPropertyArray[13].setName("OtherDedicatedDescriptions");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector5 = new Vector();
        cIMPropertyArray[13].setValue(new CIMValue(vector5));
        cIMPropertyArray[14] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[14].setName("OtherEnabledState");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var20_20 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var20_20));
        cIMPropertyArray[15] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[15].setName("OtherIdentifyingInfo");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector6 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector6));
        cIMPropertyArray[16] = new CIMProperty("PowerManagementCapabilities");
        cIMPropertyArray[16].setName("PowerManagementCapabilities");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector7 = new Vector();
        cIMPropertyArray[16].setValue(new CIMValue(vector7));
        cIMPropertyArray[17] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[17].setName("PrimaryOwnerContact");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        Object var23_23 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var23_23));
        cIMPropertyArray[18] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[18].setName("PrimaryOwnerName");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        Object var24_24 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var24_24));
        cIMPropertyArray[19] = new CIMProperty("RequestedState");
        cIMPropertyArray[19].setName("RequestedState");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[19].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[20] = new CIMProperty("ResetCapability");
        cIMPropertyArray[20].setName("ResetCapability");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)2));
        Object var26_26 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var26_26));
        cIMPropertyArray[21] = new CIMProperty("Roles");
        cIMPropertyArray[21].setName("Roles");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector8 = new Vector();
        cIMPropertyArray[21].setValue(new CIMValue(vector8));
        cIMPropertyArray[22] = new CIMProperty("Status");
        cIMPropertyArray[22].setName("Status");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)8));
        Object var28_28 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var28_28));
        cIMPropertyArray[23] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[23].setName("StatusDescriptions");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector9 = new Vector();
        cIMPropertyArray[23].setValue(new CIMValue((Object)"OK"));
        cIMPropertyArray[24] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[24].setName("TimeOfLastStateChange");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)12));
        Object var30_30 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var30_30));
        cIMPropertyArray[25] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[25].setName("SystemCreationClassName");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[25].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[26] = new CIMProperty("Types");
        cIMPropertyArray[26].setName("Types");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector10 = new Vector();
        cIMPropertyArray[26].setValue(new CIMValue(vector10));
        cIMPropertyArray[27] = new CIMProperty("InterconnectAddress");
        cIMPropertyArray[27].setName("InterconnectAddress");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)8));
        Object var32_32 = null;
        cIMPropertyArray[27].setValue(new CIMValue(var32_32));
        cIMPropertyArray[28] = new CIMProperty("MaxNumberOfNodes");
        cIMPropertyArray[28].setName("MaxNumberOfNodes");
        cIMPropertyArray[28].setType(CIMDataType.getPredefinedType((int)4));
        Object var33_33 = null;
        cIMPropertyArray[28].setValue(new CIMValue(var33_33));
        cIMPropertyArray[29] = new CIMProperty("ClusterState");
        cIMPropertyArray[29].setName("ClusterState");
        cIMPropertyArray[29].setType(CIMDataType.getPredefinedType((int)2));
        Object var34_34 = null;
        cIMPropertyArray[29].setValue(new CIMValue(var34_34));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_storage_system() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_StorageSystem");
        cIMInstance.setName("IBMTSESS_StorageSystem");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        int n = 28;
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("CreationClassName");
        cIMPropertyArray[0].setName("CreationClassName");
        cIMPropertyArray[0].setKey(true);
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[0].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        String string = "IBM TotalStorage DS8000";
        cIMPropertyArray[1].setValue(new CIMValue((Object)string));
        cIMPropertyArray[2] = new CIMProperty("Name");
        cIMPropertyArray[2].setName("Name");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)this.subsystemName));
        cIMPropertyArray[3] = new CIMProperty("Dedicated");
        cIMPropertyArray[3].setName("Dedicated");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{new UnsignedInt16(3), new UnsignedInt16(15)};
        vector2.add(unsignedInt16Array[0]);
        vector2.add(unsignedInt16Array[1]);
        cIMPropertyArray[3].setValue(new CIMValue(vector2));
        cIMPropertyArray[4] = new CIMProperty("Description");
        cIMPropertyArray[4].setName("Description");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "IBM TotalStorage DS8000 " + this.subsystemName;
        cIMPropertyArray[4].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[5] = new CIMProperty("ElementName");
        cIMPropertyArray[5].setName("ElementName");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "IBM TotalStorage DS8000";
        cIMPropertyArray[5].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[6] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[6].setName("EnabledDefault");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[7] = new CIMProperty("EnabledState");
        cIMPropertyArray[7].setName("EnabledState");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(2);
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[8] = new CIMProperty("IdentifyingDescriptions");
        cIMPropertyArray[8].setName("IdentifyingDescriptions");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("IPAddressV4HMC");
        vector3.add("MTMS");
        vector3.add("Machine signature");
        vector3.add("WWNN");
        cIMPropertyArray[8].setValue(new CIMValue(vector3));
        cIMPropertyArray[9] = new CIMProperty("InstallDate");
        cIMPropertyArray[9].setName("InstallDate");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)12));
        Object var13_13 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var13_13));
        cIMPropertyArray[10] = new CIMProperty("Model");
        cIMPropertyArray[10].setName("Model");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[10].setValue(new CIMValue((Object)"921"));
        cIMPropertyArray[11] = new CIMProperty("NameFormat");
        cIMPropertyArray[11].setName("NameFormat");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[11].setValue(new CIMValue((Object)"Other"));
        cIMPropertyArray[12] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[12].setName("OperationalStatus");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        UnsignedInt16[] unsignedInt16Array2 = new UnsignedInt16[]{new UnsignedInt16(2)};
        vector4.add(unsignedInt16Array[0]);
        vector4.add(unsignedInt16Array[1]);
        cIMPropertyArray[12].setValue(new CIMValue(vector4));
        cIMPropertyArray[13] = new CIMProperty("OtherDedicatedDescriptions");
        cIMPropertyArray[13].setName("OtherDedicatedDescriptions");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector5 = new Vector();
        cIMPropertyArray[13].setValue(new CIMValue(vector5));
        cIMPropertyArray[14] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[14].setName("OtherEnabledState");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var17_17 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var17_17));
        cIMPropertyArray[15] = new CIMProperty("OtherIdentifyingInfo");
        cIMPropertyArray[15].setName("OtherIdentifyingInfo");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector6 = new Vector<String>();
        vector6.add(this.ipAddressSubsystem);
        vector6.add(this.subsystemNameWithModel);
        vector6.add(this.machineSignature);
        vector6.add(this.wwn);
        cIMPropertyArray[15].setValue(new CIMValue(vector6));
        cIMPropertyArray[16] = new CIMProperty("PowerManagementCapabilities");
        cIMPropertyArray[16].setName("PowerManagementCapabilities");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)16));
        Vector vector7 = new Vector();
        cIMPropertyArray[16].setValue(new CIMValue(vector7));
        cIMPropertyArray[17] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[17].setName("PrimaryOwnerContact");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "IBM Customer";
        cIMPropertyArray[17].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[18] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[18].setName("PrimaryOwnerName");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "IBM Corporation";
        cIMPropertyArray[18].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[19] = new CIMProperty("RequestedState");
        cIMPropertyArray[19].setName("RequestedState");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[19].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[20] = new CIMProperty("ResetCapability");
        cIMPropertyArray[20].setName("ResetCapability");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)2));
        Object var23_23 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var23_23));
        cIMPropertyArray[21] = new CIMProperty("Roles");
        cIMPropertyArray[21].setName("Roles");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector8 = new Vector();
        cIMPropertyArray[21].setValue(new CIMValue(vector8));
        cIMPropertyArray[22] = new CIMProperty("Status");
        cIMPropertyArray[22].setName("Status");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)8));
        Object var25_25 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var25_25));
        cIMPropertyArray[23] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[23].setName("StatusDescriptions");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector9 = new Vector();
        cIMPropertyArray[23].setValue(new CIMValue((Object)"OK"));
        cIMPropertyArray[24] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[24].setName("TimeOfLastStateChange");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)12));
        Object var27_27 = null;
        cIMPropertyArray[24].setValue(new CIMValue(var27_27));
        cIMPropertyArray[25] = new CIMProperty("codelevel");
        cIMPropertyArray[25].setName("codelevel");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[25].setValue(new CIMValue((Object)"5.0.500.123"));
        cIMPropertyArray[26] = new CIMProperty("nvs");
        cIMPropertyArray[26].setName("nvs");
        cIMPropertyArray[26].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = "";
        cIMPropertyArray[26].setValue(new CIMValue((Object)string6));
        cIMPropertyArray[27] = new CIMProperty("cache");
        cIMPropertyArray[27].setName("cache");
        cIMPropertyArray[27].setType(CIMDataType.getPredefinedType((int)8));
        String string7 = "";
        cIMPropertyArray[27].setValue(new CIMValue((Object)string7));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private void populate_RegisteredProfile() throws Exception {
        CIMInstance cIMInstance;
        int n;
        CIMInstance cIMInstance2 = this.get_ibmts_registered_profile();
        System.out.println("Instance = " + cIMInstance2);
        CIMInstance cIMInstance3 = this.get_ibmtsess_registered_profile();
        System.out.println("Instance = " + cIMInstance3);
        CIMInstance[] cIMInstanceArray = this.get_ibmtsess_registered_sub_profile();
        for (int i = 0; i < cIMInstanceArray.length; ++i) {
            System.out.println("Instance = " + cIMInstanceArray[i]);
        }
        CIMInstance cIMInstance4 = this.get_ibmts_object_manager();
        System.out.println("Instance = " + cIMInstance4);
        CIMInstance cIMInstance5 = this.get_ibmts_namespace();
        System.out.println("Instance = " + cIMInstance5);
        CIMInstance cIMInstance6 = this.get_ibmts_account();
        System.out.println("Instance = " + cIMInstance6);
        CIMInstance cIMInstance7 = this.get_ibmts_account_management_service();
        System.out.println("Instance = " + cIMInstance7);
        CIMInstance cIMInstance8 = this.get_ibmts_system();
        System.out.println("Instance = " + cIMInstance8);
        CIMInstance cIMInstance9 = this.get_ibmts_certificate();
        System.out.println("Instance = " + cIMInstance9);
        if (cIMInstance9 != null) {
            // empty if block
        }
        CIMInstance cIMInstance10 = this.get_certificate_setting();
        System.out.println("Instance = " + cIMInstance10);
        CIMInstance cIMInstance11 = this.get_cimxml_communication_mechanism();
        System.out.println("Instance = " + cIMInstance11);
        CIMInstance[] cIMInstanceArray2 = this.get_indication_filter();
        for (int i = 0; i < cIMInstanceArray2.length; ++i) {
            System.out.println("Instance = " + cIMInstanceArray2[i]);
        }
        CIMInstance cIMInstance12 = this.get_ibmts_truststore();
        System.out.println("Instance = " + cIMInstance12);
        if (cIMInstance12 != null) {
            // empty if block
        }
        CIMInstance cIMInstance13 = this.get_ibmts_truststore_management_service();
        System.out.println("Instance = " + cIMInstance13);
        if (cIMInstance13 != null) {
            // empty if block
        }
        CIMInstance cIMInstance14 = this.get_ibmtsess_provider();
        System.out.println("Instance = " + cIMInstance14);
        if (cIMInstance14 != null) {
            // empty if block
        }
        CIMInstance cIMInstance15 = this.get_ibmts_namespace_in_manager(cIMInstance4, cIMInstance5);
        System.out.println("Instance = " + cIMInstance15);
        if (cIMInstance15 != null) {
            // empty if block
        }
        CIMInstance cIMInstance16 = this.get_ibmts_account_management_service_for_system(cIMInstance7, cIMInstance4);
        System.out.println("Instance = " + cIMInstance16);
        if (cIMInstance16 != null) {
            // empty if block
        }
        CIMInstance cIMInstance17 = this.get_ibmts_account_on_cimom(cIMInstance4, cIMInstance6);
        System.out.println("Instance = " + cIMInstance17);
        if (cIMInstance17 != null) {
            // empty if block
        }
        CIMInstance cIMInstance18 = this.get_ibmts_comm_mechanism_for_manager(cIMInstance4, cIMInstance11);
        System.out.println("Instance = " + cIMInstance18);
        if (cIMInstance18 != null) {
            // empty if block
        }
        CIMInstance cIMInstance19 = this.get_ibmts_hosted_access_point(cIMInstance8, cIMInstance11);
        System.out.println("Instance = " + cIMInstance19);
        if (cIMInstance19 != null) {
            // empty if block
        }
        CIMInstance cIMInstance20 = this.get_ibmts_element_conforms_to_profile(cIMInstance2, cIMInstance4);
        System.out.println("Instance = " + cIMInstance20);
        if (cIMInstance20 != null) {
            // empty if block
        }
        CIMInstance cIMInstance21 = this.get_ibmts_hosted_service(cIMInstance8, cIMInstance4);
        System.out.println("Instance = " + cIMInstance21);
        if (cIMInstance21 != null) {
            // empty if block
        }
        for (n = 0; n < cIMInstanceArray2.length; ++n) {
            cIMInstance = this.get_ibmts_indication_filters_conforms_to_profile(cIMInstance2, cIMInstanceArray2[n]);
            System.out.println("Instance = " + cIMInstance);
            if (cIMInstance == null) continue;
        }
        for (n = 0; n < cIMInstanceArray.length; ++n) {
            cIMInstance = this.get_ibmtsess_sub_profile_requires_profile(cIMInstance3, cIMInstanceArray[n]);
            System.out.println("Instance = " + cIMInstance);
            if (cIMInstance == null) continue;
        }
    }

    private CIMInstance get_ibmtsess_provider() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_Provider");
        cIMInstance.setName("IBMTSESS_Provider");
        int n = 22;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("CreationClassName");
        cIMPropertyArray[1].setName("CreationClassName");
        cIMPropertyArray[1].setKey(true);
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[1].setValue(new CIMValue((Object)"IBMTSESS_Provider"));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        String string = "IBM ESS CIM Provider";
        cIMPropertyArray[2].setValue(new CIMValue((Object)string));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "IBM ESS CIM Provider";
        cIMPropertyArray[3].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[4] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[4].setName("EnabledDefault");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[5] = new CIMProperty("EnabledState");
        cIMPropertyArray[5].setName("EnabledState");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[6] = new CIMProperty("Handle");
        cIMPropertyArray[6].setName("Handle");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "com.ibm.tpc.simulator.cimom.sunwbem.provider.Provider";
        cIMPropertyArray[6].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[7] = new CIMProperty("InstallDate");
        cIMPropertyArray[7].setName("InstallDate");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var11_11));
        cIMPropertyArray[8] = new CIMProperty("Name");
        cIMPropertyArray[8].setName("Name");
        cIMPropertyArray[8].setKey(true);
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "IBM ESS Provider";
        cIMPropertyArray[8].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[9] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[9].setName("OperationalStatus");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)22));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(2));
        cIMPropertyArray[9].setValue(new CIMValue(vector2));
        cIMPropertyArray[10] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[10].setName("OtherEnabledState");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        Object var14_14 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var14_14));
        cIMPropertyArray[11] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[11].setName("PrimaryOwnerContact");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[12].setName("PrimaryOwnerName");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var16_16));
        cIMPropertyArray[13] = new CIMProperty("RequestedState");
        cIMPropertyArray[13].setName("RequestedState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[14] = new CIMProperty("Started");
        cIMPropertyArray[14].setName("Started");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[14].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[15] = new CIMProperty("StartMode");
        cIMPropertyArray[15].setName("StartMode");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        Object var19_19 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var19_19));
        cIMPropertyArray[16] = new CIMProperty("Status");
        cIMPropertyArray[16].setName("Status");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        Object var20_20 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var20_20));
        cIMPropertyArray[17] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[17].setName("StatusDescriptions");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("OK");
        cIMPropertyArray[17].setValue(new CIMValue(vector3));
        cIMPropertyArray[18] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[18].setName("SystemCreationClassName");
        cIMPropertyArray[18].setKey(true);
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[18].setValue(new CIMValue((Object)"IBMTS"));
        cIMPropertyArray[19] = new CIMProperty("SystemName");
        cIMPropertyArray[19].setName("SystemName");
        cIMPropertyArray[19].setKey(true);
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[19].setValue(new CIMValue((Object)"IBM Provider"));
        cIMPropertyArray[20] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[20].setName("TimeOfLastStateChange");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)12));
        Object var22_22 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var22_22));
        cIMPropertyArray[21] = new CIMProperty("version");
        cIMPropertyArray[21].setName("version");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[21].setValue(new CIMValue((Object)"5.1.0.43"));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_sub_profile_requires_profile(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTSESS_SubProfileRequiresProfile");
        cIMInstance3.setName("IBMTSESS_SubProfileRequiresProfile");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTSESS_RegisteredProfile"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTSESS_RegisteredSubProfile"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_indication_filters_conforms_to_profile(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_IndicationFiltersConformsToProfile");
        cIMInstance3.setName("IBMTS_IndicationFiltersConformsToProfile");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("ConformantStandard");
        cIMProperty.setName("ConformantStandard");
        cIMProperty.setType(new CIMDataType("IBMTS_RegisteredProfile"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("ManagedElement");
        cIMProperty2.setName("ManagedElement");
        cIMProperty2.setType(new CIMDataType("IBMTS_IndicationFilter"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_hosted_service(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_HostedService");
        cIMInstance3.setName("IBMTS_HostedService");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTS_System"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTS_ObjectManager"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_element_conforms_to_profile(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_ElementConformsToProfile");
        cIMInstance3.setName("IBMTS_ElementConformsToProfile");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("ConformantStandard");
        cIMProperty.setName("ConformantStandard");
        cIMProperty.setType(new CIMDataType("IBMTS_RegisteredProfile"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("ManagedElement");
        cIMProperty2.setName("ManagedElement");
        cIMProperty2.setType(new CIMDataType("IBMTS_ObjectManager"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_hosted_access_point(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_HostedAccessPoint");
        cIMInstance3.setName("IBMTS_HostedAccessPoint");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTS_System"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTS_CIMXMLCommunicationMechanism"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_comm_mechanism_for_manager(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_CommMechanismForManager");
        cIMInstance3.setName("IBMTS_CommMechanismForManager");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTS_ObjectManager"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTS_CIMXMLCommunicationMechanism"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_account_on_cimom(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_AccountOnCIMOM");
        cIMInstance3.setName("IBMTS_AccountOnCIMOM");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("GroupComponent");
        cIMProperty.setName("GroupComponent");
        cIMProperty.setType(new CIMDataType("IBMTS_ObjectManager"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("PartComponent");
        cIMProperty2.setName("PartComponent");
        cIMProperty2.setType(new CIMDataType("IBMTS_Account"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        CIMProperty cIMProperty3 = new CIMProperty("Role");
        cIMProperty3.setName("Role");
        cIMProperty3.setType(CIMDataType.getPredefinedType((int)8));
        String string = "Administrator";
        cIMProperty3.setValue(new CIMValue((Object)string));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        vector.add(cIMProperty3);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_account_management_service_for_system(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_NamespaceInManager");
        cIMInstance3.setName("IBMTS_NamespaceInManager");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTS_AccountManagementService"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTS_ObjectManager"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_namespace_in_manager(CIMInstance cIMInstance, CIMInstance cIMInstance2) throws Exception {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance);
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2);
        CIMInstance cIMInstance3 = new CIMInstance();
        cIMInstance3.setClassName("IBMTS_NamespaceInManager");
        cIMInstance3.setName("IBMTS_NamespaceInManager");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("Antecedent");
        cIMProperty.setName("Antecedent");
        cIMProperty.setType(new CIMDataType("IBMTS_ObjectManager"));
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        CIMProperty cIMProperty2 = new CIMProperty("Dependent");
        cIMProperty2.setName("Dependent");
        cIMProperty2.setType(new CIMDataType("IBMTS_NameSpace"));
        cIMProperty2.setValue(new CIMValue((Object)cIMObjectPath2));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        cIMInstance3.setProperties(vector);
        return cIMInstance3;
    }

    private CIMInstance get_ibmts_truststore_management_service() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_TruststoreManagementService");
        cIMInstance.setName("IBMTS_TruststoreManagementService");
        int n = 23;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("AutoGenerationEnabled");
        cIMPropertyArray[0].setName("AutoGenerationEnabled");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(false);
        cIMPropertyArray[0].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[1].setValue(new CIMValue(var6_6));
        cIMPropertyArray[2] = new CIMProperty("CreationClassName");
        cIMPropertyArray[2].setName("CreationClassName");
        cIMPropertyArray[2].setKey(true);
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTS_TruststoreManagementService"));
        cIMPropertyArray[3] = new CIMProperty("DefaultValidity");
        cIMPropertyArray[3].setName("DefaultValidity");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)4));
        UnsignedInt32 unsignedInt32 = new UnsignedInt32(365L);
        cIMPropertyArray[3].setValue(new CIMValue((Object)unsignedInt32));
        cIMPropertyArray[4] = new CIMProperty("Description");
        cIMPropertyArray[4].setName("Description");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var8_8 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var8_8));
        cIMPropertyArray[5] = new CIMProperty("ElementName");
        cIMPropertyArray[5].setName("ElementName");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var9_9));
        cIMPropertyArray[6] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[6].setName("EnabledDefault");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[6].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[7] = new CIMProperty("EnabledState");
        cIMPropertyArray[7].setName("EnabledState");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[8] = new CIMProperty("HealthState");
        cIMPropertyArray[8].setName("HealthState");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)2));
        Object var12_12 = null;
        cIMPropertyArray[8].setValue(new CIMValue(var12_12));
        cIMPropertyArray[9] = new CIMProperty("InstallDate");
        cIMPropertyArray[9].setName("InstallDate");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        Object var13_13 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var13_13));
        cIMPropertyArray[10] = new CIMProperty("Name");
        cIMPropertyArray[10].setName("Name");
        cIMPropertyArray[10].setKey(true);
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        String string = "SVC_CIMOM";
        cIMPropertyArray[10].setValue(new CIMValue((Object)string));
        cIMPropertyArray[11] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[11].setName("OperationalStatus");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector2 = new Vector();
        cIMPropertyArray[11].setValue(new CIMValue(vector2));
        cIMPropertyArray[12] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[12].setName("OtherEnabledState");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var16_16));
        cIMPropertyArray[13] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[13].setName("PrimaryOwnerContact");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)8));
        Object var17_17 = null;
        cIMPropertyArray[13].setValue(new CIMValue(var17_17));
        cIMPropertyArray[14] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[14].setName("PrimaryOwnerName");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("RequestedState");
        cIMPropertyArray[15].setName("RequestedState");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(12);
        cIMPropertyArray[15].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[16] = new CIMProperty("Started");
        cIMPropertyArray[16].setName("Started");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)9));
        Object var20_20 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var20_20));
        cIMPropertyArray[17] = new CIMProperty("StartMode");
        cIMPropertyArray[17].setName("StartMode");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        Object var21_21 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var21_21));
        cIMPropertyArray[18] = new CIMProperty("Status");
        cIMPropertyArray[18].setName("Status");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        Object var22_22 = null;
        cIMPropertyArray[18].setValue(new CIMValue(var22_22));
        cIMPropertyArray[19] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[19].setName("StatusDescriptions");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[19].setValue(new CIMValue(vector3));
        cIMPropertyArray[20] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[20].setName("SystemCreationClassName");
        cIMPropertyArray[20].setKey(true);
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[20].setValue(new CIMValue((Object)"IBMTS"));
        cIMPropertyArray[21] = new CIMProperty("SystemName");
        cIMPropertyArray[21].setName("SystemName");
        cIMPropertyArray[21].setKey(true);
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[21].setValue(new CIMValue((Object)"IBM SSG CIMOM"));
        cIMPropertyArray[22] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[22].setName("TimeOfLastStateChange");
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)8));
        Object var24_24 = null;
        cIMPropertyArray[22].setValue(new CIMValue(var24_24));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmts_truststore() throws Exception {
        CIMInstance cIMInstance = null;
        return cIMInstance;
    }

    private CIMInstance[] get_indication_filter() throws Exception {
        CIMInstance[] cIMInstanceArray = new CIMInstance[4];
        for (int i = 0; i < cIMInstanceArray.length; ++i) {
            cIMInstanceArray[i] = new CIMInstance();
            cIMInstanceArray[i].setClassName("IBMTS_IndicationFilter");
            cIMInstanceArray[i].setName("IBMTS_IndicationFilter");
            int n = 10;
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            CIMProperty[] cIMPropertyArray = new CIMProperty[n];
            cIMPropertyArray[0] = new CIMProperty("Caption");
            cIMPropertyArray[0].setName("Caption");
            cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
            Object var6_6 = null;
            cIMPropertyArray[0].setValue(new CIMValue(var6_6));
            cIMPropertyArray[1] = new CIMProperty("CreationClassName");
            cIMPropertyArray[1].setName("CreationClassName");
            cIMPropertyArray[1].setKey(true);
            cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
            cIMPropertyArray[1].setValue(new CIMValue((Object)"CIM_IndicationFilter"));
            cIMPropertyArray[2] = new CIMProperty("Description");
            cIMPropertyArray[2].setName("Description");
            cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
            String string = null;
            switch (i) {
                case 0: {
                    string = "CIM_InstCreation Filter";
                    break;
                }
                case 1: {
                    string = "CIM_InstDeletion Filter";
                    break;
                }
                case 2: {
                    string = "CIM_InstModification Filter";
                    break;
                }
                case 3: {
                    string = "CIM_ProcessIndication Filter";
                }
            }
            cIMPropertyArray[2].setValue(new CIMValue((Object)string));
            cIMPropertyArray[3] = new CIMProperty("ElementName");
            cIMPropertyArray[3].setName("ElementName");
            cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
            cIMPropertyArray[3].setValue(new CIMValue((Object)string));
            cIMPropertyArray[4] = new CIMProperty("Name");
            cIMPropertyArray[4].setName("Name");
            cIMPropertyArray[4].setKey(true);
            cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
            String string2 = null;
            switch (i) {
                case 0: {
                    string2 = "CIM_InstCreation";
                    break;
                }
                case 1: {
                    string2 = "CIM_InstDeletion";
                    break;
                }
                case 2: {
                    string2 = "CIM_InstModification";
                    break;
                }
                case 3: {
                    string2 = "CIM_ProcessIndication";
                }
            }
            cIMPropertyArray[4].setValue(new CIMValue((Object)string2));
            cIMPropertyArray[5] = new CIMProperty("Query");
            cIMPropertyArray[5].setName("Query");
            cIMPropertyArray[5].setKey(true);
            cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
            String string3 = null;
            switch (i) {
                case 0: {
                    string3 = "SELECT * FROM CIM_InstCreation";
                    break;
                }
                case 1: {
                    string3 = "SELECT * FROM CIM_InstDeletion";
                    break;
                }
                case 2: {
                    string3 = "SELECT * FROM CIM_InstModification";
                    break;
                }
                case 3: {
                    string3 = "SELECT * FROM CIM_ProcessIndication";
                }
            }
            cIMPropertyArray[5].setValue(new CIMValue((Object)string3));
            cIMPropertyArray[6] = new CIMProperty("QueryLanguage");
            cIMPropertyArray[6].setName("QueryLanguage");
            cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
            cIMPropertyArray[6].setValue(new CIMValue((Object)"WQL"));
            cIMPropertyArray[7] = new CIMProperty("SourceNamespace");
            cIMPropertyArray[7].setName("SourceNamespace");
            cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
            Object var10_10 = null;
            cIMPropertyArray[7].setValue(new CIMValue(var10_10));
            cIMPropertyArray[8] = new CIMProperty("SystemCreationClassName");
            cIMPropertyArray[8].setName("SystemCreationClassName");
            cIMPropertyArray[8].setKey(true);
            cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
            cIMPropertyArray[8].setValue(new CIMValue((Object)"CIM_IndicationFilter"));
            cIMPropertyArray[9] = new CIMProperty("SystemName");
            cIMPropertyArray[9].setName("SystemName");
            cIMPropertyArray[9].setKey(true);
            cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
            cIMPropertyArray[9].setValue(new CIMValue((Object)"IBMTS"));
            for (int j = 0; j < n; ++j) {
                vector.add(cIMPropertyArray[j]);
            }
            cIMInstanceArray[i].setProperties(vector);
        }
        return cIMInstanceArray;
    }

    private CIMInstance get_cimxml_communication_mechanism() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_CIMXMLCommunicationMechanism");
        cIMInstance.setName("IBMTS_CIMXMLCommunicationMechanism");
        int n = 26;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("AuthenticationMechanismDescriptions");
        cIMPropertyArray[0].setName("AuthenticationMechanismDescriptions");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector2 = new Vector();
        cIMPropertyArray[0].setValue(new CIMValue(vector2));
        cIMPropertyArray[1] = new CIMProperty("AuthenticationMechanismsSupported");
        cIMPropertyArray[1].setName("AuthenticationMechanismsSupported");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        vector3.add(new UnsignedInt16(3));
        cIMPropertyArray[1].setValue(new CIMValue(vector3));
        cIMPropertyArray[2] = new CIMProperty("Caption");
        cIMPropertyArray[2].setName("Caption");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var7_7));
        cIMPropertyArray[3] = new CIMProperty("CIMValidated");
        cIMPropertyArray[3].setName("CIMValidated");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(false);
        cIMPropertyArray[3].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[4] = new CIMProperty("CIMXMLProtocolVersion");
        cIMPropertyArray[4].setName("CIMXMLProtocolVersion");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(1);
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[5] = new CIMProperty("CommunicationMechanism");
        cIMPropertyArray[5].setName("CommunicationMechanism");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(2);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[6] = new CIMProperty("CreationClassName");
        cIMPropertyArray[6].setName("CreationClassName");
        cIMPropertyArray[6].setKey(true);
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[6].setValue(new CIMValue((Object)"IBMTS_CIMXMLCommunicationMechanism"));
        cIMPropertyArray[7] = new CIMProperty("Description");
        cIMPropertyArray[7].setName("Description");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var11_11));
        cIMPropertyArray[8] = new CIMProperty("ElementName");
        cIMPropertyArray[8].setName("ElementName");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        String string = "CIMXMLCommunicationMechanism";
        cIMPropertyArray[8].setValue(new CIMValue((Object)string));
        cIMPropertyArray[9] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[9].setName("EnabledDefault");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(2);
        cIMPropertyArray[9].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[10] = new CIMProperty("EnabledState");
        cIMPropertyArray[10].setName("EnabledState");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt164 = new UnsignedInt16(5);
        cIMPropertyArray[10].setValue(new CIMValue((Object)unsignedInt164));
        cIMPropertyArray[11] = new CIMProperty("FunctionalProfilesSupported");
        cIMPropertyArray[11].setName("FunctionalProfilesSupported");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[7];
        int n2 = 0;
        for (int i = 2; i <= 9; ++i) {
            if (i != 4) {
                unsignedInt16Array[n2] = new UnsignedInt16(i);
                vector4.add(unsignedInt16Array[n2]);
            } else {
                --n2;
            }
            ++n2;
        }
        cIMPropertyArray[11].setValue(new CIMValue(vector4));
        cIMPropertyArray[12] = new CIMProperty("InstallDate");
        cIMPropertyArray[12].setName("InstallDate");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)12));
        Object var17_18 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var17_18));
        cIMPropertyArray[13] = new CIMProperty("MultipleOperationsSupported");
        cIMPropertyArray[13].setName("MultipleOperationsSupported");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl2 = new Boolean(false);
        cIMPropertyArray[13].setValue(new CIMValue((Object)bl2));
        cIMPropertyArray[14] = new CIMProperty("Name");
        cIMPropertyArray[14].setName("Name");
        cIMPropertyArray[14].setKey(true);
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[14].setValue(new CIMValue((Object)"IBMTS_CIMXMLCommunicationMechanism"));
        cIMPropertyArray[15] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[15].setName("OperationalStatus");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector5 = new Vector<UnsignedInt16>();
        vector5.add(new UnsignedInt16(2));
        cIMPropertyArray[15].setValue(new CIMValue(vector5));
        cIMPropertyArray[16] = new CIMProperty("OtherCommunicationMechanismDescription");
        cIMPropertyArray[16].setName("OtherCommunicationMechanismDescription");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "CIM-XML";
        cIMPropertyArray[16].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[17] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[17].setName("OtherEnabledState");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        Object var21_23 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var21_23));
        cIMPropertyArray[18] = new CIMProperty("RequestedState");
        cIMPropertyArray[18].setName("RequestedState");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt165 = new UnsignedInt16(5);
        cIMPropertyArray[18].setValue(new CIMValue((Object)unsignedInt165));
        cIMPropertyArray[19] = new CIMProperty("Status");
        cIMPropertyArray[19].setName("Status");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        Object var23_25 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var23_25));
        cIMPropertyArray[20] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[20].setName("StatusDescriptions");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector6 = new Vector<String>();
        vector6.add("OK");
        cIMPropertyArray[20].setValue(new CIMValue(vector6));
        cIMPropertyArray[21] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[21].setName("SystemCreationClassName");
        cIMPropertyArray[21].setKey(true);
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[21].setValue(new CIMValue((Object)"IBMTS"));
        cIMPropertyArray[22] = new CIMProperty("SystemName");
        cIMPropertyArray[22].setName("SystemName");
        cIMPropertyArray[22].setKey(true);
        cIMPropertyArray[22].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "IBM XMLCommunicationMechanism";
        cIMPropertyArray[22].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[23] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[23].setName("TimeOfLastStateChange");
        cIMPropertyArray[23].setType(CIMDataType.getPredefinedType((int)12));
        Object var26_28 = null;
        cIMPropertyArray[23].setValue(new CIMValue(var26_28));
        cIMPropertyArray[24] = new CIMProperty("version");
        cIMPropertyArray[24].setName("version");
        cIMPropertyArray[24].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[24].setValue(new CIMValue((Object)"1.0"));
        cIMPropertyArray[25] = new CIMProperty("FunctionalProfileDescriptions");
        cIMPropertyArray[25].setName("FunctionalProfileDescriptions");
        cIMPropertyArray[25].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector7 = new Vector();
        cIMPropertyArray[25].setValue(new CIMValue(vector7));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_certificate_setting() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_CertificateSetting");
        cIMInstance.setName("IBMTS_CertificateSetting");
        int n = 8;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[8];
        cIMPropertyArray[0] = new CIMProperty("AutoGenerationEnabled");
        cIMPropertyArray[0].setName("AutoGenerationEnabled");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)9));
        cIMPropertyArray[0].setValue(new CIMValue((Object)new Boolean(false)));
        cIMPropertyArray[1] = new CIMProperty("Caption");
        cIMPropertyArray[1].setName("Caption");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        String string = "IBM default setting for certificate creation";
        cIMPropertyArray[1].setValue(new CIMValue((Object)string));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "The vital product data of a node.";
        cIMPropertyArray[2].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "IBM default setting for certificate creation";
        cIMPropertyArray[3].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[4] = new CIMProperty("InstanceID");
        cIMPropertyArray[4].setName("InstanceID");
        cIMPropertyArray[4].setKey(true);
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "DefaultCertificateSetting";
        cIMPropertyArray[4].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[5] = new CIMProperty("ServerCertificateName");
        cIMPropertyArray[5].setName("ServerCertificateName");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "CIMOMserver";
        cIMPropertyArray[5].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[6] = new CIMProperty("SignerCertificateName");
        cIMPropertyArray[6].setName("SignerCertificateName");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        String string6 = "CIMOMserver";
        cIMPropertyArray[6].setValue(new CIMValue((Object)string6));
        cIMPropertyArray[7] = new CIMProperty("Validity");
        cIMPropertyArray[7].setName("Validity");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)4));
        UnsignedInt32 unsignedInt32 = new UnsignedInt32("365");
        cIMPropertyArray[7].setValue(new CIMValue((Object)unsignedInt32));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmts_certificate() throws Exception {
        CIMInstance cIMInstance = null;
        return cIMInstance;
    }

    private CIMInstance get_ibmts_system() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_System");
        cIMInstance.setName("IBMTS_System");
        int n = 18;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("CreationClassName");
        cIMPropertyArray[1].setName("CreationClassName");
        cIMPropertyArray[1].setKey(true);
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[1].setValue(new CIMValue((Object)"IBMTS_System"));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBMTS_System"));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        String string = "Proxy Server";
        cIMPropertyArray[3].setValue(new CIMValue((Object)string));
        cIMPropertyArray[4] = new CIMProperty("EnabledState");
        cIMPropertyArray[4].setName("EnabledState");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(5);
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[5] = new CIMProperty("InstallDate");
        cIMPropertyArray[5].setName("InstallDate");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)12));
        Object var8_8 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var8_8));
        cIMPropertyArray[6] = new CIMProperty("Name");
        cIMPropertyArray[6].setName("Name");
        cIMPropertyArray[6].setKey(true);
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string2 = inetAddress.getHostAddress();
        cIMPropertyArray[6].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[7] = new CIMProperty("NameFormat");
        cIMPropertyArray[7].setName("NameFormat");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        String string3 = "Other";
        cIMPropertyArray[7].setValue(new CIMValue((Object)string3));
        cIMPropertyArray[8] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[8].setName("OperationalStatus");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(2));
        cIMPropertyArray[8].setValue(new CIMValue(vector2));
        cIMPropertyArray[9] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[9].setName("OtherEnabledState");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        Object var13_13 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var13_13));
        cIMPropertyArray[10] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[10].setName("PrimaryOwnerContact");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        String string4 = "IBM Customer";
        cIMPropertyArray[10].setValue(new CIMValue((Object)string4));
        cIMPropertyArray[11] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[11].setName("PrimaryOwnerName");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        String string5 = "IBM Corporation";
        cIMPropertyArray[11].setValue(new CIMValue((Object)string5));
        cIMPropertyArray[12] = new CIMProperty("RequestedState");
        cIMPropertyArray[12].setName("RequestedState");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[12].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[13] = new CIMProperty("Roles");
        cIMPropertyArray[13].setName("Roles");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[13].setValue(new CIMValue(vector3));
        cIMPropertyArray[14] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[14].setName("StatusDescriptions");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector4 = new Vector<String>();
        vector4.add(new String("OK"));
        cIMPropertyArray[14].setValue(new CIMValue(vector4));
        cIMPropertyArray[15] = new CIMProperty("Status");
        cIMPropertyArray[15].setName("Status");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        Object var19_19 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var19_19));
        cIMPropertyArray[16] = new CIMProperty("EnabledState");
        cIMPropertyArray[16].setName("EnabledState");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[16].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[17] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[17].setName("TimeOfLastStateChange");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)12));
        Object var21_21 = null;
        cIMPropertyArray[17].setValue(new CIMValue(var21_21));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmts_account_management_service() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_AccountManagementService");
        cIMInstance.setName("IBMTS_AccountManagementService");
        int n = 20;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("CreationClassName");
        cIMPropertyArray[1].setName("CreationClassName");
        cIMPropertyArray[1].setKey(true);
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[1].setValue(new CIMValue((Object)"IBMTS_AccountManagementService"));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var6_6));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var7_7));
        cIMPropertyArray[4] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[4].setName("EnabledDefault");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[5] = new CIMProperty("EnabledState");
        cIMPropertyArray[5].setName("EnabledState");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[6] = new CIMProperty("InstallDate");
        cIMPropertyArray[6].setName("InstallDate");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var10_10));
        cIMPropertyArray[7] = new CIMProperty("Name");
        cIMPropertyArray[7].setName("Name");
        cIMPropertyArray[7].setKey(true);
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        String string = "SVC_CIMOM";
        cIMPropertyArray[7].setValue(new CIMValue((Object)string));
        cIMPropertyArray[8] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[8].setName("OperationalStatus");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector2 = new Vector();
        cIMPropertyArray[8].setValue(new CIMValue(vector2));
        cIMPropertyArray[9] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[9].setName("OtherEnabledState");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        Object var13_13 = null;
        cIMPropertyArray[9].setValue(new CIMValue(var13_13));
        cIMPropertyArray[10] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[10].setName("PrimaryOwnerContact");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        Object var14_14 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var14_14));
        cIMPropertyArray[11] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[11].setName("PrimaryOwnerName");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var15_15 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var15_15));
        cIMPropertyArray[12] = new CIMProperty("RequestedState");
        cIMPropertyArray[12].setName("RequestedState");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[12].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[13] = new CIMProperty("Started");
        cIMPropertyArray[13].setName("Started");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)9));
        Object var17_17 = null;
        cIMPropertyArray[13].setValue(new CIMValue(var17_17));
        cIMPropertyArray[14] = new CIMProperty("StartMode");
        cIMPropertyArray[14].setName("StartMode");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("Status");
        cIMPropertyArray[15].setName("Status");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)8));
        Object var19_19 = null;
        cIMPropertyArray[15].setValue(new CIMValue(var19_19));
        cIMPropertyArray[16] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[16].setName("StatusDescriptions");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector3 = new Vector();
        cIMPropertyArray[16].setValue(new CIMValue(vector3));
        cIMPropertyArray[17] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[17].setName("SystemCreationClassName");
        cIMPropertyArray[17].setKey(true);
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)"IBMTS"));
        cIMPropertyArray[18] = new CIMProperty("SystemName");
        cIMPropertyArray[18].setName("SystemName");
        cIMPropertyArray[18].setKey(true);
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[18].setValue(new CIMValue((Object)"IBM SSG CIMOM"));
        cIMPropertyArray[19] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[19].setName("TimeOfLastStateChange");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        Object var21_21 = null;
        cIMPropertyArray[19].setValue(new CIMValue(var21_21));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmts_account() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_Account");
        cIMInstance.setName("IBMTS_Account");
        int n = 21;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("CreationClassName");
        cIMPropertyArray[1].setName("CreationClassName");
        cIMPropertyArray[1].setKey(true);
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[1].setValue(new CIMValue((Object)"IBMTS_Account"));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var6_6 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var6_6));
        cIMPropertyArray[3] = new CIMProperty("Descriptions");
        cIMPropertyArray[3].setName("Descriptions");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector2 = new Vector();
        cIMPropertyArray[3].setValue(new CIMValue(vector2));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var8_8 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var8_8));
        cIMPropertyArray[5] = new CIMProperty("Host");
        cIMPropertyArray[5].setName("Host");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("Administrator");
        cIMPropertyArray[5].setValue(new CIMValue(vector3));
        cIMPropertyArray[6] = new CIMProperty("InstallDate");
        cIMPropertyArray[6].setName("InstallDate");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var10_10));
        cIMPropertyArray[7] = new CIMProperty("LocalityName");
        cIMPropertyArray[7].setName("LocalityName");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector4 = new Vector();
        cIMPropertyArray[7].setValue(new CIMValue(vector4));
        cIMPropertyArray[8] = new CIMProperty("Name");
        cIMPropertyArray[8].setName("Name");
        cIMPropertyArray[8].setKey(true);
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        String string = "superuser";
        cIMPropertyArray[8].setValue(new CIMValue((Object)string));
        cIMPropertyArray[9] = new CIMProperty("OU");
        cIMPropertyArray[9].setName("OU");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector5 = new Vector();
        cIMPropertyArray[9].setValue(new CIMValue(vector5));
        cIMPropertyArray[10] = new CIMProperty("ObjectClass");
        cIMPropertyArray[10].setName("ObjectClass");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector6 = new Vector();
        cIMPropertyArray[10].setValue(new CIMValue(vector6));
        cIMPropertyArray[11] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[11].setName("OperationalStatus");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector7 = new Vector();
        cIMPropertyArray[11].setValue(new CIMValue(vector7));
        cIMPropertyArray[12] = new CIMProperty("OrganizationName");
        cIMPropertyArray[12].setName("OrganizationName");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector8 = new Vector();
        cIMPropertyArray[12].setValue(new CIMValue(vector8));
        cIMPropertyArray[13] = new CIMProperty("SeeAlso");
        cIMPropertyArray[13].setName("SeeAlso");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector9 = new Vector();
        cIMPropertyArray[13].setValue(new CIMValue(vector9));
        cIMPropertyArray[14] = new CIMProperty("Status");
        cIMPropertyArray[14].setName("Status");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var18_18 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var18_18));
        cIMPropertyArray[15] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[15].setName("StatusDescriptions");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector10 = new Vector();
        cIMPropertyArray[15].setValue(new CIMValue(vector10));
        cIMPropertyArray[16] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[16].setName("SystemCreationClassName");
        cIMPropertyArray[16].setKey(true);
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[16].setValue(new CIMValue((Object)"IBMTS_Account"));
        cIMPropertyArray[17] = new CIMProperty("SystemName");
        cIMPropertyArray[17].setName("SystemName");
        cIMPropertyArray[17].setKey(true);
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[17].setValue(new CIMValue((Object)"icat"));
        cIMPropertyArray[18] = new CIMProperty("UserCertificate");
        cIMPropertyArray[18].setName("UserCertificate");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)22));
        Vector vector11 = new Vector();
        cIMPropertyArray[18].setValue(new CIMValue(vector11));
        cIMPropertyArray[19] = new CIMProperty("UserID");
        cIMPropertyArray[19].setName("UserID");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        String string2 = "superuser";
        cIMPropertyArray[19].setValue(new CIMValue((Object)string2));
        cIMPropertyArray[20] = new CIMProperty("UserPassword");
        cIMPropertyArray[20].setName("UserPassword");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector12 = new Vector<String>();
        vector12.add("y95Se6dVeZuE8k8=");
        cIMPropertyArray[20].setValue(new CIMValue(vector12));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmts_namespace() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_NameSpace");
        cIMInstance.setName("IBMTS_NameSpace");
        int n = 14;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("ClassInfo");
        cIMPropertyArray[1].setName("CreationClassName");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)2));
        cIMPropertyArray[1].setValue(new CIMValue((Object)new UnsignedInt16(10)));
        cIMPropertyArray[2] = new CIMProperty("ClassType");
        cIMPropertyArray[2].setName("ClassType");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)2));
        Object var6_6 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var6_6));
        cIMPropertyArray[3] = new CIMProperty("ClassTypeVersion");
        cIMPropertyArray[3].setName("ClassTypeVersion");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var7_7));
        cIMPropertyArray[4] = new CIMProperty("CreationClassName");
        cIMPropertyArray[4].setName("CreationClassName");
        cIMPropertyArray[4].setKey(true);
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[4].setValue(new CIMValue((Object)"IBMTS_NameSpace"));
        cIMPropertyArray[5] = new CIMProperty("Description");
        cIMPropertyArray[5].setName("Description");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        Object var8_8 = null;
        cIMPropertyArray[5].setValue(new CIMValue(var8_8));
        cIMPropertyArray[6] = new CIMProperty("DescriptionOfClassInfo");
        cIMPropertyArray[6].setName("DescriptionOfClassInfo");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[6].setValue(new CIMValue(var9_9));
        cIMPropertyArray[7] = new CIMProperty("DescriptionOfClassType");
        cIMPropertyArray[7].setName("DescriptionOfClassType");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var10_10));
        cIMPropertyArray[8] = new CIMProperty("ElementName");
        cIMPropertyArray[8].setName("ElementName");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[8].setValue(new CIMValue((Object)"/root/ibm"));
        cIMPropertyArray[9] = new CIMProperty("Name");
        cIMPropertyArray[9].setName("Name");
        cIMPropertyArray[9].setKey(true);
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[9].setValue(new CIMValue((Object)"/root/ibm"));
        cIMPropertyArray[10] = new CIMProperty("ObjectManagerCreationClassName");
        cIMPropertyArray[10].setName("ObjectManagerCreationClassName");
        cIMPropertyArray[10].setKey(true);
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[10].setValue(new CIMValue((Object)"IBMTS_ObjectManager"));
        cIMPropertyArray[11] = new CIMProperty("ObjectManagerName");
        cIMPropertyArray[11].setName("ObjectManagerName");
        cIMPropertyArray[11].setKey(true);
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[11].setValue(new CIMValue((Object)"IBM_CIMOM_1145095755750_1288880889"));
        cIMPropertyArray[12] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[12].setName("SystemCreationClassName");
        cIMPropertyArray[12].setKey(true);
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[12].setValue(new CIMValue((Object)"IBMTS"));
        cIMPropertyArray[13] = new CIMProperty("SystemName");
        cIMPropertyArray[13].setName("SystemName");
        cIMPropertyArray[13].setKey(true);
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[13].setValue(new CIMValue((Object)"IBM Namespace"));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmts_object_manager() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_ObjectManager");
        cIMInstance.setName("IBMTS_ObjectManager");
        int n = 22;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("Caption");
        cIMPropertyArray[0].setName("Caption");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)8));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("CreationClassName");
        cIMPropertyArray[1].setName("CreationClassName");
        cIMPropertyArray[1].setKey(true);
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[1].setValue(new CIMValue((Object)"IBMTS_ObjectManager"));
        cIMPropertyArray[2] = new CIMProperty("Description");
        cIMPropertyArray[2].setName("Description");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[2].setValue(new CIMValue((Object)"IBM TotalStorage DS CIM Agent Version 5.1.0.43"));
        cIMPropertyArray[3] = new CIMProperty("ElementName");
        cIMPropertyArray[3].setName("ElementName");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[3].setValue(new CIMValue((Object)"ESS CIM Agent 5.1.0.43"));
        cIMPropertyArray[4] = new CIMProperty("EnabledDefault");
        cIMPropertyArray[4].setName("EnabledDefault");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        cIMPropertyArray[4].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[5] = new CIMProperty("EnabledState");
        cIMPropertyArray[5].setName("EnabledState");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(5);
        cIMPropertyArray[5].setValue(new CIMValue((Object)unsignedInt162));
        cIMPropertyArray[6] = new CIMProperty("GatherStatisticalData");
        cIMPropertyArray[6].setName("GatherStatisticalData");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)9));
        cIMPropertyArray[6].setValue(new CIMValue((Object)new Boolean(false)));
        cIMPropertyArray[7] = new CIMProperty("InstallDate");
        cIMPropertyArray[7].setName("InstallDate");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)12));
        Object var8_8 = null;
        cIMPropertyArray[7].setValue(new CIMValue(var8_8));
        cIMPropertyArray[8] = new CIMProperty("Name");
        cIMPropertyArray[8].setName("Name");
        cIMPropertyArray[8].setKey(true);
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[8].setValue(new CIMValue((Object)"IBM_CIMOM_1145095755750_1288880889"));
        cIMPropertyArray[9] = new CIMProperty("OperationalStatus");
        cIMPropertyArray[9].setName("OperationalStatus");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(2));
        cIMPropertyArray[9].setValue(new CIMValue(vector2));
        cIMPropertyArray[10] = new CIMProperty("OtherEnabledState");
        cIMPropertyArray[10].setName("OtherEnabledState");
        cIMPropertyArray[10].setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMPropertyArray[10].setValue(new CIMValue(var10_10));
        cIMPropertyArray[11] = new CIMProperty("PrimaryOwnerContact");
        cIMPropertyArray[11].setName("PrimaryOwnerContact");
        cIMPropertyArray[11].setType(CIMDataType.getPredefinedType((int)8));
        Object var11_11 = null;
        cIMPropertyArray[11].setValue(new CIMValue(var11_11));
        cIMPropertyArray[12] = new CIMProperty("PrimaryOwnerName");
        cIMPropertyArray[12].setName("PrimaryOwnerName");
        cIMPropertyArray[12].setType(CIMDataType.getPredefinedType((int)8));
        Object var12_12 = null;
        cIMPropertyArray[12].setValue(new CIMValue(var12_12));
        cIMPropertyArray[13] = new CIMProperty("RequestedState");
        cIMPropertyArray[13].setName("RequestedState");
        cIMPropertyArray[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt163 = new UnsignedInt16(5);
        cIMPropertyArray[13].setValue(new CIMValue((Object)unsignedInt163));
        cIMPropertyArray[14] = new CIMProperty("StartMode");
        cIMPropertyArray[14].setName("StartMode");
        cIMPropertyArray[14].setType(CIMDataType.getPredefinedType((int)8));
        Object var14_14 = null;
        cIMPropertyArray[14].setValue(new CIMValue(var14_14));
        cIMPropertyArray[15] = new CIMProperty("Started");
        cIMPropertyArray[15].setName("Started");
        cIMPropertyArray[15].setType(CIMDataType.getPredefinedType((int)9));
        Boolean bl = new Boolean(true);
        cIMPropertyArray[15].setValue(new CIMValue((Object)bl));
        cIMPropertyArray[16] = new CIMProperty("Status");
        cIMPropertyArray[16].setName("Status");
        cIMPropertyArray[16].setType(CIMDataType.getPredefinedType((int)8));
        Object var16_16 = null;
        cIMPropertyArray[16].setValue(new CIMValue(var16_16));
        cIMPropertyArray[17] = new CIMProperty("StatusDescriptions");
        cIMPropertyArray[17].setName("StatusDescriptions");
        cIMPropertyArray[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> vector3 = new Vector<String>();
        vector3.add("OK");
        cIMPropertyArray[17].setValue(new CIMValue(vector3));
        cIMPropertyArray[18] = new CIMProperty("SystemCreationClassName");
        cIMPropertyArray[18].setName("SystemCreationClassName");
        cIMPropertyArray[18].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[18].setValue(new CIMValue((Object)"IBM_TS"));
        cIMPropertyArray[19] = new CIMProperty("SystemName");
        cIMPropertyArray[19].setName("SystemName");
        cIMPropertyArray[19].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[19].setValue(new CIMValue((Object)"IBM SSG CIMOM"));
        cIMPropertyArray[20] = new CIMProperty("TimeOfLastStateChange");
        cIMPropertyArray[20].setName("TimeOfLastStateChange");
        cIMPropertyArray[20].setType(CIMDataType.getPredefinedType((int)12));
        Object var18_18 = null;
        cIMPropertyArray[20].setValue(new CIMValue(var18_18));
        cIMPropertyArray[21] = new CIMProperty("version");
        cIMPropertyArray[21].setName("version");
        cIMPropertyArray[21].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[21].setValue(new CIMValue((Object)"5.1.0.43"));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmts_registered_profile() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTS_RegisteredProfile");
        cIMInstance.setName("IBMTS_RegisteredProfile");
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty("AdvertiseTypeDescriptions");
        cIMProperty.setName("AdvertiseTypeDescriptions");
        cIMProperty.setType(CIMDataType.getPredefinedType((int)22));
        Object var4_4 = null;
        cIMProperty.setValue(new CIMValue(var4_4));
        CIMProperty cIMProperty2 = new CIMProperty("AdvertiseTypes");
        cIMProperty2.setName("AdvertiseTypes");
        cIMProperty2.setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
        vector2.add(unsignedInt16);
        cIMProperty2.setValue(new CIMValue(vector2));
        CIMProperty cIMProperty3 = new CIMProperty("InstanceID");
        cIMProperty3.setKey(true);
        cIMProperty3.setName("InstanceID");
        cIMProperty3.setType(CIMDataType.getPredefinedType((int)8));
        cIMProperty3.setValue(new CIMValue((Object)"IBMTS:Server"));
        CIMProperty cIMProperty4 = new CIMProperty("OtherRegisteredOrganization");
        cIMProperty4.setName("OtherRegisteredOrganization");
        cIMProperty4.setType(CIMDataType.getPredefinedType((int)8));
        Object var10_10 = null;
        cIMProperty4.setValue(new CIMValue(var10_10));
        CIMProperty cIMProperty5 = new CIMProperty("RegisteredName");
        cIMProperty5.setName("RegisteredName");
        cIMProperty5.setType(CIMDataType.getPredefinedType((int)8));
        cIMProperty5.setValue(new CIMValue((Object)"Server"));
        CIMProperty cIMProperty6 = new CIMProperty("RegisteredOrganization");
        cIMProperty6.setName("RegisteredOrganization");
        cIMProperty6.setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(11);
        cIMProperty6.setValue(new CIMValue((Object)unsignedInt162));
        CIMProperty cIMProperty7 = new CIMProperty("RegisteredVersion");
        cIMProperty7.setName("RegisteredVersion");
        cIMProperty7.setType(CIMDataType.getPredefinedType((int)8));
        cIMProperty7.setValue(new CIMValue((Object)"1.0.3"));
        vector.add(cIMProperty);
        vector.add(cIMProperty2);
        vector.add(cIMProperty3);
        vector.add(cIMProperty4);
        vector.add(cIMProperty5);
        vector.add(cIMProperty6);
        vector.add(cIMProperty7);
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance get_ibmtsess_registered_profile() throws Exception {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName("IBMTSESS_RegisteredProfile");
        cIMInstance.setName("IBMTSESS_RegisteredProfile");
        int n = 10;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty[] cIMPropertyArray = new CIMProperty[n];
        cIMPropertyArray[0] = new CIMProperty("AdvertiseTypeDescriptions");
        cIMPropertyArray[0].setName("AdvertiseTypeDescriptions");
        cIMPropertyArray[0].setType(CIMDataType.getPredefinedType((int)22));
        Object var5_5 = null;
        cIMPropertyArray[0].setValue(new CIMValue(var5_5));
        cIMPropertyArray[1] = new CIMProperty("AdvertiseTypes");
        cIMPropertyArray[1].setName("AdvertiseTypes");
        cIMPropertyArray[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(2));
        cIMPropertyArray[1].setValue(new CIMValue(vector2));
        cIMPropertyArray[2] = new CIMProperty("Caption");
        cIMPropertyArray[2].setName("Caption");
        cIMPropertyArray[2].setType(CIMDataType.getPredefinedType((int)8));
        Object var7_7 = null;
        cIMPropertyArray[2].setValue(new CIMValue(var7_7));
        cIMPropertyArray[3] = new CIMProperty("Description");
        cIMPropertyArray[3].setName("Description");
        cIMPropertyArray[3].setType(CIMDataType.getPredefinedType((int)8));
        Object var8_8 = null;
        cIMPropertyArray[3].setValue(new CIMValue(var8_8));
        cIMPropertyArray[4] = new CIMProperty("ElementName");
        cIMPropertyArray[4].setName("ElementName");
        cIMPropertyArray[4].setType(CIMDataType.getPredefinedType((int)8));
        Object var9_9 = null;
        cIMPropertyArray[4].setValue(new CIMValue(var9_9));
        cIMPropertyArray[5] = new CIMProperty("InstanceID");
        cIMPropertyArray[5].setKey(true);
        cIMPropertyArray[5].setName("InstanceID");
        cIMPropertyArray[5].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[5].setValue(new CIMValue((Object)"Array"));
        cIMPropertyArray[6] = new CIMProperty("OtherRegisteredOrganization");
        cIMPropertyArray[6].setName("OtherRegisteredOrganization");
        cIMPropertyArray[6].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[6].setValue(new CIMValue((Object)"SNIA"));
        cIMPropertyArray[7] = new CIMProperty("RegisteredName");
        cIMPropertyArray[7].setName("RegisteredName");
        cIMPropertyArray[7].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[7].setValue(new CIMValue((Object)"Array"));
        cIMPropertyArray[8] = new CIMProperty("RegisteredOrganization");
        cIMPropertyArray[8].setName("RegisteredOrganization");
        cIMPropertyArray[8].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(11);
        cIMPropertyArray[8].setValue(new CIMValue((Object)unsignedInt16));
        cIMPropertyArray[9] = new CIMProperty("RegisteredVersion");
        cIMPropertyArray[9].setName("RegisteredVersion");
        cIMPropertyArray[9].setType(CIMDataType.getPredefinedType((int)8));
        cIMPropertyArray[9].setValue(new CIMValue((Object)"1.0.3"));
        for (int i = 0; i < n; ++i) {
            vector.add(cIMPropertyArray[i]);
        }
        cIMInstance.setProperties(vector);
        return cIMInstance;
    }

    private CIMInstance[] get_ibmtsess_registered_sub_profile() throws Exception {
        int n = 10;
        CIMInstance[] cIMInstanceArray = new CIMInstance[n];
        for (int i = 0; i < n; ++i) {
            cIMInstanceArray[i] = new CIMInstance();
            cIMInstanceArray[i].setClassName("IBMTSESS_RegisteredSubProfile");
            cIMInstanceArray[i].setName("IBMTSESS_RegisteredSubProfile");
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            CIMProperty cIMProperty = new CIMProperty("AdvertiseTypeDescriptions");
            cIMProperty.setName("AdvertiseTypeDescriptions");
            cIMProperty.setType(CIMDataType.getPredefinedType((int)22));
            Object var6_6 = null;
            cIMProperty.setValue(new CIMValue(var6_6));
            CIMProperty cIMProperty2 = new CIMProperty("AdvertiseTypes");
            cIMProperty2.setName("AdvertiseTypes");
            cIMProperty2.setType(CIMDataType.getPredefinedType((int)16));
            Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
            vector2.add(unsignedInt16);
            cIMProperty2.setValue(new CIMValue(vector2));
            CIMProperty cIMProperty3 = new CIMProperty("InstanceID");
            cIMProperty3.setKey(true);
            cIMProperty3.setName("InstanceID");
            cIMProperty3.setType(CIMDataType.getPredefinedType((int)8));
            switch (i) {
                case 1: {
                    cIMProperty3.setValue(new CIMValue((Object)"Extra Capacity Set"));
                    break;
                }
                case 2: {
                    cIMProperty3.setValue(new CIMValue((Object)"Access Points"));
                    break;
                }
                case 3: {
                    cIMProperty3.setValue(new CIMValue((Object)"LUN Mapping and Masking"));
                    break;
                }
                case 4: {
                    cIMProperty3.setValue(new CIMValue((Object)"Disk Drive"));
                    break;
                }
                case 5: {
                    cIMProperty3.setValue(new CIMValue((Object)"Location"));
                    break;
                }
                case 6: {
                    cIMProperty3.setValue(new CIMValue((Object)"LUN Creation"));
                    break;
                }
                case 7: {
                    cIMProperty3.setValue(new CIMValue((Object)"Software"));
                    break;
                }
                case 8: {
                    cIMProperty3.setValue(new CIMValue((Object)"Pool Manipulation Capabilities and Settings"));
                    break;
                }
                case 9: {
                    cIMProperty3.setValue(new CIMValue((Object)"Copy Services"));
                    break;
                }
                case 10: {
                    cIMProperty3.setValue(new CIMValue((Object)"Extent Mapping"));
                }
            }
            CIMProperty cIMProperty4 = new CIMProperty("OtherRegisteredOrganization");
            cIMProperty4.setName("OtherRegisteredOrganization");
            cIMProperty4.setType(CIMDataType.getPredefinedType((int)8));
            cIMProperty4.setValue(new CIMValue((Object)"SNIA"));
            CIMProperty cIMProperty5 = new CIMProperty("RegisteredName");
            cIMProperty5.setName("RegisteredName");
            cIMProperty5.setType(CIMDataType.getPredefinedType((int)8));
            switch (i) {
                case 1: {
                    cIMProperty5.setValue(new CIMValue((Object)"Extra Capacity Set"));
                    break;
                }
                case 2: {
                    cIMProperty5.setValue(new CIMValue((Object)"Access Points"));
                    break;
                }
                case 3: {
                    cIMProperty5.setValue(new CIMValue((Object)"LUN Mapping and Masking"));
                    break;
                }
                case 4: {
                    cIMProperty5.setValue(new CIMValue((Object)"Disk Drive"));
                    break;
                }
                case 5: {
                    cIMProperty5.setValue(new CIMValue((Object)"Location"));
                    break;
                }
                case 6: {
                    cIMProperty5.setValue(new CIMValue((Object)"LUN Creation"));
                    break;
                }
                case 7: {
                    cIMProperty5.setValue(new CIMValue((Object)"Software"));
                    break;
                }
                case 8: {
                    cIMProperty5.setValue(new CIMValue((Object)"Pool Manipulation Capabilities and Settings"));
                    break;
                }
                case 9: {
                    cIMProperty5.setValue(new CIMValue((Object)"Copy Services"));
                    break;
                }
                case 10: {
                    cIMProperty5.setValue(new CIMValue((Object)"Extent Mapping"));
                }
            }
            CIMProperty cIMProperty6 = new CIMProperty("RegisteredOrganization");
            cIMProperty6.setName("RegisteredOrganization");
            cIMProperty6.setType(CIMDataType.getPredefinedType((int)2));
            UnsignedInt16 unsignedInt162 = new UnsignedInt16(11);
            cIMProperty6.setValue(new CIMValue((Object)unsignedInt162));
            CIMProperty cIMProperty7 = new CIMProperty("RegisteredVersion");
            cIMProperty7.setName("RegisteredVersion");
            cIMProperty7.setType(CIMDataType.getPredefinedType((int)8));
            cIMProperty7.setValue(new CIMValue((Object)"1.0.3"));
            vector.add(cIMProperty);
            vector.add(cIMProperty2);
            vector.add(cIMProperty3);
            vector.add(cIMProperty4);
            vector.add(cIMProperty5);
            vector.add(cIMProperty6);
            vector.add(cIMProperty7);
            cIMInstanceArray[i].setProperties(vector);
        }
        return cIMInstanceArray;
    }

    private CIMObjectPath getObjectPath(CIMInstance cIMInstance) throws Exception {
        CIMObjectPath cIMObjectPath = null;
        if (cIMInstance != null) {
            cIMObjectPath = cIMInstance.getObjectPath();
            cIMObjectPath.setNameSpace("/root/ibm");
        }
        return cIMObjectPath;
    }

    public static void main(String[] stringArray) {
        try {
            DS8KCIMOMDataGenerator dS8KCIMOMDataGenerator = new DS8KCIMOMDataGenerator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            Class.forName("COM.ibm.db2.jdbc.app.DB2Driver");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

