/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS8K;

import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods.DS6kExtrinsicMethods;

public class DS8KGenerator {
    private static final String ROOT_IBM_XML = "XML\\Storage\\IBM\\DS8K\\DS8K_Root_IBM.xml";
    private static final String NAMESPACE_ROOT_IBM = "/root/ibm";
    private static final String STANDARD_POOL_SIZE = "10737418240";
    private static final String STANDARD_VOL_SIZE = "1073741824";
    private String configFile = "conf/DS8K-requirement.config";

    public void generateData(String string) {
        if (null != string) {
            this.configFile = string;
        }
        DatabaseManager databaseManager = DatabaseManager.getDbManager();
        try {
            databaseManager.insert_CIMOM_INFO(1, "Sun Java WBEM CIMOM", "9.182.185.190", NAMESPACE_ROOT_IBM, "administrator", "san46pass");
            int n = databaseManager.getMaxID("SIM.CIMOM_INFO");
            databaseManager.insert_NS_INFO(n, NAMESPACE_ROOT_IBM);
            int n2 = databaseManager.getMaxID("SIM.NS_INFO");
            DeviceDataGenerator deviceDataGenerator = new DeviceDataGenerator(ROOT_IBM_XML, this.configFile);
            DataGeneratorResponse dataGeneratorResponse = deviceDataGenerator.generateData(NAMESPACE_ROOT_IBM);
            databaseManager.persistInstances(n2, dataGeneratorResponse.getInstanceMap(), deviceDataGenerator.getParserResponse().getClassMap());
            List list = DatabaseManager.getDbManager().enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSESS_StorageConfigurationService");
            Iterator iterator = list.iterator();
            CIMObjectPath cIMObjectPath = null;
            while (iterator.hasNext()) {
                cIMObjectPath = (CIMObjectPath)iterator.next();
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.configFile));
            int n3 = Integer.parseInt(properties.getProperty("NUMBER_OF_POOLS"));
            String[] stringArray = properties.getProperty("MAPPING_DISK_TO_POOL").split(" ");
            String[] stringArray2 = properties.getProperty("MAPPING_POOL_TO_VOLUME").split(" ");
            List list2 = DatabaseManager.getDbManager().enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSESS_StorageExtent");
            Iterator iterator2 = list2.iterator();
            for (int i = 0; i < n3; ++i) {
                Vector<CIMArgument> vector = new Vector<CIMArgument>();
                Vector<CIMArgument> vector2 = new Vector<CIMArgument>();
                String string2 = "pool-" + i;
                CIMArgument cIMArgument = new CIMArgument("ElementName");
                cIMArgument.setValue(new CIMValue((Object)string2, CIMDataType.getPredefinedType((int)8)));
                vector.add(cIMArgument);
                CIMArgument cIMArgument2 = new CIMArgument("Goal");
                vector.add(cIMArgument2);
                CIMArgument cIMArgument3 = new CIMArgument("InExtents");
                Vector<String> vector3 = new Vector<String>();
                for (int j = 0; j < new Integer(stringArray[i]); ++j) {
                    vector3.add(iterator2.next().toString());
                }
                cIMArgument3.setValue(new CIMValue(vector3, CIMDataType.getPredefinedType((int)22)));
                vector.add(cIMArgument3);
                CIMArgument cIMArgument4 = new CIMArgument("InPools");
                vector.add(cIMArgument4);
                CIMArgument cIMArgument5 = new CIMArgument("Pool");
                vector.add(cIMArgument5);
                UnsignedInt64 unsignedInt64 = new UnsignedInt64(STANDARD_POOL_SIZE);
                CIMArgument cIMArgument6 = new CIMArgument("Size");
                cIMArgument6.setValue(new CIMValue((Object)unsignedInt64, CIMDataType.getPredefinedType((int)6)));
                vector.add(cIMArgument6);
                CIMArgument cIMArgument7 = new CIMArgument("Job");
                vector2.add(cIMArgument7);
                vector2.add(cIMArgument5);
                vector2.add(cIMArgument6);
                CIMArgument[] cIMArgumentArray = new CIMArgument[vector.size()];
                vector.toArray(cIMArgumentArray);
                CIMArgument[] cIMArgumentArray2 = new CIMArgument[vector2.size()];
                vector2.toArray(cIMArgumentArray2);
                CIMValue cIMValue = DS6kExtrinsicMethods.createOrModifyStoragePool(cIMObjectPath, cIMArgumentArray, cIMArgumentArray2);
                if (((UnsignedInt16)cIMValue.getValue()).intValue() != 0) continue;
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMArgumentArray2[1].getValue().getValue();
                for (int j = 0; j < new Integer(stringArray2[i]); ++j) {
                    Vector<CIMArgument> vector4 = new Vector<CIMArgument>();
                    Vector<CIMArgument> vector5 = new Vector<CIMArgument>();
                    String string3 = "pool" + i + "vol" + j;
                    CIMArgument cIMArgument8 = new CIMArgument("ElementName");
                    cIMArgument8.setValue(new CIMValue((Object)string3, CIMDataType.getPredefinedType((int)8)));
                    vector4.add(cIMArgument8);
                    UnsignedInt16 unsignedInt16 = new UnsignedInt16(2);
                    CIMArgument cIMArgument9 = new CIMArgument("ElementType");
                    cIMArgument9.setValue(new CIMValue((Object)unsignedInt16, CIMDataType.getPredefinedType((int)2)));
                    vector4.add(cIMArgument9);
                    CIMArgument cIMArgument10 = new CIMArgument("Goal");
                    vector4.add(cIMArgument10);
                    CIMArgument cIMArgument11 = new CIMArgument("InPool");
                    cIMArgument11.setValue(new CIMValue((Object)cIMObjectPath2, new CIMDataType(cIMObjectPath2.getObjectName())));
                    vector4.add(cIMArgument11);
                    UnsignedInt64 unsignedInt642 = new UnsignedInt64(STANDARD_VOL_SIZE);
                    CIMArgument cIMArgument12 = new CIMArgument("Size");
                    cIMArgument12.setValue(new CIMValue((Object)unsignedInt642, CIMDataType.getPredefinedType((int)6)));
                    vector4.add(cIMArgument12);
                    CIMArgument cIMArgument13 = new CIMArgument("Job");
                    vector5.add(cIMArgument13);
                    vector5.add(cIMArgument12);
                    CIMArgument cIMArgument14 = new CIMArgument("TheElement");
                    cIMArgument14.setType(CIMDataType.getPredefinedType((int)29));
                    vector5.add(cIMArgument14);
                    CIMArgument[] cIMArgumentArray3 = new CIMArgument[vector4.size()];
                    vector4.toArray(cIMArgumentArray3);
                    CIMArgument[] cIMArgumentArray4 = new CIMArgument[vector5.size()];
                    vector5.toArray(cIMArgumentArray4);
                    DS6kExtrinsicMethods.createOrModifyElementFromStoragePool(cIMObjectPath, cIMArgumentArray3, cIMArgumentArray4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

