/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ConnectionPool {
    private static final int INITIAL_CONNECTION_POOL_SIZE = 5;
    private static List connectionList = new ArrayList();
    private static List busyConnection = new ArrayList();

    public static synchronized Connection getConnection() {
        if (connectionList.size() == 0) {
            ConnectionPool.createConnection();
        }
        Connection connection = (Connection)connectionList.remove(0);
        busyConnection.add(connection);
        return connection;
    }

    public static synchronized void closeConnection(Connection connection) {
        connectionList.add(connection);
        busyConnection.remove(connection);
    }

    private static void createConnection() {
        try {
            connectionList.add(DriverManager.getConnection("jdbc:db2:SIMDB"));
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Iterator iterator = connectionList.iterator();
        while (iterator.hasNext()) {
            ((Connection)iterator.next()).close();
        }
        iterator = busyConnection.iterator();
        while (iterator.hasNext()) {
            ((Connection)iterator.next()).close();
        }
    }

    static {
        for (int i = 0; i < 5; ++i) {
            ConnectionPool.createConnection();
        }
    }
}

