/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.simulator.cimom.common.generator.ParserRespose;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimMapping;
import org.eclipse.aperi.simulator.cimom.common.generator.SimProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimPropertyPreSuf;
import org.eclipse.aperi.simulator.cimom.common.generator.SimRandomProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimReferProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimUnitMap;
import org.eclipse.aperi.simulator.cimom.common.generator.SimValue;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ClassXMLParser
extends DefaultHandler {
    private ParserRespose response = new ParserRespose();
    private SimClass simClass;
    private SimProperty simProperty;
    private SimValue simValue;
    private SimMapping simMapping;
    private SimUnitMap simUnitMap;
    private boolean isValue = false;

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        block4: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block3: {
                                    if (!string3.equalsIgnoreCase("Class")) break block3;
                                    this.handleClass(attributes);
                                    break block4;
                                }
                                if (!string3.equalsIgnoreCase("Property")) break block5;
                                this.handleProperty(attributes);
                                break block4;
                            }
                            if (!string3.equalsIgnoreCase("Value")) break block6;
                            this.handleValue(attributes);
                            break block4;
                        }
                        if (!string3.equalsIgnoreCase("Antecedent")) break block7;
                        this.handleAntecedent(attributes);
                        break block4;
                    }
                    if (!string3.equalsIgnoreCase("Dependent")) break block8;
                    this.handleDependent(attributes);
                    break block4;
                }
                if (!string3.equalsIgnoreCase("Mapping")) break block9;
                this.simMapping = new SimMapping();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getQName(i);
                    if (!string4.equalsIgnoreCase("Type")) continue;
                    this.simMapping.setMappingType(attributes.getValue(i).trim());
                }
                break block4;
            }
            if (!string3.equalsIgnoreCase("Map")) break block4;
            this.simUnitMap = new SimUnitMap();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getQName(i);
                if (string5.equalsIgnoreCase("Antecedent")) {
                    this.simUnitMap.setAntecedentNumber(Integer.parseInt(attributes.getValue(i).trim()));
                    continue;
                }
                if (!string5.equalsIgnoreCase("Dependent")) continue;
                this.simUnitMap.setDependentNumber(Integer.parseInt(attributes.getValue(i).trim()));
            }
        }
    }

    private void handleClass(Attributes attributes) {
        this.simClass = new SimClass();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            if (string.equalsIgnoreCase("Name")) {
                this.simClass.setName(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Namespace")) {
                this.simClass.setNamespace(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("NOI")) {
                String string2 = attributes.getValue(i).trim();
                if (string2.equalsIgnoreCase("")) continue;
                this.simClass.setNumberOfInstances(Integer.parseInt(string2));
                continue;
            }
            if (string.equalsIgnoreCase("CfgExp")) {
                this.simClass.setConfExp(attributes.getValue(i).trim());
                this.simClass.setConfiguration(true);
                continue;
            }
            if (string.equalsIgnoreCase("Association")) {
                this.simClass.setAssociation(attributes.getValue(i).trim().equalsIgnoreCase("true"));
                this.simClass = new SimAssociationClass(this.simClass);
                continue;
            }
            if (!string.equalsIgnoreCase("AutoGenerate")) continue;
            this.simClass.setAutoGenerate(attributes.getValue(i).trim().equalsIgnoreCase("true"));
        }
    }

    private void handleProperty(Attributes attributes) {
        this.simProperty = new SimProperty();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            if (string.equalsIgnoreCase("Name")) {
                this.simProperty.setName(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Type")) {
                this.simProperty.setDataType(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Multiple")) {
                this.simProperty.setMultiple(true);
                continue;
            }
            if (string.equalsIgnoreCase("Key")) {
                if (!attributes.getValue(i).trim().equalsIgnoreCase("true")) continue;
                this.simProperty.setKey(true);
                continue;
            }
            if (string.equalsIgnoreCase("Random")) {
                if (!attributes.getValue(i).trim().equalsIgnoreCase("true")) continue;
                this.simProperty = new SimRandomProperty(this.simProperty);
                this.simProperty.setRandom(true);
                continue;
            }
            if (string.equalsIgnoreCase("Prefix")) {
                if (!(this.simProperty instanceof SimPropertyPreSuf)) {
                    this.simProperty = new SimPropertyPreSuf(this.simProperty);
                }
                ((SimPropertyPreSuf)this.simProperty).setPrefix(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Suffix")) {
                if (!(this.simProperty instanceof SimPropertyPreSuf)) {
                    this.simProperty = new SimPropertyPreSuf(this.simProperty);
                }
                ((SimPropertyPreSuf)this.simProperty).setSuffix(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Seperator")) {
                if (!(this.simProperty instanceof SimRandomProperty)) {
                    this.simProperty = new SimRandomProperty(this.simProperty);
                }
                ((SimRandomProperty)this.simProperty).setSeperator(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Refers")) {
                if (!(this.simProperty instanceof SimReferProperty)) {
                    this.simProperty = new SimReferProperty(this.simProperty);
                    this.simProperty.setRefer(true);
                }
                ((SimReferProperty)this.simProperty).setRefersProperty(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("External")) {
                if (!(this.simProperty instanceof SimReferProperty)) {
                    this.simProperty = new SimReferProperty(this.simProperty);
                    this.simProperty.setRefer(true);
                }
                ((SimReferProperty)this.simProperty).setExternalClassName(attributes.getValue(i).trim());
                ((SimReferProperty)this.simProperty).setExternal(true);
                continue;
            }
            if (string.equalsIgnoreCase("Incremental")) {
                if (!attributes.getValue(i).trim().equalsIgnoreCase("true")) continue;
                this.simProperty.setIncremental(1);
                continue;
            }
            if (!string.equalsIgnoreCase("Start")) continue;
            this.simProperty.setIncremental(Integer.parseInt(attributes.getValue(i).trim()));
        }
    }

    private void handleValue(Attributes attributes) {
        this.isValue = true;
        if (attributes.getLength() != 0) {
            this.simValue = new SimValue();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                if (string.equalsIgnoreCase("CfgExp")) {
                    this.simValue.setConfiguration(true);
                    this.simValue.setValue(attributes.getValue(i).trim());
                    continue;
                }
                if (string.equalsIgnoreCase("CfgProp")) {
                    this.simValue.setConfProp(true);
                    this.simValue.setValue(attributes.getValue(i).trim());
                    continue;
                }
                if (string.equalsIgnoreCase("Prefix")) {
                    this.simValue.setPrefix(attributes.getValue(i).trim());
                    continue;
                }
                if (string.equalsIgnoreCase("Suffix")) {
                    this.simValue.setSuffix(attributes.getValue(i).trim());
                    continue;
                }
                if (string.equalsIgnoreCase("External")) {
                    ((SimReferProperty)this.simProperty).setExternal(true);
                    this.simValue.setExternal(attributes.getValue(i).trim());
                    continue;
                }
                if (!string.equalsIgnoreCase("Datetime")) continue;
                this.simValue.setCurrentDate(true);
            }
        }
    }

    private void handleAntecedent(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            if (string.equalsIgnoreCase("Name")) {
                ((SimAssociationClass)this.simClass).setAntecedentName(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("ClassName")) {
                ((SimAssociationClass)this.simClass).setAntecedentClassName(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Key")) {
                if (!attributes.getValue(i).trim().equalsIgnoreCase("true")) continue;
                ((SimAssociationClass)this.simClass).setAntecedentKey(true);
                continue;
            }
            if (!string.equalsIgnoreCase("Namespace")) continue;
            ((SimAssociationClass)this.simClass).setAntecedentNS(attributes.getValue(i).trim());
        }
    }

    private void handleDependent(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            if (string.equalsIgnoreCase("Name")) {
                ((SimAssociationClass)this.simClass).setDependentName(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("ClassName")) {
                ((SimAssociationClass)this.simClass).setDependentClassName(attributes.getValue(i).trim());
                continue;
            }
            if (string.equalsIgnoreCase("Key")) {
                if (!attributes.getValue(i).trim().equalsIgnoreCase("true")) continue;
                ((SimAssociationClass)this.simClass).setDependentKey(true);
                continue;
            }
            if (!string.equalsIgnoreCase("Namespace")) continue;
            ((SimAssociationClass)this.simClass).setDependentNS(attributes.getValue(i).trim());
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string3.equalsIgnoreCase("Class")) {
            this.response.addClass(this.simClass);
        } else if (string3.equalsIgnoreCase("Property")) {
            this.simClass.addProperty(this.simProperty);
        } else if (string3.equalsIgnoreCase("Value")) {
            this.isValue = false;
            if (null != this.simValue) {
                if (this.simProperty.isMultiple()) {
                    this.simProperty.addValue(this.simValue);
                } else {
                    this.simProperty.setValue(this.simValue);
                }
                this.simValue = null;
            }
        } else if (string3.equalsIgnoreCase("Mapping")) {
            ((SimAssociationClass)this.simClass).setMapping(this.simMapping);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        if (!(string = string.trim()).equalsIgnoreCase("") && this.isValue) {
            if (null != this.simValue) {
                if (this.simValue.getValue() != null) {
                    this.simValue.setValue(this.simValue.getValue() + string);
                } else {
                    this.simValue.setValue(string);
                }
            } else if (this.simProperty.isMultiple()) {
                this.simProperty.addValue(string);
            } else if (this.simProperty.getValue() != null) {
                this.simProperty.setValue(this.simProperty.getValue() + string);
            } else {
                this.simProperty.setValue(string);
            }
        } else if (!string.equalsIgnoreCase("") && null != this.simUnitMap) {
            this.simUnitMap.setMapValue(string);
            this.simMapping.addUnitMap(this.simUnitMap);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        return super.resolveEntity(string, string2);
    }

    public ParserRespose parse(String string) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(string, (DefaultHandler)this);
        return this.response;
    }

    public static void main(String[] stringArray) throws ParserConfigurationException, SAXException, IOException {
        ClassXMLParser classXMLParser = new ClassXMLParser();
        System.out.println(classXMLParser.parse("Abc.xml"));
    }
}

