/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import org.eclipse.aperi.simulator.cimom.common.generator.ClassXMLParser;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.InstanceCreator;
import org.eclipse.aperi.simulator.cimom.common.generator.ParserRespose;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimMapping;
import org.eclipse.aperi.simulator.cimom.common.generator.SimUnitMap;

public class DeviceDataGenerator {
    private static final String NAMESPACE_CLASSNAME_SEPERATOR = ":";
    private String xmlFileName;
    private String configurationFile;
    private InstanceCreator creator;
    private Properties confProperties;
    private ParserRespose parserResponse;

    public DeviceDataGenerator(String string, String string2) {
        this.xmlFileName = string;
        this.configurationFile = string2;
        this.creator = new InstanceCreator();
        this.confProperties = new Properties();
        try {
            this.confProperties.load(new FileInputStream(this.configurationFile));
            this.creator.setConfProperties(this.confProperties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private ParserRespose initGenerator(String string) {
        try {
            ClassXMLParser classXMLParser = new ClassXMLParser();
            this.parserResponse = classXMLParser.parse(this.xmlFileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        this.creator.setNamespace(string);
        return this.parserResponse;
    }

    public DataGeneratorResponse generateData(String string) {
        DataGeneratorResponse dataGeneratorResponse = new DataGeneratorResponse();
        this.initGenerator(string);
        Iterator iterator = this.parserResponse.getClassList().iterator();
        while (iterator.hasNext()) {
            SimClass simClass = (SimClass)iterator.next();
            if (simClass.isAutoGenerate()) {
                Object object;
                if (simClass.isConfiguration()) {
                    simClass.parseConfExp(this.confProperties);
                }
                if (null != (object = !simClass.isAssociation() ? this.handleClass(dataGeneratorResponse, simClass) : this.handleAssociationClass((SimAssociationClass)simClass, dataGeneratorResponse))) {
                    this.addInstancesToResponse(dataGeneratorResponse, simClass, object);
                    continue;
                }
                dataGeneratorResponse.addRemainingClass(simClass);
                continue;
            }
            dataGeneratorResponse.addRemainingClass(simClass);
        }
        return dataGeneratorResponse;
    }

    public DataGeneratorResponse generateData(List list, DataGeneratorResponse dataGeneratorResponse) {
        Object object;
        String string;
        Object object2;
        DataGeneratorResponse dataGeneratorResponse2 = new DataGeneratorResponse();
        Iterator iterator = dataGeneratorResponse.getInstanceMap().keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            string = ((String)object2).substring(((String)object2).indexOf(58) + 1);
            object = list.iterator();
            boolean bl = true;
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (string2.indexOf(91) != -1) {
                    string2 = this.extractSimClassName(string2).getName();
                }
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            dataGeneratorResponse2.addInstances((String)object2, dataGeneratorResponse.getInstanceMap().get(object2));
        }
        object2 = list.iterator();
        while (object2.hasNext()) {
            Object object3;
            string = (String)object2.next();
            object = null;
            object = string.indexOf(91) != -1 ? this.extractSimClassName(string) : (SimClass)this.parserResponse.getClassMap().get(string);
            if (((SimClass)object).isConfiguration()) {
                ((SimClass)object).parseConfExp(this.confProperties);
            }
            if (null == (object3 = !((SimClass)object).isAssociation() ? this.handleClass(dataGeneratorResponse2, (SimClass)object) : this.handleAssociationClass((SimAssociationClass)object, dataGeneratorResponse2))) continue;
            this.addInstancesToResponse(dataGeneratorResponse2, (SimClass)object, object3);
            this.addInstancesToResponse(dataGeneratorResponse, (SimClass)object, object3);
        }
        dataGeneratorResponse2.getInstanceMap().clear();
        return dataGeneratorResponse;
    }

    private SimClass extractSimClassName(String string) {
        SimClass simClass = (SimClass)this.parserResponse.getClassMap().get(string.substring(0, string.indexOf(91)));
        String string2 = string.substring(string.indexOf(91) + 1);
        String string3 = string2.substring(0, string2.indexOf("->"));
        String string4 = string2.substring(string2.indexOf("->") + 2, string2.indexOf(93));
        if (simClass.isAssociation()) {
            ((SimAssociationClass)simClass).setAntecedentClassName(string3);
            ((SimAssociationClass)simClass).setDependentClassName(string4);
        }
        return simClass;
    }

    public Object handleClass(DataGeneratorResponse dataGeneratorResponse, SimClass simClass) {
        int n = 0;
        List list = null;
        System.out.println("Going to generate for : " + simClass.getName());
        if (simClass.getNumberOfInstances() != 0) {
            if (simClass.getNumberOfInstances() > 1) {
                list = this.creator.createInstances(simClass, dataGeneratorResponse.getInstanceMap());
                n = list.size();
            } else {
                n = 1;
                list = this.creator.createInstance(simClass, dataGeneratorResponse.getInstanceMap());
            }
        }
        System.out.println("NOI for class : " + simClass.getName() + " : " + n);
        return list;
    }

    public Object handleAssociationClass(SimAssociationClass simAssociationClass, DataGeneratorResponse dataGeneratorResponse) {
        int n = 0;
        Object v = dataGeneratorResponse.getInstanceMap().get(simAssociationClass.getNamespace() + NAMESPACE_CLASSNAME_SEPERATOR + simAssociationClass.getAntecedentClassName());
        Object v2 = dataGeneratorResponse.getInstanceMap().get(simAssociationClass.getNamespace() + NAMESPACE_CLASSNAME_SEPERATOR + simAssociationClass.getDependentClassName());
        Object object = null;
        if (null == v || null == v2) {
            n = 0;
            System.err.println("Null association class " + simAssociationClass.getName() + " with A = " + simAssociationClass.getAntecedentClassName() + " D = " + simAssociationClass.getDependentClassName());
            return object;
        }
        SimMapping simMapping = simAssociationClass.getMapping();
        object = simMapping != null ? (simMapping.getMappingType().equalsIgnoreCase("Generic") ? this.handleGenericMapping(simAssociationClass, v, v2) : (simMapping.getMappingType().equalsIgnoreCase("Custom") ? this.handleCustomMapping(simAssociationClass, v, v2) : this.handleNormalMapping(simAssociationClass, v, v2))) : this.handleNormalMapping(simAssociationClass, v, v2);
        n = object != null ? (object instanceof List ? ((List)object).size() : 1) : 0;
        System.out.println("NOI for class : " + simAssociationClass.getName() + " : " + n);
        return object;
    }

    private List handleGenericMapping(SimAssociationClass simAssociationClass, Object object, Object object2) {
        ArrayList arrayList = new ArrayList();
        SimMapping simMapping = simAssociationClass.getMapping();
        SimUnitMap simUnitMap = (SimUnitMap)simMapping.getMapList().get(0);
        if (-1 != simUnitMap.getAntecedentNumber()) {
            int n = simUnitMap.getAntecedentNumber();
            int n2 = Integer.parseInt(simUnitMap.getMapValue());
            if (object instanceof CIMInstance) {
                arrayList.addAll(this.creator.createAssociationInstances((SimClass)simAssociationClass, (CIMInstance)object, ((List)object2).subList(0, n2).toArray()));
            } else {
                int n3 = ((List)object).size();
                for (int i = 0; i < n3; i += n) {
                    arrayList.addAll(this.creator.createAssociationInstances((SimClass)simAssociationClass, (CIMInstance)((List)object).get(i), ((List)object2).subList(i * n2, (i + 1) * n2).toArray()));
                }
            }
        } else {
            int n = Integer.parseInt(simUnitMap.getMapValue());
            int n4 = simUnitMap.getDependentNumber();
            if (object2 instanceof CIMInstance) {
                arrayList.addAll(this.creator.createAssociationInstances((SimClass)simAssociationClass, ((List)object).subList(0, n).toArray(), (CIMInstance)object2));
            } else {
                int n5 = ((List)object2).size();
                for (int i = 0; i < n5; i += n4) {
                    arrayList.addAll(this.creator.createAssociationInstances((SimClass)simAssociationClass, ((List)object).subList(i * n, (i + 1) * n).toArray(), (CIMInstance)((List)object2).get(i)));
                }
            }
        }
        return arrayList;
    }

    private List handleCustomMapping(SimAssociationClass simAssociationClass, Object object, Object object2) {
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        List list = simAssociationClass.getMapping().getMapList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            List list2;
            SimUnitMap simUnitMap = (SimUnitMap)iterator.next();
            String string = simUnitMap.getMapValue();
            if (-1 != simUnitMap.getAntecedentNumber()) {
                list2 = null;
                if (string.indexOf(44) != -1) {
                    int[] nArray = this.parseMapString(string);
                    list2 = new ArrayList();
                    for (n = 0; n < nArray.length; ++n) {
                        if (nArray[n] == -1) continue;
                        list2.add(((List)object2).get(nArray[n] - 1));
                    }
                } else if (string.indexOf(45) != -1) {
                    int n2 = Integer.parseInt(string.substring(0, string.indexOf(45)));
                    n = Integer.parseInt(string.substring(string.indexOf(45) + 1));
                    list2 = ((List)object2).subList(n2 - 1, n);
                } else {
                    int n3 = Integer.parseInt(string);
                    if (object2 instanceof CIMInstance) {
                        arrayList.add(this.creator.createAssociationInstance((SimClass)simAssociationClass, (CIMInstance)((List)object).get(simUnitMap.getAntecedentNumber() - 1), (CIMInstance)object2));
                        continue;
                    }
                    if (object instanceof List) {
                        arrayList.add(this.creator.createAssociationInstance((SimClass)simAssociationClass, (CIMInstance)((List)object).get(simUnitMap.getAntecedentNumber() - 1), (CIMInstance)((List)object2).get(n3)));
                        continue;
                    }
                    arrayList.add(this.creator.createAssociationInstance((SimClass)simAssociationClass, (CIMInstance)object, (CIMInstance)((List)object2).get(n3)));
                    continue;
                }
                arrayList.addAll(this.creator.createAssociationInstances((SimClass)simAssociationClass, (CIMInstance)((List)object).get(simUnitMap.getAntecedentNumber() - 1), list2.toArray()));
                continue;
            }
            list2 = null;
            if (string.indexOf(44) != -1) {
                int[] nArray = this.parseMapString(string);
                list2 = new ArrayList();
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] == -1) continue;
                    list2.add(((List)object).get(nArray[n] - 1));
                }
            } else if (string.indexOf(45) != -1) {
                int n4 = Integer.parseInt(string.substring(0, string.indexOf(45)));
                n = Integer.parseInt(string.substring(string.indexOf(45) + 1));
                list2 = ((List)object).subList(n4 - 1, n);
            } else {
                int n5 = Integer.parseInt(string);
                arrayList.add(this.creator.createAssociationInstance((SimClass)simAssociationClass, (CIMInstance)((List)object).get(n5), (CIMInstance)((List)object2).get(simUnitMap.getDependentNumber() - 1)));
                continue;
            }
            arrayList.addAll(this.creator.createAssociationInstances((SimClass)simAssociationClass, list2.toArray(), (CIMInstance)((List)object2).get(simUnitMap.getDependentNumber() - 1)));
        }
        return arrayList;
    }

    private Object handleNormalMapping(SimAssociationClass simAssociationClass, Object object, Object object2) {
        Object object3 = object instanceof List ? (object2 instanceof List ? this.creator.createAssociationInstances((SimClass)simAssociationClass, ((List)object).toArray(), ((List)object2).toArray()) : this.creator.createAssociationInstances((SimClass)simAssociationClass, ((List)object).toArray(), (CIMInstance)object2)) : (object2 instanceof List ? this.creator.createAssociationInstances((SimClass)simAssociationClass, (CIMInstance)object, ((List)object2).toArray()) : this.creator.createAssociationInstance((SimClass)simAssociationClass, (CIMInstance)object, (CIMInstance)object2));
        return object3;
    }

    public void addInstancesToResponse(DataGeneratorResponse dataGeneratorResponse, SimClass simClass, Object object) {
        Object v = dataGeneratorResponse.getInstanceMap().get(simClass.getNamespace() + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getName());
        if (v != null) {
            if (v instanceof List) {
                if (object instanceof List) {
                    ((List)v).addAll((List)object);
                } else {
                    ((List)v).add(object);
                }
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (object instanceof List) {
                    arrayList.add(0, v);
                    arrayList.addAll((List)object);
                } else {
                    arrayList.add(object);
                    arrayList.add(v);
                }
                dataGeneratorResponse.addInstances(simClass.getNamespace() + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getName(), arrayList);
            }
        } else {
            dataGeneratorResponse.addInstances(simClass.getNamespace() + NAMESPACE_CLASSNAME_SEPERATOR + simClass.getName(), object);
        }
    }

    private int[] parseMapString(String string) {
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = !stringArray[i].trim().equalsIgnoreCase("") ? Integer.parseInt(stringArray[i]) : -1;
        }
        return nArray;
    }

    public Properties getConfProperties() {
        return this.confProperties;
    }

    public void setConfProperties(Properties properties) {
        this.confProperties = properties;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public void setXmlFileName(String string) {
        this.xmlFileName = string;
    }

    public InstanceCreator getCreator() {
        return this.creator;
    }

    public ParserRespose getParserResponse() {
        return this.parserResponse;
    }
}

