/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.eclipse.aperi.simulator.ui.RestoreDB;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class CreateDB {
    private static final String DB_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final String DROP_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 drop DB {0}";
    private static final String CREATE_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 create DB {0}";

    public int CreateDatabase() {
        boolean bl;
        String string = SetupWizardUtility.getProperty("SIMULATION_MODE");
        int n = 0;
        int n2 = this.TestDB();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            if (this.dropAndCreateDB()) {
                n = 1;
            }
        } else if (n2 == 2 && this.create()) {
            n = 1;
        }
        if (string.equals("Snapshot-based") && (bl = SetupWizardUtility.getProperty("SNAPSHOT_SIMULATION_MODE").equals("Restore Backup DB")) && this.restore()) {
            n = 2;
        }
        return n;
    }

    private boolean restore() {
        RestoreDB restoreDB = new RestoreDB();
        boolean bl = restoreDB.restore(SetupWizardUtility.getProperty("DB_NAME"), SetupWizardUtility.getProperty("BACK_UP_PATH"));
        return bl;
    }

    private boolean dropAndCreateDB() {
        boolean bl = false;
        try {
            if (this.runDBdrop()) {
                if (this.runDBCreate() && this.ConfigDB()) {
                    bl = true;
                }
            } else {
                JOptionPane.showMessageDialog(null, "Databse is currently in use!Please close any application using the database", "Databse in Use", 0);
                System.exit(0);
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    private boolean create() {
        boolean bl = false;
        try {
            if (this.runDBCreate() && this.ConfigDB()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean ConfigDB() {
        boolean bl;
        try {
            Connection connection;
            Class.forName(DB_DRIVER);
            String string = SetupWizardUtility.getProperty("DB_USER_NAME");
            String string2 = SetupWizardUtility.getProperty("DB_PASSWORD");
            if (string.equals("Default") || string2.equals("Default")) {
                String string3 = "jdbc:db2:" + SetupWizardUtility.getProperty("DB_NAME");
                System.out.println("DB URL  is" + string3);
                connection = DriverManager.getConnection(string3);
                System.out.println("Connection Successful");
            } else {
                String string4 = SetupWizardUtility.getProperty("DB_HOST_URL");
                String string5 = SetupWizardUtility.getProperty("DB_NAME");
                String string6 = "jdbc:db2://" + string4 + ":50000/" + string5;
                System.out.println("DB_URL is " + string6);
                connection = DriverManager.getConnection(string6, string, string2);
                System.out.println("Connection Successful");
            }
            System.out.println("Connection Successful in config file");
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement();
            statement = this.prepareStatement(statement);
            statement.executeBatch();
            connection.commit();
            connection.close();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    public Statement prepareStatement(Statement statement) {
        try {
            String string;
            FileReader fileReader = new FileReader("resources\\DDL_CLASSCreate.ddl");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                statement.addBatch(string);
            }
            fileReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return statement;
    }

    public boolean runDBdrop() throws Exception {
        String string = MessageFormat.format(DROP_DB_COMMAND, SetupWizardUtility.getProperty("DB_NAME"));
        System.out.println("Execute Drop databse command is " + string);
        return this.executeCommand(string) == 0;
    }

    public boolean runDBCreate() throws Exception {
        String string = MessageFormat.format(CREATE_DB_COMMAND, SetupWizardUtility.getProperty("DB_NAME"));
        System.out.println("Execute create database command is " + string);
        return this.executeCommand(string) == 0;
    }

    private int executeCommand(String string) {
        System.out.println("Command to run: " + string);
        int n = -1;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (null != (string2 = bufferedReader.readLine())) {
                System.out.println("Output: " + string2);
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (null != (string2 = bufferedReader.readLine())) {
                System.out.println("Error: " + string2);
            }
            bufferedReader.close();
            n = process.waitFor();
            System.out.println("The return value is : " + n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return n;
    }

    public int TestDB() {
        int n = 0;
        int n2 = 0;
        try {
            Class.forName(DB_DRIVER);
            String string = SetupWizardUtility.getProperty("DB_USER_NAME");
            String string2 = SetupWizardUtility.getProperty("DB_PASSWORD");
            if (string.equals("Default") || string2.equals("Default")) {
                String string3 = "jdbc:db2:" + SetupWizardUtility.getProperty("DB_NAME");
                Connection connection = DriverManager.getConnection(string3);
                System.out.println("Connection Successful");
                connection.close();
            } else {
                String string4 = SetupWizardUtility.getProperty("DB_HOST_URL");
                String string5 = SetupWizardUtility.getProperty("DB_NAME");
                String string6 = "jdbc:db2://" + string4 + ":50000/" + string5;
                System.out.println("DB_URL is " + string6);
                Connection connection = DriverManager.getConnection(string6, string, string2);
                System.out.println("Connection Successful");
                connection.close();
            }
            n = 1;
        }
        catch (Exception exception) {
            System.out.println("Databse Does Not exist!");
        }
        System.out.println("Database exist value:  " + n);
        if (n == 1) {
            int n3 = JOptionPane.showConfirmDialog(null, "The Database already exist! Do u want to replace it?", "Confirm", 0);
            n2 = n3 == 0 ? 1 : 0;
        }
        if (n == 0) {
            n2 = 2;
        }
        return n2;
    }
}

