/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.wbem.cim.CIMException;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;
import org.eclipse.aperi.simulator.ui.TestDBConnection;
import org.eclipse.aperi.simulator.ui.TestSblimCIMOMConnection;
import org.eclipse.aperi.simulator.ui.TestWbemCimomConnection;

public class InputScreens {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JButton jbBrowseDirPath;
    protected JTextField jtfdirName;
    private static final File DEFAULT_WBEM_DIR_PATH = new File("C:\\SAN_SIMULATOR");
    private static final File DEFAULT_PROPERTY_FILE_PATH = new File("C:\\SAN_SIMULATOR\\SANSimulator.Properties");
    private boolean wbemPropertiesSet;
    private String destinationPath;
    private File fileName;
    private JRadioButton jrbInterActive;
    private JRadioButton jrbNonInterActive;
    protected boolean nonInteractiveSetup;
    protected boolean interactiveSetup;
    protected boolean setupModeSet;
    protected boolean installModeClicked;
    private JRadioButton jrbSwitch;
    private JRadioButton jrbStorage;
    private JRadioButton jrbOthers;
    private JRadioButton jrbServer;
    private JComboBox jcbSwitch;
    private JComboBox jcbStorage;
    private JComboBox jcbOthers;
    private JComboBox jcbServer;
    protected boolean deviceClicked = false;
    private String[] switchTypes = new String[]{"Brocade_110.4.0", "Brocade_110.4.0a", "Cisco(Not Supported)", "McData(Not Supported)", "QLogic(Not Supported)"};
    private String[] storageTypes = new String[]{"DS4K_9.16.G0.06", "DS8K_5.1.0.40", "DS6K_5.1.0.40"};
    private String[] serverTypes = new String[]{"IBM AIX(Not Supported)", "Linux(Not Supported)", "Microsoft Windows(Not Supported)"};
    private String[] otherDevices = new String[]{"IBM Tape Library(Not Supported)", "iSCSi Device(Not Supported)"};
    private ButtonGroup jbgradioGroup;
    private boolean devicePropSet;
    private boolean switchSelected;
    private boolean storageSelected;
    private boolean othersSelected;
    private boolean serverSelected;
    private String deviceCategory;
    private String deviceType = "Not Set";
    private JTextField jtfDBName;
    private JTextField jtfDBUserId;
    private JTextField jtfDBHostUrl;
    private JPasswordField jtfDBPasswd;
    private boolean databasePropSet;
    private String dbName;
    private String dbUserId;
    private String dbPassWord;
    private String dbHostUrl;
    private JComboBox jcbSimulation_mode;
    private String[] simulationTypes = new String[]{"Snapshot-based", "Configuaration-based"};
    private String simulationMode;
    private boolean simulationModeSet;
    private JRadioButton jrbFresh;
    private JRadioButton jrbRestore;
    protected boolean snapshotSetupMode = true;
    protected boolean restoreBackupDB;
    protected boolean startFreshSnapshot;
    protected boolean snapshotModeSet;
    protected boolean setupModeClicked;
    private JButton jbBrowseDBPath;
    protected boolean dbPathSet;
    protected JTextField jtfDBPath;
    private String strdbPath;
    private String snapshot_type;
    private JTextField jtfCIMhost_url;
    private JTextField jtfCIMuid;
    private JTextField jtfCIMport;
    private JTextField jtfCIMnmspace;
    private JPasswordField jtfCIMpwd;
    private JComboBox jcbprotocols;
    private JComboBox jcbcimomTypes;
    private String[] cimomTypes = new String[]{"Sun WBEM", "SBLIM"};
    private String[] protocols = new String[]{"http", "https"};
    private String cimomHostUrl;
    private String cimomPort;
    private String cimomUid;
    private String cimomPwd;
    private String cimomNameSpace;
    private String cimomProtocol;
    private boolean cimomPropSet;
    private String cimomType;
    private JButton jbBrowseConfigFile;
    protected JTextField jtfConfigFilePath;
    private boolean configPropSet;
    private String strConfigFile;
    private File configFile;
    private JButton jbBrowsePropFile;
    protected JTextField jtfSANPropFilePath;
    private boolean nonInteractiveModeSet;
    protected static String SANPropPath;
    private File SANPropFile;

    protected JPanel setupModeChoiceScreen() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("<html><b>Please select the mode of Setup</b><br><br> Experts can choose a <b>\ufffdNon-interactive mode\ufffd</b> where user can give all the inputs through a single file.<br> It is recommended that new users choose <b>\ufffdInteractive mode\ufffd</b>.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(272);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel2.setLayout(this.layout);
        JLabel jLabel2 = new JLabel("<html><br><br></html>", 2);
        jPanel2.add(jLabel2);
        this.jrbNonInterActive = new JRadioButton("Non-interactive Mode");
        this.jrbInterActive = new JRadioButton("Interactive Mode");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbNonInterActive);
        buttonGroup.add(this.jrbInterActive);
        this.jrbInterActive.addItemListener(new InstallRadioHandler("Interactive"));
        this.jrbNonInterActive.addItemListener(new InstallRadioHandler("NonInteractive"));
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.constraints.insets.top = 40;
        this.constraints.insets.bottom = 20;
        this.constraints.insets.left = 5;
        this.addComponent(jPanel2, this.jrbInterActive, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets.top = 20;
        this.constraints.insets.left = 5;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.addComponent(jPanel2, this.jrbNonInterActive, 1, 0, 1, 1);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (this.setupModeSet) {
            if (this.nonInteractiveSetup) {
                this.jrbNonInterActive.doClick();
            } else if (this.interactiveSetup) {
                this.jrbInterActive.doClick();
            }
        }
        return jPanel;
    }

    protected JPanel sanPropertyFilePathScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Properties File Path</b><br><br>Please specify the path for Properties file you want to use<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(this.layout);
        JLabel jLabel2 = new JLabel("<html>SAN Simulator Properties File Path<html>");
        this.jtfSANPropFilePath = new JTextField(20);
        this.jtfSANPropFilePath.setText("resources" + File.separator + "SANSimulator.Properties");
        this.SANPropFile = new File("resources" + File.separator + "SANSimulator.Properties");
        this.jbBrowsePropFile = new JButton("Browse");
        this.jbBrowsePropFile.setPreferredSize(new Dimension(30, 25));
        if (this.nonInteractiveModeSet) {
            this.jtfSANPropFilePath.setText(SANPropPath);
        }
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.addComponent(jPanel2, jLabel2, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jtfSANPropFilePath, 0, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jbBrowsePropFile, 0, 2, 1, 1);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        SANPropbrowseButtonHandler sANPropbrowseButtonHandler = new SANPropbrowseButtonHandler();
        this.jbBrowsePropFile.addActionListener(sANPropbrowseButtonHandler);
        return jPanel;
    }

    protected JPanel wbemInstallPathScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html>&nbsp <b>WBEM Services Installation Path</b><br><br>Please specify the path where wbemservices directory will get installed<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(this.layout);
        JLabel jLabel2 = new JLabel("<html>Directory Path<html>");
        this.jtfdirName = new JTextField(20);
        this.jtfdirName.setText("C:\\SAN_SIMULATOR\\");
        this.jbBrowseDirPath = new JButton("Browse");
        this.jbBrowseDirPath.setPreferredSize(new Dimension(25, 25));
        if (this.wbemPropertiesSet) {
            this.jtfdirName.setText(this.destinationPath);
        }
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 13;
        this.constraints.fill = 0;
        this.addComponent(jPanel2, jLabel2, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jtfdirName, 0, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jbBrowseDirPath, 0, 2, 1, 1);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        browseButtonHandler browseButtonHandler2 = new browseButtonHandler();
        this.jbBrowseDirPath.addActionListener(browseButtonHandler2);
        return jPanel;
    }

    protected JPanel deviceSelectScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Device Selection</b><br><br>Please the device you want to simulate<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.add(new JLabel("<html><br><br><b>Device Selection Option</b><html>"));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbSwitch = new JRadioButton("Switch");
        jPanel4.add(this.jrbSwitch);
        this.jcbSwitch = new JComboBox<String>(this.switchTypes);
        this.jrbSwitch.setPreferredSize(new Dimension(75, 30));
        this.jcbSwitch.setEnabled(false);
        this.jcbSwitch.setPreferredSize(new Dimension(130, 20));
        jPanel4.add(this.jcbSwitch);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbStorage = new JRadioButton("Storage");
        this.jrbStorage.setPreferredSize(new Dimension(75, 30));
        jPanel5.add(this.jrbStorage);
        this.jcbStorage = new JComboBox<String>(this.storageTypes);
        this.jcbStorage.setEnabled(false);
        this.jcbStorage.setPreferredSize(new Dimension(130, 20));
        jPanel5.add(this.jcbStorage);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbServer = new JRadioButton("Server");
        this.jrbServer.setPreferredSize(new Dimension(75, 30));
        jPanel6.add(this.jrbServer);
        this.jcbServer = new JComboBox<String>(this.serverTypes);
        this.jcbServer.setEnabled(false);
        this.jcbServer.setPreferredSize(new Dimension(130, 20));
        jPanel6.add(this.jcbServer);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbOthers = new JRadioButton("Others");
        this.jrbOthers.setPreferredSize(new Dimension(75, 30));
        jPanel7.add(this.jrbOthers);
        this.jcbOthers = new JComboBox<String>(this.otherDevices);
        this.jcbOthers.setEnabled(false);
        this.jcbOthers.setPreferredSize(new Dimension(130, 20));
        jPanel7.add(this.jcbOthers);
        jPanel2.add(jPanel7);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.jbgradioGroup = new ButtonGroup();
        this.jbgradioGroup.add(this.jrbSwitch);
        this.jbgradioGroup.add(this.jrbStorage);
        this.jbgradioGroup.add(this.jrbServer);
        this.jbgradioGroup.add(this.jrbOthers);
        this.jrbSwitch.addItemListener(new RadioButtonHandler("Switch"));
        this.jrbStorage.addItemListener(new RadioButtonHandler("Storage"));
        this.jrbServer.addItemListener(new RadioButtonHandler("Server"));
        this.jrbOthers.addItemListener(new RadioButtonHandler("Others"));
        this.jcbSwitch.addItemListener(new DeviceTypeHandler());
        this.jcbStorage.addItemListener(new DeviceTypeHandler());
        this.jcbOthers.addItemListener(new DeviceTypeHandler());
        this.jcbServer.addItemListener(new DeviceTypeHandler());
        if (this.devicePropSet) {
            if (this.switchSelected) {
                this.jrbSwitch.doClick();
                this.jcbSwitch.setSelectedItem(this.deviceType);
            }
            if (this.storageSelected) {
                this.jrbStorage.doClick();
                this.jcbStorage.setSelectedItem(this.deviceType);
            }
            if (this.serverSelected) {
                this.jrbServer.doClick();
                this.jcbServer.setSelectedItem(this.deviceType);
            }
            if (this.othersSelected) {
                this.jrbOthers.doClick();
                this.jcbOthers.setSelectedItem(this.deviceType);
            }
        }
        return jPanel;
    }

    protected JPanel dbInfoScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Enter the database details</b><br><br><br> If the database of the specified name exists, it will be dropped and recreated.<br>You can test the connection to the database using <b>\ufffdTest DB2 Connection\ufffd</b> button.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(295);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel2 = new JLabel("Databse name");
        jPanel3.add(jLabel2);
        jLabel2.setPreferredSize(new Dimension(75, 20));
        this.jtfDBName = new JTextField(10);
        this.jtfDBName.setPreferredSize(new Dimension(100, 20));
        this.jtfDBName.setText("SIMDB");
        jPanel3.add(this.jtfDBName);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel3 = new JLabel("User ID");
        jLabel3.setPreferredSize(new Dimension(75, 10));
        jPanel4.add(jLabel3);
        this.jtfDBUserId = new JTextField(10);
        this.jtfDBUserId.setPreferredSize(new Dimension(100, 20));
        this.jtfDBUserId.setText("Default");
        jPanel4.add(this.jtfDBUserId);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel4 = new JLabel("Password");
        jPanel5.add(jLabel4);
        jLabel4.setPreferredSize(new Dimension(75, 10));
        this.jtfDBPasswd = new JPasswordField(8);
        this.jtfDBPasswd.setPreferredSize(new Dimension(100, 20));
        jPanel5.add(this.jtfDBPasswd);
        jPanel2.add(jPanel5);
        this.jtfDBPasswd.setText("Default");
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel5 = new JLabel("Host URL");
        jLabel5.setPreferredSize(new Dimension(75, 10));
        jPanel6.add(jLabel5);
        this.jtfDBHostUrl = new JTextField(10);
        this.jtfDBHostUrl.setText("localhost");
        this.jtfDBHostUrl.setEditable(false);
        this.jtfDBHostUrl.setPreferredSize(new Dimension(100, 20));
        jPanel6.add(this.jtfDBHostUrl);
        jPanel2.add(jPanel6);
        JButton jButton = new JButton("Test DB Connection");
        jButton.addActionListener(new TestDB());
        jPanel2.add((Component)jButton, "Center");
        if (this.databasePropSet) {
            this.jtfDBName.setText(this.dbName);
            this.jtfDBUserId.setText(this.dbUserId);
            this.jtfDBPasswd.setText(this.dbPassWord);
            this.jtfDBHostUrl.setText(this.dbHostUrl);
        }
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected boolean ModeSelectedSet() {
        return this.installModeClicked;
    }

    protected boolean PropFileSet() {
        return !this.jtfSANPropFilePath.getText().equals("");
    }

    protected boolean DeviceSelected() {
        return this.deviceClicked;
    }

    protected boolean WBEMPathSet() {
        return !this.jtfdirName.getText().equals("");
    }

    protected boolean snapshotModeSet() {
        return this.setupModeClicked;
    }

    protected boolean configPathSet() {
        return !this.jtfConfigFilePath.getText().equals("");
    }

    protected boolean backupFilePathSet() {
        return !this.jtfDBPath.getText().equals("");
    }

    protected JPanel simulationModeSelectScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Please select the method of simulation</b><br><br> Snapshot based method requires details of the live CIMOM of selected device to take the snapshot.<br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(292);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel2 = new JLabel("<html><br><br><br></html>", 2);
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(new JLabel("<html>Select Option&nbsp&nbsp&nbsp<br><html>"));
        this.jcbSimulation_mode = new JComboBox<String>(this.simulationTypes);
        jPanel3.add(this.jcbSimulation_mode);
        jPanel2.add(jPanel3);
        JLabel jLabel3 = new JLabel("<html><br><br><br></html>", 2);
        jPanel2.add(jLabel3);
        this.jcbSimulation_mode.addItemListener(new SimulationModeHandler());
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.add(jPanel2);
        jPanel.add((Component)jPanel4, "Center");
        if (this.simulationModeSet) {
            this.jcbSimulation_mode.setSelectedItem(this.simulationMode);
        }
        return jPanel;
    }

    protected JPanel snapshotModeSelectScreen() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("<html><b>Choose appropriate option for your snapshot</b><br><br> You can choose 'Restore Snapshot Backup' if you already have snapshot image of the device you want to simulate. Otherwise you can take a new snapshot by choosing 'Start Fresh Snapshot'</b>.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(this.layout);
        JLabel jLabel2 = new JLabel("<html><br><br></html>", 2);
        jPanel2.add(jLabel2);
        this.jrbRestore = new JRadioButton("Restore Snapshot Backup");
        this.jrbFresh = new JRadioButton("Start Fresh Snapshot");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbRestore);
        buttonGroup.add(this.jrbFresh);
        this.jrbRestore.addItemListener(new SnapshotRadioHandler("Restore"));
        this.jrbFresh.addItemListener(new SnapshotRadioHandler("Fresh"));
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.constraints.insets.top = 40;
        this.constraints.insets.bottom = 20;
        this.constraints.insets.left = 5;
        this.addComponent(jPanel2, this.jrbRestore, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets.top = 20;
        this.constraints.insets.left = 5;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.addComponent(jPanel2, this.jrbFresh, 1, 0, 1, 1);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (this.snapshotModeSet) {
            if (this.restoreBackupDB) {
                this.jrbRestore.doClick();
            } else if (this.startFreshSnapshot) {
                this.jrbFresh.doClick();
            }
        }
        return jPanel;
    }

    protected JPanel snapshotCIMOMInfoScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Enter the live CIMOM information</b><br><br> You can test the connection to the CIMOM using the \ufffdTest CIMOM Connect\ufffd button.<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel2 = new JLabel("Host URL");
        jLabel2.setPreferredSize(new Dimension(100, 10));
        jPanel3.add(jLabel2);
        this.jtfCIMhost_url = new JTextField(10);
        jPanel3.add(this.jtfCIMhost_url);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel3 = new JLabel("Port");
        jLabel3.setPreferredSize(new Dimension(100, 10));
        jPanel4.add(jLabel3);
        this.jtfCIMport = new JTextField(10);
        this.jtfCIMport.setPreferredSize(new Dimension(100, 20));
        jPanel4.add(this.jtfCIMport);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel4 = new JLabel("User Name");
        jLabel4.setPreferredSize(new Dimension(100, 10));
        jPanel5.add(jLabel4);
        this.jtfCIMuid = new JTextField(10);
        this.jtfCIMuid.setPreferredSize(new Dimension(100, 20));
        jPanel5.add(this.jtfCIMuid);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel5 = new JLabel("Password");
        jLabel5.setPreferredSize(new Dimension(100, 10));
        jPanel6.add(jLabel5);
        this.jtfCIMpwd = new JPasswordField(8);
        this.jtfCIMpwd.setPreferredSize(new Dimension(100, 20));
        jPanel6.add(this.jtfCIMpwd);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel6 = new JLabel("Interop Namespace");
        jLabel6.setPreferredSize(new Dimension(100, 10));
        jPanel7.add(jLabel6);
        this.jtfCIMnmspace = new JTextField(10);
        this.jtfCIMnmspace.setPreferredSize(new Dimension(100, 20));
        jPanel7.add(this.jtfCIMnmspace);
        jPanel2.add(jPanel7);
        JPanel jPanel8 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel7 = new JLabel("Protocol");
        jLabel7.setPreferredSize(new Dimension(100, 10));
        jPanel8.add(jLabel7);
        this.jcbprotocols = new JComboBox<String>(this.protocols);
        this.jcbprotocols.setPreferredSize(new Dimension(100, 20));
        jPanel8.add(this.jcbprotocols);
        jPanel2.add(jPanel8);
        JPanel jPanel9 = new JPanel(new FlowLayout(0, 5, 3));
        JLabel jLabel8 = new JLabel("Cimom Type");
        jPanel9.add(jLabel8);
        jLabel8.setPreferredSize(new Dimension(100, 10));
        this.jcbcimomTypes = new JComboBox<String>(this.cimomTypes);
        this.jcbcimomTypes.setPreferredSize(new Dimension(100, 20));
        jPanel9.add(this.jcbcimomTypes);
        jPanel2.add(jPanel9);
        JButton jButton = new JButton("Test CIMOM Connection");
        jButton.addActionListener(new TestCIMOM());
        jPanel2.add((Component)jButton, "Center");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (this.cimomPropSet) {
            this.jtfCIMhost_url.setText(this.cimomHostUrl);
            this.jtfCIMport.setText(this.cimomPort);
            this.jtfCIMuid.setText(this.cimomUid);
            this.jtfCIMpwd.setText(this.cimomPort);
            this.jtfCIMnmspace.setText(this.cimomNameSpace);
            this.jcbprotocols.setSelectedItem(this.cimomProtocol);
            this.jcbcimomTypes.setSelectedItem(this.cimomType);
        }
        return jPanel;
    }

    protected JPanel backupDBInfoScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Enter Snapshot Backup Location</b><br><br>Please specify the path where you have your snapshot image stored. If your database name is SIMDB, enter the path of parent directory of SIMDB.0<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(new JLabel("<html><br><br><br>Snapshot Backup Path&nbsp&nbsp<br><br><br><br><html>"));
        this.jtfDBPath = new JTextField(20);
        jPanel3.add(this.jtfDBPath);
        this.jbBrowseDBPath = new JButton("Browse");
        jPanel3.add(this.jbBrowseDBPath);
        jPanel2.add(jPanel3);
        if (this.dbPathSet) {
            this.jtfDBPath.setText(this.strdbPath);
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel2);
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setSize(100, 100);
        jPanel.add((Component)jPanel4, "Center");
        DBPathbrowseButtonHandler dBPathbrowseButtonHandler = new DBPathbrowseButtonHandler();
        this.jbBrowseDBPath.addActionListener(dBPathbrowseButtonHandler);
        return jPanel;
    }

    protected boolean checkCimomPropset() {
        if (this.jtfCIMhost_url.getText().equals("")) {
            return false;
        }
        if (this.jtfCIMuid.getText().equals("") || new String(this.jtfCIMpwd.getPassword()).equals("")) {
            return false;
        }
        return !this.jtfCIMport.getText().equals("") && !this.jtfCIMnmspace.getText().equals("");
    }

    protected boolean checkSimulationMode() {
        if (this.jcbSimulation_mode.getSelectedItem().equals("Snapshot-based")) {
            return true;
        }
        JOptionPane.showMessageDialog(null, "Sorry !Only Snapshot-based Simulation supported!", "SimulationMode Error", 1);
        return false;
    }

    protected JPanel configInfoScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Configuration-based Simulation</b><br><br>Please specify the path of Configuration File<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(110);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(new JLabel("<html><br><br><br>Configuration File Path&nbsp&nbsp<br><br><br><br><html>"));
        this.jtfConfigFilePath = new JTextField(20);
        jPanel3.add(this.jtfConfigFilePath);
        this.jtfConfigFilePath.setText("conf\\DS4K-requirement.config");
        this.jbBrowseConfigFile = new JButton("Browse");
        jPanel3.add(this.jbBrowseConfigFile);
        jPanel2.add(jPanel3);
        if (this.configPropSet) {
            this.jtfConfigFilePath.setText(this.strConfigFile);
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel2);
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setSize(100, 100);
        jPanel.add((Component)jPanel4, "Center");
        ConfigbrowseButtonHandler configbrowseButtonHandler = new ConfigbrowseButtonHandler();
        this.jbBrowseConfigFile.addActionListener(configbrowseButtonHandler);
        return jPanel;
    }

    protected JPanel SimulationModeScreen() {
        if (this.snapshotSetupMode) {
            return this.snapshotModeSelectScreen();
        }
        return this.configInfoScreen();
    }

    protected JPanel setupConfirmScreen() {
        try {
            SetupWizardUtility.loadProperties(this.interactiveSetup);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Confirm Installation Parameters<br><br> </b>Please confirmed the installation parameters and click <b>Install</b> to proceed<br><br><br></html", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(200);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.add(new JLabel("WBEM Installation Path:      " + SetupWizardUtility.getProperty("WBEM_INSTALL_PATH")));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel4.add(new JLabel("Database Name:                  \t" + SetupWizardUtility.getProperty("DB_NAME")));
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel5.add(new JLabel("Database URL:              \t       " + SetupWizardUtility.getProperty("DB_HOST_URL")));
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel6.add(new JLabel("Simulation Mode:                  " + SetupWizardUtility.getProperty("SIMULATION_MODE")));
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel7.add(new JLabel("Host IP  for CIMOM:            " + SetupWizardUtility.getProperty("CIMOM_HOST_URL")));
        JPanel jPanel8 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel8.add(new JLabel("Port:                                     " + SetupWizardUtility.getProperty("CIMOM_PORT")));
        JPanel jPanel9 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel9.add(new JLabel("Namespace:                  \t\t\t\t\t       " + SetupWizardUtility.getProperty("CIMOM_NAMESPACE")));
        JPanel jPanel10 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel10.add(new JLabel("Protocol:                               " + SetupWizardUtility.getProperty("CIMOM_PROTOCOL")));
        JPanel jPanel11 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel11.add(new JLabel("Device to Simulate:               " + SetupWizardUtility.getProperty("DEVICE_CATEGORY") + "->" + SetupWizardUtility.getProperty("DEVICE_TYPE")));
        JPanel jPanel12 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel12.add(new JLabel("Configuration FilePath:        " + SetupWizardUtility.getProperty("CONFIG_FILE_PATH")));
        JPanel jPanel13 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel13.add(new JLabel("CIMOM Type:                       " + SetupWizardUtility.getProperty("CIMOM_TYPE")));
        JPanel jPanel14 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel14.add(new JLabel("Snapshot Type:                    " + SetupWizardUtility.getProperty("SNAPSHOT_SIMULATION_MODE")));
        JPanel jPanel15 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel15.add(new JLabel("Backup DB Path:                   " + SetupWizardUtility.getProperty("BACK_UP_PATH")));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel2.add(jPanel11);
        jPanel2.add(jPanel6);
        if (SetupWizardUtility.getProperty("SIMULATION_MODE").equals("Snapshot-based")) {
            jPanel2.add(jPanel14);
            if (SetupWizardUtility.getProperty("SNAPSHOT_SIMULATION_MODE").equals("Restore Backup DB")) {
                jPanel2.add(jPanel15);
            } else {
                jPanel2.add(jPanel7);
                jPanel2.add(jPanel8);
                jPanel2.add(jPanel9);
                jPanel2.add(jPanel10);
                jPanel2.add(jPanel13);
            }
        } else {
            jPanel2.add(jPanel12);
        }
        JPanel jPanel16 = new JPanel();
        jPanel16.add(jPanel2);
        jPanel16.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel16, "Center");
        return jPanel;
    }

    protected void saveDbProperties() {
        this.dbName = this.jtfDBName.getText();
        this.dbPassWord = new String(this.jtfDBPasswd.getPassword()).equals("") ? "Default" : new String(this.jtfDBPasswd.getPassword());
        this.dbUserId = this.jtfDBUserId.getText().equals("") ? "Default" : this.jtfDBUserId.getText();
        this.dbHostUrl = this.jtfDBHostUrl.getText();
        this.databasePropSet = true;
    }

    protected void saveDeviceProperties() {
        this.devicePropSet = true;
        if (this.switchSelected) {
            this.deviceType = (String)this.jcbSwitch.getSelectedItem();
            this.deviceCategory = "Switch";
        }
        if (this.storageSelected) {
            this.deviceType = (String)this.jcbStorage.getSelectedItem();
            this.deviceCategory = "Storage";
        }
        if (this.othersSelected) {
            this.deviceType = (String)this.jcbOthers.getSelectedItem();
            this.deviceCategory = "Others";
        }
    }

    protected void saveSModeProperties() {
        this.simulationMode = this.jcbSimulation_mode.getSelectedItem().toString();
        this.simulationModeSet = true;
    }

    protected void saveSnapshotModeProperties() {
        this.snapshotModeSet = true;
        if (this.restoreBackupDB) {
            this.startFreshSnapshot = false;
            this.snapshot_type = "Restore Backup DB";
        } else if (this.startFreshSnapshot) {
            this.snapshot_type = "Fresh Snapshot";
            this.restoreBackupDB = false;
        }
    }

    protected void saveSnapshotProperties() {
        this.cimomHostUrl = this.jtfCIMhost_url.getText();
        this.cimomPort = this.jtfCIMport.getText();
        this.cimomUid = this.jtfCIMuid.getText();
        this.cimomPwd = new String(this.jtfCIMpwd.getPassword());
        this.cimomNameSpace = this.jtfCIMnmspace.getText();
        this.cimomProtocol = this.jcbprotocols.getSelectedItem().toString();
        this.cimomType = this.jcbcimomTypes.getSelectedItem().toString();
        this.cimomPropSet = true;
    }

    protected void saveDBPathProperties() {
        this.dbPathSet = true;
        this.strdbPath = this.jtfDBPath.getText();
    }

    protected void saveInstallMode() {
        this.setupModeSet = true;
        if (this.nonInteractiveSetup) {
            this.interactiveSetup = false;
        } else if (this.interactiveSetup) {
            this.nonInteractiveSetup = false;
        }
    }

    protected void saveProperties() {
        SetupWizardUtility.setProperty("WBEM_INSTALL_PATH", this.destinationPath);
        SetupWizardUtility.setProperty("DEVICE_CATEGORY", this.deviceCategory);
        SetupWizardUtility.setProperty("DEVICE_TYPE", this.deviceType);
        SetupWizardUtility.setProperty("DB_NAME", this.dbName);
        SetupWizardUtility.setProperty("DB_USER_NAME", this.dbUserId);
        SetupWizardUtility.setProperty("DB_PASSWORD", this.dbPassWord);
        SetupWizardUtility.setProperty("DB_HOST_URL", this.dbHostUrl);
        SetupWizardUtility.setProperty("SIMULATION_MODE", this.simulationMode);
        if (this.snapshotSetupMode && this.startFreshSnapshot) {
            SetupWizardUtility.setProperty("SNAPSHOT_SIMULATION_MODE", this.snapshot_type);
            SetupWizardUtility.setProperty("CIMOM_HOST_URL", this.cimomHostUrl);
            SetupWizardUtility.setProperty("CIMOM_PORT", this.cimomPort);
            SetupWizardUtility.setProperty("CIMOM_USER_ID", this.cimomUid);
            SetupWizardUtility.setProperty("CIMOM_PASSWORD", this.cimomPwd);
            SetupWizardUtility.setProperty("CIMOM_NAMESPACE", this.cimomNameSpace);
            SetupWizardUtility.setProperty("CIMOM_PROTOCOL", this.cimomProtocol);
            SetupWizardUtility.setProperty("CIMOM_TYPE", this.cimomType);
        } else if (this.snapshotSetupMode && this.restoreBackupDB) {
            SetupWizardUtility.setProperty("SNAPSHOT_SIMULATION_MODE", this.snapshot_type);
            SetupWizardUtility.setProperty("BACK_UP_PATH", this.strdbPath);
        } else {
            SetupWizardUtility.setProperty("CONFIG_FILE_PATH", this.strConfigFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    protected void saveDirPath() {
        this.destinationPath = this.jtfdirName.getText();
        this.wbemPropertiesSet = true;
    }

    protected void saveConfigProp() {
        this.strConfigFile = this.jtfConfigFilePath.getText();
        this.configPropSet = true;
    }

    protected void saveSANPathProp() {
        SANPropPath = this.SANPropFile.toString();
        this.nonInteractiveModeSet = true;
    }

    private File opendir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this.deviceSelectScreen());
        if (n == 1) {
            return DEFAULT_WBEM_DIR_PATH;
        }
        this.fileName = jFileChooser.getSelectedFile();
        return this.fileName;
    }

    private File openfile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this.deviceSelectScreen());
        if (n == 1) {
            return DEFAULT_PROPERTY_FILE_PATH;
        }
        this.configFile = jFileChooser.getSelectedFile();
        return this.configFile;
    }

    private void addComponent(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n2;
        this.constraints.gridy = n;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.layout.setConstraints(component, this.constraints);
        jPanel.add(component);
    }

    private class RadioButtonHandler
    implements ItemListener {
        private String jrbt;

        public RadioButtonHandler(String string) {
            this.jrbt = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            InputScreens.this.deviceClicked = true;
            if (this.jrbt.equals("Switch")) {
                InputScreens.this.switchSelected = true;
                InputScreens.this.storageSelected = false;
                InputScreens.this.othersSelected = false;
                InputScreens.this.serverSelected = false;
                InputScreens.this.jcbServer.setEnabled(false);
                InputScreens.this.jcbSwitch.setEnabled(true);
                InputScreens.this.jcbStorage.setEnabled(false);
                InputScreens.this.jcbOthers.setEnabled(false);
                if (InputScreens.this.deviceType.equalsIgnoreCase("Not Set")) {
                    InputScreens.this.deviceType = "Brocade_110.4.0";
                }
            }
            if (this.jrbt.equals("Storage")) {
                InputScreens.this.switchSelected = false;
                InputScreens.this.storageSelected = true;
                InputScreens.this.othersSelected = false;
                InputScreens.this.serverSelected = false;
                InputScreens.this.jcbServer.setEnabled(false);
                InputScreens.this.jcbSwitch.setEnabled(false);
                InputScreens.this.jcbStorage.setEnabled(true);
                InputScreens.this.jcbOthers.setEnabled(false);
                if (InputScreens.this.deviceType.equalsIgnoreCase("Not Set")) {
                    InputScreens.this.deviceType = "DS4K_9.16.G0.06";
                }
            }
            if (this.jrbt.equals("Others")) {
                InputScreens.this.switchSelected = false;
                InputScreens.this.storageSelected = false;
                InputScreens.this.othersSelected = true;
                InputScreens.this.serverSelected = false;
                InputScreens.this.jcbServer.setEnabled(false);
                InputScreens.this.jcbSwitch.setEnabled(false);
                InputScreens.this.jcbStorage.setEnabled(false);
                InputScreens.this.jcbOthers.setEnabled(true);
                InputScreens.this.deviceType = "Not Supported";
            }
            if (this.jrbt.equals("Server")) {
                InputScreens.this.switchSelected = false;
                InputScreens.this.storageSelected = false;
                InputScreens.this.othersSelected = false;
                InputScreens.this.serverSelected = true;
                InputScreens.this.jcbSwitch.setEnabled(false);
                InputScreens.this.jcbStorage.setEnabled(false);
                InputScreens.this.jcbOthers.setEnabled(false);
                InputScreens.this.jcbServer.setEnabled(true);
                InputScreens.this.deviceType = "Not Supported";
            }
        }
    }

    private class SnapshotRadioHandler
    implements ItemListener {
        private String SnapshotMode;

        public SnapshotRadioHandler(String string) {
            this.SnapshotMode = string;
            System.out.println("Snapshot Mode" + string);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            InputScreens.this.setupModeClicked = true;
            if (this.SnapshotMode.equals("Restore")) {
                InputScreens.this.restoreBackupDB = true;
                InputScreens.this.startFreshSnapshot = false;
            } else if (this.SnapshotMode.equals("Fresh")) {
                InputScreens.this.restoreBackupDB = false;
                InputScreens.this.startFreshSnapshot = true;
            }
        }
    }

    private class InstallRadioHandler
    implements ItemListener {
        private String InstallMode;

        public InstallRadioHandler(String string) {
            this.InstallMode = string;
            System.out.println("Installation Mode" + string);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            InputScreens.this.installModeClicked = true;
            if (this.InstallMode.equals("NonInteractive")) {
                InputScreens.this.nonInteractiveSetup = true;
                InputScreens.this.interactiveSetup = false;
            } else if (this.InstallMode.equals("Interactive")) {
                InputScreens.this.nonInteractiveSetup = false;
                InputScreens.this.interactiveSetup = true;
            }
        }
    }

    private class DeviceTypeHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                System.out.println("Hello device type is " + itemEvent.getItem().toString());
                if (itemEvent.getItem() == "Brocade_110.4.0") {
                    InputScreens.this.deviceType = itemEvent.getItem().toString();
                    System.out.println("Device Type " + InputScreens.this.deviceType);
                } else if (itemEvent.getItem() == "Brocade_110.4.0a") {
                    InputScreens.this.deviceType = itemEvent.getItem().toString();
                    System.out.println("Device Type " + InputScreens.this.deviceType);
                } else if (itemEvent.getItem() == "DS4K_9.16.G0.06") {
                    InputScreens.this.deviceType = itemEvent.getItem().toString();
                    System.out.println("Device Type " + InputScreens.this.deviceType);
                } else if (itemEvent.getItem() == "DS6K_5.1.0.40") {
                    InputScreens.this.deviceType = itemEvent.getItem().toString();
                    System.out.println("Device Type  " + InputScreens.this.deviceType);
                } else if (itemEvent.getItem() == "DS8K_5.1.0.40") {
                    InputScreens.this.deviceType = itemEvent.getItem().toString();
                    System.out.println("Device Type  " + InputScreens.this.deviceType);
                } else {
                    InputScreens.this.deviceType = "Not Sopported";
                }
            }
        }
    }

    private class SimulationModeHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItem() == "Configuaration-based") {
                System.out.println("Simulation Mode" + itemEvent.getItem());
                InputScreens.this.snapshotSetupMode = false;
                System.out.println(InputScreens.this.snapshotSetupMode);
            } else {
                System.out.println("Simulation Mode" + itemEvent.getItem());
                InputScreens.this.snapshotSetupMode = true;
                System.out.println(InputScreens.this.snapshotSetupMode);
            }
        }
    }

    private class TestDB
    implements ActionListener {
        private String hosturl;
        private String userid;
        private String dbname;
        private String password;

        private TestDB() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TestDBConnection testDBConnection = new TestDBConnection();
            this.dbname = InputScreens.this.jtfDBName.getText();
            this.password = new String(InputScreens.this.jtfDBPasswd.getPassword()).equals("") ? "Default" : new String(InputScreens.this.jtfDBPasswd.getPassword());
            this.userid = InputScreens.this.jtfDBUserId.getText().equals("") ? "Default" : InputScreens.this.jtfDBUserId.getText();
            this.hosturl = InputScreens.this.jtfDBHostUrl.getText();
            System.out.println(this.dbname + "  " + this.password + "   " + this.userid + "  " + this.hosturl);
            int n = testDBConnection.testConnection(this.dbname, this.userid, this.password, this.hosturl);
            if (n == 1) {
                JOptionPane.showMessageDialog(null, "Database Connection successful", "Test DB Conncetion", 1);
            } else {
                JOptionPane.showMessageDialog(null, "Databse Conncetion failed", "Test DB Conncetion", 0);
            }
        }
    }

    private class TestCIMOM
    implements ActionListener {
        private String cimomurl;
        private String cimomuserid;
        private String cimompasswd;
        private String cimomnmspace;
        private String cimomprotocol;
        private String cimomport;

        private TestCIMOM() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            this.cimomurl = InputScreens.this.jtfCIMhost_url.getText();
            this.cimomport = InputScreens.this.jtfCIMport.getText();
            this.cimomuserid = InputScreens.this.jtfCIMuid.getText();
            this.cimompasswd = new String(InputScreens.this.jtfCIMpwd.getPassword());
            this.cimomnmspace = InputScreens.this.jtfCIMnmspace.getText();
            this.cimomprotocol = InputScreens.this.jcbprotocols.getSelectedItem().toString();
            InputScreens.this.cimomType = InputScreens.this.jcbcimomTypes.getSelectedItem().toString();
            System.out.println("URL " + this.cimomurl + " port " + this.cimomport + " userid " + this.cimomuserid + " password " + this.cimompasswd + " Namespace " + this.cimomnmspace + " Protocol " + this.cimomprotocol);
            if (InputScreens.this.cimomType.equals("Sun WBEM")) {
                TestWbemCimomConnection testWbemCimomConnection = new TestWbemCimomConnection();
                System.out.println("In Sun WBEM");
                try {
                    n = testWbemCimomConnection.testConnection(this.cimomurl, this.cimomport, this.cimomuserid, this.cimompasswd, this.cimomnmspace, this.cimomprotocol);
                }
                catch (CIMException cIMException) {
                    cIMException.printStackTrace();
                }
            } else {
                TestSblimCIMOMConnection testSblimCIMOMConnection = new TestSblimCIMOMConnection();
                System.out.println("In SBLIM");
                n = testSblimCIMOMConnection.testConnection(this.cimomurl, this.cimomport, this.cimomuserid, this.cimompasswd, this.cimomnmspace, this.cimomprotocol);
            }
            if (n == 1) {
                JOptionPane.showMessageDialog(null, "Connection Successful !", "Test CIMOM Connection", 1);
                System.out.println("Connection Successful ! ");
            } else if (n == 0) {
                JOptionPane.showMessageDialog(null, "Connection Refused !", "Test CIMOM Connection", 0);
                System.out.println("Connection Refused ! ");
            }
        }
    }

    private class SANPropbrowseButtonHandler
    implements ActionListener {
        private SANPropbrowseButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputScreens.this.SANPropFile = InputScreens.this.openfile();
            InputScreens.this.jtfSANPropFilePath.setText(InputScreens.this.SANPropFile.toString());
        }
    }

    private class ConfigbrowseButtonHandler
    implements ActionListener {
        private ConfigbrowseButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputScreens.this.jtfConfigFilePath.setText(InputScreens.this.openfile().toString());
        }
    }

    private class DBPathbrowseButtonHandler
    implements ActionListener {
        private DBPathbrowseButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputScreens.this.jtfDBPath.setText(InputScreens.this.opendir().toString());
        }
    }

    private class browseButtonHandler
    implements ActionListener {
        private browseButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputScreens.this.jtfdirName.setText(InputScreens.this.opendir().toString());
        }
    }
}

