/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.simulator.ui.ButtonsPanel;
import org.eclipse.aperi.simulator.ui.InputScreens;
import org.eclipse.aperi.simulator.ui.SetupProcess;

public class MainScreen
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Container container = this.getContentPane();
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    int curPosScreen = 1;
    private JPanel inputPanel;
    private InputScreens screenObj = new InputScreens();
    private SetupProcess instProc = new SetupProcess();
    private JPanel jpMain = new JPanel(new BorderLayout());
    private ButtonsPanel jpButton = new ButtonsPanel();

    public MainScreen() {
        super("SAN Simulator Setup Wizard");
        this.setDefaultCloseOperation(3);
        this.showSetupPanel();
    }

    private JPanel getScreen() {
        if (this.curPosScreen == 1) {
            this.jpButton.setBackVisible(false);
            this.jpButton.setNextVisible(true);
            return this.screenObj.setupModeChoiceScreen();
        }
        if (this.curPosScreen == 2) {
            this.screenObj.saveInstallMode();
            if (this.screenObj.nonInteractiveSetup) {
                this.jpButton.setBackVisible(true);
                this.jpButton.setNextVisible(true);
                this.jpButton.setInstallVisisble(false);
                return this.screenObj.sanPropertyFilePathScreen();
            }
            this.jpButton.setBackVisible(true);
            return this.screenObj.wbemInstallPathScreen();
        }
        if (this.curPosScreen == 3) {
            if (this.screenObj.nonInteractiveSetup) {
                this.screenObj.saveSANPathProp();
                this.jpButton.setBackVisible(true);
                this.jpButton.setNextVisible(false);
                this.jpButton.setInstallVisisble(true);
                return this.screenObj.setupConfirmScreen();
            }
            this.screenObj.saveDirPath();
            return this.screenObj.deviceSelectScreen();
        }
        if (this.curPosScreen == 4) {
            this.screenObj.saveDeviceProperties();
            return this.screenObj.dbInfoScreen();
        }
        if (this.curPosScreen == 5) {
            this.screenObj.saveDbProperties();
            return this.screenObj.simulationModeSelectScreen();
        }
        if (this.curPosScreen == 6) {
            this.screenObj.saveSModeProperties();
            this.jpButton.setInstallVisisble(false);
            this.jpButton.setNextVisible(true);
            return this.screenObj.SimulationModeScreen();
        }
        if (this.curPosScreen == 7) {
            if (this.screenObj.snapshotSetupMode && this.screenObj.startFreshSnapshot) {
                this.screenObj.saveSnapshotModeProperties();
                return this.screenObj.snapshotCIMOMInfoScreen();
            }
            if (this.screenObj.snapshotSetupMode && this.screenObj.restoreBackupDB) {
                this.screenObj.saveSnapshotModeProperties();
                return this.screenObj.backupDBInfoScreen();
            }
            this.screenObj.saveConfigProp();
            this.screenObj.saveProperties();
            this.jpButton.setNextVisible(false);
            this.jpButton.setInstallVisisble(true);
            return this.screenObj.setupConfirmScreen();
        }
        if (this.curPosScreen == 8) {
            if (this.screenObj.snapshotSetupMode && this.screenObj.startFreshSnapshot) {
                this.screenObj.saveSnapshotProperties();
                this.screenObj.saveProperties();
            } else if (this.screenObj.snapshotSetupMode && this.screenObj.restoreBackupDB) {
                this.screenObj.saveDBPathProperties();
                this.screenObj.saveProperties();
            }
            this.jpButton.setNextVisible(false);
            this.jpButton.setInstallVisisble(true);
            return this.screenObj.setupConfirmScreen();
        }
        return null;
    }

    private void showSetupPanel() {
        this.container = this.getContentPane();
        this.container.setLayout(this.layout);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.jpButton.jbBack.addActionListener(buttonHandler);
        this.jpButton.jbNext.addActionListener(buttonHandler);
        this.jpButton.jbCancel.addActionListener(buttonHandler);
        this.jpButton.jbInstall.addActionListener(buttonHandler);
        this.inputPanel = this.getScreen();
        this.jpMain.add((Component)this.inputPanel, "North");
        ImageIcon imageIcon = new ImageIcon("resources\\logo2_mm.gif");
        JLabel jLabel = new JLabel("", imageIcon, 2);
        this.addComponent(jLabel, 0, 0, 1, 5);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.jpMain.setBorder(BorderFactory.createEtchedBorder());
        this.addComponent(this.jpMain, 0, 1, 1, 1);
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 1;
        this.addComponent(this.jpButton, 4, 1, 1, 1);
        this.setSize(600, 450);
        this.setLocation(150, 150);
        this.setVisible(true);
    }

    private void addComponent(Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n2;
        this.constraints.gridy = n;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.layout.setConstraints(component, this.constraints);
        this.container.add(component);
    }

    private boolean PreviousPropSet() {
        if (this.curPosScreen == 1) {
            return this.screenObj.ModeSelectedSet();
        }
        if (this.screenObj.nonInteractiveSetup) {
            if (this.curPosScreen == 2) {
                return this.screenObj.PropFileSet();
            }
            if (this.curPosScreen == 3) {
                return true;
            }
        } else {
            if (this.curPosScreen == 2) {
                return this.screenObj.WBEMPathSet();
            }
            if (this.curPosScreen == 3) {
                return this.screenObj.DeviceSelected();
            }
            if (this.curPosScreen == 4) {
                return true;
            }
            if (this.curPosScreen == 5) {
                return true;
            }
            if (this.screenObj.snapshotSetupMode) {
                if (this.curPosScreen == 6) {
                    return this.screenObj.snapshotModeSet();
                }
                if (this.screenObj.startFreshSnapshot) {
                    if (this.curPosScreen == 7) {
                        return this.screenObj.checkCimomPropset();
                    }
                    if (this.curPosScreen == 8) {
                        return true;
                    }
                } else {
                    if (this.curPosScreen == 7) {
                        return this.screenObj.backupFilePathSet();
                    }
                    if (this.curPosScreen == 8) {
                        return true;
                    }
                }
            } else {
                if (this.curPosScreen == 6) {
                    return this.screenObj.configPathSet();
                }
                if (this.curPosScreen == 7) {
                    return true;
                }
            }
        }
        return false;
    }

    public void getNextScreen() {
        System.out.println("Current Screen Position " + this.curPosScreen);
        if (this.PreviousPropSet()) {
            ++this.curPosScreen;
            this.jpMain.remove(this.inputPanel);
            this.inputPanel = this.getScreen();
            this.jpMain.add((Component)this.inputPanel, "Center");
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(null, "Please fill all the required Information before you proceed!", "Error", 0);
        }
    }

    protected class ButtonHandler
    implements ActionListener {
        protected ButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Button Command " + actionEvent.getActionCommand());
            if (actionEvent.getActionCommand() == "Cancel") {
                int n = JOptionPane.showConfirmDialog(null, "If you Cancel the setup now, SAN Simulator will not be installed. Are you sure you want to exit?", "Cancel", 1);
                if (n == 0) {
                    JOptionPane.showMessageDialog(null, "Please close (if any) all the Open Command Windows to exit setup !", "Cancel", 1);
                    MainScreen.this.dispose();
                    System.exit(0);
                } else if (n == 1 || n == 2) {
                    // empty if block
                }
            }
            if (actionEvent.getActionCommand() == "Next") {
                System.out.println("Current Screen Position " + MainScreen.this.curPosScreen);
                if (MainScreen.this.PreviousPropSet()) {
                    ++MainScreen.this.curPosScreen;
                    MainScreen.this.jpMain.remove(MainScreen.this.inputPanel);
                    MainScreen.this.inputPanel = MainScreen.this.getScreen();
                    MainScreen.this.jpMain.add((Component)MainScreen.this.inputPanel, "Center");
                    MainScreen.this.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Please fill all the required Information before you proceed!", "Error", 0);
                }
            }
            if (actionEvent.getActionCommand() == "Back") {
                System.out.println("Current Screen Position " + MainScreen.this.curPosScreen);
                --MainScreen.this.curPosScreen;
                MainScreen.this.jpMain.remove(MainScreen.this.inputPanel);
                MainScreen.this.inputPanel = MainScreen.this.getScreen();
                MainScreen.this.jpMain.add((Component)MainScreen.this.inputPanel, "Center");
                MainScreen.this.setVisible(true);
            }
            if (actionEvent.getActionCommand() == "Install") {
                System.out.println("Current Screen Position " + MainScreen.this.curPosScreen);
                MainScreen.this.jpMain.remove(MainScreen.this.inputPanel);
                MainScreen.this.inputPanel = MainScreen.this.getScreen();
                MainScreen.this.jpMain.add((Component)MainScreen.this.inputPanel, "Center");
                MainScreen.this.setVisible(true);
                MainScreen.this.instProc.start();
                MainScreen.this.dispose();
            }
        }
    }
}

