/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.wbemservices.wbem.compiler.mofc.I18N;

class BeanArgReader
extends BufferedReader {
    private static final String PACKAGE = "PACKAGE=";
    private static final String IMPORTS = "IMPORTS=";
    private static final String EXCEPTIONS = "EXCEPTIONS=";
    private static final char EQUALS = '=';
    private String packageName = null;
    private String imports = null;
    private String exceptions = null;

    public BeanArgReader(FileReader fileReader) {
        super(fileReader);
        I18N.setResourceName("org.wbemservices.wbem.compiler.mofc.Compiler");
        this.readFile();
    }

    private void readFile() {
        int index = -1;
        try {
            String line;
            while ((line = this.readLine()) != null) {
                index = line.indexOf(61) + 1;
                if (index > 0) {
                    if (line.startsWith(PACKAGE)) {
                        this.packageName = line.substring(index);
                        continue;
                    }
                    if (line.startsWith(IMPORTS)) {
                        this.imports = line.substring(index);
                        continue;
                    }
                    if (line.startsWith(EXCEPTIONS)) {
                        this.exceptions = line.substring(index);
                        continue;
                    }
                    this.printError(line);
                    continue;
                }
                this.printError(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printError(String badLine) {
        Vector<String> vError = new Vector<String>(1);
        vError.addElement(badLine);
        System.err.println(I18N.loadStringFormat("ERR_BEAN_ARG_BAD", vError));
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getImports() {
        return this.imports;
    }

    public String getExceptions() {
        return this.exceptions;
    }
}

