/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import org.wbemservices.wbem.compiler.mofc.BeanClassWriter;
import org.wbemservices.wbem.compiler.mofc.BeanGeneratorConstants;
import org.wbemservices.wbem.compiler.mofc.BeanInterfaceWriter;
import org.wbemservices.wbem.compiler.mofc.I18N;
import org.wbemservices.wbem.compiler.mofc.JavaDocElement;

class BeanGenerator
implements BeanGeneratorConstants {
    private static CIMOMHandle cimomHandle = null;
    private CIMClass cimClass = null;
    private static StringBuffer fileHeader = null;
    private static StringBuffer packageStatement = null;
    private static StringBuffer importStatements = null;
    private static StringBuffer exceptions = null;
    private static StringBuffer invokeMethodExceptions = null;
    private static String[] keywordArr = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private static String lastKeyword = null;
    private static final String invalidChars = "!@#$%^&*(-){[]}+=?/\"'<,>.:;\\|        ";
    private static String packageName = null;
    private static Vector vImports = null;
    private static Vector vExceptions = null;
    private static File outputDir = null;

    public BeanGenerator(CIMOMHandle cimomHandle, CIMClass cimClass, String packageName, String imports, String exceptions, File outputDir) {
        BeanGenerator.cimomHandle = cimomHandle;
        this.cimClass = cimClass;
        BeanGenerator.packageName = packageName;
        BeanGenerator.outputDir = outputDir;
        Debug.trace2((String)("Generating Java Bean source for " + cimClass.getName()));
        vImports = BeanGenerator.parseColonList(imports);
        vExceptions = BeanGenerator.parseColonList(exceptions);
        I18N.setResourceName("org.wbemservices.wbem.compiler.mofc.Compiler");
        BeanInterfaceWriter beanInterfaceWriter = new BeanInterfaceWriter(cimClass);
        BeanClassWriter beanClassWriter = new BeanClassWriter(cimClass);
    }

    public static void writeToFile(StringBuffer fileName, StringBuffer fileContents, File beanDir) {
        fileName.append(".java");
        Debug.trace3((String)("Generating source file: " + fileName.toString()));
        try {
            File fileToWrite = new File(beanDir.getAbsolutePath(), fileName.toString());
            if (fileToWrite.exists()) {
                fileToWrite.delete();
            }
            try {
                String pathName = beanDir.getAbsolutePath() + File.separator + fileName.toString();
                FileWriter fileWriter = new FileWriter(pathName, true);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(fileContents.toString());
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            catch (IOException ioe) {
                System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", fileName.toString()));
                System.exit(1);
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    public static void writeToFile(StringBuffer fileName, StringBuffer fileContents) {
        BeanGenerator.writeToFile(fileName, fileContents, outputDir);
    }

    public static String getSuperClass(CIMClass cimClass) {
        String superClass = BeanGenerator.getClassName(cimClass.getSuperClass());
        if (!BeanGenerator.hasContents(superClass)) {
            superClass = "CIM";
        }
        return superClass;
    }

    public static String getClassName(String name) {
        if (!BeanGenerator.hasContents(name)) {
            return name;
        }
        name = BeanGenerator.firstCharUpper(name).toString();
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(name, "_");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            sb.append(BeanGenerator.firstCharUpper(token)).append("_");
        }
        if (sb.toString().lastIndexOf("_") == sb.length() - 1) {
            sb = new StringBuffer(sb.substring(0, sb.toString().lastIndexOf("_")));
        }
        return sb.toString();
    }

    public static StringBuffer getAccessorDoc(CIMProperty cimProp) {
        Debug.trace3((String)("Generating accessor method JavaDoc for property: " + cimProp.getOriginClass() + "." + cimProp.getName()));
        String accessorDesc = I18N.loadStringFormat("BEAN_ACCESSOR_JAVADOC", cimProp.getOriginClass(), (Object)cimProp.getName());
        StringBuffer mofDescBuffer = BeanGenerator.getPropertyDescription(cimProp);
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1 + vExceptions.size());
        JavaDocElement javaDocElement = new JavaDocElement("@return", BeanGenerator.getPropertyDataType(cimProp), I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", cimProp.getName()));
        vJavaDocElements.addElement(javaDocElement);
        BeanGenerator.addExceptionsToVector(vJavaDocElements, vExceptions);
        StringBuffer sb = BeanGenerator.getJavaDoc(accessorDesc, mofDescBuffer, vJavaDocElements, 1);
        return sb;
    }

    public static StringBuffer getMutatorDoc(CIMProperty cimProp) {
        Debug.trace3((String)("Generating mutator method JavaDoc for property: " + cimProp.getOriginClass() + "." + cimProp.getName()));
        String mutatorDesc = I18N.loadStringFormat("BEAN_MUTATOR_JAVADOC", cimProp.getOriginClass(), (Object)cimProp.getName());
        StringBuffer mofDescBuffer = BeanGenerator.getPropertyDescription(cimProp);
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1 + vExceptions.size());
        JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getPropertyDataType(cimProp), I18N.loadStringFormat("MUTATOR_PARAM_DESCRIPTION", cimProp.getName()));
        vJavaDocElements.addElement(javaDocElement);
        BeanGenerator.addExceptionsToVector(vJavaDocElements, vExceptions);
        StringBuffer sb = BeanGenerator.getJavaDoc(mutatorDesc, mofDescBuffer, vJavaDocElements, 1);
        return sb;
    }

    public static StringBuffer getUnitsDoc(CIMProperty cimProp) {
        Debug.trace3((String)("Generating units accessor method JavaDoc for property: " + cimProp.getOriginClass() + "." + cimProp.getName()));
        StringBuffer sb = new StringBuffer();
        if (BeanGenerator.hasQualifier(cimProp, "Units")) {
            String unitsDesc = I18N.loadStringFormat("BEAN_UNITS_JAVADOC", cimProp.getOriginClass(), (Object)cimProp.getName());
            StringBuffer mofDesc = BeanGenerator.getPropertyDescription(cimProp);
            Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1 + vExceptions.size());
            JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadStringFormat("UNITS_RETURN_DESCRIPTION", cimProp.getName()));
            vJavaDocElements.addElement(javaDocElement);
            BeanGenerator.addExceptionsToVector(vJavaDocElements, vExceptions);
            sb.append(BeanGenerator.getJavaDoc(unitsDesc, mofDesc, vJavaDocElements, 1));
        }
        return sb;
    }

    public static StringBuffer getDisplayNameDoc(CIMProperty cimProp) {
        Debug.trace3((String)("Generating display name accessor method JavaDoc for property: " + cimProp.getOriginClass() + "." + cimProp.getName()));
        StringBuffer sb = new StringBuffer();
        if (BeanGenerator.hasQualifier(cimProp, "DisplayName")) {
            String displayNameDesc = I18N.loadStringFormat("BEAN_DISPLAYNAME_JAVADOC", cimProp.getOriginClass(), (Object)cimProp.getName());
            StringBuffer mofDesc = BeanGenerator.getPropertyDescription(cimProp);
            Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1 + vExceptions.size());
            JavaDocElement javaDocElement = new JavaDocElement("@return", new StringBuffer("String"), I18N.loadStringFormat("DISPLAYNAME_RETURN_DESCRIPTION", cimProp.getName()));
            vJavaDocElements.addElement(javaDocElement);
            BeanGenerator.addExceptionsToVector(vJavaDocElements, vExceptions);
            sb.append(BeanGenerator.getJavaDoc(displayNameDesc, mofDesc, vJavaDocElements, 1));
        }
        return sb;
    }

    public static StringBuffer getInvokeMethodDoc(CIMMethod cimMethod) {
        Debug.trace3((String)("Generating invokeMethod JavaDoc for property: " + cimMethod.getOriginClass() + "." + cimMethod.getName()));
        String methodDesc = I18N.loadStringFormat("BEAN_INVOKEMETHOD_JAVADOC", cimMethod.getOriginClass(), (Object)cimMethod.getName());
        StringBuffer mofDesc = BeanGenerator.getMethodDescription(cimMethod);
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1 + vExceptions.size());
        JavaDocElement javaDocElement = new JavaDocElement("@return", BeanGenerator.getDataType(cimMethod.getType()), I18N.loadStringFormat("INVOKEMETHOD_RETURN_DESCRIPTION", cimMethod.getName()));
        vJavaDocElements.addElement(javaDocElement);
        BeanGenerator.addExceptionsToVector(vJavaDocElements, vExceptions);
        BeanGenerator.insertParamsInVector(vJavaDocElements, cimMethod.getParameters());
        StringBuffer sb = BeanGenerator.getJavaDoc(methodDesc, mofDesc, vJavaDocElements, 1);
        return sb;
    }

    public static StringBuffer getFileHeader() {
        Debug.trace3((String)"Generating file header");
        if (!BeanGenerator.hasContents(fileHeader)) {
            String timeStamp = new Date().toString();
            String versionStr = BeanGenerator.format("{0}.{1}.{2}", Integer.toString(1), Integer.toString(0), Integer.toString(0));
            fileHeader = BeanGenerator.getJavaDoc(I18N.loadStringFormat("FILE_HEADER", versionStr, (Object)timeStamp), new StringBuffer(), null, 0).append("\n");
        }
        return fileHeader;
    }

    public static StringBuffer getPackageStatement(String packageName) {
        Debug.trace3((String)"Generating package statement");
        StringBuffer packageStatement = new StringBuffer(BeanGenerator.format("package {0};\n", packageName)).append("\n");
        return packageStatement;
    }

    public static StringBuffer getPackageStatement() {
        if (!BeanGenerator.hasContents(packageStatement)) {
            packageStatement = BeanGenerator.getPackageStatement(packageName);
        }
        return packageStatement;
    }

    public static StringBuffer getImportStatements(Vector v) {
        Debug.trace3((String)"Generating import statement(s)");
        StringBuffer importStatements = new StringBuffer("import javax.wbem.client.*;\nimport javax.wbem.cim.*;\nimport java.util.*;\n");
        if (BeanGenerator.hasContents(v)) {
            Enumeration eImports = v.elements();
            while (eImports.hasMoreElements()) {
                String currentImport = (String)eImports.nextElement();
                importStatements.append(BeanGenerator.format("import {0};\n", currentImport));
            }
        }
        importStatements.append("\n");
        return importStatements;
    }

    public static StringBuffer getImportStatements() {
        if (!BeanGenerator.hasContents(importStatements)) {
            importStatements = BeanGenerator.getImportStatements(vImports);
        }
        return importStatements;
    }

    public static StringBuffer getPropertyDescription(CIMProperty cimProp) {
        Debug.trace3((String)("Generating description for property: " + cimProp.getOriginClass() + "." + cimProp.getName()));
        StringBuffer sb = new StringBuffer();
        if (BeanGenerator.hasQualifier(cimProp, "Description")) {
            sb.append(BeanGenerator.replaceNewlines((String)cimProp.getQualifier("Description").getValue().getValue()));
        }
        return sb;
    }

    private static boolean hasProperty(Vector vProps, CIMProperty cimProp) {
        boolean bHasProperty = false;
        Enumeration eProps = vProps.elements();
        String propName = cimProp.getName();
        while (eProps.hasMoreElements() && !bHasProperty) {
            CIMProperty currentProp = (CIMProperty)eProps.nextElement();
            if (!propName.equalsIgnoreCase(currentProp.getName())) continue;
            bHasProperty = true;
        }
        return bHasProperty;
    }

    public static StringBuffer getOverriddenDataType(CIMClass cimClass, CIMProperty cimProp) {
        CIMClass superClass = null;
        CIMProperty superProp = null;
        String propName = cimProp.getName();
        if (BeanGenerator.hasQualifier(cimProp, "Override")) {
            propName = BeanGenerator.getQualifier(cimProp, "Override");
        }
        String[] propArr = new String[]{propName};
        String superClassName = cimClass.getSuperClass();
        CIMObjectPath objectPath = new CIMObjectPath(superClassName);
        while (superProp == null || BeanGenerator.hasQualifier(superProp, "Override")) {
            try {
                superClass = cimomHandle.getClass(objectPath, true, true, true, propArr);
                superProp = superClass.getProperty(propArr[0]);
            }
            catch (CIMException cex) {
                // empty catch block
            }
            superClassName = superClass.getSuperClass();
            objectPath = new CIMObjectPath(superClassName);
        }
        return BeanGenerator.getPropertyDataType(superProp);
    }

    public static StringBuffer getPropertyDataType(CIMProperty cimProp) {
        StringBuffer sb = BeanGenerator.getDataType(cimProp.getType());
        if ((BeanGenerator.hasQualifier(cimProp, "ValueMap") || BeanGenerator.hasQualifier(cimProp, "Values")) && BeanGenerator.isArrayType(sb)) {
            sb = new StringBuffer(sb.substring(0, sb.length() - 2));
        }
        return sb;
    }

    public static boolean isArrayType(StringBuffer dataType) {
        return dataType.toString().indexOf("[]") > 0;
    }

    public static boolean hasQualifier(CIMParameter cimParam, String qualName) {
        CIMQualifier cimQual = cimParam.getQualifier(qualName);
        return cimQual != null;
    }

    public static boolean hasQualifier(CIMProperty cimProp, String qualName) {
        CIMQualifier cimQual = cimProp.getQualifier(qualName);
        return cimQual != null;
    }

    public static boolean hasQualifier(CIMMethod cimMethod, String qualName) {
        CIMQualifier cimQual = cimMethod.getQualifier(qualName);
        return cimQual != null;
    }

    public static boolean hasQualifier(CIMClass cimClass, String qualName) {
        CIMQualifier cimQual = cimClass.getQualifier(qualName);
        return cimQual != null;
    }

    public static String getQualifier(CIMProperty cimProp, String qualName) {
        String qualStr = "";
        if (BeanGenerator.hasQualifier(cimProp, qualName)) {
            qualStr = (String)cimProp.getQualifier(qualName).getValue().getValue();
        }
        return qualStr;
    }

    public static String getQualifier(CIMClass cimClass, String qualName) {
        String qualStr = "";
        if (BeanGenerator.hasQualifier(cimClass, qualName)) {
            qualStr = (String)cimClass.getQualifier(qualName).getValue().getValue();
        }
        return qualStr;
    }

    public static StringBuffer getMethodDescription(CIMMethod cimMethod) {
        Debug.trace3((String)("Generating description for method: " + cimMethod.getOriginClass() + "." + cimMethod.getName()));
        StringBuffer sb = new StringBuffer();
        if (BeanGenerator.hasQualifier(cimMethod, "Description")) {
            sb.append(BeanGenerator.replaceNewlines((String)cimMethod.getQualifier("Description").getValue().getValue()));
        }
        return sb;
    }

    public static StringBuffer getClassDescription(CIMClass cimClass) {
        Debug.trace3((String)("Generating description for class: " + cimClass.getName()));
        StringBuffer sb = new StringBuffer();
        if (BeanGenerator.hasQualifier(cimClass, "Description")) {
            sb.append(BeanGenerator.replaceNewlines((String)cimClass.getQualifier("Description").getValue().getValue()));
        }
        return sb;
    }

    private static String replaceNewlines(String str) {
        StringBuffer buffer = new StringBuffer(str);
        int index = buffer.toString().indexOf("\n");
        while (index > -1) {
            buffer.replace(index, index + 1, " ");
            index = buffer.toString().indexOf("\n");
        }
        return buffer.toString();
    }

    public static StringBuffer getInvokeMethodParams(CIMMethod cimMethod) {
        StringBuffer sb = new StringBuffer();
        Vector vParams = cimMethod.getParameters();
        if (!BeanGenerator.hasContents(vParams)) {
            return sb;
        }
        Enumeration eParams = vParams.elements();
        while (eParams.hasMoreElements()) {
            CIMParameter param = (CIMParameter)eParams.nextElement();
            if (!BeanGenerator.isInParameter(param)) continue;
            boolean hasValues = BeanGenerator.hasQualifier(param, "Values") || BeanGenerator.hasQualifier(param, "ValueMap");
            StringBuffer dataType = BeanGenerator.getDataType(param.getType());
            if (hasValues) {
                dataType = BeanGenerator.isArrayType(dataType) ? new StringBuffer("String[]") : new StringBuffer("String");
            }
            sb.append(BeanGenerator.format("{0} {1}, ", dataType.toString(), BeanGenerator.getParameterName(param.getName())));
        }
        if (BeanGenerator.hasOutParameter(cimMethod)) {
            sb.append(BeanGenerator.format("{0} {1}", BeanGenerator.getOutputInterfaceName(cimMethod).toString() + "[]", BeanGenerator.getOutputParameterName(cimMethod).toString()));
        } else {
            sb = new StringBuffer(sb.substring(0, sb.toString().lastIndexOf(",")));
        }
        return sb;
    }

    public static String getParameterName(String str) {
        if (BeanGenerator.isKeyword(str = BeanGenerator.firstCharLower(str).toString())) {
            str = BeanGenerator.firstCharUpper(str).toString();
        }
        return str;
    }

    public static Vector getConstantNames(CIMProperty cimProp, String prefix) {
        Vector vConstantNames = BeanGenerator.getValuesConstantValues(cimProp);
        return BeanGenerator.getConstantNames(vConstantNames, prefix);
    }

    public static Vector getConstantNames(CIMParameter cimParam, String prefix) {
        Vector vConstantNames = BeanGenerator.getValuesConstantValues(cimParam);
        return BeanGenerator.getConstantNames(vConstantNames, prefix);
    }

    public static Vector getConstantNames(Vector vConstantNames, String prefix) {
        if (BeanGenerator.hasContents(vConstantNames)) {
            Vector<String> vNewConstantNames = new Vector<String>(vConstantNames.size());
            Enumeration eConstantNames = vConstantNames.elements();
            String newName = "";
            while (eConstantNames.hasMoreElements()) {
                String currentName = BeanGenerator.replacePlus((String)eConstantNames.nextElement());
                StringTokenizer st = new StringTokenizer(currentName, invalidChars);
                while (st.hasMoreTokens()) {
                    newName = newName + st.nextToken() + "_";
                }
                int lastUnderscore = newName.lastIndexOf("_");
                if (lastUnderscore > 0) {
                    newName = newName.substring(0, lastUnderscore);
                }
                newName = newName.toUpperCase();
                int suffix = 1;
                String tmpNewName = newName;
                while (vNewConstantNames.contains(newName)) {
                    newName = tmpNewName + Integer.toString(suffix);
                    ++suffix;
                }
                vNewConstantNames.addElement(newName);
                newName = "";
            }
            vConstantNames = BeanGenerator.prependPrefix(vNewConstantNames, prefix);
        }
        return vConstantNames;
    }

    public static Vector getValuesConstantValues(CIMProperty cimProp) {
        Vector vConstantValues = new Vector();
        boolean bValueMap = BeanGenerator.hasQualifier(cimProp, "ValueMap");
        boolean bValues = BeanGenerator.hasQualifier(cimProp, "Values");
        if (bValues) {
            vConstantValues = (Vector)cimProp.getQualifier("Values").getValue().getValue();
        } else if (bValueMap) {
            vConstantValues = (Vector)cimProp.getQualifier("ValueMap").getValue().getValue();
        }
        return vConstantValues;
    }

    public static Vector getValuesConstantValues(CIMParameter cimParam) {
        Vector vConstantValues = new Vector();
        boolean bValueMap = BeanGenerator.hasQualifier(cimParam, "ValueMap");
        boolean bValues = BeanGenerator.hasQualifier(cimParam, "Values");
        if (bValues) {
            vConstantValues = (Vector)cimParam.getQualifier("Values").getValue().getValue();
        } else if (bValueMap) {
            vConstantValues = (Vector)cimParam.getQualifier("ValueMap").getValue().getValue();
        }
        return vConstantValues;
    }

    public static Vector getValueMapConstantValues(CIMProperty cimProp) {
        Vector vConstantValues = new Vector();
        if (BeanGenerator.hasQualifier(cimProp, "ValueMap")) {
            vConstantValues = (Vector)cimProp.getQualifier("ValueMap").getValue().getValue();
        } else {
            Vector vValues = (Vector)cimProp.getQualifier("Values").getValue().getValue();
            vConstantValues = BeanGenerator.generateValueMap(vValues.size());
        }
        return vConstantValues;
    }

    public static Vector getValueMapConstantValues(CIMParameter cimParam) {
        Vector vConstantValues = new Vector();
        if (BeanGenerator.hasQualifier(cimParam, "ValueMap")) {
            vConstantValues = (Vector)cimParam.getQualifier("ValueMap").getValue().getValue();
        } else {
            Vector vValues = (Vector)cimParam.getQualifier("Values").getValue().getValue();
            vConstantValues = BeanGenerator.generateValueMap(vValues.size());
        }
        return vConstantValues;
    }

    private static Vector generateValueMap(int size) {
        Vector<String> vValueMap = new Vector<String>(size);
        for (int i = 0; i < size; ++i) {
            vValueMap.addElement(Integer.toString(i));
        }
        return vValueMap;
    }

    private static String replacePlus(String str) {
        if (str.indexOf(43) < 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(str, "+");
        while (tokenizer.hasMoreTokens()) {
            sb.append(tokenizer.nextToken()).append("plus");
        }
        return sb.toString();
    }

    private static Vector prependPrefix(Vector vContainer, String prefix) {
        Vector<String> vNewContainer = new Vector<String>(vContainer.size());
        Enumeration eContainer = vContainer.elements();
        while (eContainer.hasMoreElements()) {
            String currentElement = prefix + (String)eContainer.nextElement();
            vNewContainer.addElement(currentElement);
        }
        return vNewContainer;
    }

    public static boolean isInParameter(CIMParameter cimParam) {
        return BeanGenerator.hasQualifier(cimParam, "IN");
    }

    public static boolean isOutParameter(CIMParameter cimParam) {
        return BeanGenerator.hasQualifier(cimParam, "OUT");
    }

    public static boolean hasInParameter(CIMMethod method) {
        return BeanGenerator.getInParameters(method).length > 0;
    }

    public static boolean hasOutParameter(CIMMethod method) {
        return BeanGenerator.getOutParameters(method).length > 0;
    }

    public static CIMParameter[] getInParameters(CIMMethod method) {
        Vector<CIMParameter> vInParams = new Vector<CIMParameter>();
        Vector vParams = method.getParameters();
        if (BeanGenerator.hasContents(vParams)) {
            Enumeration eParams = vParams.elements();
            while (eParams.hasMoreElements()) {
                CIMParameter param = (CIMParameter)eParams.nextElement();
                if (!BeanGenerator.isInParameter(param)) continue;
                vInParams.addElement(param);
            }
        }
        return vInParams.toArray(new CIMParameter[0]);
    }

    public static CIMParameter[] getOutParameters(CIMMethod method) {
        Vector<CIMParameter> vOutParams = new Vector<CIMParameter>();
        Vector vParams = method.getParameters();
        if (BeanGenerator.hasContents(vParams)) {
            Enumeration eParams = vParams.elements();
            while (eParams.hasMoreElements()) {
                CIMParameter param = (CIMParameter)eParams.nextElement();
                if (!BeanGenerator.isOutParameter(param)) continue;
                vOutParams.addElement(param);
            }
        }
        return vOutParams.toArray(new CIMParameter[0]);
    }

    private static boolean isKeyword(String str) {
        if (BeanGenerator.hasContents(lastKeyword) && lastKeyword.equals(str)) {
            return true;
        }
        boolean bKeyword = false;
        for (int i = 0; i < keywordArr.length; ++i) {
            if (!str.equals(keywordArr[i])) continue;
            lastKeyword = keywordArr[i];
            bKeyword = true;
            break;
        }
        return bKeyword;
    }

    public static StringBuffer getOutputClassName(CIMMethod cimMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append(BeanGenerator.format("{0}_{1}OutputImpl", cimMethod.getOriginClass(), BeanGenerator.firstCharUpper(cimMethod.getName()).toString()));
        return sb;
    }

    public static StringBuffer getOutputInterfaceName(CIMMethod cimMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append(BeanGenerator.format("{0}_{1}Output", cimMethod.getOriginClass(), BeanGenerator.firstCharUpper(cimMethod.getName()).toString()));
        return sb;
    }

    public static StringBuffer getOutputParameterName(CIMMethod cimMethod) {
        StringBuffer outputParamName = BeanGenerator.firstCharLower(BeanGenerator.getOutputInterfaceName(cimMethod).toString());
        StringBuffer sb = new StringBuffer(outputParamName.toString());
        return sb;
    }

    public static StringBuffer getPropertyName(CIMProperty cimProp) {
        return BeanGenerator.firstCharLower(cimProp.getName());
    }

    public static StringBuffer getParameterName(CIMParameter cimParam) {
        return new StringBuffer(BeanGenerator.getParameterName(cimParam.getName()));
    }

    public static StringBuffer firstCharUpper(String str) {
        String firstChar = str.substring(0, 1);
        StringBuffer sb = new StringBuffer(firstChar.toUpperCase());
        return sb.append(str.substring(1));
    }

    public static StringBuffer firstCharLower(String str) {
        String firstChar = str.substring(0, 1);
        StringBuffer sb = new StringBuffer(firstChar.toLowerCase());
        return sb.append(str.substring(1));
    }

    public static boolean hasContents(Vector v) {
        return v != null && v.size() > 0;
    }

    public static boolean hasContents(Object[] oa) {
        return oa != null && oa.length > 0;
    }

    public static boolean hasContents(String s) {
        return s != null && !s.equals("");
    }

    public static boolean hasContents(StringBuffer sb) {
        return sb != null && sb.length() > 0;
    }

    private static StringBuffer getWrappedString(StringBuffer str, StringBuffer breakStr, int indentLength) {
        int lineLength = 80 - indentLength - 1;
        int wrappedLength = 80 - BeanGenerator.getTokenLength(breakStr.toString()) - 1;
        if (BeanGenerator.getTokenLength(str.toString()) < lineLength) {
            return str;
        }
        StringTokenizer tokenizer = new StringTokenizer(str.toString(), " ");
        StringBuffer returnBuffer = new StringBuffer();
        int tokenLength = 0;
        int bufferLength = 0;
        boolean hasWrapped = false;
        StringBuffer currentBuffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            while (BeanGenerator.hasOneQuote(currentToken) && tokenizer.hasMoreTokens()) {
                currentToken = currentToken + " " + tokenizer.nextToken();
            }
            tokenLength = BeanGenerator.getTokenLength(currentToken);
            if (!hasWrapped && tokenLength > lineLength || !hasWrapped && tokenLength + bufferLength < lineLength || hasWrapped && tokenLength + bufferLength < wrappedLength) {
                currentBuffer.append(currentToken);
                currentBuffer.append(" ");
            } else {
                hasWrapped = true;
                currentBuffer.append(breakStr);
                returnBuffer.append(currentBuffer);
                currentBuffer = new StringBuffer(currentToken);
                currentBuffer.append(" ");
            }
            bufferLength = BeanGenerator.getTokenLength(currentBuffer.toString());
        }
        if (currentBuffer.toString().endsWith("\n ")) {
            currentBuffer = new StringBuffer(currentBuffer.substring(0, currentBuffer.length() - 1));
        }
        returnBuffer.append(currentBuffer);
        return returnBuffer;
    }

    private static boolean hasOneQuote(String str) {
        int first = str.indexOf("\"");
        int last = str.lastIndexOf("\"");
        return first > -1 && first == last;
    }

    private static int getTokenLength(String str) {
        int index = 0;
        if (str == null || str.length() == 0) {
            return index;
        }
        int numTabs = 0;
        index = str.indexOf("\t", index);
        while (index > -1) {
            index = str.indexOf("\t", index + 1);
            ++numTabs;
        }
        return 8 * numTabs - numTabs + str.length();
    }

    public static StringBuffer getIndentString(int indent) {
        StringBuffer sb = new StringBuffer();
        int numTabs = indent / 2;
        for (int i = 0; i < numTabs; ++i) {
            sb.append("\t");
        }
        if (indent % 2 != 0) {
            sb.append("    ");
        }
        return sb;
    }

    public static StringBuffer getSourceLine(String source, int indent) {
        StringBuffer sb = BeanGenerator.getIndentString(indent);
        StringBuffer breakBuffer = BeanGenerator.getBreakString(source, indent);
        return sb.append(BeanGenerator.getWrappedString(new StringBuffer(source), breakBuffer, BeanGenerator.getTokenLength(sb.toString())));
    }

    private static StringBuffer getBreakString(String source, int indent) {
        StringBuffer breakBuffer = new StringBuffer("\n");
        breakBuffer.append(BeanGenerator.getIndentString(indent + 1));
        if (source.indexOf("//") > -1) {
            breakBuffer.append("//").append(" ");
        }
        return breakBuffer;
    }

    public static StringBuffer getJavaDoc(String beanDesc, StringBuffer mofDesc, Vector vJavaDocElements, int indent) {
        StringBuffer indentBuffer = BeanGenerator.getIndentString(indent);
        StringBuffer sb = new StringBuffer(indentBuffer.toString());
        sb.append("/**\n");
        indentBuffer.append(" ");
        sb.append(indentBuffer).append("* ");
        int indentLength = BeanGenerator.getTokenLength(indentBuffer.toString()) + "* ".length();
        StringBuffer breakBuffer = new StringBuffer("\n");
        breakBuffer.append(indentBuffer).append("* ");
        sb.append(BeanGenerator.getWrappedString(new StringBuffer(beanDesc), breakBuffer, indentLength));
        if (BeanGenerator.hasContents(mofDesc)) {
            sb.append(breakBuffer).append(breakBuffer);
            sb.append(BeanGenerator.getWrappedString(mofDesc, breakBuffer, indentLength));
        }
        if (BeanGenerator.hasContents(vJavaDocElements)) {
            sb.append(breakBuffer);
            Enumeration eJavaDocElements = vJavaDocElements.elements();
            while (eJavaDocElements.hasMoreElements()) {
                JavaDocElement currentElement = (JavaDocElement)eJavaDocElements.nextElement();
                sb.append(breakBuffer);
                sb.append(BeanGenerator.getWrappedString(new StringBuffer(BeanGenerator.format("{0}\t{1}\t{2}", currentElement.getTag().toString(), currentElement.getType().toString(), currentElement.getDescription())), breakBuffer, indentLength));
            }
        }
        sb.append("\n").append(indentBuffer).append("*/\n");
        return sb;
    }

    public static Vector parseColonList(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ":");
        Vector<String> vReturn = new Vector<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            vReturn.addElement(tokenizer.nextToken());
        }
        return vReturn;
    }

    public static StringBuffer getDataType(CIMDataType cimDataType) {
        switch (cimDataType.getType()) {
            case 9: {
                return new StringBuffer("Boolean");
            }
            case 23: {
                return new StringBuffer("Boolean[]");
            }
            case 13: {
                return new StringBuffer("Character");
            }
            case 27: {
                return new StringBuffer("Character[]");
            }
            case 12: {
                return new StringBuffer("CIMDateTime");
            }
            case 10: {
                return new StringBuffer("Float");
            }
            case 24: {
                return new StringBuffer("Float[]");
            }
            case 11: {
                return new StringBuffer("Double");
            }
            case 25: {
                return new StringBuffer("Double[]");
            }
            case 1: {
                return new StringBuffer("Byte");
            }
            case 15: {
                return new StringBuffer("Byte[]");
            }
            case 3: {
                return new StringBuffer("Short");
            }
            case 17: {
                return new StringBuffer("Short[]");
            }
            case 5: {
                return new StringBuffer("Integer");
            }
            case 19: {
                return new StringBuffer("Integer[]");
            }
            case 7: {
                return new StringBuffer("Long");
            }
            case 21: {
                return new StringBuffer("Long[]");
            }
            case 8: {
                return new StringBuffer("String");
            }
            case 22: {
                return new StringBuffer("String[]");
            }
            case 0: {
                return new StringBuffer("UnsignedInt8");
            }
            case 14: {
                return new StringBuffer("UnsignedInt8[]");
            }
            case 2: {
                return new StringBuffer("UnsignedInt16");
            }
            case 16: {
                return new StringBuffer("UnsignedInt16[]");
            }
            case 4: {
                return new StringBuffer("UnsignedInt32");
            }
            case 18: {
                return new StringBuffer("UnsignedInt32[]");
            }
            case 6: {
                return new StringBuffer("UnsignedInt64");
            }
            case 20: {
                return new StringBuffer("UnsignedInt64[]");
            }
        }
        if (cimDataType.isReferenceType()) {
            return new StringBuffer(cimDataType.getRefClassName()).append("Bean");
        }
        return new StringBuffer("UNKNOWN DATATYPE: ").append(cimDataType.toString());
    }

    private static void addExceptionsToVector(Vector vJavaDocElements, Vector vExceptions) {
        if (vJavaDocElements.capacity() > 1) {
            Enumeration enExceptions = vExceptions.elements();
            while (enExceptions.hasMoreElements()) {
                String currentException = (String)enExceptions.nextElement();
                JavaDocElement javaDocElement = new JavaDocElement("@exception", new StringBuffer(currentException), "");
                vJavaDocElements.addElement(javaDocElement);
            }
        }
    }

    private static void insertParamsInVector(Vector vJavaDocElements, Vector vParams) {
        if (!BeanGenerator.hasContents(vParams)) {
            return;
        }
        Enumeration en = vParams.elements();
        int insertCounter = 0;
        while (en.hasMoreElements()) {
            CIMParameter cimParam = (CIMParameter)en.nextElement();
            if (!BeanGenerator.isInParameter(cimParam)) continue;
            JavaDocElement javaDocElement = new JavaDocElement("@param", BeanGenerator.getDataType(cimParam.getType()), I18N.loadStringFormat("INVOKEMETHOD_PARAM_DESCRIPTION", cimParam.getName()));
            vJavaDocElements.insertElementAt(javaDocElement, insertCounter);
            ++insertCounter;
        }
    }

    public static StringBuffer getExceptions() {
        if (!BeanGenerator.hasContents(exceptions) && BeanGenerator.hasContents(vExceptions)) {
            exceptions = new StringBuffer(" throws ");
            Enumeration eExceptions = vExceptions.elements();
            while (eExceptions.hasMoreElements()) {
                exceptions.append((String)eExceptions.nextElement());
                exceptions.append(", ");
            }
            exceptions = new StringBuffer(exceptions.substring(0, exceptions.length() - 2));
        }
        return exceptions;
    }

    public static StringBuffer getInvokeMethodExceptions() {
        if (!BeanGenerator.hasContents(invokeMethodExceptions)) {
            if (!BeanGenerator.hasContents(BeanGenerator.getExceptions())) {
                invokeMethodExceptions = new StringBuffer("throws CIMException");
            } else {
                invokeMethodExceptions = new StringBuffer(BeanGenerator.getExceptions().toString());
                invokeMethodExceptions.append(", ").append("CIMException");
            }
        }
        return invokeMethodExceptions;
    }

    public static String format(String pattern, String arg1) {
        Object[] args = new String[]{arg1};
        return MessageFormat.format(pattern, args);
    }

    public static String format(String pattern, String arg1, String arg2) {
        Object[] args = new String[]{arg1, arg2};
        return MessageFormat.format(pattern, args);
    }

    public static String format(String pattern, String arg1, String arg2, String arg3) {
        Object[] args = new String[]{arg1, arg2, arg3};
        return MessageFormat.format(pattern, args);
    }

    public static String format(String pattern, String arg1, String arg2, String arg3, String arg4) {
        Object[] args = new String[]{arg1, arg2, arg3, arg4};
        return MessageFormat.format(pattern, args);
    }
}

