/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.Debug;
import org.wbemservices.wbem.compiler.mofc.BeanGenerator;
import org.wbemservices.wbem.compiler.mofc.BeanGeneratorConstants;
import org.wbemservices.wbem.compiler.mofc.I18N;
import org.wbemservices.wbem.compiler.mofc.JavaDocElement;

class BeanInterfaceWriter
implements BeanGeneratorConstants {
    private CIMClass cimClass = null;
    private Vector vProperties = null;
    private Vector vMethods = null;
    private String superClass = null;
    private String className = null;

    public BeanInterfaceWriter(CIMClass cimClass) {
        this.cimClass = cimClass;
        Debug.trace2((String)("Generating Java Interface source for " + cimClass.getName()));
        I18N.setResourceName("org.wbemservices.wbem.compiler.mofc.Compiler");
        this.populateClassData();
        this.generateInterface();
    }

    private void populateClassData() {
        this.superClass = BeanGenerator.getSuperClass(this.cimClass);
        this.className = BeanGenerator.getClassName(this.cimClass.getName());
        this.vProperties = this.cimClass.getProperties();
        this.vMethods = this.cimClass.getMethods();
    }

    private void generateInterface() {
        StringBuffer nameBuffer = new StringBuffer(this.className);
        nameBuffer.append("Bean");
        StringBuffer sb = new StringBuffer();
        sb.append(BeanGenerator.getFileHeader());
        sb.append(BeanGenerator.getPackageStatement());
        sb.append(BeanGenerator.getImportStatements());
        sb.append(this.getInterfaceOpen());
        sb.append(this.getPropertyMethods());
        sb.append(this.getInvokeMethods());
        sb.append(this.getInterfaceClose());
        BeanGenerator.writeToFile(nameBuffer, sb);
    }

    private StringBuffer getInterfaceOpen() {
        Debug.trace3((String)("Generating Interface definition for: " + this.className));
        String beanDesc = I18N.loadStringFormat("BEAN_INTERFACE_JAVADOC", this.className);
        StringBuffer mofDesc = BeanGenerator.getClassDescription(this.cimClass);
        StringBuffer sb = BeanGenerator.getJavaDoc(beanDesc, mofDesc, null, 0);
        String openLine = BeanGenerator.hasContents(this.superClass) ? BeanGenerator.format("public interface {0}Bean extends {1}Bean ", this.className, this.superClass) : BeanGenerator.format("public interface {0}Bean ", this.className);
        sb.append(openLine).append("{\n").append("\n");
        return sb;
    }

    private StringBuffer getInterfaceClose() {
        StringBuffer sb = new StringBuffer("}");
        sb.append(BeanGenerator.format(" // Interface {0}Bean", this.className));
        return sb;
    }

    private StringBuffer getPropertyMethods() {
        Debug.trace3((String)("Generating Interface property definitions for: " + this.className));
        StringBuffer sb = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vProperties)) {
            return sb;
        }
        Enumeration enumeration = this.vProperties.elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cimProp = (CIMProperty)enumeration.nextElement();
            sb.append(this.generatePropertyMethods(cimProp));
        }
        return sb.append("\n");
    }

    private StringBuffer generatePropertyMethods(CIMProperty cimProp) {
        boolean hasConstants;
        StringBuffer sb = new StringBuffer();
        boolean isOverridden = BeanGenerator.hasQualifier(cimProp, "Override");
        boolean bl = hasConstants = BeanGenerator.hasQualifier(cimProp, "ValueMap") || BeanGenerator.hasQualifier(cimProp, "Values");
        if (isOverridden && !hasConstants) {
            return sb;
        }
        cimProp.setOriginClass(this.className);
        if (!isOverridden) {
            StringBuffer tmpBuffer;
            if (!hasConstants) {
                sb.append(BeanGenerator.getAccessorDoc(cimProp));
                sb.append(this.getAccessor(cimProp));
                sb.append(BeanGenerator.getMutatorDoc(cimProp));
                sb.append(this.getMutator(cimProp));
            }
            if (BeanGenerator.hasContents(tmpBuffer = BeanGenerator.getUnitsDoc(cimProp))) {
                sb.append(tmpBuffer).append(this.getUnits(cimProp));
            }
            if (BeanGenerator.hasContents(tmpBuffer = BeanGenerator.getDisplayNameDoc(cimProp))) {
                sb.append(tmpBuffer).append(this.getDisplayName(cimProp));
            }
        }
        if (hasConstants && !isOverridden) {
            sb.append(this.getConstants(cimProp));
            sb.append(this.getConstantsMethods(cimProp));
        }
        return sb;
    }

    private StringBuffer getAccessor(CIMProperty cimProp) {
        Debug.trace3((String)("Generating Interface property accessor for: " + this.className + "." + cimProp.getName()));
        String interfaceStr = BeanGenerator.format("public {0} get{1}(){2};", BeanGenerator.getPropertyDataType(cimProp).toString(), BeanGenerator.firstCharUpper(cimProp.getName()).toString(), BeanGenerator.getExceptions().toString());
        StringBuffer sb = BeanGenerator.getSourceLine(interfaceStr, 1);
        return sb.append("\n").append("\n");
    }

    private StringBuffer getMutator(CIMProperty cimProp) {
        Debug.trace3((String)("Generating Interface property mutator for: " + this.className + "." + cimProp.getName()));
        String interfaceStr = BeanGenerator.format("public void set{0}({1} {2}){3};", BeanGenerator.firstCharUpper(cimProp.getName()).toString(), BeanGenerator.getPropertyDataType(cimProp).toString(), BeanGenerator.getParameterName(cimProp.getName()), BeanGenerator.getExceptions().toString());
        StringBuffer sb = BeanGenerator.getSourceLine(interfaceStr, 1);
        return sb.append("\n").append("\n");
    }

    private StringBuffer getUnits(CIMProperty cimProp) {
        Debug.trace3((String)("Generating Interface property units accessor for: " + this.className + "." + cimProp.getName()));
        String interfaceStr = BeanGenerator.format("public String get{0}Units(){1};", BeanGenerator.firstCharUpper(cimProp.getName()).toString(), BeanGenerator.getExceptions().toString());
        StringBuffer sb = BeanGenerator.getSourceLine(interfaceStr, 1);
        return sb.append("\n").append("\n");
    }

    private StringBuffer getDisplayName(CIMProperty cimProp) {
        Debug.trace3((String)("Generating Interface property display name accessor for: " + this.className + "." + cimProp.getName()));
        String interfaceStr = BeanGenerator.format("public String get{0}DisplayName(){1};", BeanGenerator.firstCharUpper(cimProp.getName()).toString(), BeanGenerator.getExceptions().toString());
        StringBuffer sb = BeanGenerator.getSourceLine(interfaceStr, 1);
        return sb.append("\n").append("\n");
    }

    private StringBuffer getConstants(CIMProperty cimProp) {
        StringBuffer sb = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUEMAP_CONSTANTS_JAVADOC", cimProp.getName()), new StringBuffer(), null, 1);
        String prefix = cimProp.getName().toUpperCase() + "VALUE_";
        Enumeration eConstantNames = BeanGenerator.getConstantNames(cimProp, prefix).elements();
        Enumeration eConstantValues = BeanGenerator.getValuesConstantValues(cimProp).elements();
        while (eConstantNames.hasMoreElements()) {
            String constantName = (String)eConstantNames.nextElement();
            String constantValue = (String)eConstantValues.nextElement();
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public final static String {0} = new String(\"{1}\");\n", constantName, constantValue), 1));
        }
        return sb.append("\n");
    }

    private StringBuffer getConstants(CIMParameter cimParam, String name) {
        StringBuffer sb = BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUEMAP_CONSTANTS_JAVADOC", cimParam.getName(), (Object)name), new StringBuffer(), null, 1);
        String prefix = name.toUpperCase() + "_" + cimParam.getName().toUpperCase() + "VALUE_";
        Enumeration eConstantNames = BeanGenerator.getConstantNames(cimParam, prefix).elements();
        Enumeration eConstantValues = BeanGenerator.getValuesConstantValues(cimParam).elements();
        while (eConstantNames.hasMoreElements()) {
            String constantName = (String)eConstantNames.nextElement();
            String constantValue = (String)eConstantValues.nextElement();
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public final static String {0} = new String(\"{1}\");\n", constantName, constantValue), 1));
        }
        return sb.append("\n");
    }

    private StringBuffer getConstantsMethods(CIMProperty cimProp) {
        StringBuffer dataType = new StringBuffer("String");
        StringBuffer realType = BeanGenerator.getDataType(cimProp.getType());
        if (BeanGenerator.isArrayType(realType)) {
            dataType = new StringBuffer("String[]");
        }
        StringBuffer dataTypeArr = new StringBuffer("String[]");
        String propName = BeanGenerator.firstCharUpper(cimProp.getName()).toString();
        JavaDocElement javaDocElement = new JavaDocElement("@return", dataType, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", propName));
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1);
        vJavaDocElements.addElement(javaDocElement);
        StringBuffer sb = BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_ACCESSOR_JAVADOC", this.className, (Object)cimProp.getName()), BeanGenerator.getPropertyDescription(cimProp), vJavaDocElements, 1);
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2};", dataType.toString(), propName, BeanGenerator.getExceptions().toString()), 1));
        sb.append("\n").append("\n");
        javaDocElement = new JavaDocElement("@param", dataType, I18N.loadStringFormat("MUTATOR_PARAM_DESCRIPTION", propName));
        vJavaDocElements = new Vector(2);
        vJavaDocElements.addElement(javaDocElement);
        javaDocElement = new JavaDocElement("@exception", new StringBuffer("CIMException"), I18N.loadString("CIMEXCEPTION_DESCRIPTION"));
        vJavaDocElements.addElement(javaDocElement);
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("BEAN_MUTATOR_JAVADOC", this.className, (Object)cimProp.getName()), BeanGenerator.getPropertyDescription(cimProp), vJavaDocElements, 1));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public void set{0}({1} {2}){3};", propName, dataType.toString(), BeanGenerator.getParameterName(cimProp.getName()), "throws CIMException"), 1));
        sb.append("\n").append("\n");
        javaDocElement = new JavaDocElement("@return", dataTypeArr, I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
        vJavaDocElements = new Vector(1);
        vJavaDocElements.addElement(javaDocElement);
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PROP_VALUES_ACCESSOR_JAVADOC", this.className, (Object)cimProp.getName()), BeanGenerator.getPropertyDescription(cimProp), vJavaDocElements, 1));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values();", propName), 1));
        sb.append("\n").append("\n");
        return sb;
    }

    private StringBuffer getConstantsMethod(CIMParameter cimParam, String methodName) {
        StringBuffer sb = new StringBuffer();
        StringBuffer dataType = new StringBuffer("String[]");
        String paramName = BeanGenerator.firstCharUpper(cimParam.getName()).toString();
        String name = BeanGenerator.firstCharUpper(methodName).toString() + "_" + paramName;
        JavaDocElement javaDocElement = new JavaDocElement("@return", dataType, I18N.loadString("VALUESACCESSOR_RETURN_DESCRIPTION"));
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1);
        vJavaDocElements.addElement(javaDocElement);
        Object[] objArr = new Object[]{this.className, methodName, paramName};
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("PARAM_VALUES_ACCESSOR_JAVADOC", objArr), new StringBuffer(), vJavaDocElements, 1));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public String[] get{0}Values();", name), 1));
        sb.append("\n").append("\n");
        return sb;
    }

    private StringBuffer getInvokeMethods() {
        Debug.trace3((String)("Generating Interface invokeMethods for: " + this.className));
        StringBuffer sb = new StringBuffer();
        if (!BeanGenerator.hasContents(this.vMethods)) {
            return sb;
        }
        Enumeration eMethods = this.vMethods.elements();
        while (eMethods.hasMoreElements()) {
            CIMMethod cimMethod = (CIMMethod)eMethods.nextElement();
            Vector vParams = cimMethod.getParameters();
            if (BeanGenerator.hasContents(vParams)) {
                Enumeration eParams = vParams.elements();
                while (eParams.hasMoreElements()) {
                    CIMParameter cimParam = (CIMParameter)eParams.nextElement();
                    if (!BeanGenerator.hasQualifier(cimParam, "Values") && !BeanGenerator.hasQualifier(cimParam, "ValueMap")) continue;
                    sb.append(this.getConstants(cimParam, cimMethod.getName()));
                    sb.append(this.getConstantsMethod(cimParam, cimMethod.getName()));
                }
            }
            cimMethod.setOriginClass(this.className);
            sb.append(BeanGenerator.getInvokeMethodDoc(cimMethod));
            sb.append(this.getInvokeMethod(cimMethod));
            if (!BeanGenerator.hasOutParameter(cimMethod)) continue;
            BeanGenerator.writeToFile(BeanGenerator.getOutputInterfaceName(cimMethod), this.getMethodOutputInterface(cimMethod));
        }
        sb = new StringBuffer(sb.substring(0, sb.length() - 1));
        return sb.append("\n");
    }

    private StringBuffer getInvokeMethod(CIMMethod cimMethod) {
        Debug.trace3((String)("Generating Interface invokeMethod for: " + this.className + "." + cimMethod.getName()));
        String interfaceStr = BeanGenerator.format("public {0} {1}({2}){3};", BeanGenerator.getDataType(cimMethod.getType()).toString(), cimMethod.getName(), BeanGenerator.getInvokeMethodParams(cimMethod).toString(), BeanGenerator.getInvokeMethodExceptions().toString());
        StringBuffer sb = BeanGenerator.getSourceLine(interfaceStr, 1);
        return sb.append("\n").append("\n");
    }

    private StringBuffer getMethodOutputInterface(CIMMethod cimMethod) {
        StringBuffer sb = new StringBuffer();
        String interfaceName = BeanGenerator.getOutputInterfaceName(cimMethod).toString();
        sb.append(BeanGenerator.getFileHeader());
        sb.append(BeanGenerator.getPackageStatement());
        sb.append(BeanGenerator.getImportStatements());
        sb.append(BeanGenerator.getJavaDoc(I18N.loadStringFormat("METHODOUTPUT_INTERFACE_JAVADOC", cimMethod.getOriginClass(), (Object)cimMethod.getName()), BeanGenerator.getMethodDescription(cimMethod), null, 0));
        sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public interface {0} ", interfaceName) + "{\n" + "\n", 0));
        CIMParameter[] outParams = BeanGenerator.getOutParameters(cimMethod);
        Vector<JavaDocElement> vJavaDocElements = new Vector<JavaDocElement>(1);
        for (int i = 0; i < outParams.length; ++i) {
            CIMParameter cimParam = outParams[i];
            String paramName = BeanGenerator.firstCharUpper(cimParam.getName()).toString();
            StringBuffer dataType = BeanGenerator.getDataType(cimParam.getType());
            vJavaDocElements.addElement(new JavaDocElement("@return", dataType, I18N.loadStringFormat("ACCESSOR_RETURN_DESCRIPTION", paramName)));
            sb.append(BeanGenerator.getJavaDoc(BeanGenerator.format(I18N.loadString("METHODOUTPUT_ACCESSOR_JAVADOC"), paramName, cimMethod.getOriginClass(), cimMethod.getName()), new StringBuffer(), vJavaDocElements, 1));
            sb.append(BeanGenerator.getSourceLine(BeanGenerator.format("public {0} get{1}(){2};", dataType.toString(), paramName, ""), 1)).append("\n").append("\n");
            vJavaDocElements.removeAllElements();
        }
        sb.append(BeanGenerator.getSourceLine("}" + BeanGenerator.format(" // Interface {0}", interfaceName), 0));
        return sb;
    }
}

