/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.wbemservices.wbem.compiler.mofc.I18N;

public class LogFile {
    public static final int DEVELOPMENT = 4;
    public static final int DEBUG = 3;
    public static final int INFORMATIONAL = 2;
    public static final int WARNING = 1;
    public static final int CRITICAL = 0;
    private static final String newLine = "\n";
    private static boolean started = false;
    private static int logLevel = 1;
    private static DataOutputStream fStream;
    private static String fileName;
    private static boolean verbose;

    public static void add(int level, String resourceID) {
        if (logLevel >= level) {
            LogFile.addInfo(I18N.loadString(resourceID));
        }
    }

    public static void add(int level, String resourceID, Object[] obj) {
        if (logLevel >= level) {
            MessageFormat mf = new MessageFormat(I18N.loadString(resourceID));
            mf.setLocale(I18N.locale);
            for (int i = 0; i < obj.length; ++i) {
                obj[i] = obj[i].toString();
            }
            LogFile.addInfo(mf.format(obj));
        }
    }

    public static void add(int level, String resourceID, Object info1, Object info2, Object info3) {
        LogFile.add(level, resourceID, new Object[]{info1, info2, info3});
    }

    public static void add(int level, String resourceID, Object info1, Object info2) {
        LogFile.add(level, resourceID, new Object[]{info1, info2});
    }

    public static void add(int level, String resourceID, Object info) {
        LogFile.add(level, resourceID, new Object[]{info});
    }

    public static void add(int level, InputStream in) {
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(new DataInputStream(in)));
        try {
            String line;
            while ((line = fileReader.readLine()) != null) {
                if (logLevel < level) continue;
                LogFile.addInfo(line);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void methodEntry(String methodName) {
        LogFile.add(4, "METHOD_ENTRY", methodName);
    }

    public static void methodReturn(String methodName) {
        LogFile.add(4, "METHOD_RETURN", methodName);
    }

    private static void addInfo(String info) {
        if (started) {
            try {
                if (verbose) {
                    System.out.println(info);
                    System.out.println(newLine);
                }
                fStream.writeBytes(info);
                fStream.writeBytes(newLine);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getFileName() {
        return fileName;
    }

    public static int getLevel() {
        return logLevel;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean b) {
        verbose = b;
    }

    public static void setFileName(String name) {
        fileName = name;
    }

    public static void setLevel(int level) {
        logLevel = level;
    }

    public static void start() {
        LogFile.start(fileName);
    }

    public static void start(String fName) {
        fileName = fName;
        try {
            File f = new File(fileName);
            if (f.exists()) {
                File fBak = new File(fileName + ".bak");
                if (fBak.exists()) {
                    if (fBak.delete()) {
                        f.renameTo(fBak);
                    } else {
                        f.delete();
                    }
                } else {
                    f.renameTo(fBak);
                }
            }
            fStream = new DataOutputStream(new FileOutputStream(f));
        }
        catch (IOException e) {
            System.out.println("LogFile:" + e);
            System.exit(1);
        }
        started = true;
        LogFile.writeHeader();
    }

    public static void stop() {
        LogFile.writeFooter();
        try {
            fStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeFooter() {
        try {
            fStream.writeBytes("Completed: " + DateFormat.getDateTimeInstance(0, 0, I18N.locale).format(new Date()) + newLine);
            fStream.writeBytes(newLine);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeHeader() {
        String[] logNames = new String[]{"CRITICAL", "WARNING", "INFORMATION", "DEBUG", "DEVELOPMENT"};
        try {
            fStream.writeBytes("Started:" + DateFormat.getDateTimeInstance(0, 0, I18N.locale).format(new Date()) + newLine);
            fStream.writeBytes("Log Level: " + logNames[logLevel] + newLine);
            fStream.writeBytes(newLine);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        fileName = "logfile.log";
        verbose = false;
    }
}

