/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.io.BufferedWriter;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.wbemservices.wbem.compiler.mofc.BeanBaseWriter;
import org.wbemservices.wbem.compiler.mofc.BeanGenerator;
import org.wbemservices.wbem.compiler.mofc.CIM_Mofc;
import org.wbemservices.wbem.compiler.mofc.I18N;
import org.wbemservices.wbem.compiler.mofc.LocalCIMClient;
import org.wbemservices.wbem.compiler.mofc.LogFile;
import org.wbemservices.wbem.compiler.mofc.MofcCIMValue;
import org.wbemservices.wbem.compiler.mofc.XmlWriter;

public class MofcBackend {
    private CIMOMHandle clientAPI;
    private CIMOMHandle rootClient;
    private CIM_Mofc parser;
    private UserPrincipal up;
    private PasswordCredential pc;
    public String fileName;
    public int lineNo;
    public int parsePhase;
    private String cimhost;
    private boolean setQual;
    private boolean setClass;
    private boolean setInstance;
    private boolean BEAN;
    private boolean deleteMode;
    private boolean XML;
    private boolean BUILD;
    private BufferedWriter xmlOut;
    private BufferedWriter bigxmlOut;
    private XmlWriter xmlwriter;
    private String qualDebug;
    private String classDebug;
    private String instanceDebug;
    private boolean connectToCimom;
    private String protocol;
    private String beanPackage;
    private String beanImports;
    private String beanExceptions;
    private String beanDir;
    private static final String NSDELETEMODE = "__delete";
    private static final String NSCREATEMODE = "__create";
    private static final String NSMODIFYMODE = "__modify";
    public Hashtable classAliases;
    public Hashtable instanceAliases;
    public Hashtable instanceAliasesNS;
    public Vector qualifiers;
    public Vector properties;
    public Vector methods;
    public Vector parameters;
    public boolean erroneousUnit;
    public boolean erroneousPart;
    public boolean erroneousQualifierList;
    public int refsRequired;
    public int keysRequired;
    public CIMNameSpace curNameSpace;
    public String curSchema;
    public CIMClass curClassEl;
    public CIMProperty curPropRefEl;
    public CIMMethod curMethodEl;
    public CIMQualifier curQualifierEl;
    public CIMQualifierType curQualifierTypeEl;
    public CIMParameter curParameterEl;
    public CIMInstance curInstanceEl;
    public CIMProperty curIPropertyEl;
    public String curLevel;
    public CIMDataType curType;
    public String curValueType;
    public MofcCIMValue curValues;
    public int size;
    public String curInstanceAlias;
    public String curClassAlias;
    public boolean print_MOFComp;

    void HOLG_START(String a) {
        LogFile.add(4, "METHOD_START", a);
    }

    void HOLG_PRINT(String a) {
        LogFile.add(4, "NONE", a);
    }

    void HOLG_PRINT_ELEMENT(CIMElement a) {
        LogFile.add(4, "NONE", a);
    }

    void HOLG_END(String a) {
        LogFile.add(4, "METHOD_END", a);
    }

    void reportWarning(String errorType, String error, String data) {
        Integer lineNo = new Integer(this.parser.getCurrentLine());
        LogFile.add(0, "ERROR_WARNING", this.fileName, lineNo);
        LogFile.add(0, errorType);
        LogFile.add(0, error, new Object[]{data});
        System.err.println(I18N.loadStringFormat("ERROR_WARNING", this.fileName, lineNo));
        System.err.println(I18N.loadString(errorType));
        System.err.println(I18N.loadStringFormat(error, data));
    }

    void reportError(String errorType, String error, int exit, String data) throws CIMException {
        Integer lineNo = new Integer(this.parser.getCurrentLine());
        LogFile.add(0, "ERROR_LINE", this.fileName, lineNo);
        LogFile.add(0, errorType);
        LogFile.add(0, error, new Object[]{data});
        if (this.parser.isInvoked) {
            throw new CIMException("CIM_ERR_FAILED", new Object[]{this.fileName, lineNo, errorType, error, data});
        }
        System.err.println(I18N.loadStringFormat("ERROR_LINE", this.fileName, lineNo));
        System.err.println(I18N.loadString(errorType));
        System.err.println(I18N.loadStringFormat(error, data));
        System.exit(exit);
    }

    void setParsePhase(int phase) {
        if (phase == 2 && (this.parser.mode == 1 || this.parser.mode == 2)) {
            this.deleteMode = false;
            this.setQual = false;
            this.setClass = false;
            this.setInstance = false;
            this.deleteMode = false;
        }
        this.parsePhase = phase;
    }

    public void cleanup() throws CIMException {
        if (this.rootClient != null) {
            this.rootClient.close();
        }
        if (this.clientAPI != null) {
            this.clientAPI.close();
        }
    }

    public MofcBackend(Hashtable clht, CIM_Mofc parser) throws RemoteException, MalformedURLException, NotBoundException, Exception {
        block15: {
            this.clientAPI = null;
            this.rootClient = null;
            this.up = null;
            this.pc = null;
            this.fileName = "";
            this.lineNo = 0;
            this.parsePhase = 1;
            this.setQual = false;
            this.setClass = false;
            this.setInstance = false;
            this.BEAN = false;
            this.deleteMode = false;
            this.XML = false;
            this.BUILD = false;
            this.xmlwriter = new XmlWriter();
            this.qualDebug = "ADDING_QUALIFIERTYPE";
            this.classDebug = "ADDING_CLASS";
            this.instanceDebug = "ADDING_INSTANCE";
            this.connectToCimom = true;
            this.protocol = "cim-rmi";
            this.beanPackage = "";
            this.beanImports = "";
            this.beanExceptions = "";
            this.beanDir = "";
            this.curNameSpace = new CIMNameSpace();
            this.curSchema = "";
            this.parser = parser;
            String standalone = (String)clht.get("standalone");
            if (standalone != null) {
                boolean bl = this.connectToCimom = standalone.compareToIgnoreCase("true") != 0;
                if (!this.connectToCimom) {
                    System.setProperty("logdir", (String)clht.get("logdir"));
                    System.setProperty("passAllProviderCheck", "true");
                }
            }
            this.connectToCimom &= !parser.isInvoked;
            String username = (String)clht.get("username");
            String password = (String)clht.get("password");
            if (username != null && username.length() != 0) {
                if (password == null) {
                    System.out.print(I18N.loadString("PASSWORD"));
                    byte[] a = new byte[20];
                    System.in.read(a, 0, 20);
                    for (int i = 0; i < a.length; ++i) {
                        if (a[i] != 10) continue;
                        a[i] = 0;
                        break;
                    }
                    password = new String(a);
                }
                this.up = new UserPrincipal(username);
                this.pc = new PasswordCredential(password);
            }
            if (clht.get("-H") != null) {
                this.protocol = "cim-xml";
            }
            this.cimhost = (String)clht.get("cimhost");
            if (this.cimhost == null || this.cimhost.length() == 0) {
                this.cimhost = "localhost";
            }
            Object object = this.rootClient = this.connectToCimom ? new CIMClient(new CIMNameSpace(this.cimhost, ""), (Principal)this.up, (Object)this.pc, this.protocol) : new LocalCIMClient(new CIMNameSpace(this.cimhost, ""), (Principal)this.up, this.pc, parser.callBack);
            if (clht.get("-j") != null) {
                this.BEAN = true;
                this.beanPackage = (String)clht.get("beanPackage");
                this.beanImports = (String)clht.get("beanImports");
                this.beanExceptions = (String)clht.get("beanExceptions");
                String dir = (String)clht.get("logdir");
                this.beanDir = dir == null ? System.getProperty("user.dir") : dir;
                BeanBaseWriter beanBaseWriter = new BeanBaseWriter(this.beanPackage, new File(this.beanDir));
            }
            if (clht.get("-x") != null) {
                this.XML = true;
            }
            if (clht.get("-b") != null) {
                this.BUILD = true;
            }
            if (clht.get("-Q") != null) {
                this.setQual = true;
                this.qualDebug = "SETTING_QUALIFIERTYPE";
            }
            if (clht.get("-C") != null) {
                this.setClass = true;
                this.classDebug = "SETTING_CLASS";
            }
            if (clht.get("-I") != null) {
                this.setInstance = true;
                this.instanceDebug = "SETTING_INSTANCE";
            }
            this.curNameSpace.setHost(this.cimhost);
            try {
                this.rootClient.createNameSpace(this.curNameSpace);
            }
            catch (CIMException e) {
                if (e.getID().equals("CIM_ERR_ALREADY_EXISTS") || e.getID().equals("CIM_ERR_ACCESS_DENIED")) break block15;
                throw e;
            }
        }
        CIMNameSpace cns = new CIMNameSpace();
        cns.setHost(this.cimhost);
        this.clientAPI = this.connectToCimom ? new CIMClient(cns, (Principal)this.up, (Object)this.pc, this.protocol) : new LocalCIMClient(cns, (Principal)this.up, this.pc, parser.callBack);
        this.classAliases = new Hashtable();
        this.qualifiers = new Vector();
        this.properties = new Vector();
        this.methods = new Vector();
        this.instanceAliases = new Hashtable();
        this.instanceAliasesNS = new Hashtable();
        this.parameters = new Vector();
        this.erroneousUnit = false;
        this.erroneousPart = false;
        this.erroneousQualifierList = false;
        this.refsRequired = 0;
        this.keysRequired = 0;
        this.curClassEl = new CIMClass();
        this.curPropRefEl = new CIMProperty();
        this.curMethodEl = new CIMMethod();
        this.curQualifierEl = new CIMQualifier();
        this.curQualifierTypeEl = new CIMQualifierType();
        this.curParameterEl = new CIMParameter();
        this.curInstanceEl = new CIMInstance();
        this.curIPropertyEl = new CIMProperty();
        this.curType = null;
        this.curInstanceAlias = null;
        this.curClassAlias = null;
        this.curValueType = "";
        this.curValues = new MofcCIMValue();
        this.size = 0;
        this.print_MOFComp = false;
    }

    public String toString() {
        return new String("MofcBackend:\nNamespaceTable:\nEnd of NamespaceTable\nQualifierTypesTable:\nEnd of QualifierTypesTable\nEnd of MofcBackend\n");
    }

    public void resetAfterSyntaxError() {
        this.HOLG_START("resetAfterSyntaxError");
        this.qualifiers = new Vector();
        this.properties = new Vector();
        this.methods = new Vector();
        this.parameters = new Vector();
        this.erroneousUnit = false;
        this.erroneousPart = false;
        this.erroneousQualifierList = false;
        this.refsRequired = 0;
        this.keysRequired = 0;
        this.curClassEl = new CIMClass();
        this.curPropRefEl = new CIMProperty();
        this.curMethodEl = new CIMMethod();
        this.curQualifierEl = new CIMQualifier();
        this.curParameterEl = new CIMParameter();
        this.curInstanceEl = new CIMInstance();
        this.curIPropertyEl = new CIMProperty();
        this.curInstanceAlias = null;
        this.curClassAlias = null;
        this.curType = null;
        this.curValueType = "";
        this.curValues = new MofcCIMValue();
        this.size = 0;
        this.HOLG_END("resetAfterSyntaxError");
    }

    public void switchNamespace(String newNamespace) throws CIMException {
        this.HOLG_START("switchNamespace");
        if (this.parser.mode == 1 || this.parser.mode == 2) {
            if (newNamespace.equals(NSCREATEMODE)) {
                Debug.trace3((String)"Going to create mode");
                this.setQual = false;
                this.setClass = false;
                this.setInstance = false;
                this.deleteMode = false;
                return;
            }
            if (newNamespace.equals(NSMODIFYMODE)) {
                Debug.trace3((String)"Going to set mode");
                this.setQual = true;
                this.setClass = true;
                this.setInstance = true;
                this.deleteMode = false;
                return;
            }
            if (newNamespace.equals(NSDELETEMODE)) {
                this.deleteMode = true;
                return;
            }
        }
        if (this.parsePhase == 1) {
            return;
        }
        this.curNameSpace.setNameSpace(newNamespace);
        try {
            this.rootClient.createNameSpace(this.curNameSpace);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.clientAPI.close();
            this.clientAPI = null;
            this.clientAPI = this.connectToCimom ? new CIMClient(this.curNameSpace, (Principal)this.up, (Object)this.pc, this.protocol) : new LocalCIMClient(this.curNameSpace, (Principal)this.up, this.pc, this.parser.callBack);
        }
        catch (Exception e) {
            if (e instanceof CIMException) {
                this.reportError("ERR_EXC", "ERR_CIMOM_CONNECTION", 1, this.parser.toStringCIMException((CIMException)((Object)e)));
            }
            this.reportError("ERR_EXC", "ERR_CIMOM_CONNECTION", 1, e.toString());
        }
        this.HOLG_END("switchNamespace");
    }

    public void assignSchemaName(String schemaName) throws CIMException {
        this.HOLG_START("assignSchemaName");
        if (schemaName.indexOf("_") >= 0) {
            this.reportError("ERR_SEM", "ERR_ILLEGAL_SCHEMA_NAME", 1, schemaName);
        } else {
            this.curSchema = schemaName.substring(1, schemaName.length() - 1);
        }
        this.HOLG_END("assignSchemaName");
    }

    public void assignQualifierTypeScope(CIMScope applies) {
        this.HOLG_START("assignQualifierTypeScope");
        this.curQualifierTypeEl.addScope(applies);
        this.HOLG_END("assignQualifierTypeScope");
    }

    public void assignQualifierTypeFlavor(CIMFlavor newFlavor) {
        this.HOLG_START("assignQualifierTypeFlavor");
        this.curQualifierTypeEl.addFlavor(newFlavor);
        this.HOLG_END("assignQualifierTypeFlavor");
    }

    public void addQualifierType() throws CIMException {
        this.HOLG_START("addQualifierType");
        if (this.erroneousPart) {
            this.erroneousUnit = true;
        }
        if (!this.erroneousUnit) {
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curQualifierTypeEl);
            if (this.parsePhase == 2) {
                try {
                    LogFile.add(3, this.qualDebug, this.curQualifierTypeEl.getName());
                    if (this.parser.isVerbose()) {
                        System.out.println(I18N.loadStringFormat(this.qualDebug, this.curQualifierTypeEl.getName()));
                    }
                    if (this.setQual) {
                        this.clientAPI.setQualifierType(new CIMObjectPath(this.curQualifierTypeEl.getName()), this.curQualifierTypeEl);
                    } else {
                        this.clientAPI.createQualifierType(new CIMObjectPath(this.curQualifierTypeEl.getName()), this.curQualifierTypeEl);
                    }
                    if (this.XML && this.BUILD) {
                        this.xmlwriter.writeBigXml(this.curQualifierTypeEl, this.bigxmlOut);
                    }
                }
                catch (CIMException e) {
                    if (e.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setQual || e.getID().equals("CIM_ERR_NOT_FOUND") && this.setQual) {
                        this.reportWarning("ERR_SEM", "ERR_SETTING_QUALIFIER_TYPE", this.parser.toStringCIMException(e));
                    } else {
                        this.reportError("ERR_SEM", "ERR_SETTING_QUALIFIER_TYPE", 1, this.parser.toStringCIMException(e));
                    }
                }
                catch (Exception e) {
                    this.reportError("ERR_EXC", "ERR_SETTING_QUALIFIER_TYPE", 1, e.toString());
                }
            }
        }
        this.curQualifierTypeEl = new CIMQualifierType();
        this.HOLG_END("addQualifierType");
    }

    public void assignQualifierNameType(String qualifierName) {
        this.HOLG_START("assignQualifierNameType");
        this.curQualifierEl.setName(qualifierName);
        this.HOLG_PRINT(qualifierName);
        this.HOLG_END("assignQualifierNameType");
    }

    public void assignQualifierParameter(boolean arrayType) {
        this.HOLG_START("assignQualifierParameter");
        if (!this.erroneousQualifierList && !this.curValues.isEmpty()) {
            CIMValue cv = arrayType ? new CIMValue((Object)this.curValues.vVector) : new CIMValue(this.curValues.firstElement());
            this.curQualifierEl.setValue(cv);
        }
        this.curValues = new MofcCIMValue();
        this.HOLG_END("assignQualifierParameter");
    }

    public void assignQualifierFlavor(CIMFlavor newFlavor) {
        this.HOLG_START("assignQualifierFlavor");
        this.curQualifierEl.addFlavor(newFlavor);
        this.HOLG_END("assignQualifierFlavor");
    }

    public void addQualifier() {
        this.HOLG_START("addQualifier");
        if (!this.erroneousQualifierList) {
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curQualifierEl);
            this.qualifiers.addElement(this.curQualifierEl);
        }
        this.curQualifierEl = new CIMQualifier();
        this.HOLG_END("addQualifier");
    }

    public void checkQualifierList() throws CIMException {
        this.HOLG_START("checkQualifierList");
        if (!this.erroneousQualifierList && this.qualifiers.contains(new CIMQualifier("ASSOCIATION")) && !((CIMQualifier)this.qualifiers.firstElement()).getName().equalsIgnoreCase("association")) {
            this.erroneousQualifierList = true;
            this.reportError("ERR_SEM", "ERR_ASSOC_QUALIFIER_MISUSE", 1, "");
        }
        this.HOLG_END("checkQualifierList");
    }

    public void assignClassName(String className) throws CIMException {
        this.HOLG_START("assignClassName");
        if (className.indexOf("_") < 0) {
            if (this.curSchema.length() == 0) {
                this.reportError("ERR_SEM", "ERR_ILLEGAL_SCHEMA_NAME", 1, this.curSchema);
            } else {
                className = this.curSchema + "_" + className;
            }
        }
        this.curClassEl.setName(className);
        this.HOLG_PRINT(className);
        this.HOLG_END("assignClassName");
    }

    public void assignClassAlias(String aliasName) {
        this.HOLG_START("assignClassAlias");
        if (this.parsePhase == 1) {
            this.curClassAlias = aliasName;
        }
        this.HOLG_END("assignClassAlias");
    }

    public void assignSuperclassName(String superclassName) {
        this.HOLG_START("assignSuperclassName");
        this.curClassEl.setSuperClass(superclassName);
        this.HOLG_PRINT(superclassName);
        this.HOLG_END("assignSuperclassName");
    }

    public void assignClassQualifiers() {
        this.HOLG_START("assignClassQualifiers");
        if (!this.erroneousUnit) {
            CIMValue Tmp;
            int tempIndex = this.qualifiers.indexOf(new CIMQualifier("association"));
            CIMQualifier qe = tempIndex >= 0 ? (CIMQualifier)this.qualifiers.elementAt(tempIndex) : null;
            if (qe != null && (Tmp = qe.getValue()) != null && Tmp.equals((Object)CIMValue.TRUE)) {
                this.curClassEl.setIsAssociation(true);
                this.curLevel = "ASSOCIATION";
            }
            if (!this.erroneousPart) {
                this.curClassEl.setQualifiers(this.qualifiers);
            }
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignClassQualifiers");
    }

    public void setFile(BufferedWriter out) {
        this.xmlOut = out;
    }

    public void setBigFile(BufferedWriter out) {
        this.bigxmlOut = out;
    }

    public void addClass() throws CIMException {
        block21: {
            this.HOLG_START("addClass");
            this.HOLG_START("addClass");
            this.curClassEl.setProperties(this.properties);
            this.curClassEl.setMethods(this.methods);
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curClassEl);
            if (this.parser.mode == 1 && this.deleteMode) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", NSDELETEMODE);
            }
            if (this.parsePhase == 2) {
                try {
                    CIMClass curClass;
                    LogFile.add(3, this.classDebug, this.curClassEl.getName());
                    if (this.parser.isVerbose()) {
                        System.out.println(I18N.loadStringFormat(this.classDebug, this.curClassEl.getName()));
                    }
                    if (this.deleteMode) {
                        this.clientAPI.deleteClass(new CIMObjectPath(this.curClassEl.getName()));
                    } else if (this.setClass) {
                        this.clientAPI.setClass(new CIMObjectPath(this.curClassEl.getName()), this.curClassEl);
                    } else {
                        this.clientAPI.createClass(new CIMObjectPath(this.curClassEl.getName()), this.curClassEl);
                    }
                    if (this.XML) {
                        curClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), false, true, true, null);
                        this.xmlwriter.writeClass(curClass);
                        if (this.BUILD) {
                            this.xmlwriter.writeAllClasses(curClass, this.xmlOut);
                            this.xmlwriter.writeBigXml(curClass, this.bigxmlOut);
                        }
                    }
                    if (this.BEAN) {
                        curClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), true, true, true, null);
                        BeanGenerator bg = new BeanGenerator(this.clientAPI, curClass, this.beanPackage, this.beanImports, this.beanExceptions, new File(this.beanDir));
                    }
                }
                catch (CIMException e) {
                    if (e.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setClass || e.getID().equals("CIM_ERR_NOT_FOUND") && (this.setClass || this.deleteMode)) {
                        CIMClass curClass;
                        this.reportWarning("ERR_SEM", "ERR_EXC_SET_CLASS", this.parser.toStringCIMException(e));
                        if (this.XML && e.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setClass) {
                            try {
                                curClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), false, true, true, null);
                                this.xmlwriter.writeClass(curClass);
                                if (this.BUILD) {
                                    this.xmlwriter.writeAllClasses(curClass, this.xmlOut);
                                    this.xmlwriter.writeBigXml(curClass, this.bigxmlOut);
                                }
                            }
                            catch (CIMException e2) {
                                // empty catch block
                            }
                        }
                        if (this.BEAN && e.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                            curClass = this.clientAPI.getClass(new CIMObjectPath(this.curClassEl.getName()), true, true, true, null);
                            BeanGenerator beanGenerator = new BeanGenerator(this.clientAPI, curClass, this.beanPackage, this.beanImports, this.beanExceptions, new File(this.beanDir));
                        }
                        break block21;
                    }
                    this.reportError("ERR_SEM", "ERR_EXC_SET_CLASS", 1, this.parser.toStringCIMException(e));
                }
                catch (Exception e) {
                    this.reportError("ERR_EXC", "ERR_EXC_SET_CLASS", 1, e.toString());
                }
            } else if (this.curClassAlias != null) {
                this.classAliases.put(this.curClassAlias, this.curClassEl.getName());
            }
        }
        this.keysRequired = 0;
        this.curClassEl = new CIMClass();
        this.curClassAlias = null;
        this.properties = new Vector();
        this.methods = new Vector();
        this.HOLG_END("addClass");
    }

    public void assignFeatureName(String featureName) throws CIMException {
        this.HOLG_START("assignFeatureName");
        if (this.properties.contains(new CIMProperty(featureName)) || this.methods.contains(new CIMMethod(featureName))) {
            this.erroneousPart = true;
            this.reportError("ERR_SEM", "ERR_FEATURE_REDEFINED", 1, this.curClassEl.getName());
        } else {
            this.curPropRefEl.setName(featureName);
            this.curMethodEl.setName(featureName);
            this.HOLG_PRINT(featureName);
        }
        this.HOLG_END("assignFeatureName");
    }

    public void assignPropertyQualifiers() {
        this.HOLG_START("assignPropertyQualifiers");
        if (!this.erroneousPart) {
            this.curPropRefEl.setQualifiers(this.qualifiers);
            CIMQualifier cq = this.curPropRefEl.getQualifier("key");
            if (cq != null) {
                CIMValue cv = cq.getValue();
                if (cv != null) {
                    if (cv.getValue().equals(new Boolean(true))) {
                        this.curPropRefEl.setKey(true);
                    }
                } else {
                    this.curPropRefEl.setKey(true);
                }
            }
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignPropertyQualifiers");
    }

    public void addProperty() {
        this.HOLG_START("addProperty");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curPropRefEl);
            this.verifyQualifiers(this.curPropRefEl);
            this.properties.addElement(this.curPropRefEl);
        } else {
            this.erroneousUnit = true;
        }
        this.curPropRefEl = new CIMProperty();
        this.HOLG_END("addProperty");
    }

    public void assignRefClassName(CIMDataType refClassType) {
        this.HOLG_START("assignRefClassName");
        this.curPropRefEl.setType(refClassType);
        this.HOLG_PRINT(refClassType.toString());
        this.HOLG_END("assignRefClassName");
    }

    public void assignReferenceQualifiers() throws CIMException {
        this.HOLG_START("assignReferenceQualifiers");
        if (!this.erroneousPart) {
            try {
                this.curPropRefEl.setQualifiers(this.qualifiers);
            }
            catch (Exception e) {
                this.reportError("ERR_EXC", "ERR_EXC_SET_QUAL", 1, e.toString());
            }
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignReferenceQualifiers");
    }

    public void addReference() {
        this.HOLG_START("addReference");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            --this.refsRequired;
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curPropRefEl);
            this.properties.addElement(this.curPropRefEl);
        }
        this.curPropRefEl = new CIMProperty();
        this.HOLG_END("addReference");
    }

    public void assignMethodQualifiers() {
        this.HOLG_START("assignMethodQualifiers");
        this.curMethodEl.setQualifiers(this.qualifiers);
        this.qualifiers = new Vector();
        this.HOLG_END("assignMethodQualifiers");
    }

    public void assignMethodParameters() {
        this.HOLG_START("assignMethodParameters");
        if (!this.erroneousPart) {
            this.curMethodEl.setParameters(this.parameters);
        }
        this.parameters = new Vector();
        this.HOLG_END("assignMethodParameters");
    }

    public void addMethod() {
        this.HOLG_START("addMethod");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            this.methods.addElement(this.curMethodEl);
            this.HOLG_PRINT(this.curMethodEl.getName());
        } else {
            this.erroneousUnit = true;
        }
        this.curMethodEl = new CIMMethod();
        this.HOLG_END("addMethod");
    }

    public void assignParameterName(String ParameterName) throws CIMException {
        this.HOLG_START("assignParameterName");
        if (this.parameters.contains(new CIMParameter(ParameterName))) {
            this.reportError("ERR_SEM", "ERR_PARAMETER_EXISTS", 2, ParameterName);
        } else {
            this.curParameterEl.setName(ParameterName);
            this.HOLG_PRINT(ParameterName);
        }
        this.HOLG_END("assignParameterName");
    }

    public void assignParameterQualifiers() {
        this.HOLG_START("assignParameterQualifiers");
        if (!this.erroneousPart) {
            this.curParameterEl.setQualifiers(this.qualifiers);
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignParameterQualifiers");
    }

    public void addParameter() {
        this.HOLG_START("addParameter");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            this.parameters.addElement(this.curParameterEl);
            this.HOLG_PRINT(this.curParameterEl.getName());
        } else {
            this.erroneousUnit = true;
        }
        this.curParameterEl = new CIMParameter();
        this.HOLG_END("addParameter");
    }

    public void assignInstanceClass(String instanceClass) {
        this.HOLG_START("assignInstanceClass");
        this.curInstanceEl.setClassName(instanceClass);
        this.HOLG_PRINT(instanceClass);
        this.HOLG_END("assignInstanceClass");
    }

    public void assignInstanceAlias(String aliasName) {
        this.HOLG_START("assignInstanceAlias");
        if (this.parsePhase == 1) {
            this.curInstanceAlias = aliasName;
        }
        this.HOLG_END("assignInstanceAlias");
    }

    public void assignInstanceQualifiers() {
        this.HOLG_START("assignInstanceQualifiers");
        if (!this.erroneousUnit) {
            this.curInstanceEl.setQualifiers(this.qualifiers);
        }
        this.qualifiers = new Vector();
        this.HOLG_END("assignInstanceQualifiers");
    }

    public void assignInstancePropertyQualifiers() {
        this.HOLG_START("addInstancePropertyQualifiers");
        this.HOLG_END("addInstancePropertyQualifiers");
    }

    public void addInstanceProperty() {
        this.HOLG_START("addInstanceProperty");
        if (this.erroneousUnit) {
            this.erroneousPart = true;
        }
        if (!this.erroneousPart) {
            block7: {
                try {
                    CIMClass cClass = this.clientAPI.getClass(this.curInstanceEl.getObjectPath(), false, false, false, null);
                    CIMProperty cp = cClass.getProperty(this.curIPropertyEl.getName());
                    if (cp.isReference()) {
                        CIMValue cv = cp.getValue();
                        if (this.curIPropertyEl.getValue().getValue() instanceof String) {
                            CIMValue cv2 = new CIMValue((Object)new CIMObjectPath((String)this.curIPropertyEl.getValue().getValue()), cv.getType());
                            cp.setValue(cv2);
                            this.curIPropertyEl = cp;
                        }
                    }
                }
                catch (Exception e) {
                    if (this.parsePhase != 1) break block7;
                    return;
                }
            }
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curIPropertyEl);
            this.properties.addElement(this.curIPropertyEl);
        } else {
            this.erroneousUnit = true;
        }
        this.curIPropertyEl = new CIMProperty();
        this.HOLG_END("addInstanceProperty");
    }

    public void addInstance() throws CIMException {
        this.HOLG_START("addInstance");
        if (this.erroneousPart) {
            this.erroneousUnit = true;
        }
        if (!this.erroneousUnit) {
            block12: {
                this.curInstanceEl.setProperties(this.properties);
                if (this.parsePhase == 2) {
                    try {
                        LogFile.add(3, this.instanceDebug, this.curInstanceEl.getObjectPath());
                        if (this.parser.isVerbose()) {
                            System.out.println(I18N.loadStringFormat(this.instanceDebug, this.curInstanceEl.getObjectPath()));
                        }
                        if (this.deleteMode) {
                            CIMObjectPath instanceOp = new CIMObjectPath();
                            instanceOp.setObjectName(this.curInstanceEl.getClassName());
                            instanceOp.setKeys(this.curInstanceEl.getProperties());
                            this.clientAPI.deleteInstance(instanceOp);
                            break block12;
                        }
                        if (this.setInstance) {
                            this.clientAPI.setInstance(new CIMObjectPath(this.curInstanceEl.getClassName()), this.curInstanceEl);
                            break block12;
                        }
                        this.clientAPI.createInstance(new CIMObjectPath(this.curInstanceEl.getClassName()), this.curInstanceEl);
                    }
                    catch (CIMException e) {
                        if (e.getID().equals("CIM_ERR_ALREADY_EXISTS") && !this.setInstance || e.getID().equals("CIM_ERR_NOT_FOUND") && (this.setInstance || this.deleteMode)) {
                            this.reportWarning("ERR_SEM", "ERR_EXC_SET_INST", this.parser.toStringCIMException(e));
                            break block12;
                        }
                        this.reportError("ERR_SEM", "ERR_EXC_SET_INST", 1, this.parser.toStringCIMException(e));
                    }
                    catch (Exception e) {
                        this.reportError("ERR_EXC", "ERR_EXC_SET_INST", 1, e.toString());
                    }
                } else if (this.curInstanceAlias != null) {
                    this.instanceAliases.put(this.curInstanceAlias, this.curInstanceEl);
                    this.instanceAliasesNS.put(this.curInstanceAlias, this.curNameSpace);
                }
            }
            this.HOLG_PRINT_ELEMENT((CIMElement)this.curInstanceEl);
        }
        this.curInstanceEl = new CIMInstance();
        this.curInstanceAlias = null;
        this.properties = new Vector();
        this.HOLG_END("addInstance");
    }

    public CIMObjectPath getInstanceName(String aliasName) throws CIMException {
        if (this.parsePhase == 1) {
            return new CIMObjectPath();
        }
        Object o = null;
        CIMInstance ci = null;
        o = this.instanceAliases.get(aliasName);
        if (o == null) {
            this.reportError("ERR_SEM", "NO_SUCH_ALIAS", 1, aliasName);
        }
        if (o instanceof CIMObjectPath) {
            return o;
        }
        ci = o;
        CIMObjectPath op = new CIMObjectPath(ci.getClassName());
        CIMInstance nci = null;
        try {
            CIMClass cc = this.clientAPI.getClass(op, false, true, true, null);
            nci = cc.newInstance();
        }
        catch (Exception e) {
            this.reportError("ERR_SEM", "ERR_NO_SUCH_CLASS", 1, ci.getClassName());
        }
        nci.updatePropertyValues(ci.getProperties());
        op = new CIMObjectPath(ci.getClassName(), "");
        op.setKeys(nci.getKeys());
        op.setNameSpace(((CIMNameSpace)this.instanceAliasesNS.get(aliasName)).getNameSpace());
        this.instanceAliases.put(aliasName, op);
        return op;
    }

    public void verifyQualifiers(CIMProperty cp) {
        boolean hasValue = false;
        boolean hasValuemap = false;
        int numValues = -1;
        int numValuemaps = 0;
        boolean hasBitValue = false;
        boolean hasBitmap = false;
        int numBitValues = -1;
        int numBitmaps = 0;
        Vector v = cp.getQualifiers();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Vector vv;
            CIMValue cv;
            CIMQualifier cq = (CIMQualifier)e.nextElement();
            if (cq.getName().equalsIgnoreCase("values")) {
                hasValue = true;
                cv = cq.getValue();
                vv = (Vector)cv.getValue();
                numValues = vv.capacity();
            }
            if (cq.getName().equalsIgnoreCase("valuemap")) {
                hasValuemap = true;
                cv = cq.getValue();
                vv = (Vector)cv.getValue();
                numValuemaps = vv.capacity();
            }
            if (cq.getName().equalsIgnoreCase("BitMap")) {
                hasBitValue = true;
                cv = cq.getValue();
                vv = (Vector)cv.getValue();
                numBitValues = vv.capacity();
            }
            if (!cq.getName().equalsIgnoreCase("BitValues")) continue;
            hasBitmap = true;
            cv = cq.getValue();
            vv = (Vector)cv.getValue();
            numBitmaps = vv.capacity();
        }
        if (hasValue && hasValuemap && numValues != numValuemaps) {
            try {
                this.reportError("ERR_SEM", "ERR_ILLEGAL_VALUES", 1, this.curClassEl.getName() + "." + cp.getName() + " Values/ValueMap qualifiers don't have " + "the same number of elements (Values has " + numValues + " ValueMap has " + numValuemaps + ")");
            }
            catch (Exception eig) {
                // empty catch block
            }
        }
        if (hasBitValue && hasBitmap && numBitValues != numBitmaps) {
            try {
                this.reportError("ERR_SEM", "ERR_ILLEGAL_VALUES", 1, this.curClassEl.getName() + "." + cp.getName() + " BitMap/BitValues qualifiers don't have " + "the same number of elements (Values has " + numBitValues + " ValueMap has " + numBitmaps + ")");
            }
            catch (Exception eig) {
                // empty catch block
            }
        }
    }
}

