/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.compiler.mofc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import org.wbemservices.wbem.compiler.mofc.I18N;

class XmlWriter {
    private BufferedWriter xmlOut;
    private BufferedWriter bigxmlOut;
    CIMXml xi = CIMXmlFactory.getCIMXmlImpl();
    private String fileName = "mof.xml";
    private String bigfileName = "bigmof.xml";
    private String className = "";
    private String startTag = "<?xml version=\"1.0\"?>";

    public XmlWriter() {
        I18N.setResourceName("org.wbemservices.wbem.compiler.mofc.Compiler");
    }

    BufferedWriter getFile() {
        return this.xmlOut;
    }

    BufferedWriter getBigFile() {
        return this.bigxmlOut;
    }

    BufferedWriter openXmlFile() {
        try {
            BufferedWriter out;
            File xmlFile = new File(this.fileName);
            if (xmlFile.exists()) {
                xmlFile.delete();
            }
            this.xmlOut = out = new BufferedWriter(new FileWriter(this.fileName, true));
            this.writeStartTags(out);
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.fileName));
            System.exit(1);
        }
        return this.xmlOut;
    }

    BufferedWriter openBigXmlFile() {
        try {
            BufferedWriter out;
            File bigxmlFile = new File(this.bigfileName);
            if (bigxmlFile.exists()) {
                bigxmlFile.delete();
            }
            this.bigxmlOut = out = new BufferedWriter(new FileWriter(this.bigfileName, true));
            this.writeBigStartTags(out);
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.fileName));
            System.exit(1);
        }
        return this.bigxmlOut;
    }

    void writeBigStartTags(BufferedWriter out) {
        try {
            out.write(this.startTag);
            out.newLine();
            out.write("<CIM CIMVERSION=\"2.0\" DTDVERSION=\"2.0\">");
            out.newLine();
            out.write("<DECLARATION>");
            out.newLine();
            out.write("<DECLGROUP>");
            out.newLine();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeStartTags(BufferedWriter out) {
        try {
            out.write(this.startTag);
            out.newLine();
            out.write("<CLASSES>");
            out.newLine();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeEndTags(BufferedWriter out) {
        try {
            out.write("</CLASSES>");
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigEndTags(BufferedWriter out) {
        try {
            out.write("</DECLGROUP>");
            out.newLine();
            out.write("</DECLARATION>");
            out.newLine();
            out.write("</CIM>");
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeAllClasses(CIMClass curClassEl, BufferedWriter out) {
        try {
            out.write("<CLASS NAME=\"");
            out.write(curClassEl.getName());
            if (curClassEl.getSuperClass().length() != 0) {
                out.write("\" SUPERCLASS=\"");
                out.write(curClassEl.getSuperClass());
            }
            if (curClassEl.isAssociation()) {
                out.write("\" ASSOCIATION=\"true");
            }
            out.write("\" />");
            out.newLine();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigXml(CIMQualifierType curQualEl, BufferedWriter out) {
        try {
            out.write(this.xi.CIMQualifierTypeToXml(curQualEl));
            out.newLine();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeBigXml(CIMClass curClassEl, BufferedWriter out) {
        try {
            out.write("         <VALUE.OBJECT>");
            out.write(this.xi.CIMClassToXml(curClassEl, true, true, null, true));
            out.write("         </VALUE.OBJECT>");
            out.newLine();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("NO_SUCH_FILE", this.fileName));
            System.exit(1);
            return;
        }
    }

    void writeClass(CIMClass curClassEl) {
        try {
            this.className = curClassEl.getName() + ".xml";
            BufferedWriter out = new BufferedWriter(new FileWriter(curClassEl.getName() + ".xml", false));
            out.write(this.startTag);
            out.newLine();
            out.write("<CIM CIMVERSION=\"2.0\" DTDVERSION=\"2.0\">");
            out.newLine();
            out.write("   <DECLARATION>");
            out.newLine();
            out.write("      <DECLGROUP>");
            out.newLine();
            out.write("         <VALUE.OBJECT>");
            out.newLine();
            out.write(this.xi.CIMClassToXml(curClassEl, true, true, null, true));
            out.write("         </VALUE.OBJECT>");
            out.newLine();
            out.write("      </DECLGROUP>");
            out.newLine();
            out.write("   </DECLARATION>");
            out.newLine();
            out.write("</CIM>");
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            System.err.println(I18N.loadStringFormat("CANNOT_CREATE_FILE", this.className));
            System.exit(1);
        }
    }
}

