/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class CIMFlavor
implements Serializable,
Cloneable,
Comparable {
    public static final int ENABLEOVERRIDE = 0;
    public static final int DISABLEOVERRIDE = 1;
    public static final int RESTRICTED = 2;
    public static final int TOSUBCLASS = 3;
    public static final int TRANSLATE = 4;
    private int flavor;
    private static final CIMFlavor[] flavors = new CIMFlavor[]{new CIMFlavor(0), new CIMFlavor(1), new CIMFlavor(2), new CIMFlavor(3), new CIMFlavor(4)};

    public CIMFlavor(int flavor) {
        if (flavor < 0 || flavor > 4) {
            throw new IllegalArgumentException("Flavor value out of range");
        }
        this.flavor = flavor;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CIMFlavor)) {
            return false;
        }
        return this.flavor == ((CIMFlavor)obj).flavor;
    }

    public int hashCode() {
        return this.flavor;
    }

    public int getFlavor() {
        return this.flavor;
    }

    public static CIMFlavor getFlavor(int flavor) {
        if (flavor < 0 || flavor > 4) {
            throw new IllegalArgumentException("Flavor value out of range");
        }
        return flavors[flavor];
    }

    public String toMOF() {
        if (this.flavor == 0) {
            return "EnableOverride";
        }
        if (this.flavor == 1) {
            return "DisableOverride";
        }
        if (this.flavor == 2) {
            return "Restricted";
        }
        if (this.flavor == 3) {
            return "ToSubclass";
        }
        if (this.flavor == 4) {
            return "Translatable";
        }
        return "INVALID FLAVOR";
    }

    public String toString() {
        return this.toMOF();
    }

    public Object clone() {
        return this;
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMFlavor)) {
            throw new IllegalArgumentException("Invalid object to comparte with");
        }
        return this.flavor - ((CIMFlavor)o).flavor;
    }
}

