/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.math.BigInteger;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt8;

public class UnsignedInt64
extends Number
implements Serializable,
Cloneable {
    private BigInteger value;
    public static BigInteger MIN_VALUE = new BigInteger("0");
    public static BigInteger MAX_VALUE = new BigInteger("1").shiftLeft(64).subtract(new BigInteger("1"));

    public UnsignedInt64(byte value) {
        this.value = new BigInteger(Byte.toString(value));
        if (this.value.compareTo(MIN_VALUE) == -1 || this.value.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(short value) {
        this.value = new BigInteger(Short.toString(value));
        if (this.value.compareTo(MIN_VALUE) == -1 || this.value.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(int value) {
        this.value = new BigInteger(Integer.toString(value));
        if (this.value.compareTo(MIN_VALUE) == -1 || this.value.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(long value) {
        this.value = new BigInteger(Long.toString(value));
        if (this.value.compareTo(MIN_VALUE) == -1 || this.value.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("null bigInteger argument");
        }
        this.value = new BigInteger(value.toString());
        if (this.value.compareTo(MIN_VALUE) < 0 || this.value.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.value = new BigInteger(value);
        if (this.value.compareTo(MIN_VALUE) < 0 || this.value.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(UnsignedInt8 value) {
        this.value = new BigInteger(value.toString());
    }

    public UnsignedInt64(UnsignedInt16 value) {
        this.value = new BigInteger(value.toString());
    }

    public UnsignedInt64(UnsignedInt32 value) {
        this.value = new BigInteger(value.toString());
    }

    public UnsignedInt64(UnsignedInt64 value) {
        this.value = new BigInteger(value.toString());
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt64) {
            return this.value.compareTo(((UnsignedInt64)o).value) == 0;
        }
        return false;
    }

    public byte byteValue() {
        if (this.value.compareTo(new BigInteger(Byte.toString((byte)127))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return this.value.byteValue();
    }

    public short shortValue() {
        if (this.value.compareTo(new BigInteger(Short.toString((short)Short.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Short value which is inbetween " + Short.MIN_VALUE + " .. " + Short.MAX_VALUE);
        }
        return this.value.shortValue();
    }

    public int intValue() {
        if (this.value.compareTo(new BigInteger(Integer.toString(Integer.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Integer value which is inbetween " + Integer.MIN_VALUE + " .. " + Integer.MAX_VALUE);
        }
        return this.value.intValue();
    }

    public long longValue() {
        if (this.value.compareTo(new BigInteger(Long.toString(Long.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Long value which is inbetween " + Long.MIN_VALUE + " .. " + Long.MAX_VALUE);
        }
        return this.value.longValue();
    }

    public float floatValue() {
        if (this.value.compareTo(new BigInteger(Float.toString(Float.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Float value which is inbetween " + Float.MIN_VALUE + " .. " + Float.MAX_VALUE);
        }
        return this.value.floatValue();
    }

    public double doubleValue() {
        if (this.value.compareTo(new BigInteger(Double.toString(Double.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Double value which is inbetween " + Double.MIN_VALUE + " .. " + Double.MAX_VALUE);
        }
        return this.value.doubleValue();
    }

    public BigInteger bigIntValue() {
        return new BigInteger(this.value.toString());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object clone() {
        return new UnsignedInt64(this.value);
    }
}

