/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class UnsignedInt8
extends Number
implements Serializable,
Cloneable {
    private short value;
    public static short MIN_VALUE = 0;
    public static short MAX_VALUE = (short)255;

    public UnsignedInt8(byte value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt8(short value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt8(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.value = Short.parseShort(value);
        if (this.value < MIN_VALUE || this.value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt8(UnsignedInt8 value) {
        this.value = value.shortValue();
    }

    public String toString() {
        return Short.toString(this.value);
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt8) {
            return this.value == ((UnsignedInt8)o).value;
        }
        return false;
    }

    public byte byteValue() {
        if (this.value < -128 || this.value > 127) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return Byte.parseByte(Short.toString(this.value));
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return new Short(this.value).hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return new UnsignedInt8(this.value);
    }
}

