/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client.indications;

import org.sblim.wbem.cim.CIMException;

public class CIMError {
    private int statusCode;
    private String description;

    public CIMError() {
        this(1, "");
    }

    public CIMError(CIMException cimException) {
        if (cimException == null) {
            throw new IllegalArgumentException("null cim exception argument");
        }
        this.statusCode = cimException.getStatusCode();
        this.description = cimException.getDescription();
    }

    public CIMError(int status) {
        this(status, null);
    }

    public CIMError(int status, String msg) {
        this.setCode(status);
        this.setDescription(msg);
    }

    public int getCode() {
        return this.statusCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCode(int errCode) {
        if (errCode > 18 || errCode < 1) {
            throw new IllegalArgumentException("invalid error code");
        }
        this.statusCode = errCode;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "CIMError: " + CIMException.getStatusFromCode(this.statusCode + 1) + (this.description != null ? "(" + this.description + ")" : "");
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMError)) {
            return false;
        }
        CIMError that = (CIMError)o;
        return this.statusCode == that.statusCode && (this.description == null ? that.description == null : this.description.equals(that.description));
    }

    public int hashCode() {
        return (this.description != null ? this.description.hashCode() : 0) << 16 + this.statusCode;
    }
}

