/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.HttpContentHandler;
import org.sblim.wbem.http.HttpException;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpServerMethod;
import org.sblim.wbem.http.MessageReader;
import org.sblim.wbem.http.MessageWriter;
import org.sblim.wbem.http.io.ASCIIPrintStream;
import org.sblim.wbem.util.GlobalProperties;

public class HttpConnectionHandler {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    HttpContentHandler handler;

    public HttpConnectionHandler(HttpContentHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handleConnection(Socket socket) {
        block26: {
            InputStream is = null;
            OutputStream os = null;
            try {
                is = socket.getInputStream();
                os = socket.getOutputStream();
                while (true) {
                    boolean persistent;
                    MessageReader reader;
                    block24: {
                        MessageWriter writer;
                        reader = new MessageReader(is);
                        persistent = reader.isPersistentConnectionSupported();
                        boolean chunk = reader.isChunkSupported();
                        HttpServerMethod readerMethod = reader.getMethod();
                        if (readerMethod.getMethodName().equals("POST") || readerMethod.getMethodName().equals("M-POST")) {
                            Logger logger;
                            writer = new MessageWriter(os, persistent, chunk);
                            this.handler.handleContent(reader, writer, socket.getInetAddress());
                            writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 200, "OK"));
                            Object var11_18 = null;
                            try {
                                writer.close();
                            }
                            catch (IOException e2) {
                                logger = GlobalProperties.getLogger();
                                if (logger.isLoggable(Level.WARNING)) {
                                    logger.log(Level.WARNING, "exception while closing output stream from socket", e2);
                                }
                                break block24;
                            }
                            {
                                catch (HttpException e) {
                                    writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), e.getStatus(), e.getMessage()));
                                    var11_18 = null;
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException e2) {
                                        logger = GlobalProperties.getLogger();
                                        if (logger.isLoggable(Level.WARNING)) {
                                            logger.log(Level.WARNING, "exception while closing output stream from socket", e2);
                                        }
                                        break block24;
                                    }
                                }
                                catch (Throwable t) {
                                    writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 501, "Not Implemented"));
                                    writer.reset();
                                    this.writeError(writer.getOutputStream(), "error", "error");
                                    var11_18 = null;
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException e2) {
                                        logger = GlobalProperties.getLogger();
                                        if (logger.isLoggable(Level.WARNING)) {
                                            logger.log(Level.WARNING, "exception while closing output stream from socket", e2);
                                        }
                                        break block24;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                block25: {
                                    var11_18 = null;
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException e2) {
                                        logger = GlobalProperties.getLogger();
                                        if (!logger.isLoggable(Level.WARNING)) break block25;
                                        logger.log(Level.WARNING, "exception while closing output stream from socket", e2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        persistent = false;
                        writer = new MessageWriter(os, false, false);
                        HttpHeader header = new HttpHeader();
                        writer.setHeader(header);
                        writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 501, "Not Implemented"));
                        this.writeError(writer.getOutputStream(), "", "");
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            Logger logger = GlobalProperties.getLogger();
                            if (!logger.isLoggable(Level.WARNING)) break block24;
                            logger.log(Level.WARNING, "exception while closing output stream from socket", e);
                        }
                    }
                    if (persistent) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            Logger logger = GlobalProperties.getLogger();
                            if (!logger.isLoggable(Level.WARNING)) continue;
                            logger.log(Level.WARNING, "exception while closing input stream from socket", e);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                Logger logger = GlobalProperties.getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block26;
                logger.log(Level.WARNING, "exception while closing socket", e);
            }
        }
    }

    public void close() {
        this.handler.close();
    }

    private void setDefaultHeaders(HttpHeader headers) {
        if (headers != null) {
            // empty if block
        }
    }

    private void writeError(ASCIIPrintStream dos, String title, String body) {
        dos.print("<HTTP> <HEAD> <TITLE>" + title + "</TITLE></HEAD><BODY>" + body + "</BODY></HTML>");
    }
}

