/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS4K;

import java.io.FileInputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;

public class DS4KCimomDataGenerator {
    private static final String DS4K_SYSTEM_NAME_PREFIX = "600A0B80000BC456";
    private static final String INTEROP_XML = "XML\\Storage\\IBM\\DS4K\\DS4K_interop.xml";
    private static final String ROOT_LSISSI11_XML = "XML\\Storage\\IBM\\DS4K\\DS4K_LSISSI_11.xml";
    private static final String NAMESPACE_INTEROP = "/interop";
    private static final String NAMESPACE_ROOT_LSISSI11 = "/root/lsissi11";
    private String configFile = "conf/DS4K-requirement.config";
    private String storageSystemName;
    private String storageSystemNumber;

    private void generateDataForInterop(int nsID, DataGeneratorResponse lsissi11Response) throws Exception {
        DeviceDataGenerator dataGenerator = new DeviceDataGenerator(INTEROP_XML, this.configFile);
        DataGeneratorResponse response = dataGenerator.generateData(NAMESPACE_INTEROP);
        Iterator iter = response.getRemainingClassList().iterator();
        SimClass simClass = null;
        while (iter.hasNext() && !(simClass = (SimClass)iter.next()).getName().equalsIgnoreCase("LSISSI_ElementConformsToProfile")) {
        }
        List instances = dataGenerator.getCreator().createAssociationInstances(simClass, ((List)response.getInstanceMap().get("/interop:LSISSI_RegisteredProfile")).toArray(), (CIMInstance)lsissi11Response.getInstanceMap().get("/root/lsissi11:LSISSI_StorageSystem"));
        response.getInstanceMap().put("/interop:LSISSI_ElementConformsToProfile", instances);
        DatabaseManager.getDbManager().persistInstances(nsID, response.getInstanceMap(), dataGenerator.getParserResponse().getClassMap());
    }

    private DataGeneratorResponse generateDataForLSISSI11(int nsID) throws Exception {
        DeviceDataGenerator dataGenerator = new DeviceDataGenerator(ROOT_LSISSI11_XML, this.configFile);
        dataGenerator.getConfProperties().setProperty("STORAGE_SYSTEM_NUMBER", this.storageSystemNumber);
        dataGenerator.getConfProperties().setProperty("STORAGE_SYSTEM_NAME", this.storageSystemName);
        DataGeneratorResponse response = dataGenerator.generateData(NAMESPACE_ROOT_LSISSI11);
        Properties properties = new Properties();
        properties.load(new FileInputStream("conf/classlist.properties"));
        String[] classArray = properties.getProperty("STORAGE_POOL_LIST").split(",");
        LinkedList classList = new LinkedList();
        Collections.addAll(classList, classArray);
        classArray = properties.getProperty("STORAGE_VOLUME_LIST").split(",");
        Collections.addAll(classList, classArray);
        classArray = properties.getProperty("STORAGE_EXTENT_LIST").split(",");
        Collections.addAll(classList, classArray);
        Properties confProperties = new Properties();
        confProperties.load(new FileInputStream(this.configFile));
        int numberOfStoragePool = Integer.parseInt(confProperties.getProperty("NUMBER_OF_STORAGE_POOL"));
        String[] volumeData = confProperties.getProperty("MAPPING_POOL_TO_VOLUME").split(" ");
        String[] extentData = confProperties.getProperty("MAPPING_DISK_TO_POOL").split(" ");
        for (int i = 0; i < numberOfStoragePool; ++i) {
            dataGenerator.getConfProperties().setProperty("NUMBER_OF_STORAGE_POOL", "1");
            dataGenerator.getConfProperties().setProperty("NUMBER_OF_DISK", extentData[i]);
            dataGenerator.getConfProperties().setProperty("NUMBER_OF_VOLUMES", volumeData[i]);
            dataGenerator.generateData(classList, response);
        }
        DatabaseManager.getDbManager().persistInstances(nsID, response.getInstanceMap(), dataGenerator.getParserResponse().getClassMap());
        return response;
    }

    public void generateData(String confFile) {
        if (null != confFile) {
            this.configFile = confFile;
        }
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            this.storageSystemNumber = DS4K_SYSTEM_NAME_PREFIX + IDGenerator.getRandomKey("8") + IDGenerator.getRandomKey("8");
            this.storageSystemName = "StorageSystem-" + IDGenerator.getRandomKey("4");
            dbManager.insert_CIMOM_INFO(1, "DS4K " + this.storageSystemName + " CIMOM", "127.0.0.1", NAMESPACE_INTEROP, "administrator", "san46pass");
            int cimomId = dbManager.getMaxID("SIM.CIMOM_INFO");
            dbManager.insert_NS_INFO(cimomId, NAMESPACE_INTEROP);
            int interopNsID = dbManager.getMaxID("SIM.NS_INFO");
            dbManager.insert_NS_INFO(cimomId, NAMESPACE_ROOT_LSISSI11);
            int lsissi11NsID = dbManager.getMaxID("SIM.NS_INFO");
            DataGeneratorResponse lsissi11Response = this.generateDataForLSISSI11(lsissi11NsID);
            this.generateDataForInterop(interopNsID, lsissi11Response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("Jai Baberi");
        DS4KCimomDataGenerator test = new DS4KCimomDataGenerator();
        test.generateData(null);
        System.out.println("Program completed");
    }
}

