/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.util.CharUtils;

public class CIMElement
implements Serializable,
Comparable {
    protected static final String[] opening_braket = new String[]{"", "[", "(", "{"};
    protected static final String[] closing_braket = new String[]{"", "]", ")", "}"};
    protected static final String EMPTY = "";
    protected String name;

    public CIMElement() {
        this.name = EMPTY;
    }

    public CIMElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null element name argument");
        }
        this.name = name;
    }

    public CIMElement(CIMElement cimElement) {
        if (cimElement == null) {
            throw new IllegalArgumentException("null element argument");
        }
        this.name = cimElement.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null element name argument");
        }
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CIMElement)) {
            return false;
        }
        return this.name.equalsIgnoreCase(((CIMElement)obj).name);
    }

    public boolean lessThan(CIMElement element) {
        if (element == null) {
            throw new IllegalArgumentException("null element argument");
        }
        return this.name.toUpperCase().compareTo(element.name.toUpperCase()) < 0;
    }

    public CIMElement assign(CIMElement newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException("null element argument");
        }
        this.name = newElement.name;
        return this;
    }

    protected static String vectorToMOFString(Vector vector, boolean linefeed, int tabs) {
        return CIMElement.vectorToMOFString(vector, linefeed, tabs, 1, true);
    }

    protected static String vectorToMOFString(Vector vector) {
        return CIMElement.vectorToMOFString(vector, true, 1, 1, true);
    }

    protected static void tabs(StringBuffer buf, int tabs) {
        while (tabs-- > 0) {
            buf.append('\t');
        }
    }

    protected static String vectorToMOFString(Vector vector, boolean linefeed, int tab, int braketType, boolean useCommas) {
        StringBuffer buf = new StringBuffer();
        if (vector != null) {
            CIMElement.tabs(buf, tab);
            buf.append(opening_braket[braketType]);
            Iterator iter = vector.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object o;
                if (i > 0) {
                    if (useCommas) {
                        buf.append(',');
                    }
                    if (linefeed) {
                        buf.append('\n');
                        CIMElement.tabs(buf, tab);
                    }
                    buf.append(' ');
                }
                if ((o = iter.next()) != null) {
                    if (o instanceof String || o instanceof CIMObjectPath) {
                        buf.append('\"' + CharUtils.escape(o.toString()) + '\"');
                    } else if (o instanceof Character) {
                        buf.append('\'' + CharUtils.escape(o.toString()) + '\'');
                    } else {
                        buf.append(o.toString());
                    }
                } else {
                    buf.append("NULL");
                }
                ++i;
            }
            if (linefeed) {
                buf.append('\n');
            }
            buf.append(closing_braket[braketType]);
        }
        return buf.toString();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMElement)) {
            throw new IllegalArgumentException("Invalid object to compare with");
        }
        return this.name.toUpperCase().compareTo(((CIMElement)o).name.toUpperCase());
    }
}

