/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.util.GlobalProperties;

public class CIMNameSpace
implements Serializable,
Cloneable {
    private String host;
    private String namespace;
    private int port;
    private String file = "/";
    private URI uri;
    private String protocol = "http";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_FILE = "/cimom";
    private static final String DEFAULT_HOST = null;
    private static final int DEFAULT_PORT = 5988;
    private static final String DEFAULT_NAMESPACE = "root/cimv2";
    public static final char NAMESPACE_SEPARATOR = '/';

    public CIMNameSpace() throws CIMException {
        this.host = DEFAULT_HOST;
        this.port = 5988;
        this.file = DEFAULT_FILE;
        this.protocol = "http";
        this.namespace = DEFAULT_NAMESPACE;
        try {
            this.uri = new URI(this.protocol, null, this.host, this.port, this.file, null, null);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public CIMNameSpace(String hostUrl) throws CIMException {
        this(hostUrl, null);
    }

    public CIMNameSpace(String host, String namespace) throws CIMException {
        this.uri = null;
        if (host == null) {
            host = DEFAULT_HOST;
        }
        if (namespace == null) {
            namespace = DEFAULT_NAMESPACE;
        }
        this.setNamespace(namespace);
        try {
            int pos;
            this.uri = host.indexOf(47) == -1 ? ((pos = host.indexOf(58)) == -1 && pos + 1 == host.length() ? new URI("http", null, host, 5988, DEFAULT_FILE, null, null) : new URI("http", host, DEFAULT_FILE, null)) : new URI(host);
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", e);
        }
        this.host = this.uri.getHost();
        this.port = this.uri.getPort();
        this.file = this.uri.getPath();
        this.protocol = this.uri.getScheme();
        if (this.file == null || this.file.length() == 0 || this.file.equals("/")) {
            this.file = DEFAULT_FILE;
        }
        if (this.port == -1) {
            this.port = 5988;
        }
        this.namespace = namespace;
        if (this.host == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Invalid hostname: \"" + host + "\"");
        }
        try {
            this.uri = new URI(this.protocol, null, this.host, this.port, this.file, null, null);
        }
        catch (Exception e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "invalid URI format", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e, "malformed URI");
        }
    }

    protected void updateURI() throws CIMException {
        try {
            this.uri = new URI(this.protocol, null, this.host, this.port, this.file, null, null);
        }
        catch (Exception e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "invalid URI format", e);
            }
            throw new CIMException("CIM_ERR_FAILED", e, "malformed URI");
        }
    }

    public Object clone() {
        CIMNameSpace that = new CIMNameSpace();
        that.host = this.host;
        that.namespace = this.namespace;
        that.port = this.port;
        that.protocol = this.protocol;
        that.file = this.file;
        that.uri = this.uri;
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMNameSpace)) {
            return false;
        }
        CIMNameSpace that = (CIMNameSpace)o;
        if (!this.uri.equals(that.uri)) {
            return false;
        }
        return this.namespace.equals(that.namespace);
    }

    public String getHost() {
        return this.host;
    }

    public URI getHostURI() throws CIMException {
        return this.uri;
    }

    public URL getHostURL() throws CIMException {
        URL url = null;
        try {
            url = this.uri.toURL();
        }
        catch (Throwable e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "invalid URI format", e);
            }
            try {
                url = new URL(this.protocol, this.host, this.port, this.file);
            }
            catch (Throwable n) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "invalid URI format", e);
                }
                throw new CIMException("CIM_ERR_FAILED", n, "malformed URI");
            }
        }
        return url;
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public static CIMNameSpace parse(String p) throws CIMException {
        return new CIMNameSpace(p);
    }

    public void setPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("invalid port number argument: " + port);
        }
        this.port = port;
        this.updateURI();
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException("null hostname argument");
        }
        String realHost = host;
        int i = host.indexOf(58);
        if (i > -1) {
            realHost = host.substring(0, i);
            String realPort = host.substring(i + 1);
            int newPort = -1;
            try {
                this.port = newPort = Integer.parseInt(realPort);
            }
            catch (NumberFormatException e) {
                newPort = -1;
            }
            this.host = realHost;
        } else {
            this.host = host;
        }
        this.updateURI();
    }

    public void setNameSpace(String namespace) throws CIMException {
        if (namespace == null) {
            throw new IllegalArgumentException("null namespace argument");
        }
        this.setNamespace(namespace);
        this.updateURI();
    }

    protected void setNamespace(String namespace) {
        if (namespace != null) {
            if (namespace.indexOf(92) > -1) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", "namespace should not contain '\\' character");
            }
            boolean tryAgain = false;
            do {
                tryAgain = false;
                if (namespace.startsWith("/")) {
                    namespace = namespace.substring(1);
                    tryAgain = true;
                }
                if (!namespace.endsWith("/")) continue;
                namespace = namespace.substring(0, namespace.length() - 1);
                tryAgain = true;
            } while (tryAgain);
            this.namespace = namespace;
        } else {
            this.namespace = "";
        }
    }

    public String toString() {
        return "//" + (this.host == null ? "" : this.host) + '/' + (this.namespace == null ? "" : this.namespace) + "/";
    }
}

