/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class CIMScope
implements Cloneable,
Comparable,
Serializable {
    public static final int SCHEMA = 0;
    public static final int CLASS = 1;
    public static final int ASSOCIATION = 2;
    public static final int INDICATION = 3;
    public static final int PROPERTY = 4;
    public static final int REFERENCE = 5;
    public static final int METHOD = 6;
    public static final int PARAMETER = 7;
    public static final int ANY = 8;
    private int scope;
    protected static final CIMScope[] scopes = new CIMScope[]{new CIMScope(0), new CIMScope(1), new CIMScope(2), new CIMScope(3), new CIMScope(4), new CIMScope(5), new CIMScope(6), new CIMScope(7), new CIMScope(8)};

    public CIMScope(int scope) {
        if (scope < 0 || scope > 8) {
            throw new IllegalArgumentException("scope out of range");
        }
        this.scope = scope;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CIMScope)) {
            return false;
        }
        return this.scope == ((CIMScope)obj).scope;
    }

    public int hashCode() {
        return this.scope;
    }

    public int getScope() {
        return this.scope;
    }

    public static CIMScope getScope(int scope) {
        if (scope < 0 || scope > 8) {
            throw new IllegalArgumentException("scope out of range");
        }
        return scopes[scope];
    }

    public String toMOF() {
        if (this.scope == 0) {
            return "Schema";
        }
        if (this.scope == 1) {
            return "Class";
        }
        if (this.scope == 2) {
            return "Association";
        }
        if (this.scope == 3) {
            return "Indication";
        }
        if (this.scope == 4) {
            return "Property";
        }
        if (this.scope == 5) {
            return "Reference";
        }
        if (this.scope == 6) {
            return "Method";
        }
        if (this.scope == 7) {
            return "Parameter";
        }
        if (this.scope == 8) {
            return "Any";
        }
        return "INVALID SCOPE";
    }

    public String toString() {
        return this.toMOF();
    }

    public Object clone() {
        return this;
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMScope)) {
            throw new IllegalArgumentException("Invalid object to comparte with");
        }
        return this.scope - ((CIMScope)o).scope;
    }
}

