/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Calendar;
import org.sblim.wbem.cim.CIMDateTime;

public class CIMSimpleDateTime
extends CIMDateTime {
    public CIMSimpleDateTime() {
        this.s = "00000000000000.000000-000";
        this.interval = false;
        this.presicion = 12;
    }

    public CIMSimpleDateTime(String str) {
        if (str.indexOf(58) > -1) {
            throw new IllegalArgumentException("simple date time must not be used to define intervals: " + str);
        }
        this.interval = false;
        CIMSimpleDateTime.valueOf(this, str);
    }

    public CIMSimpleDateTime(Calendar cal) {
        if (cal == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        Calendar calendar = (Calendar)cal.clone();
        this.offsetminute = calendar.get(15) / 60000;
        this.year = calendar.get(1);
        this.month = calendar.get(2) - calendar.getMinimum(2) + 1;
        this.day = calendar.get(5) - calendar.getMinimum(5) + 1;
        this.hour = calendar.get(11) - calendar.getMinimum(11);
        this.minute = calendar.get(12) - calendar.getMinimum(12);
        this.second = calendar.get(13) - calendar.getMinimum(13);
        this.millisecond = calendar.get(14) - calendar.getMinimum(14);
        this.presicion = 12;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public void setDay(int day) {
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("invalid value of offset minute:" + day);
        }
        this.calendar = null;
        this.day = day;
    }

    public void setMonth(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("invalid value of month [1-12]:" + month);
        }
        this.calendar = null;
        this.month = month;
    }

    public void setYear(int year) {
        this.calendar = null;
        this.year = year;
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        CIMSimpleDateTime date = new CIMSimpleDateTime("20040405130342.000000+060");
        System.out.println(date);
        System.out.println(date.getCalendar());
    }
}

