/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.util.CharUtils;

public class CIMValue
implements Serializable,
Cloneable {
    private Object value;
    private CIMDataType type;
    public static final CIMValue FALSE = new CIMValue(Boolean.FALSE);
    public static final CIMValue TRUE = new CIMValue(Boolean.TRUE);

    public CIMValue(Object value) {
        if (value instanceof Object[]) {
            value = new Vector<Object>(Arrays.asList((Object[])value));
        }
        if (value instanceof Vector) {
            int dataType = CIMDataType.findType((Object)value);
            this.type = CIMDataType.getPredefinedType(dataType);
            Vector<Object> newValue = value;
            Iterator<Object> iter = newValue.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (dataType == CIMDataType.findArrayType(CIMDataType.findType(obj))) continue;
                throw new IllegalArgumentException("Invalid data type. The array contains elements that do not match arrays type");
            }
            this.value = newValue;
        } else {
            int dataType = CIMDataType.findType((Object)value);
            this.type = dataType == 14 ? new CIMDataType(((CIMObjectPath)((Object)value)).getObjectName()) : new CIMDataType(dataType);
            this.value = value;
        }
    }

    public CIMValue(Object value, CIMDataType dataType) {
        if (value instanceof Object[]) {
            if ((value = new Vector<Object>(Arrays.asList((Object[])value))) != null) {
                if (!(dataType == null || dataType.isArrayType() && dataType.getType() != -1)) {
                    throw new IllegalArgumentException("Invalid argument type. Array type expected");
                }
                Iterator<Object> iter = value.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    int elementType = CIMDataType.findArrayType(CIMDataType.findType(obj));
                    if (CIMDataType.isTypeCompatible(obj, dataType) || elementType == 32) continue;
                    throw new IllegalArgumentException("Invalid element type. One of the elements of the array does not match the data type or a compatible data type of the array");
                }
                this.value = value;
            }
        } else {
            if (value != null && (value instanceof Vector || dataType != null && dataType.isArrayType())) {
                throw new IllegalArgumentException("value type does not match the specified data type");
            }
            if (!(dataType == null || value == null || CIMDataType.isTypeCompatible(value, dataType) && dataType.getType() != -1)) {
                throw new IllegalArgumentException("Invalid argument type. The value contains an element that does not match the data type or a compatible data type");
            }
            this.value = value;
        }
        this.type = dataType;
    }

    public CIMValue(Vector value, CIMDataType dataType) {
        if (!(value == null || dataType != null && dataType.isArrayType())) {
            throw new IllegalArgumentException("Array data type expected");
        }
        if (value != null) {
            if (!(dataType == null || dataType.isArrayType() && dataType.getType() != -1)) {
                throw new IllegalArgumentException("Invalid argument type. Array type expected");
            }
            Vector newValue = value;
            Iterator iter = newValue.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                int elementType = CIMDataType.findArrayType(CIMDataType.findType(obj));
                if (CIMDataType.isTypeCompatible(obj, dataType) || elementType == 32) continue;
                throw new IllegalArgumentException("Invalid element type. One of the elements of the array does not match the data type or a compatible data type of the array");
            }
            this.value = newValue;
        }
        this.type = dataType;
    }

    protected CIMValue() {
    }

    public Object clone() {
        CIMValue that = new CIMValue();
        that.value = this.value instanceof Vector ? ((Vector)this.value).clone() : this.value;
        if (this.type != null) {
            that.type = (CIMDataType)this.type.clone();
        }
        return that;
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.value != null) {
            if (this.value instanceof Vector) {
                return ((Vector)this.value).contains(obj);
            }
            return this.value.equals(obj);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.value == null && this.type != null;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isNullValue() {
        return this.isNull();
    }

    public int getSize() {
        if (this.value instanceof Vector) {
            return ((Vector)this.value).size();
        }
        if (this.type != null) {
            return this.type.getSize();
        }
        return -1;
    }

    public int size() {
        return this.getSize();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CIMValue)) {
            return false;
        }
        CIMValue that = (CIMValue)obj;
        if (!(this.type != null ? this.type.equals(that.type) : that.type == null)) {
            return false;
        }
        return this.value == null ? that.value == null : this.value.equals(that.value);
    }

    public int hashCode() {
        return (this.value != null ? this.value.hashCode() : 0) << 16 + (this.type != null ? this.type.hashCode() : 0);
    }

    public CIMDataType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isArrayValue() {
        return this.value instanceof Vector || this.type.isArrayType();
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (this.value != null) {
            if (this.type != null && this.type.isArrayType()) {
                buf.append(CIMElement.vectorToMOFString((Vector)this.value, false, 1));
            } else if (this.value instanceof String || this.value instanceof CIMObjectPath) {
                buf.append('\"');
                buf.append(CharUtils.escape(this.value.toString()));
                buf.append('\"');
            } else if (this.value instanceof Character) {
                buf.append('\'');
                buf.append(CharUtils.escape(this.value.toString()));
                buf.append('\'');
            } else {
                buf.append(String.valueOf(this.value));
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public static void main(String[] args) {
        CIMValue value1 = new CIMValue((Object)null, CIMDataType.getPredefinedType(13));
        CIMValue value2 = new CIMValue("string");
        System.out.println(value1);
        System.out.println(value2);
        System.out.println("equals() = " + value1.equals(value2));
        String[] strArray = new String[]{"hello", "bye"};
        CIMValue value3 = new CIMValue(strArray, CIMDataType.getPredefinedType(24));
        System.out.println(value3);
    }
}

