/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt8;

public class UnsignedInt32
extends Number
implements Serializable,
Cloneable {
    private long value;
    public static long MIN_VALUE = 0L;
    public static long MAX_VALUE = 0xFFFFFFFFL;

    public UnsignedInt32(byte value) {
        if ((long)value < MIN_VALUE || (long)value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt32(short value) {
        if ((long)value < MIN_VALUE || (long)value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt32(int value) {
        if ((long)value < MIN_VALUE || (long)value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt32(long value) {
        if (value < MIN_VALUE || value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.value = value;
    }

    public UnsignedInt32(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.value = Long.parseLong(value);
        if (this.value < MIN_VALUE || this.value > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt32(UnsignedInt8 value) {
        this.value = value.longValue();
    }

    public UnsignedInt32(UnsignedInt16 value) {
        this.value = value.longValue();
    }

    public UnsignedInt32(UnsignedInt32 value) {
        this.value = value.longValue();
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt32) {
            return this.value == ((UnsignedInt32)o).value;
        }
        return false;
    }

    public byte byteValue() {
        if (this.value < -128L || this.value > 127L) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return (byte)this.value;
    }

    public short shortValue() {
        if (this.value < -32768L || this.value > 32767L) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Short value which is inbetween " + Short.MIN_VALUE + " .. " + Short.MAX_VALUE);
        }
        return (short)this.value;
    }

    public int intValue() {
        if (this.value < Integer.MIN_VALUE || this.value > Integer.MAX_VALUE) {
            throw new NumberFormatException("Value range exceeded. The value " + this.value + " is not in the range of a Integer value which is inbetween " + Integer.MIN_VALUE + " .. " + Integer.MAX_VALUE);
        }
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return new Long(this.value).hashCode();
    }

    public Object clone() {
        return new UnsignedInt32(this.value);
    }
}

