/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMTransportException;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.BatchHandle;
import org.sblim.wbem.client.BatchResult;
import org.sblim.wbem.client.CIMEnumerationImpl;
import org.sblim.wbem.client.CIMOMHandle;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.indications.CIMEventDispatcher;
import org.sblim.wbem.client.indications.CIMIndicationHandler;
import org.sblim.wbem.client.indications.CIMIndicationListenertList;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.client.operations.CIMAssociatorNamesOp;
import org.sblim.wbem.client.operations.CIMAssociatorsOp;
import org.sblim.wbem.client.operations.CIMCreateNameSpaceOp;
import org.sblim.wbem.client.operations.CIMDeleteNameSpaceOp;
import org.sblim.wbem.client.operations.CIMEnumClassNamesOp;
import org.sblim.wbem.client.operations.CIMEnumClassesOp;
import org.sblim.wbem.client.operations.CIMEnumInstanceNamesOp;
import org.sblim.wbem.client.operations.CIMEnumInstancesOp;
import org.sblim.wbem.client.operations.CIMEnumNameSpaceOp;
import org.sblim.wbem.client.operations.CIMEnumQualifierTypesOp;
import org.sblim.wbem.client.operations.CIMExecQueryOp;
import org.sblim.wbem.client.operations.CIMGetClassOp;
import org.sblim.wbem.client.operations.CIMGetInstanceOp;
import org.sblim.wbem.client.operations.CIMGetPropertyOp;
import org.sblim.wbem.client.operations.CIMGetQualifierTypeOp;
import org.sblim.wbem.client.operations.CIMInvokeMethodOp;
import org.sblim.wbem.client.operations.CIMOperation;
import org.sblim.wbem.client.operations.CIMReferenceNamesOp;
import org.sblim.wbem.client.operations.CIMReferencesOp;
import org.sblim.wbem.http.AuthInfo;
import org.sblim.wbem.http.AuthorizationHandler;
import org.sblim.wbem.http.HttpClientPool;
import org.sblim.wbem.http.HttpConnectionHandler;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpHeaderParser;
import org.sblim.wbem.http.HttpServerConnection;
import org.sblim.wbem.http.HttpUrlConnection;
import org.sblim.wbem.http.io.DebugInputStream;
import org.sblim.wbem.util.Benchmark;
import org.sblim.wbem.util.GlobalProperties;
import org.sblim.wbem.xml.CIMClientXML_HelperImpl;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.CIMXMLParserImpl;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CIMClientXML
implements CIMOMHandle {
    private static final String CLASSNAME = "org.sblim.wbem.client.CIMClientXML";
    private URI uri;
    private CIMIndicationListenertList indicationClient;
    private HttpServerConnection indicationServer = null;
    private Object lock = new Object();
    private int counter = 0;
    private int nsCntr = 1;
    private static CIMClientXML_HelperImpl xmlHelper;
    private CIMNameSpace nameSpace;
    private HttpUrlConnection connection;
    private boolean useMPost = true;
    private boolean useHttp11 = true;
    private Locale locale = Locale.getDefault();
    private HttpClientPool httpClientPool = new HttpClientPool();
    private AuthorizationHandler auth_handler;
    private String authorization;
    private Logger logger = null;

    public CIMClientXML(CIMNameSpace ns, Principal principal, Object credential) throws CIMException {
        try {
            this.init(ns, principal, credential);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void init(CIMNameSpace ns, Principal principal, Object credential) throws CIMException {
        String methodName = "init";
        this.logger = GlobalProperties.getLogger();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "init(CIMNameSpace, Principal, Object)", new Object[]{ns, principal, credential});
        }
        try {
            try {
                if (ns == null) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null namespace argument");
                }
                this.nameSpace = (CIMNameSpace)ns.clone();
                this.uri = this.nameSpace.getHostURI();
                if (this.uri == null) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER", "Malformed URI is equal to NULL");
                }
                AuthInfo authInfo = new AuthInfo(Boolean.FALSE, this.nameSpace.getHost(), this.nameSpace.getPort(), null, null, null);
                boolean defaultAuthEnabled = GlobalProperties.isCredentialsDefaultEnabled();
                if (credential == null || principal == null || principal.getName() == null || credential instanceof PasswordCredential && (((PasswordCredential)credential).getUserPassword() == null || ((PasswordCredential)credential).getUserPassword().length == 0) || !(credential instanceof PasswordCredential)) {
                    if (defaultAuthEnabled) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.log(Level.FINER, "Empty credential or principal - Default IS enabled !");
                        }
                        String defaultPrincipal = GlobalProperties.getDefaultPrincipal();
                        String defaultCredential = GlobalProperties.getDefaultCredentials();
                        authInfo.setCredentials(new PasswordAuthentication(defaultPrincipal, defaultCredential.toCharArray()));
                    } else if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "Empty credential or principal - Default NOT enabled !");
                    }
                } else if (credential instanceof PasswordCredential) {
                    authInfo.setCredentials(new PasswordAuthentication(principal.getName(), ((PasswordCredential)credential).getUserPassword()));
                }
                this.auth_handler = new AuthorizationHandler();
                this.auth_handler.addAuthorizationInfo(authInfo);
                this.indicationClient = new CIMIndicationListenertList();
                xmlHelper = new CIMClientXML_HelperImpl();
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error occured during initilizing", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error occured during initilizing", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var10_11 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    protected void getCIMOMCapabilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale newLocale) {
        String methodName = "setLocale(Locale)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, newLocale);
        }
        try {
            if (newLocale == null) {
                CIMException e = new CIMException("CIM_ERR_INVALID_PARAMETER", "null Locale object");
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Invalid Locale object - null reference", e);
                }
                throw e;
            }
            this.locale = newLocale;
            Object var5_4 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public Locale getLocale() {
        String methodName = "getLocale()";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, this.locale);
            this.logger.exiting(CLASSNAME, methodName, this.locale);
        }
        return this.locale;
    }

    public void useHttp11(boolean bool) {
        String methodName = "useHttp11(boolean)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, bool);
        }
        this.useHttp11 = bool;
        if (!this.useHttp11) {
            this.useMPost = false;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Setting useHttp11:" + this.useHttp11);
            this.logger.log(Level.FINER, "Setting MPost:" + this.useMPost);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName);
        }
    }

    public void useMPost(boolean bool) {
        String methodName = "useMPost(boolean)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, bool);
        }
        this.useMPost = bool;
        if (this.useMPost) {
            this.useHttp11 = true;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Setting useHttp11:" + this.useHttp11);
            this.logger.log(Level.FINER, "Setting MPost:" + this.useMPost);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName);
        }
    }

    public void preCheck(CIMObjectPath objectName) throws CIMException {
        if (objectName == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null object path");
        }
        String ns = objectName.getNameSpace();
        if (ns == null || ns.length() == 0) {
            objectName.setNameSpace(this.nameSpace.getNameSpace());
        }
    }

    public void preCheck(CIMNameSpace namespace) throws CIMException {
        if (namespace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null namespace");
        }
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public Enumeration associatorNames(CIMObjectPath objectName) throws CIMException {
        return this.associatorNames(objectName, null, null, null, null);
    }

    public Enumeration associatorNames(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        String methodName = "associatorNames(CIMObjectPath, String, String, String, String)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, assocClass, resultClass, role, resultRole});
        }
        this.preCheck(objectName);
        Enumeration enumeration = null;
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.associatorNames_request(doc, objectName, assocClass, resultClass, role, resultRole));
                InputStreamReader is = this.transmitRequest("AssociatorNames", hh, doc);
                enumeration = this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing associatorNames request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing associatorNames request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var12_13 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
            throw throwable;
        }
        return enumeration;
    }

    public Enumeration associators(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String methodName = "associators(CIMObjectPath, String, String, String, String, boolean, boolean,  String[])";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList});
        }
        this.preCheck(objectName);
        Enumeration enumeration = null;
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.associators_request(doc, objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList));
                InputStreamReader is = this.transmitRequest("Associators", hh, doc);
                enumeration = this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing associator request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing associator request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var15_16 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
            throw throwable;
        }
        return enumeration;
    }

    public void deleteInstance(CIMObjectPath objectName) throws CIMException {
        String methodName = "deleteInstance(CIMObjectPath)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName});
        }
        this.preCheck(objectName);
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.deleteInstance_request(doc, objectName));
                InputStreamReader is = this.transmitRequest("DeleteInstance", hh, doc);
                this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing deleteInstance request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing deleteInstance request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var7_8 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public Enumeration enumerateInstanceNames(CIMObjectPath objectName) throws CIMException {
        String methodName = "enumerateInstanceNames(CIMObjectPath)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName});
        }
        this.preCheck(objectName);
        Enumeration enumeration = null;
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.enumerateInstanceNames_request(doc, objectName));
                InputStreamReader is = this.transmitRequest("EnumerateInstanceNames", hh, doc);
                enumeration = this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateInstanceNames request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateInstanceNames request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var8_9 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
        return enumeration;
    }

    public Enumeration enumerateInstances(CIMObjectPath objectName, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String methodName = "enumerateInstances(CIMObjectPath, boolean, boolean, boolean, boolean, String[])";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList});
        }
        this.preCheck(objectName);
        Enumeration enumeration = null;
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.enumerateInstances_request(doc, objectName, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList));
                InputStreamReader is = this.transmitRequest("EnumerateInstances", hh, doc);
                enumeration = this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateInstances request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateInstances request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var13_14 = null;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
            throw throwable;
        }
        return enumeration;
    }

    public CIMInstance getInstance(CIMObjectPath objectName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String methodName = "getInstance(CIMObjectPath, boolean, boolean, boolean, String[])";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, localOnly, includeQualifiers, includeClassOrigin, propertyList});
        }
        this.preCheck(objectName);
        CIMInstance inst = null;
        try {
            block10: {
                try {
                    HttpHeader hh = new HttpHeader();
                    hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                    Document doc = xmlHelper.newDocument();
                    xmlHelper.createCIMMessage(doc, xmlHelper.getInstance_request(doc, objectName, localOnly, includeQualifiers, includeClassOrigin, propertyList));
                    InputStreamReader is = this.transmitRequest("GetInstance", hh, doc);
                    Enumeration enumeration = this.getEnumeration(is, objectName);
                    if (!enumeration.hasMoreElements()) break block10;
                    inst = (CIMInstance)enumeration.nextElement();
                }
                catch (CIMException e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing getInstance request", e);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing getInstance request", e);
                    }
                    throw new CIMException("CIM_ERR_FAILED", e);
                }
            }
            Object var13_14 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, inst);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, inst);
            }
            throw throwable;
        }
        return inst;
    }

    public CIMClass getClass(CIMObjectPath objectName, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String methodName = "getClass(CIMObjectPath, boolean, boolean, boolean, String[])";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, localOnly, includeQualifiers, propertyList});
        }
        this.preCheck(objectName);
        CIMClass cimClass = null;
        try {
            block10: {
                try {
                    HttpHeader hh = new HttpHeader();
                    hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                    Document doc = xmlHelper.newDocument();
                    xmlHelper.createCIMMessage(doc, xmlHelper.getClass_request(doc, objectName, localOnly, includeQualifiers, includeClassOrigin, propertyList));
                    InputStreamReader is = this.transmitRequest("GetClass", hh, doc);
                    Enumeration enumeration = this.getEnumeration(is, objectName);
                    if (!enumeration.hasMoreElements()) break block10;
                    cimClass = (CIMClass)enumeration.nextElement();
                }
                catch (CIMException e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing getClass request", e);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing getClass request", e);
                    }
                    throw new CIMException("CIM_ERR_FAILED", e);
                }
            }
            Object var13_14 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, cimClass);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, cimClass);
            }
            throw throwable;
        }
        return cimClass;
    }

    public CIMObjectPath createInstance(CIMObjectPath objectName, CIMInstance instance) throws CIMException {
        String methodName = "createInstance(CIMObjectPath, CIMInstance)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, instance});
        }
        this.preCheck(objectName);
        CIMObjectPath ref = null;
        try {
            block10: {
                try {
                    HttpHeader hh = new HttpHeader();
                    hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                    Document doc = xmlHelper.newDocument();
                    xmlHelper.createCIMMessage(doc, xmlHelper.createInstance_request(doc, objectName, instance));
                    InputStreamReader is = this.transmitRequest("CreateInstance", hh, doc);
                    Enumeration enumeration = this.getEnumeration(is, objectName);
                    if (!enumeration.hasMoreElements()) break block10;
                    ref = (CIMObjectPath)enumeration.nextElement();
                }
                catch (CIMException e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing createInstance request", e);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing createInstance request", e);
                    }
                    throw new CIMException("CIM_ERR_FAILED", e);
                }
            }
            Object var10_11 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, ref);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, ref);
            }
            throw throwable;
        }
        return ref;
    }

    public CIMValue invokeMethod(CIMObjectPath objectName, String methodName, Vector inArgs, Vector outArgs) throws CIMException {
        String mName = "invokeMethod(CIMObjectPath, String, Vector, Vector)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, mName, new Object[]{objectName, methodName, inArgs, outArgs});
        }
        this.preCheck(objectName);
        CIMValue rtnValue = null;
        try {
            block13: {
                try {
                    CIMResponse response;
                    HttpHeader hh = new HttpHeader();
                    hh.addField("CIMObject", HttpHeader.encode(objectName.toString(), "UTF-8", "US-ASCII"));
                    Document doc = xmlHelper.newDocument();
                    xmlHelper.createCIMMessage(doc, xmlHelper.invokeMethod_request(doc, objectName, methodName, inArgs));
                    InputStreamReader is = this.transmitRequest(methodName, hh, doc);
                    if (GlobalProperties.getXmlParser() == 1 || GlobalProperties.getXmlParser() == 0) {
                        XMLDefaultHandlerImpl hndlr = new XMLDefaultHandlerImpl();
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        SAXParser saxParser = factory.newSAXParser();
                        saxParser.parse(new InputSource(is), (DefaultHandler)hndlr);
                        Vector o = hndlr.getObjects();
                        response = (CIMResponse)o.elementAt(0);
                    } else {
                        response = this.getSingleResponse(is);
                    }
                    response.checkError();
                    Vector resultSet = response.getFirstReturnValue();
                    if (resultSet.size() > 0 && resultSet.elementAt(0) instanceof CIMValue) {
                        rtnValue = (CIMValue)resultSet.elementAt(0);
                    }
                    Vector outParamValues = response.getParamValues();
                    if (outArgs == null) break block13;
                    outArgs.addAll(outParamValues);
                }
                catch (CIMException e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing invokeMethod request", e);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.log(Level.INFO, "Error while processing invokeMethod request", e);
                    }
                    throw new CIMException("CIM_ERR_FAILED", e);
                }
            }
            Object var16_17 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, mName, rtnValue);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, mName, rtnValue);
            }
            throw throwable;
        }
        return rtnValue;
    }

    public void createClass(CIMObjectPath objectName, CIMClass cc) throws CIMException {
        String methodName = "createClass(CIMObjectPath, CIMClass)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, cc});
        }
        this.preCheck(objectName);
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.createClass_request(doc, objectName, cc));
                InputStreamReader is = this.transmitRequest("CreateClass", hh, doc);
                this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing createClass request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing createClass request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var8_9 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public void createQualifierType(CIMObjectPath objectName, CIMQualifierType qt) throws CIMException {
        String methodName = "createQualifierType(CIMObjectPath, CIMQualifierType)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, qt});
        }
        this.preCheck(objectName);
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.createQualifierType_request(doc, objectName, qt));
                InputStreamReader is = this.transmitRequest("CreateQualifierType", hh, doc);
                this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing createQualifierType request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing createQualifierType request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var8_9 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public void deleteClass(CIMObjectPath objectName) throws CIMException {
        String methodName = "deleteClass(CIMObjectPath)";
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName});
        }
        this.preCheck(objectName);
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.deleteClass_request(doc, objectName));
                InputStreamReader is = this.transmitRequest("DeleteClass", hh, doc);
                this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing deleteClass request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing deleteClass request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var7_8 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public void deleteQualifierType(CIMObjectPath objectName) throws CIMException {
        String methodName = "deleteQualifierType(CIMObjectPath)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName});
        }
        this.preCheck(objectName);
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.deleteQualifierType_request(doc, objectName));
                InputStreamReader is = this.transmitRequest("DeleteQualifierType", hh, doc);
                this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing deleteQualifierType request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing deleteQualifierType request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var7_8 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public Enumeration enumerateClasses(CIMObjectPath objectName, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        String methodName = "deleteQualifierType(CIMObjectPath, boolean, boolean, boolean, boolean)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, deep, localOnly, includeQualifiers, includeClassOrigin});
        }
        this.preCheck(objectName);
        Enumeration enumeration = null;
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.enumerateClasses_request(doc, objectName, deep, localOnly, includeQualifiers, includeClassOrigin));
                InputStreamReader is = this.transmitRequest("EnumerateClasses", hh, doc);
                enumeration = this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateClasses request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateClasses request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var12_13 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
            throw throwable;
        }
        return enumeration;
    }

    public Enumeration enumerateClassNames(CIMObjectPath objectName, boolean deep) throws CIMException {
        String methodName = "enumerateClassNames(CIMObjectPath, boolean)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{objectName, deep});
        }
        this.preCheck(objectName);
        Enumeration enumeration = null;
        try {
            try {
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
                Document doc = xmlHelper.newDocument();
                xmlHelper.createCIMMessage(doc, xmlHelper.enumerateClassNames_request(doc, objectName, deep));
                InputStreamReader is = this.transmitRequest("EnumerateClassNames", hh, doc);
                enumeration = this.getEnumeration(is, objectName);
            }
            catch (CIMException e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateClassNames request", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Error while processing enumerateClassNames request", e);
                }
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            Object var9_10 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, enumeration);
            }
            throw throwable;
        }
        return enumeration;
    }

    public Enumeration execQuery(CIMObjectPath objectName) throws CIMException {
        return this.execQuery(objectName, null, "WQL");
    }

    public CIMValue getProperty(CIMObjectPath objectName, String propertyName) throws CIMException {
        this.preCheck(objectName);
        try {
            CIMProperty property;
            CIMInstance inst;
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.getInstance_request(doc, objectName, false, false, false, new String[]{propertyName}));
            InputStreamReader is = this.transmitRequest("GetInstance", hh, doc);
            Enumeration enumeration = this.getEnumeration(is, objectName);
            if (enumeration.hasMoreElements() && (inst = (CIMInstance)enumeration.nextElement()) != null && (property = inst.getProperty(propertyName)) != null) {
                return property.getValue();
            }
            return null;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public Enumeration referenceNames(CIMObjectPath objectName) throws CIMException {
        return this.referenceNames(objectName, null, null);
    }

    public Enumeration referenceNames(CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.referenceNames_request(doc, objectName, resultClass, role));
            InputStreamReader is = this.transmitRequest("ReferenceNames", hh, doc);
            return this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public Enumeration references(CIMObjectPath objectName) throws CIMException {
        return this.references(objectName, null, null, true, true, null);
    }

    public Enumeration references(CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.references_request(doc, objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList));
            InputStreamReader is = this.transmitRequest("References", hh, doc);
            return this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setClass(CIMObjectPath objectName, CIMClass cc) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.setClass_request(doc, objectName, cc));
            InputStreamReader is = this.transmitRequest("ModifyClass", hh, doc);
            this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setInstance(CIMObjectPath objectName, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.setInstance_request(doc, objectName, ci, includeQualifiers, propertyList));
            InputStreamReader is = this.transmitRequest("ModifyInstance", hh, doc);
            this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setProperty(CIMObjectPath objectName, String propertyName) throws CIMException {
        this.setProperty(objectName, propertyName, null);
    }

    public void setProperty(CIMObjectPath objectName, String propertyName, CIMValue newValue) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.setProperty_request(doc, objectName, propertyName, newValue));
            InputStreamReader is = this.transmitRequest("SetProperty", hh, doc);
            this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void setQualifierType(CIMObjectPath objectName, CIMQualifierType qt) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.setQualifierType_request(doc, objectName, qt));
            InputStreamReader is = this.transmitRequest("SetQualifierType", hh, doc);
            this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public void close() throws CIMException {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "The CIM Client on: " + this.uri + " has been closed!");
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public void createNameSpace(CIMNameSpace ns) throws CIMException {
        this.preCheck(ns);
        String namespace = ns.getNameSpace();
        int i = namespace.lastIndexOf(47);
        if (i < 0) {
            throw new CIMException("CIM_ERR_NOT_FOUND", "Invalid namespace. Must contain at least one /");
        }
        String parentNs = namespace.substring(0, i);
        namespace = namespace.substring(i + 1);
        CIMInstance inst = new CIMInstance();
        inst.setClassName("CIM_NameSpace");
        CIMProperty prop = new CIMProperty("NameSpace");
        prop.setValue(new CIMValue(namespace, CIMDataType.getPredefinedType(8)));
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        v.add(prop);
        inst.setProperties(v);
        CIMObjectPath op = new CIMObjectPath(null, parentNs);
        this.createInstance(op, inst);
    }

    public void deleteNameSpace(CIMNameSpace ns) throws CIMException {
        this.preCheck(ns);
        CIMObjectPath op = new CIMObjectPath();
        op.setNameSpace(ns);
        this.deleteInstance(op);
    }

    public Enumeration enumNameSpace(CIMObjectPath objectName, boolean deep) throws CIMException {
        this.preCheck(objectName);
        objectName.setObjectName("CIM_NameSpace");
        return this.enumerateInstanceNames(objectName);
    }

    public Enumeration execQuery(CIMObjectPath objectName, String query, String queryLanguage) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.execQuery_request(doc, objectName, query, queryLanguage));
            InputStreamReader is = this.transmitRequest("ExecQuery", hh, doc);
            return this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public CIMQualifierType getQualifierType(CIMObjectPath objectName) throws CIMException {
        return this.getQualifierType(objectName, null);
    }

    public CIMQualifierType getQualifierType(CIMObjectPath objectName, String qt) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.getQualifier_request(doc, objectName, qt));
            InputStreamReader is = this.transmitRequest("GetQualifier", hh, doc);
            Enumeration enumeration = this.getEnumeration(is, objectName);
            if (enumeration.hasMoreElements()) {
                return (CIMQualifierType)enumeration.nextElement();
            }
            return null;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public Enumeration enumQualifierTypes(CIMObjectPath objectName) throws CIMException {
        this.preCheck(objectName);
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(objectName.getNameSpace(), "UTF-8", "US-ASCII"));
            Document doc = xmlHelper.newDocument();
            xmlHelper.createCIMMessage(doc, xmlHelper.enumQualifierTypes_request(doc, objectName));
            InputStreamReader is = this.transmitRequest("EnumerateQualifiers", hh, doc);
            return this.getEnumeration(is, objectName);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public BatchResult performBatchOperations(BatchHandle bc) throws CIMException {
        Vector operations = bc.getOperations();
        BatchResult result = null;
        if (operations.size() < 2) {
            throw new CIMException("CIM_ERR_FAILED", "Invalid number of batch operations (" + operations.size() + ")");
        }
        Iterator iter = operations.iterator();
        while (iter.hasNext()) {
            CIMOperation op = (CIMOperation)iter.next();
            if (op instanceof CIMCreateNameSpaceOp || op instanceof CIMDeleteNameSpaceOp) {
                this.preCheck(op.getNameSpace());
                continue;
            }
            this.preCheck(op.getObjectName());
        }
        HttpHeader hh = new HttpHeader();
        hh.addField("CIMBatch", "CIMBatch");
        Document doc = xmlHelper.newDocument();
        try {
            CIMResponse response;
            xmlHelper.performBatchOperation_request(doc, operations);
            InputStreamReader is = this.transmitRequest(null, hh, doc);
            if (GlobalProperties.getXmlParser() == 1 || GlobalProperties.getXmlParser() == 0) {
                XMLDefaultHandlerImpl hndlr = new XMLDefaultHandlerImpl();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new InputSource(is), (DefaultHandler)hndlr);
                Vector o = hndlr.getObjects();
                response = (CIMResponse)o.elementAt(0);
            } else {
                response = this.getMultiResponse(is);
            }
            Vector allResponses = response.getAllResponses();
            if (allResponses.size() != operations.size()) {
                throw new CIMException("CIM_ERR_FAILED", "Batch operation result set size does not the size of the request");
            }
            iter = allResponses.iterator();
            for (int i = 0; i < allResponses.size(); ++i) {
                CIMResponse resp = (CIMResponse)allResponses.elementAt(i);
                CIMOperation op = (CIMOperation)operations.elementAt(i);
                if (resp.isSuccessul()) {
                    if (op instanceof CIMGetClassOp || op instanceof CIMGetInstanceOp || op instanceof CIMGetPropertyOp || op instanceof CIMGetQualifierTypeOp) {
                        Vector v = resp.getFirstReturnValue();
                        if (v.size() > 0) {
                            if (op instanceof CIMGetPropertyOp) {
                                CIMInstance inst = (CIMInstance)v.elementAt(0);
                                CIMProperty property = inst.getProperty(((CIMGetPropertyOp)op).getPropertyName());
                                if (property == null) continue;
                                op.setResult(property.getValue());
                                continue;
                            }
                            if (op instanceof CIMGetClassOp || op instanceof CIMGetInstanceOp) {
                                op.setResult(CIMClientXML.fixResultSet(op.getObjectName(), v, this.nameSpace));
                                continue;
                            }
                            op.setResult(v.elementAt(0));
                            continue;
                        }
                        op.setResult(null);
                        continue;
                    }
                    if (op instanceof CIMAssociatorNamesOp || op instanceof CIMAssociatorsOp || op instanceof CIMEnumClassesOp || op instanceof CIMEnumClassNamesOp || op instanceof CIMEnumInstanceNamesOp || op instanceof CIMEnumInstancesOp || op instanceof CIMEnumNameSpaceOp || op instanceof CIMEnumQualifierTypesOp || op instanceof CIMReferenceNamesOp || op instanceof CIMReferencesOp || op instanceof CIMExecQueryOp) {
                        op.setResult(CIMClientXML.fixResultSet(op.getObjectName(), resp.getFirstReturnValue(), this.nameSpace).elements());
                        continue;
                    }
                    if (!(op instanceof CIMInvokeMethodOp)) continue;
                    Vector outParamValues = resp.getParamValues();
                    Vector outArgs = ((CIMInvokeMethodOp)op).getOutParams();
                    if (outArgs == null) continue;
                    outArgs.addAll(outParamValues);
                    continue;
                }
                op.setResult(resp.getException());
            }
            result = new BatchResult(operations.toArray(new CIMOperation[operations.size()]));
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean initializeIndicationServer() {
        if (this.indicationServer != null) return true;
        CIMClientXML cIMClientXML = this;
        synchronized (cIMClientXML) {
            if (this.indicationServer != null) return true;
            CIMEventDispatcher dispatcher = new CIMEventDispatcher(this.indicationClient);
            CIMIndicationHandler indicationHdlr = new CIMIndicationHandler(dispatcher);
            try {
                this.indicationServer = new HttpServerConnection(new HttpConnectionHandler(indicationHdlr), 0);
                this.indicationServer.setName("CIMListener - Http Server");
                this.indicationServer.start();
                return true;
            }
            catch (Exception e) {
                dispatcher.kill();
                if (!this.logger.isLoggable(Level.WARNING)) return false;
                this.logger.log(Level.WARNING, "could not initialize CIM Indication Listener", e);
            }
            return false;
        }
    }

    public void addCIMListener(CIMListener listener) throws CIMException {
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication listener");
        }
        this.indicationClient.addListener(listener);
    }

    public void addCIMListener(CIMListener listener, String id) throws CIMException {
        if (listener == null) {
            throw new IllegalArgumentException("null CIMListener argument");
        }
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication listener");
        }
        this.indicationClient.addListener(listener);
    }

    public void removeCIMListener(CIMListener listener) throws CIMException {
        this.indicationClient.removeListener(listener);
    }

    public CIMInstance getIndicationListener(CIMListener listener) throws CIMException {
        if (listener == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null listener argument");
        }
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication listener");
        }
        try {
            String host = this.indicationServer.getHostIP();
            int port = this.indicationServer.getPort();
            CIMClass clazz = this.getClass(new CIMObjectPath("CIM_ListenerDestinationCIMXML"), false, false, false, null);
            CIMInstance inst = clazz.newInstance();
            inst.setProperty("CreationClassName", new CIMValue("CIM_IndicationHandlerCIMXML", CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemCreationClassName", new CIMValue("CIM_ComputerSystem", CIMDataType.getPredefinedType(8)));
            inst.setProperty("Name", new CIMValue(this.getUniqueID(host, port), CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemName", new CIMValue(host, CIMDataType.getPredefinedType(8)));
            String id = String.valueOf(listener.hashCode());
            inst.setProperty("Destination", new CIMValue("http://" + host + ":" + port + "/" + id, CIMDataType.getPredefinedType(8)));
            return inst;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    public CIMInstance getIndicationHandler(CIMListener listener) throws CIMException {
        if (listener == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "null listener argument");
        }
        if (!this.initializeIndicationServer()) {
            throw new CIMException("CIM_ERR_FAILED", "Could not initialize indication server");
        }
        try {
            String host = this.indicationServer.getHostIP();
            int port = this.indicationServer.getPort();
            String id = String.valueOf(listener.hashCode());
            CIMClass clazz = this.getClass(new CIMObjectPath("CIM_IndicationHandler"), false, false, false, null);
            CIMInstance inst = clazz.newInstance();
            inst.setProperty("CreationClassName", new CIMValue("CIM_IndicationHandler", CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemCreationClassName", new CIMValue("CIM_ComputerSystem", CIMDataType.getPredefinedType(8)));
            inst.setProperty("Name", new CIMValue(this.getUniqueID(host, port), CIMDataType.getPredefinedType(8)));
            inst.setProperty("SystemName", new CIMValue(host, CIMDataType.getPredefinedType(8)));
            inst.setProperty("Destination", new CIMValue("http://" + host + ":" + port + "/" + id, CIMDataType.getPredefinedType(8)));
            return inst;
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueID(String host, int port) {
        int cntr;
        Object object = this.lock;
        synchronized (object) {
            cntr = this.counter++;
        }
        String uniqueId = host + ":" + port + ":" + System.currentTimeMillis() + ":" + cntr++;
        return uniqueId;
    }

    public HttpUrlConnection newConnection(String cimMethod, HttpHeader hh) {
        String methodName = "newConnection(String, HttpHeader)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{cimMethod, hh});
        }
        this.connection = new HttpUrlConnection(this.uri, this.httpClientPool, this.auth_handler);
        if (this.useMPost) {
            this.connection.setRequestMethod("M-POST");
        } else {
            this.connection.setRequestMethod("POST");
        }
        this.connection.useHttp11(this.useHttp11);
        String localeStr = this.locale.getLanguage() + '-' + this.locale.getCountry();
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setRequestProperty("Content-type", "application/xml; charset=\"utf-8\"");
        this.connection.setRequestProperty("Accept", "text/html, text/xml, application/xml");
        this.connection.setRequestProperty("Cache-Control", "no-cache");
        this.connection.setRequestProperty("Content-Language", localeStr);
        this.connection.setRequestProperty("Accept-Language", localeStr);
        if (this.authorization != null) {
            this.connection.setRequestProperty("Authorization", this.authorization);
        }
        String prefix = "";
        if (this.connection.getRequestMethod().equalsIgnoreCase("M-POST")) {
            ++this.nsCntr;
            if (this.nsCntr > 99) {
                this.nsCntr = 0;
            }
            String ns = (this.nsCntr < 10 ? "0" : "") + this.nsCntr;
            this.connection.setRequestProperty("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + ns);
            prefix = ns + "-";
        }
        this.connection.setRequestProperty(prefix + "CIMProtocolVersion", "1.0");
        this.connection.setRequestProperty(prefix + "CIMOperation", "MethodCall");
        try {
            this.connection.setRequestProperty(prefix + "CIMMethod", HttpHeader.encode(cimMethod, "UTF-8", "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Unable to encode HTTP Header", e);
            }
            this.connection.setRequestProperty(prefix + "CIMMethod", cimMethod);
        }
        Iterator iter = hh.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.connection.setRequestProperty(prefix + entry.getKey().toString(), entry.getValue().toString());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "headers = " + hh);
            this.logger.exiting(CLASSNAME, methodName, this.connection);
        }
        return this.connection;
    }

    public Enumeration getEnumeration(InputStreamReader is, CIMObjectPath objectName) throws IOException, SAXException {
        CIMEnumerationImpl enumeration = GlobalProperties.getXmlParser() == 1 || GlobalProperties.getXmlParser() == 0 ? new CIMEnumerationImpl(new XMLDefaultHandlerImpl(), objectName, this.nameSpace, is, this.connection.getHttpClient(), GlobalProperties.getXmlParser() == 1) : new CIMEnumerationImpl(this.getSingleResponse(is).getFirstReturnValue().elements(), objectName, this.nameSpace);
        return enumeration;
    }

    public CIMResponse getMultiResponse(InputStreamReader is) throws IOException, SAXException {
        Document doc = xmlHelper.parse(new InputSource(is));
        if (GlobalProperties.isDebugXMLInput()) {
            CIMClientXML_HelperImpl.dumpDocument(doc);
        }
        is.close();
        Element rootE = doc.getDocumentElement();
        CIMResponse response = (CIMResponse)CIMXMLParserImpl.parseCIM(rootE);
        return response;
    }

    public CIMResponse getDocument(InputStreamReader is) throws IOException, SAXException {
        Document doc = xmlHelper.parse(new InputSource(is));
        if (GlobalProperties.isDebugXMLInput()) {
            CIMClientXML_HelperImpl.dumpDocument(doc);
        }
        is.close();
        Element rootE = doc.getDocumentElement();
        CIMResponse response = (CIMResponse)CIMXMLParserImpl.parseCIM(rootE);
        response.checkError();
        return response;
    }

    private CIMResponse getSingleResponse(InputStreamReader is) throws IOException, SAXException {
        XMLDefaultHandlerImpl handler = new XMLDefaultHandlerImpl();
        handler.parse(new XMLPullParser(is));
        Vector v = handler.getObjects();
        if (v.size() > 0) {
            CIMResponse response = (CIMResponse)v.elementAt(0);
            response.checkError();
            return response;
        }
        throw new IllegalStateException("XML parsing produces no CIM response");
    }

    public InputStreamReader transmitRequest(String cimMethod, HttpHeader hh, Document doc) throws CIMException, IOException, ProtocolException, SAXException {
        String methodName = "transmitRequest(String, HttpHeader, Document )";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new Object[]{cimMethod, hh});
        }
        Benchmark.startTransportTimer();
        int retries = 1;
        while (retries-- >= 0) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Attempting to connect.. num of attempts left:" + retries);
            }
            this.connection = this.newConnection(cimMethod, hh);
            try {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "connecting...");
                }
                this.connection.connect();
            }
            catch (UnknownHostException uhe) {
                throw new CIMTransportException("EXT_ERR_UNKNOWN_SERVER", uhe);
            }
            catch (SocketException e) {
                throw new CIMTransportException("EXT_ERR_UNABLE_TO_CONNECT", e);
            }
            OutputStream os = this.connection.getOutputStream();
            if (GlobalProperties.isDebugXMLOutput()) {
                CIMClientXML_HelperImpl.dumpDocument(doc);
            }
            CIMClientXML_HelperImpl.serialize(os, doc);
            os.flush();
            os.close();
            int resultCode = 200;
            try {
                resultCode = this.connection.getResponseCode();
            }
            catch (SocketException e) {
                throw new CIMException("EXT_ERR_UNABLE_TO_CONNECT", e);
            }
            catch (SocketTimeoutException e) {
                throw new CIMException("EXT_ERR_TIME_OUT", e);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) continue;
                this.logger.log(Level.WARNING, " -->>>> Engenio ISSUE <<<<-- Exception caught while getting HTTP response code.");
                continue;
            }
            HttpHeader headers = this.parseHeaders(this.connection);
            String auth = this.connection.getRequestProperty("Authorization");
            if (auth != null) {
                this.authorization = auth;
            }
            String cimError = headers.getField("CIMError");
            if (resultCode == 200) {
                String contentLengthStr = headers.getField("Content-Length");
                int contentLenght = Integer.parseInt(contentLengthStr);
                if (contentLenght < 50) {
                    if (!this.logger.isLoggable(Level.WARNING)) continue;
                    this.logger.log(Level.WARNING, " -->>>> Engenio ISSUE <<<<-- Content Length LOWER than 50 (" + contentLenght + ")- retrying request.");
                    continue;
                }
                String charset = this.getCharacterSet(headers);
                InputStream is = GlobalProperties.isDebugInputStream() ? new DebugInputStream(this.connection.getInputStream(), GlobalProperties.getDebugOutputStream()) : this.connection.getInputStream();
                Benchmark.stopTransportTimer();
                return new InputStreamReader(is, charset);
            }
            if (resultCode == 500) {
                if (!this.logger.isLoggable(Level.FINER)) continue;
                this.logger.log(Level.FINER, "Received HTTP Error 500 - HTTP_INTERNAL_ERROR - retying !");
                continue;
            }
            if (resultCode == 501) {
                String cimProtocolVersion = headers.getField("CIMProtocolVersion");
                if (cimProtocolVersion == null && cimError == null && this.useMPost) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - retying with HTTP POST !");
                    }
                    this.useMPost = false;
                    continue;
                }
                if (cimProtocolVersion == null || cimProtocolVersion.length() == 0) {
                    cimProtocolVersion = "1.0";
                }
                if ("unsupported-protocol-version".equalsIgnoreCase(cimError)) {
                    if (!this.logger.isLoggable(Level.FINER)) break;
                    this.logger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - unsupported-protocol-version !");
                    break;
                }
                if ("multiple-request-unsupported".equalsIgnoreCase(cimError)) {
                    if (!this.logger.isLoggable(Level.FINER)) break;
                    this.logger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - multiple-request-unsupported !");
                    break;
                }
                if ("unsupported-cim-version".equalsIgnoreCase(cimError)) {
                    if (!this.logger.isLoggable(Level.FINER)) break;
                    this.logger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - unsupported-cim-version !");
                    break;
                }
                if (!"unsupported-dtd-version".equalsIgnoreCase(cimError)) continue;
                if (!this.logger.isLoggable(Level.FINER)) break;
                this.logger.log(Level.FINER, "Received HTTP Error 501 - HTTP NOT IMPLEMENTED - unsupported-dtd-version !");
                break;
            }
            if (resultCode == 400) {
                if (!"request-not-valid".equalsIgnoreCase(cimError)) {
                    if ("request-not-well-formed".equalsIgnoreCase(cimError)) {
                        if (!this.logger.isLoggable(Level.FINER)) break;
                        this.logger.log(Level.FINER, "Received HTTP Error 400 - BAD REQUEST - request-not-well-formed !");
                        break;
                    }
                    if ("request-not-loosely-valid".equalsIgnoreCase(cimError)) {
                        if (!this.logger.isLoggable(Level.FINER)) break;
                        this.logger.log(Level.FINER, "Received HTTP Error 400 - BAD REQUEST - request-not-loosely-valid !");
                        break;
                    }
                }
                if (!this.logger.isLoggable(Level.FINER)) break;
                this.logger.log(Level.FINER, "Received HTTP Error 400 - BAD REQUEST - cimError not specified!");
                break;
            }
            if (resultCode == 401) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Received HTTP Error 401 - UNAUTHORIZED. Throwing CIMAuthenticationException!");
                }
                throw new CIMAuthenticationException("EXT_ERR_AUTHENTICATION");
            }
            if (resultCode == 403) {
                if (!this.logger.isLoggable(Level.FINER)) break;
                this.logger.log(Level.FINER, "Received HTTP Error 403 - FORBIDDEN.");
                break;
            }
            if (resultCode == 407) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Received HTTP Error 407 - ERR PROXY AUTHENTICATION. Throwing CIMAuthenticationException!");
                }
                throw new CIMAuthenticationException("EXT_ERR_PROXY_AUTHENTICATION");
            }
            if (resultCode == 405) {
                if (!this.logger.isLoggable(Level.FINER)) break;
                this.logger.log(Level.FINER, "Received HTTP Error 405 - BAD METHOD.");
                break;
            }
            if (resultCode == 510) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Received HTTP Error 510 on M-POST. Retrying with POST.");
                }
                this.useMPost = false;
                continue;
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "No known HTTP error recognized. Retrying with POST.");
            }
            this.useMPost = false;
        }
        Benchmark.stopTransportTimer();
        throw new CIMTransportException("EXT_ERR_UNABLE_TO_CONNECT", new String[]{"\"HTTP " + this.connection.getResponseCode() + " " + this.connection.getResponseMessage() + "\"", "CIMError:\"" + this.connection.getHeaderField("CIMError") + "\""});
    }

    protected String getCharacterSet(HttpHeader headers) {
        String contentType = headers.getField("Content-type");
        String charset = "UTF-8";
        if (contentType != null && contentType.length() > 0) {
            HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
            charset = contentTypeHeader.findValue("charset", charset);
        }
        return charset;
    }

    protected HttpHeader parseHeaders(URLConnection con) {
        String man = con.getHeaderField("Man");
        String opt = con.getHeaderField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.findValue("ns");
        }
        if (ns != null) {
            String key;
            int i = 0;
            while ((key = con.getHeaderFieldKey(++i)) != null) {
                if (key.startsWith(ns + "-")) {
                    headers.addField(key.substring(3), con.getHeaderField(i));
                    continue;
                }
                headers.addField(key, con.getHeaderField(i));
            }
        } else {
            String key;
            int i = 1;
            while ((key = con.getHeaderFieldKey(i)) != null) {
                headers.addField(key, con.getHeaderField(i));
                ++i;
            }
        }
        return headers;
    }

    protected static Vector fixResultSet(CIMObjectPath request, Vector v, CIMNameSpace nameSpace) {
        if (v != null && request.getNameSpace() != null && nameSpace.getNameSpace() != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                CIMClientXML.fixResult(request, o, nameSpace);
            }
        }
        return v;
    }

    protected static Object fixResult(CIMObjectPath request, Object o, CIMNameSpace nameSpace) {
        if (o != null) {
            String opNs;
            String ns = request.getNameSpace();
            if (ns == null) {
                ns = nameSpace.getNameSpace();
            }
            CIMObjectPath def = new CIMObjectPath();
            def.setNameSpace(ns);
            CIMObjectPath op = null;
            if (o instanceof CIMObjectPath) {
                op = (CIMObjectPath)o;
            } else if (o instanceof CIMInstance) {
                op = ((CIMInstance)o).getObjectPath();
            } else if (o instanceof CIMClass) {
                op = ((CIMClass)o).getObjectPath();
            }
            if (op != null && ((opNs = op.getNameSpace()) == null || opNs.length() == 0)) {
                op.setNameSpace(def.getNameSpace());
            }
        }
        return o;
    }
}

