/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.client.CIMClientXML;
import org.sblim.wbem.client.CIMEnumeration;
import org.sblim.wbem.http.HttpClient;
import org.sblim.wbem.util.GlobalProperties;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CIMEnumerationImpl
implements CIMEnumeration {
    private static final String CLASSNAME = "org.sblim.wbem.client.CIMEnumerationImpl";
    private static final String EMPTY = "";
    private XMLPullParser pullParser;
    private XMLDefaultHandlerImpl hndlr;
    private CIMObjectPath request;
    private CIMNameSpace defaultNS;
    private boolean hasNext;
    private InputStreamReader is;
    private Enumeration enumeration;
    private boolean useSAX;
    private HttpClient httpClient;
    private Logger logger = GlobalProperties.getLogger();

    public CIMEnumerationImpl(Enumeration enumeration, CIMObjectPath request, CIMNameSpace defaultNS) {
        this.request = request;
        this.defaultNS = defaultNS;
        this.enumeration = enumeration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMEnumerationImpl(XMLDefaultHandlerImpl hndlr, CIMObjectPath request, CIMNameSpace defaultNS, InputStreamReader is, HttpClient httpClient, boolean useSAX) {
        String methodName = "CIMEnumerationImpl(XMLDefaultHandlerImpl, CIMObjectPath, CIMNameSpace, InputStreamReader, HttpClient, boolean)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, new String[]{request.toString(), defaultNS != null ? defaultNS.toString() : null, is != null ? is.toString() : null, httpClient != null ? httpClient.toString() : null, Boolean.toString(useSAX)});
        }
        this.hndlr = hndlr;
        this.request = request;
        this.defaultNS = defaultNS;
        this.is = is;
        this.useSAX = useSAX;
        this.httpClient = httpClient;
        try {
            try {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, useSAX ? "Using SAX parser... " : "Using Pull parser... ");
                }
                if (useSAX) {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    saxParser.parse(new InputSource(is), (DefaultHandler)this.hndlr);
                    is = null;
                } else {
                    this.pullParser = new XMLPullParser(is);
                    this.hasNext = CIMEnumerationImpl.next(this.pullParser, this.hndlr, false);
                    Vector o = this.hndlr.getObjects();
                    if (o != null && o.size() > 0) {
                        CIMResponse response = (CIMResponse)o.elementAt(0);
                        response.checkError();
                    } else {
                        CIMException ce = new CIMException("CIM_ERR_FAILED", "inconsistent state due to error while parsing response document");
                        throw ce;
                    }
                }
                Object var11_15 = null;
            }
            catch (CIMException e) {
                if (!this.logger.isLoggable(Level.INFO)) throw e;
                this.logger.log(Level.INFO, "Error processing a returned enumeration", e);
                throw e;
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.INFO)) throw new CIMException("CIM_ERR_FAILED", e);
                this.logger.log(Level.INFO, "Error processing a returned enumeration", e);
                throw new CIMException("CIM_ERR_FAILED", e);
            }
            if (!this.logger.isLoggable(Level.FINER)) return;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (!this.logger.isLoggable(Level.FINER)) throw throwable;
            this.logger.exiting(CLASSNAME, methodName, new String[]{request.toString(), defaultNS != null ? defaultNS.toString() : null, is != null ? is.toString() : null, httpClient != null ? httpClient.toString() : null, Boolean.toString(useSAX)});
            throw throwable;
        }
        this.logger.exiting(CLASSNAME, methodName, new String[]{request.toString(), defaultNS != null ? defaultNS.toString() : null, is != null ? is.toString() : null, httpClient != null ? httpClient.toString() : null, Boolean.toString(useSAX)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        boolean result;
        String methodName;
        block11: {
            block12: {
                methodName = "hasMoreElements()";
                result = false;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.entering(CLASSNAME, methodName, new String[]{this.request != null ? this.request.toString() : null, this.defaultNS != null ? this.defaultNS.toString() : null, this.is != null ? this.is.toString() : null, this.httpClient != null ? this.httpClient.toString() : null, Boolean.toString(this.useSAX)});
                }
                try {
                    if (this.enumeration != null) break block11;
                    if (!this.useSAX) break block12;
                    Vector o = this.hndlr.getObjects();
                    if (o == null || o.size() == 0) {
                        CIMException e = new CIMException("CIM_ERR_FAILED", "inconsistent XML parser: could not create cim response");
                        if (this.logger.isLoggable(Level.INFO)) {
                            this.logger.log(Level.INFO, "inconsistent XML parser: could not create cim response", e);
                        }
                        throw e;
                    }
                    CIMResponse response = (CIMResponse)o.elementAt(0);
                    boolean bl = result = response.getFirstReturnValue().size() > 0;
                    Object var7_9 = null;
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.exiting(CLASSNAME, methodName, result);
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    block13: {
                        Object var7_12 = null;
                        if (!this.logger.isLoggable(Level.FINER)) break block13;
                        this.logger.exiting(CLASSNAME, methodName, result);
                    }
                    throw throwable;
                }
            }
            result = this.hasNext;
            if (!this.hasNext) {
                this.is = null;
            }
            boolean bl = result;
            Object var7_10 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, result);
            }
            return bl;
        }
        boolean bl = result = this.enumeration.hasMoreElements();
        Object var7_11 = null;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName, result);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nextElement() {
        Object objects2;
        Object resultObj;
        String methodName;
        block16: {
            Object var6_12;
            block15: {
                methodName = "nextElement()";
                resultObj = null;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.entering(CLASSNAME, methodName);
                }
                try {
                    Object var6_11;
                    block14: {
                        try {
                            if (this.enumeration == null) {
                                Vector objects2 = this.hndlr.getObjects();
                                if (objects2.size() == 0) {
                                    CIMException e = new CIMException("CIM_ERR_FAILED", "inconsistent XML parser: could not create cim response");
                                    throw e;
                                }
                                CIMResponse response = (CIMResponse)objects2.elementAt(0);
                                response.checkError();
                                Vector v = response.getFirstReturnValue();
                                if (v != null && v.size() > 0) {
                                    resultObj = v.remove(0);
                                    CIMClientXML.fixResult(this.request, resultObj, this.defaultNS);
                                    try {
                                        this.hasNext = v.size() == 0 && !this.useSAX ? CIMEnumerationImpl.next(this.pullParser, this.hndlr, false) : true;
                                    }
                                    catch (Exception e) {
                                        if (this.logger.isLoggable(Level.WARNING)) {
                                            this.logger.log(Level.WARNING, "Unexpected exception while parsing XML document from the input stream", e);
                                        }
                                        this.hasNext = false;
                                    }
                                    if (!this.hasNext) {
                                        this.is = null;
                                    }
                                    var6_11 = resultObj;
                                    Object var8_13 = null;
                                    break block14;
                                }
                                var6_12 = resultObj;
                                break block15;
                            }
                            resultObj = this.enumeration.nextElement();
                            CIMClientXML.fixResult(this.request, resultObj, this.defaultNS);
                            objects2 = resultObj;
                            break block16;
                        }
                        catch (CIMException e) {
                            if (!this.logger.isLoggable(Level.WARNING)) throw e;
                            this.logger.log(Level.WARNING, "Error occured while reading the next enumration element", e);
                            throw e;
                        }
                        catch (Exception e) {
                            if (!this.logger.isLoggable(Level.WARNING)) throw new CIMException("CIM_ERR_FAILED", e);
                            this.logger.log(Level.WARNING, "Error occured while reading the next enumration element", e);
                            throw new CIMException("CIM_ERR_FAILED", e);
                        }
                    }
                    if (!this.logger.isLoggable(Level.FINER)) return var6_11;
                    this.logger.exiting(CLASSNAME, methodName, resultObj);
                    return var6_11;
                }
                catch (Throwable throwable) {
                    Object var8_16 = null;
                    if (!this.logger.isLoggable(Level.FINER)) throw throwable;
                    this.logger.exiting(CLASSNAME, methodName, resultObj);
                    throw throwable;
                }
            }
            Object var8_14 = null;
            if (!this.logger.isLoggable(Level.FINER)) return var6_12;
            this.logger.exiting(CLASSNAME, methodName, resultObj);
            return var6_12;
        }
        Object var8_15 = null;
        if (!this.logger.isLoggable(Level.FINER)) return objects2;
        this.logger.exiting(CLASSNAME, methodName, resultObj);
        return objects2;
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean force) throws IOException {
        String methodName = "close(boolean)";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, force);
        }
        try {
            block11: {
                try {
                    if (this.is == null) break block11;
                    if (force) {
                        this.httpClient.streamFinished(false);
                    } else if (this.enumeration == null && this.is != null) {
                        this.is.close();
                    }
                    this.is = null;
                }
                catch (IOException e) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.log(Level.WARNING, "Error occured during closing the stream of enumeration", e);
                    }
                    throw e;
                }
            }
            Object var5_3 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    public void fetchAll() throws IOException {
        String methodName = "fetchAll()";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName);
        }
        try {
            try {
                CIMEnumerationImpl.next(this.pullParser, this.hndlr, true);
            }
            catch (SAXException e) {
                CIMException ee = new CIMException("CIM_ERR_FAILED", e);
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Error occured during fetching all enumeration elements", ee);
                }
                throw ee;
            }
            Object var5_2 = null;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.exiting(CLASSNAME, methodName);
            }
            throw throwable;
        }
    }

    private static boolean next(XMLPullParser reader, DefaultHandler parserHdlr, boolean fetchAll) throws IOException, SAXException {
        block6: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    parserHdlr.startElement(EMPTY, EMPTY, reader.getElementName(), reader.getAttributes());
                    break;
                }
                case 2: {
                    parserHdlr.endElement(EMPTY, EMPTY, reader.getElementName());
                    if (fetchAll) break;
                    String lastElementName = null;
                    if (reader.getElementNames().size() > 0) {
                        lastElementName = (String)reader.getElementNames().lastElement();
                    }
                    if (lastElementName == null || !lastElementName.equalsIgnoreCase("IRETURNVALUE")) continue block6;
                    return true;
                }
                case 4: {
                    char[] buf = reader.getText().toCharArray();
                    parserHdlr.characters(buf, 0, buf.length);
                    break;
                }
                case 8: {
                    return false;
                }
            }
        }
        return false;
    }

    public void finalize() {
        String methodName;
        block5: {
            methodName = "finalize()";
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.entering(CLASSNAME, methodName);
            }
            try {
                if (this.is != null) {
                    this.close(true);
                }
            }
            catch (IOException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block5;
                this.logger.log(Level.WARNING, "Error occured during cleaning up the enumeration", e);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName);
        }
    }
}

