/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.HttpConnectionHandler;
import org.sblim.wbem.http.HttpServerWorker;
import org.sblim.wbem.http.HttpSocketFactory;
import org.sblim.wbem.util.GlobalProperties;
import org.sblim.wbem.util.ThreadPool;

public class HttpServerConnection
implements Runnable {
    protected int port;
    protected ServerSocket serverSocket;
    protected HttpConnectionHandler handler;
    protected HttpConnectionDispatcher dispatcher;
    protected boolean close = true;
    public static Vector connectionPool;
    private String serverName;
    private boolean ssl;
    private ThreadPool threadPool;
    private Thread runner;

    public HttpServerConnection(HttpConnectionHandler handler, int port, boolean ssl) throws IOException {
        this.port = port;
        this.handler = handler;
        this.ssl = ssl;
        this.serverName = "HTTP" + (ssl ? "S Server" : " Server");
        this.serverSocket = HttpSocketFactory.getInstance().getServerSocketFactory(ssl).createServerSocket(port);
    }

    public HttpServerConnection(HttpConnectionHandler handler, int port) throws IOException {
        this(handler, port, false);
    }

    public void setName(String name) {
        if (this.runner != null) {
            this.runner.setName(name);
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public String getHostIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public boolean isSSL() {
        return this.ssl;
    }

    private HttpConnectionDispatcher getDispatcher() {
        HttpConnectionDispatcher dispatcher = new HttpConnectionDispatcher(connectionPool);
        dispatcher.setName("CIMListener - " + this.serverName + " - Connection Dispatcher");
        return dispatcher;
    }

    public void start() {
        if (this.close) {
            this.close = false;
            this.threadPool = new ThreadPool(0, 2);
            connectionPool = new Vector();
            this.dispatcher = this.getDispatcher();
            this.dispatcher.start();
            this.runner = new Thread(this);
            this.runner.setName(this.serverName);
            this.runner.setDaemon(true);
            this.runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            try {
                Socket server;
                block11: {
                    server = null;
                    if (this.serverSocket != null) {
                        server = this.serverSocket.accept();
                    }
                    try {
                        if (server != null) {
                            server.setKeepAlive(true);
                        }
                    }
                    catch (IOException e) {
                        Logger logger = GlobalProperties.getLogger();
                        if (!logger.isLoggable(Level.WARNING)) break block11;
                        logger.log(Level.WARNING, "exception while adjusting the keep alive option of a socket", e);
                    }
                }
                HttpConnectionDispatcher httpConnectionDispatcher = this.dispatcher;
                synchronized (httpConnectionDispatcher) {
                    if (server != null && connectionPool != null) {
                        connectionPool.add(server);
                    }
                    this.dispatcher.notifyAll();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (!this.close);
    }

    public static Vector getConnectionPool() {
        return connectionPool;
    }

    public void close() {
        if (!this.close) {
            block6: {
                this.close = true;
                try {
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                        this.serverSocket = null;
                    }
                }
                catch (IOException e) {
                    Logger logger = GlobalProperties.getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block6;
                    logger.log(Level.WARNING, "exception while accepting connection http connection", e);
                }
            }
            this.handler.close();
            if (this.dispatcher != null) {
                this.dispatcher.close();
                this.dispatcher = null;
            }
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                this.threadPool = null;
            }
            this.runner = null;
            connectionPool = null;
        }
    }

    private class HttpConnectionDispatcher
    extends Thread {
        Vector connectionPool = null;
        boolean alive = true;

        public HttpConnectionDispatcher(Vector pool) {
            this.connectionPool = pool;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Socket getConnection() {
            HttpConnectionDispatcher httpConnectionDispatcher = this;
            synchronized (httpConnectionDispatcher) {
                while (this.connectionPool.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.alive) continue;
                    return null;
                }
                Socket socket = null;
                if (this.connectionPool != null) {
                    socket = (Socket)this.connectionPool.remove(0);
                }
                return socket;
            }
        }

        public void run() {
            while (true) {
                Socket socket = this.getConnection();
                if (!this.alive) break;
                if (socket == null) continue;
                HttpServerConnection.this.threadPool.execute(new HttpServerWorker(HttpServerConnection.this.handler, socket));
            }
        }

        public synchronized void close() {
            this.alive = false;
            this.notifyAll();
        }
    }
}

