/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.sblim.wbem.http.TrustAllKeyManager;
import org.sblim.wbem.http.TrustAllTrustManager;
import org.sblim.wbem.util.GlobalProperties;

public class HttpSocketFactory {
    private static final String CLASSNAME = "org.sblim.wbem.http.HttpSocketFactory";
    private SSLSocketFactory sslSocketFactory;
    private SocketFactory defaultSocketFactory;
    private ServerSocketFactory defaultServerSocketFactory;
    private SSLServerSocketFactory sslServerSocketFactory;
    static TrustManager[] trustAllCert;
    private SSLContext sslContext;
    private static HttpSocketFactory instance;
    Logger logger = GlobalProperties.getLogger();

    private HttpSocketFactory() {
    }

    public static HttpSocketFactory getInstance() {
        return instance;
    }

    public ServerSocketFactory getServerSocketFactory(boolean ssl) {
        if (ssl) {
            return this.getSSLServerSocketFactory();
        }
        return this.getServerSocketFactory();
    }

    public SocketFactory getSocketFactory(String protocol) {
        String methodName = "getSocketFactory(String)";
        SocketFactory socketFactory = null;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName, protocol);
        }
        if (protocol.equalsIgnoreCase("https")) {
            socketFactory = this.getSSLSocketFactory();
        } else if (protocol.equalsIgnoreCase("http")) {
            socketFactory = this.getSocketFactory();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName, socketFactory);
        }
        return socketFactory;
    }

    private SSLContext getSSLContext() {
        String methodName = "getSSLContext()";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName);
        }
        KeyManager[] allKeys = new KeyManager[]{new TrustAllKeyManager()};
        String provider = GlobalProperties.getJSSEProvider();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Loading JSSE provider:" + provider);
        }
        try {
            Class<?> providerClass = Class.forName(provider);
            Provider securityProvider = (Provider)providerClass.newInstance();
            if (Security.getProvider(securityProvider.getName()) == null) {
                Security.addProvider(securityProvider);
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Unexpected exception while initializing JSSE provider: " + provider, e);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, null);
            }
            return null;
        }
        String keyStorePath = GlobalProperties.getKeystore();
        char[] keystorePassword = GlobalProperties.getKeystorePassword();
        if (keystorePassword == null && this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "Unassigned KeyStore password");
        }
        if (keyStorePath == null && this.logger.isLoggable(Level.WARNING)) {
            this.logger.log(Level.WARNING, "Unassigned keystore path ");
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Loading keystore from :" + keyStorePath);
        }
        try {
            KeyManager[] keyManager = allKeys;
            try {
                KeyStore keystore = KeyStore.getInstance("JKS");
                keystore.load(new FileInputStream(keyStorePath), keystorePassword);
                String certificates = GlobalProperties.getJSSECertificate();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Loading KeyManagerFactory with certificates from:" + certificates);
                }
                KeyManagerFactory keymanagerfactory = KeyManagerFactory.getInstance(certificates);
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Initializing KeyManagerFactory...");
                }
                keymanagerfactory.init(keystore, keystorePassword);
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Getting KeyManager...");
                }
                keyManager = keymanagerfactory.getKeyManagers();
            }
            catch (FileNotFoundException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Keystore file not found at location: " + keyStorePath, e);
                }
                keyManager = allKeys;
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "exception while reading from keystore file", e);
                }
                keyManager = allKeys;
            }
            catch (CertificateException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "problems with certificates while loading keystore", e);
                }
                keyManager = allKeys;
            }
            catch (UnrecoverableKeyException e) {
                if (this.logger.isLoggable(Level.SEVERE)) {
                    this.logger.log(Level.SEVERE, "Unexpected exception while loading keystore", e);
                }
                keyManager = allKeys;
            }
            catch (KeyStoreException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Unexpected exception while loading keystore", e);
                }
                keyManager = allKeys;
            }
            if (keystorePassword != null) {
                for (int i = 0; i < keystorePassword.length; ++i) {
                    keystorePassword[i] = '\u0000';
                }
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Getting SSLContext instance for: SSL");
            }
            this.sslContext = SSLContext.getInstance("SSL");
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Initializing SSLContext with default certificate manager (TrustAll)...");
            }
            this.sslContext.init(keyManager, new X509TrustManager[]{new TrustAllTrustManager()}, null);
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, this.sslContext);
            }
            return this.sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "exception while initializing SSL context", e);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, null);
            }
            return null;
        }
        catch (KeyManagementException e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "exception while initializing SSL context", e);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.exiting(CLASSNAME, methodName, null);
            }
            return null;
        }
    }

    protected synchronized SSLServerSocketFactory getSSLServerSocketFactory() {
        String methodName = "getSSLServerSocketFactory()";
        SSLServerSocketFactory sssf = null;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName);
        }
        if (this.sslServerSocketFactory != null) {
            sssf = this.sslServerSocketFactory;
        } else {
            if (this.sslContext == null) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Creating default SSLContext...");
                }
                this.sslContext = this.getSSLContext();
            }
            if (this.sslContext != null) {
                sssf = this.sslContext.getServerSocketFactory();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName, sssf);
        }
        return sssf;
    }

    protected synchronized SSLSocketFactory getSSLSocketFactory() {
        String methodName = "getSSLSocketFactory()";
        SSLSocketFactory sslsf = null;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName);
        }
        if (this.sslSocketFactory != null) {
            sslsf = this.sslSocketFactory;
        } else {
            if (this.sslContext == null) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Creating default SSLContext...");
                }
                this.sslContext = this.getSSLContext();
            }
            if (this.sslContext != null) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "Getting socket factory from SSLContext");
                }
                sslsf = this.sslContext.getSocketFactory();
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName, sslsf);
        }
        return sslsf;
    }

    protected synchronized ServerSocketFactory getServerSocketFactory() {
        String methodName = "getServerSocketFactory()";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "getServerSocketFactory");
        }
        if (this.defaultServerSocketFactory == null) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Using default ServerSocketFactory");
            }
            this.defaultServerSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName, this.defaultServerSocketFactory);
        }
        return this.defaultServerSocketFactory;
    }

    protected synchronized SocketFactory getSocketFactory() {
        String methodName = " getSocketFactory()";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, methodName);
        }
        if (this.defaultSocketFactory == null) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Using default SocketFactory");
            }
            this.defaultSocketFactory = SocketFactory.getDefault();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, methodName, this.defaultSocketFactory);
        }
        return this.defaultSocketFactory;
    }

    public synchronized void setSocketFactory(SocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null socket factory");
        }
        this.defaultSocketFactory = factory;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null socket factory");
        }
        this.sslSocketFactory = factory;
    }

    public synchronized void setSSLServerSocketFactory(SSLServerSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null socket factory");
        }
        this.sslServerSocketFactory = factory;
    }

    static {
        instance = new HttpSocketFactory();
    }
}

