/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DebugInputStream
extends FilterInputStream {
    private byte[] buf = new byte[512];
    private boolean buffered = false;
    private int cur = 0;
    private int maxLen = 0;
    private OutputStream out;

    public DebugInputStream(InputStream in, OutputStream out) {
        super(in);
        this.out = out;
    }

    private void buffer() throws IOException {
        int total;
        this.buffered = true;
        while ((total = this.in.read(this.buf, this.maxLen, this.buf.length - this.maxLen)) > -1) {
            this.maxLen += total;
            if (this.maxLen != this.buf.length) continue;
            byte[] b = new byte[this.buf.length << 1];
            System.arraycopy(this.buf, 0, b, 0, this.buf.length);
            this.buf = b;
        }
        if (this.out != null) {
            this.out.write("-----------------------------\n".getBytes());
            this.out.write("Dumping raw data from stream:\n".getBytes());
            this.out.write(this.buf, 0, this.maxLen);
            this.out.write("\n".getBytes());
            this.out.write("-----------------------------\n".getBytes());
        }
    }

    public synchronized int read() throws IOException {
        if (!this.buffered) {
            this.buffer();
        }
        if (this.cur >= this.maxLen) {
            return -1;
        }
        return this.buf[this.cur++];
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            if (b == null) continue;
            b[off + i] = (byte)c;
        }
        return i;
    }
}

