/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;
import org.eclipse.aperi.simulator.ui.StartCimom;

public class CompileMOF {
    protected static String startCimomCommand;
    private static String compileMofFileCommand;
    private Logger logger = Logger.getLogger(CompileMOF.class.getName());

    private int executeCommand(String command) {
        this.logger.info("Compile MOF Command is: " + command);
        int result = 0;
        try {
            String data;
            final Process process = Runtime.getRuntime().exec(command, null, new File(SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\wbemservices\\bin"));
            Thread errorThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        String data;
                        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        while (null != (data = errorReader.readLine())) {
                            CompileMOF.this.logger.warning("Compile MOF Error: " + data);
                        }
                        errorReader.close();
                    }
                    catch (IOException e) {
                        CompileMOF.this.logger.warning(e.getMessage() + e);
                        e.printStackTrace();
                    }
                }
            });
            errorThread.start();
            BufferedReader outputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (null != (data = outputReader.readLine())) {
                if (data.equals("Compilation succeeded.")) {
                    result = 1;
                }
                this.logger.info("Compilation Output: " + data);
            }
            outputReader.close();
            process.waitFor();
        }
        catch (IOException e) {
            this.logger.severe(e.getMessage() + e);
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            this.logger.severe(e.getMessage() + e);
            e.printStackTrace();
        }
        return result;
    }

    private String createBat() {
        File cimomStarter = null;
        String filePath = "cd " + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM");
        this.logger.info("CIMOM executed from path " + filePath);
        String DriveName = SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM").substring(0, 2);
        try {
            cimomStarter = File.createTempFile("RUN_CIMOM", ".bat");
            FileWriter f1 = new FileWriter(cimomStarter.getAbsolutePath());
            f1.write("echo \"Started Execution of start_cimom.bat\"");
            f1.write("\n");
            f1.write(DriveName);
            f1.write("\n");
            f1.write(filePath);
            f1.write("\n");
            f1.write("start simulator_start_cimom.bat");
            f1.write("\n");
            f1.write("echo \"Execution Stopped\"");
            f1.write("\n");
            f1.close();
        }
        catch (IOException e) {
            this.logger.severe(e.getMessage());
        }
        return cimomStarter.getAbsolutePath().toString();
    }

    public int compile() {
        CompileMOF compile = new CompileMOF();
        int retVal = -1;
        if (compile.startCimom() && compile.compileMof()) {
            retVal = 1;
        }
        return retVal;
    }

    private boolean startCimom() {
        boolean ret = false;
        startCimomCommand = this.createBat();
        StartCimom startCimom = new StartCimom();
        startCimom.start();
        try {
            Thread.sleep(20000L);
            ret = true;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private boolean compileMof() {
        boolean retVal = true;
        File mofFileLoc = new File(SetupWizardUtility.getProperty("MOF_FILE_PATH"));
        if (mofFileLoc.isDirectory()) {
            int i;
            File[] mofFiles = mofFileLoc.listFiles();
            for (i = 0; i < mofFiles.length; ++i) {
                if (!mofFiles[i].getAbsoluteFile().toString().contains("Interop")) continue;
                compileMofFileCommand = "\"" + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\wbemservices\\bin\\mofcomp.bat" + "\"" + "  -u administrator -p passw0rd " + "\"" + mofFiles[i].getAbsolutePath();
                this.logger.info("Compile Mof Command: " + compileMofFileCommand);
                if (this.executeCommand(compileMofFileCommand) == 1) continue;
                return false;
            }
            for (i = 0; i < mofFiles.length; ++i) {
                if (mofFiles[i].getAbsoluteFile().toString().contains("Interop")) continue;
                compileMofFileCommand = "\"" + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\wbemservices\\bin\\mofcomp.bat" + "\"" + "  -u administrator -p passw0rd " + "\"" + mofFiles[i].getAbsolutePath();
                this.logger.info("Compile Mof Command: " + compileMofFileCommand);
                if (this.executeCommand(compileMofFileCommand) == 1) continue;
                return false;
            }
        }
        return retVal;
    }
}

