/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;

public class SwitchDBClient {
    public static List sanPClassList;
    public static Vector switchNames;
    public static Map fabricMap;
    public static Map switchNameIDMap;
    private static Logger logger;
    public static Vector fabricNames;

    public static void configDBForSwitch() {
        Properties properties = new Properties();
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_NAME", ConnectionUtility.switchDBName);
        properties.setProperty("DB_USERNAME", ConnectionUtility.switchDBUserid);
        properties.setProperty("DB_PASSWORD", ConnectionUtility.switchDBPassword);
        properties.setProperty("DB_LOCATION", ConnectionUtility.switchDBUrl);
        try {
            File temp = File.createTempFile("setupwizard", ".config");
            temp.deleteOnExit();
            properties.store(new FileOutputStream(temp), "SETUP WIZARD PROPERTIES");
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", temp.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Vector getFreePortsForSwitch(boolean isSourceSwitch) {
        Iterator FCPortIterator = null;
        Iterator ReferenceSystemIterator = null;
        Vector<String> freePorts = new Vector<String>();
        String switchName = isSourceSwitch ? ConnectionUtility.switchName : ConnectionUtility.deviceName;
        try {
            List switchFCClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SwitchFCPort");
            List referenceClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Switch");
            sanPClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SANProtocolEndPoint");
            ReferenceSystemIterator = referenceClassList.iterator();
            FCPortIterator = switchFCClassList.iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<CIMInstance> allPortList = new ArrayList<CIMInstance>();
        while (ReferenceSystemIterator.hasNext()) {
            CIMInstance switchInst = (CIMInstance)ReferenceSystemIterator.next();
            String elementName = switchInst.getProperty("ElementName").getValue().getValue().toString();
            if (!elementName.equals(switchName)) continue;
            CIMValue name = switchInst.getProperty("Name").getValue();
            while (FCPortIterator.hasNext()) {
                CIMInstance portInst = (CIMInstance)FCPortIterator.next();
                CIMValue systemName = portInst.getProperty("SystemName").getValue();
                if (!name.equals((Object)systemName)) continue;
                allPortList.add(portInst);
            }
            break block2;
        }
        Iterator portIterator = allPortList.iterator();
        while (portIterator.hasNext()) {
            boolean isPortBusy = false;
            CIMInstance inst1 = (CIMInstance)portIterator.next();
            CIMValue switchFCDeviceId = inst1.getProperty("DeviceID").getValue();
            Iterator SANProtocolIterator = sanPClassList.iterator();
            while (SANProtocolIterator.hasNext()) {
                CIMInstance inst2 = (CIMInstance)SANProtocolIterator.next();
                CIMValue sanPName = inst2.getProperty("Name").getValue();
                if (!sanPName.equals((Object)switchFCDeviceId)) continue;
                isPortBusy = true;
                break;
            }
            if (isPortBusy) continue;
            String portNo = inst1.getProperty("PortNumber").getValue().getValue().toString();
            String portWWN = inst1.getProperty("PermanentAddress").getValue().getValue().toString();
            freePorts.add("" + portNo + " (" + portWWN + ")");
        }
        return freePorts;
    }

    public static Vector enumerateSwitchNames() {
        Object switchList = null;
        Vector<String> switchVector = new Vector<String>();
        switchVector.add("");
        return switchVector;
    }

    public static Vector enumerateSwitchName(String fabricId) {
        Vector temp = null;
        return temp;
    }

    public static Vector enumerateSwitchNames(String fabricName) {
        Object switchList = null;
        Vector<String> switchVector = new Vector<String>();
        switchVector.add("");
        List switchInFabricList = null;
        try {
            switchInFabricList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SwitchInFabric");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator iterator = switchInFabricList.iterator();
        while (iterator.hasNext()) {
            CIMInstance inst = (CIMInstance)iterator.next();
            String fabricOpath = inst.getProperty("GroupComponent").getValue().getValue().toString();
            if (!fabricOpath.equals(fabricName)) continue;
            CIMObjectPath switchOP = new CIMObjectPath(inst.getProperty("PartComponent").getValue().getValue().toString());
            String switchID = switchOP.getKey("Name").getValue().getValue().toString();
            String switchName = (String)switchNameIDMap.get(switchID);
            logger.info("Switch available: " + switchName);
            switchVector.add(switchName);
        }
        return switchVector;
    }

    public static Vector enumerateFabric() {
        List fabricList = null;
        Vector<CIMObjectPath> fabricVector = new Vector<CIMObjectPath>();
        try {
            fabricList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Fabric");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator iter = fabricList.iterator();
        while (iter.hasNext()) {
            CIMInstance inst = (CIMInstance)iter.next();
            fabricVector.add(inst.getObjectPath());
        }
        return fabricVector;
    }

    public static List getSANProtocolEndPointFromSwitch() {
        return sanPClassList;
    }

    private static void createSwitchIDMap() {
        switchNameIDMap.clear();
        try {
            List switchList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Switch");
            Iterator iter = switchList.iterator();
            while (iter.hasNext()) {
                CIMInstance inst = (CIMInstance)iter.next();
                String switchId = inst.getProperty("Name").getValue().getValue().toString();
                String switchName = inst.getProperty("ElementName").getValue().getValue().toString();
                switchNameIDMap.put(switchId, switchName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getDeviceConnectData() {
        SwitchDBClient.createSwitchIDMap();
        Vector fabricObjectPaths = SwitchDBClient.enumerateFabric();
        Iterator iter = fabricObjectPaths.iterator();
        fabricNames.removeAllElements();
        fabricMap.clear();
        while (iter.hasNext()) {
            CIMObjectPath fabricOp = (CIMObjectPath)iter.next();
            String strFabricOp = fabricOp.toString();
            Vector switchesInfabric = SwitchDBClient.enumerateSwitchNames(strFabricOp);
            String strFabricName = fabricOp.getKey("Name").getValue().getValue().toString();
            fabricMap.put(strFabricName, switchesInfabric);
            fabricNames.add(strFabricName);
        }
    }

    static {
        fabricMap = new HashMap();
        switchNameIDMap = new HashMap();
        logger = Logger.getLogger(SwitchDBClient.class.getName());
        fabricNames = new Vector();
    }
}

