/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.SwitchDBClient;

public class TargetDeviceDBClient {
    private static Connection connection;
    public static String storageDeviceCategory;
    private static Map DeviceTypeMap;
    private static Logger logger;

    private static List getAllPortsForSelectedDevice() {
        Iterator FCPortIterator = null;
        Iterator ReferenceSystemIterator = null;
        try {
            List otherFCClassList = null;
            List referenceClassList = null;
            if (storageDeviceCategory.equals("DS4K")) {
                otherFCClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_FCPort");
                referenceClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_StorageSystem");
            } else if (storageDeviceCategory.equals("DS6K")) {
                otherFCClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_FCPort");
                referenceClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_StorageSystem");
            }
            FCPortIterator = otherFCClassList.iterator();
            ReferenceSystemIterator = referenceClassList.iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<CIMInstance> allPortList = new ArrayList<CIMInstance>();
        while (ReferenceSystemIterator.hasNext()) {
            CIMInstance systemInst = (CIMInstance)ReferenceSystemIterator.next();
            CIMValue deviceName = systemInst.getProperty("Name").getValue();
            String strDeviceName = ConnectionUtility.deviceName.split("_")[1];
            if (!deviceName.getValue().toString().equalsIgnoreCase(strDeviceName)) continue;
            while (FCPortIterator.hasNext()) {
                CIMInstance fcPortInst = (CIMInstance)FCPortIterator.next();
                CIMValue systemName = fcPortInst.getProperty("SystemName").getValue();
                if (!deviceName.equals((Object)systemName)) continue;
                allPortList.add(fcPortInst);
            }
            break block2;
        }
        return allPortList;
    }

    public static void configDBForTargetDevice() {
        String url = ConnectionUtility.targetDevcieDBUrl;
        String name = ConnectionUtility.targetDevcieDBName;
        String uid = ConnectionUtility.targetDevcieDBUserid;
        String pwd = ConnectionUtility.targetDevcieDBPassword;
        if (pwd.equals("") || uid.equals("")) {
            String DB_URL = "jdbc:db2:" + name;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                connection = DriverManager.getConnection(DB_URL);
            }
            catch (ClassNotFoundException e) {
                logger.severe("Exception in DB Configuration: " + e);
            }
            catch (SQLException e) {
                logger.severe("SQLException in DB Configuration: " + e);
            }
            logger.info("Target Device DB Configured with DB URL: " + DB_URL);
        } else {
            String DB_URL = "jdbc:db2://" + url + ":50000/" + name;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                connection = DriverManager.getConnection(DB_URL, uid, pwd);
            }
            catch (ClassNotFoundException e) {
                logger.severe("Exception in DB COnfiguration: " + e);
            }
            catch (SQLException e) {
                logger.severe("Exception in DB COnfiguration: " + e);
            }
            logger.info("Target Device DB Configured for DB URL: " + DB_URL);
        }
    }

    private static String getDeviceType() {
        String strDevice = null;
        String deviceSelected = ConnectionUtility.deviceName;
        strDevice = (String)DeviceTypeMap.get(deviceSelected);
        return strDevice;
    }

    public static Vector getFreePortsForSelectedDevice() {
        storageDeviceCategory = TargetDeviceDBClient.getDeviceType();
        Iterator SANProtocolIterator = null;
        List sanPClassList = new ArrayList();
        Vector<String> freePorts = new Vector<String>();
        try {
            sanPClassList = SwitchDBClient.getSANProtocolEndPointFromSwitch();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator FCPortIterator = TargetDeviceDBClient.getAllPortsForSelectedDevice().iterator();
        while (FCPortIterator.hasNext()) {
            boolean isPortBusy = false;
            CIMInstance inst1 = (CIMInstance)FCPortIterator.next();
            CIMValue otherFCDeviceId = inst1.getProperty("DeviceID").getValue();
            SANProtocolIterator = sanPClassList.iterator();
            while (SANProtocolIterator.hasNext()) {
                CIMInstance inst2 = (CIMInstance)SANProtocolIterator.next();
                CIMValue sanPName = inst2.getProperty("Name").getValue();
                if (!sanPName.equals((Object)otherFCDeviceId)) continue;
                isPortBusy = true;
                break;
            }
            if (isPortBusy) continue;
            String portNo = inst1.getProperty("PortNumber").getValue().getValue().toString();
            String portWWN = inst1.getProperty("PermanentAddress").getValue().getValue().toString();
            freePorts.add("" + portNo + " (" + portWWN + ")");
        }
        return freePorts;
    }

    public static Vector enumerateStorageNames() {
        String targetDeviceName;
        CIMInstance inst;
        List targetDevice = null;
        Vector<String> deviceVector = new Vector<String>();
        try {
            targetDevice = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_StorageSystem");
        }
        catch (Exception e) {
            logger.severe("Error in Enumerating: " + e);
        }
        Iterator iterator = targetDevice.iterator();
        while (iterator.hasNext()) {
            inst = (CIMInstance)iterator.next();
            String targetDeviceElementName = inst.getProperty("ElementName").getValue().getValue().toString();
            targetDeviceName = inst.getProperty("Name").getValue().getValue().toString();
            deviceVector.add(targetDeviceElementName + "_" + targetDeviceName);
            DeviceTypeMap.put(targetDeviceElementName + "_" + targetDeviceName, "DS4K");
        }
        try {
            targetDevice = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_StorageSystem");
        }
        catch (Exception e) {
            logger.severe("Error in Enumerating: " + e);
        }
        iterator = targetDevice.iterator();
        while (iterator.hasNext()) {
            inst = (CIMInstance)iterator.next();
            String targetdeviceElementName = inst.getProperty("ElementName").getValue().getValue().toString();
            targetdeviceElementName = targetdeviceElementName.equalsIgnoreCase("IBM TotalStorage DS8000") ? "DS8K" : "DS6K";
            targetDeviceName = inst.getProperty("Name").getValue().getValue().toString();
            deviceVector.add(targetdeviceElementName + "_" + targetDeviceName);
            DeviceTypeMap.put(targetdeviceElementName + "_" + targetDeviceName, "DS6K");
        }
        return deviceVector;
    }

    static {
        DeviceTypeMap = new HashMap();
        logger = Logger.getLogger(TargetDeviceDBClient.class.getName());
    }
}

