/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.ExpressionParser;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimPropertyPreSuf;
import org.eclipse.aperi.simulator.cimom.common.generator.SimRandomProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimReferProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimValue;

public class InstanceCreator {
    private String namespace;
    private Properties confProperties;
    private int count = 0;

    public InstanceCreator() {
    }

    public InstanceCreator(String nameSpace) {
        this.namespace = nameSpace;
    }

    public CIMInstance createAssociationInstance(SimClass simClass, CIMInstance antecedent, CIMInstance dependent) {
        CIMObjectPath path1 = this.getObjectPath(antecedent, ((SimAssociationClass)simClass).getAntecedentNS());
        CIMObjectPath path2 = this.getObjectPath(dependent, ((SimAssociationClass)simClass).getDependentNS());
        return this.createAssociationInstance(simClass, path1, path2);
    }

    public CIMInstance createAssociationInstance(SimClass simClass, CIMObjectPath path1, CIMObjectPath path2) {
        CIMInstance instance = new CIMInstance();
        instance.setClassName(simClass.getName());
        instance.setName(simClass.getName());
        List properties = simClass.getProperties();
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty cimProperty = new CIMProperty(((SimAssociationClass)simClass).getAntecedentName());
        cimProperty.setName(((SimAssociationClass)simClass).getAntecedentName());
        cimProperty.setType(new CIMDataType(((SimAssociationClass)simClass).getAntecedentClassName()));
        path1.setNameSpace(((SimAssociationClass)simClass).getAntecedentNS());
        cimProperty.setValue(new CIMValue((Object)path1));
        cimProperty.setKey(((SimAssociationClass)simClass).isAntecedentKey());
        v.add(cimProperty);
        cimProperty = new CIMProperty(((SimAssociationClass)simClass).getDependentName());
        cimProperty.setName(((SimAssociationClass)simClass).getDependentName());
        CIMDataType dataType = new CIMDataType(((SimAssociationClass)simClass).getDependentClassName());
        cimProperty.setType(dataType);
        path2.setNameSpace(((SimAssociationClass)simClass).getDependentNS());
        cimProperty.setValue(new CIMValue((Object)path2));
        cimProperty.setKey(((SimAssociationClass)simClass).isDependentKey());
        v.add(cimProperty);
        for (int i = 0; i < properties.size(); ++i) {
            SimProperty property = (SimProperty)properties.get(i);
            cimProperty = new CIMProperty(property.getName());
            cimProperty.setName(property.getName());
            cimProperty.setType(property.getCIMDataType());
            this.setPropertyValue(cimProperty, property.getValue());
            cimProperty.setKey(property.isKey());
            v.add(cimProperty);
        }
        instance.setProperties(v);
        this.setObjectPath(instance, simClass.getNamespace());
        System.out.println("Create  association instance : " + ++this.count);
        return instance;
    }

    public List createAssociationInstances(SimClass simClass, CIMInstance antecedent, Object[] dependents) {
        ArrayList<CIMInstance> instanceList = new ArrayList<CIMInstance>();
        for (int i = 0; i < dependents.length; ++i) {
            instanceList.add(this.createAssociationInstance(simClass, antecedent, (CIMInstance)dependents[i]));
        }
        return instanceList;
    }

    public List createAssociationInstances(SimClass simClass, Object[] antecedents, CIMInstance dependent) {
        ArrayList<CIMInstance> instanceList = new ArrayList<CIMInstance>();
        for (int i = 0; i < antecedents.length; ++i) {
            instanceList.add(this.createAssociationInstance(simClass, (CIMInstance)antecedents[i], dependent));
        }
        return instanceList;
    }

    public List createAssociationInstances(SimClass simClass, Object[] antecedents, Object[] dependents) {
        ArrayList<CIMInstance> instanceList = new ArrayList<CIMInstance>();
        if (antecedents.length != dependents.length) {
            return null;
        }
        for (int i = 0; i < antecedents.length; ++i) {
            instanceList.add(this.createAssociationInstance(simClass, (CIMInstance)antecedents[i], (CIMInstance)dependents[i]));
        }
        return instanceList;
    }

    public List createInstances(SimClass simClass, Map instanceMap) {
        ArrayList<CIMInstance> instanceList = new ArrayList<CIMInstance>();
        int noi = simClass.getNumberOfInstances();
        for (int i = 0; i < noi; ++i) {
            CIMInstance instance = new CIMInstance();
            instance.setName(simClass.getName());
            instance.setClassName(simClass.getName());
            Iterator iter = simClass.getProperties().iterator();
            Vector<CIMProperty> properties = new Vector<CIMProperty>();
            while (iter.hasNext()) {
                SimProperty property = (SimProperty)iter.next();
                CIMProperty cimProperty = new CIMProperty(property.getName());
                cimProperty.setName(property.getName());
                cimProperty.setType(property.getCIMDataType());
                cimProperty.setKey(property.isKey());
                Object propertyValue = null;
                if (property.isRefer()) {
                    if (((SimReferProperty)property).isExternal()) {
                        this.setPropertyValue(cimProperty, this.getExternalReferProperty(property, instanceMap, properties, i));
                    } else {
                        this.setPropertyValue(cimProperty, this.getReferProperty(property, properties));
                    }
                } else if (property.isMultiple()) {
                    propertyValue = this.handleMultipleValueProperty(property, i);
                } else if (property.isRandom()) {
                    propertyValue = IDGenerator.getRandomKey(property);
                    propertyValue = SimProperty.getTypedValue(propertyValue, property.getDataType());
                } else {
                    propertyValue = property.isIncremental() ? new Integer(property.getIncremental() + i) : (property.isMultiple() ? property.getValues(i) : property.getValue());
                }
                this.setPropertyValue(cimProperty, propertyValue);
                properties.add(cimProperty);
            }
            instance.setProperties(properties);
            this.setObjectPath(instance, simClass.getNamespace());
            instanceList.add(instance);
        }
        return instanceList;
    }

    public CIMInstance createInstance(SimClass simClass, Map instanceMap) {
        CIMInstance instance = new CIMInstance();
        instance.setName(simClass.getName());
        instance.setClassName(simClass.getName());
        Iterator iter = simClass.getProperties().iterator();
        Vector<CIMProperty> properties = new Vector<CIMProperty>();
        while (iter.hasNext()) {
            SimProperty property = (SimProperty)iter.next();
            CIMProperty cimProperty = new CIMProperty(property.getName());
            cimProperty.setName(property.getName());
            cimProperty.setType(property.getCIMDataType());
            cimProperty.setKey(property.isKey());
            Object propertyValue = null;
            if (property.isRefer()) {
                if (((SimReferProperty)property).isExternal()) {
                    this.setPropertyValue(cimProperty, this.getExternalReferProperty(property, instanceMap, properties, 0));
                } else {
                    this.setPropertyValue(cimProperty, this.getReferProperty(property, properties));
                }
            } else if (property.isMultiple()) {
                propertyValue = this.handleMultipleValueProperty(property, 0);
            } else if (property.isRandom()) {
                propertyValue = IDGenerator.getRandomKey(property);
                propertyValue = SimProperty.getTypedValue(propertyValue, property.getDataType());
            } else {
                propertyValue = property.isIncremental() ? new Integer(property.getIncremental()) : property.getValue();
            }
            this.setPropertyValue(cimProperty, propertyValue);
            properties.add(cimProperty);
        }
        instance.setProperties(properties);
        this.setObjectPath(instance, simClass.getNamespace());
        return instance;
    }

    private String handleMultipleValueProperty(SimProperty property, int instanceCount) {
        StringBuffer buffer = new StringBuffer();
        if (property instanceof SimPropertyPreSuf) {
            buffer.append(((SimPropertyPreSuf)property).getPrefix());
        }
        List values = property.getValues();
        int size = values.size();
        for (int index = 0; index < size; ++index) {
            Object value = values.get(index);
            if (value instanceof SimValue) {
                buffer.append(((SimValue)value).getPrefix());
                if (((SimValue)value).isCurrentDate()) {
                    buffer.append(new Long(System.currentTimeMillis()));
                } else if (((SimValue)value).isConfiguration()) {
                    buffer.append(ExpressionParser.parseConfExp(this.confProperties, ((SimValue)value).getValue()));
                } else if (((SimValue)value).isConfProp()) {
                    buffer.append(this.confProperties.getProperty(((SimValue)value).getValue()));
                } else if (((SimValue)value).isIncremental()) {
                    buffer.append(((SimValue)value).getIncremental() + instanceCount);
                }
                buffer.append(((SimValue)value).getSuffix());
                continue;
            }
            if (property.isRandom()) {
                if (index == 0) continue;
                buffer.append(((SimRandomProperty)property).getSeperator());
                buffer.append(IDGenerator.getRandomKey((String)value));
                continue;
            }
            buffer.append(values.get(instanceCount));
            break;
        }
        if (property instanceof SimPropertyPreSuf) {
            buffer.append(((SimPropertyPreSuf)property).getSuffix());
        }
        return buffer.toString();
    }

    private void setPropertyValue(CIMProperty cimProperty, Object propertyValue) {
        if (null != propertyValue) {
            if (cimProperty.getType().isArrayType()) {
                Vector<Object> propertyValuesVector = new Vector<Object>();
                String[] array = propertyValue.toString().split(",");
                for (int i = 0; i < array.length; ++i) {
                    if (cimProperty.getType().toString().equals("uint8") || cimProperty.getType().equals((Object)"uint8[]")) {
                        try {
                            propertyValuesVector.add(new UnsignedInt8(array[i]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                        }
                    } else if (cimProperty.getType().toString().equals("uint16") || cimProperty.getType().equals((Object)"uint16[]")) {
                        try {
                            propertyValuesVector.add(new UnsignedInt16(array[i]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                        }
                    } else if (cimProperty.getType().toString().equals("uint32") || cimProperty.getType().equals((Object)"uint32[]")) {
                        try {
                            propertyValuesVector.add(new UnsignedInt32(array[i]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                        }
                    } else if (cimProperty.getType().toString().equals("uint64") || cimProperty.getType().equals((Object)"uint64[]")) {
                        try {
                            propertyValuesVector.add(new UnsignedInt64(array[i]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                        }
                    } else if (cimProperty.getType().toString().equals("boolean") || cimProperty.getType().toString().equals("boolean[]")) {
                        propertyValuesVector.add(new Boolean(array[i]));
                        continue;
                    }
                    propertyValuesVector.add(array[i]);
                }
                cimProperty.setValue(new CIMValue(propertyValuesVector));
            } else {
                Object finalValue = null;
                if (propertyValue instanceof SimValue) {
                    if (((SimValue)propertyValue).isCurrentDate()) {
                        finalValue = new Long(System.currentTimeMillis());
                    } else if (((SimValue)propertyValue).isConfiguration()) {
                        finalValue = new Integer(ExpressionParser.parseConfExp(this.confProperties, ((SimValue)propertyValue).getValue()));
                    } else if (((SimValue)propertyValue).isConfProp()) {
                        finalValue = this.confProperties.getProperty(((SimValue)propertyValue).getValue());
                        finalValue = SimProperty.getTypedValue(finalValue, cimProperty.getType().toString());
                    }
                } else {
                    finalValue = propertyValue;
                }
                cimProperty.setValue(new CIMValue(finalValue));
            }
        }
    }

    private String getReferProperty(SimProperty referProperty, Vector properties) {
        String newValue;
        if (referProperty.isMultiple()) {
            List valuesList = referProperty.getValues();
            Iterator iter = valuesList.iterator();
            StringBuffer buffer = new StringBuffer();
            while (iter.hasNext()) {
                SimValue value = (SimValue)iter.next();
                String name = value.getValue();
                buffer.append(value.getPrefix());
                buffer.append(this.getPropertyValue(properties, name));
                buffer.append(value.getSuffix());
            }
            newValue = buffer.toString();
        } else {
            String name = ((SimReferProperty)referProperty).getRefersProperty();
            newValue = ((SimPropertyPreSuf)referProperty).getPrefix() + this.getPropertyValue(properties, name) + ((SimPropertyPreSuf)referProperty).getSuffix();
        }
        return newValue;
    }

    private String getExternalReferProperty(SimProperty referProperty, Map instanceMap, Vector properties, int index) {
        String derivedValue = null;
        if (referProperty.isMultiple()) {
            List valuesList = referProperty.getValues();
            Iterator iter = valuesList.iterator();
            StringBuffer buffer = new StringBuffer();
            while (iter.hasNext()) {
                SimValue value = (SimValue)iter.next();
                buffer.append(value.getPrefix());
                if (value.isExternal()) {
                    if (referProperty.isRandom()) {
                        buffer.append(this.getExternalPropertyValue(value.getExternal(), value.getValue(), instanceMap, -1));
                    } else {
                        buffer.append(this.getExternalPropertyValue(value.getExternal(), value.getValue(), instanceMap, index));
                    }
                } else {
                    buffer.append(this.getPropertyValue(properties, value.getValue()));
                }
                buffer.append(value.getSuffix());
            }
            derivedValue = buffer.toString();
        } else {
            String propertyName = ((SimReferProperty)referProperty).getRefersProperty();
            String className = ((SimReferProperty)referProperty).getExternalClassName();
            Object externalPropertyValue = referProperty.isRandom() ? this.getExternalPropertyValue(className, propertyName, instanceMap, -1) : this.getExternalPropertyValue(className, propertyName, instanceMap, index);
            derivedValue = ((SimPropertyPreSuf)referProperty).getPrefix() + externalPropertyValue + ((SimPropertyPreSuf)referProperty).getSuffix();
        }
        return derivedValue;
    }

    private Object getPropertyValue(Vector properties, String name) {
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            CIMProperty property = (CIMProperty)properties.get(i);
            if (!property.getName().equals(name)) continue;
            Object value = property.getValue().getValue();
            return value;
        }
        return null;
    }

    private Object getExternalPropertyValue(String className, String propertyName, Map instanceMap, int index) {
        CIMProperty externalProperty;
        Object referenceInstance = instanceMap.get(this.namespace + ":" + className);
        if (referenceInstance instanceof CIMInstance) {
            externalProperty = ((CIMInstance)referenceInstance).getProperty(propertyName);
        } else if (index == -1) {
            int i = new Random().nextInt(((List)referenceInstance).size());
            externalProperty = ((CIMInstance)((List)referenceInstance).get(i)).getProperty(propertyName);
        } else {
            externalProperty = ((CIMInstance)((List)referenceInstance).get(index)).getProperty(propertyName);
        }
        return externalProperty.getValue().getValue();
    }

    private void setObjectPath(CIMInstance instance, String ns) {
        CIMObjectPath objectPath = new CIMObjectPath();
        objectPath.setObjectName(instance.getClassName());
        objectPath.setNameSpace(ns);
        objectPath.setKeys(instance.getKeys());
        instance.setObjectPath(objectPath);
    }

    private CIMObjectPath getObjectPath(CIMInstance instance, String ns) {
        CIMObjectPath cimOP = null;
        if (instance != null) {
            cimOP = instance.getObjectPath();
            cimOP.setNameSpace(ns);
            cimOP.setKeys(instance.getKeys());
        }
        return cimOP;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Properties getConfProperties() {
        return this.confProperties;
    }

    public void setConfProperties(Properties confProperties) {
        this.confProperties = confProperties;
    }

    public CIMInstance createDefaultInstance(SimClass simClass) {
        CIMInstance instance = new CIMInstance();
        instance.setName(simClass.getName());
        instance.setClassName(simClass.getName());
        Iterator iter = simClass.getProperties().iterator();
        Vector<CIMProperty> properties = new Vector<CIMProperty>();
        while (iter.hasNext()) {
            SimProperty property = (SimProperty)iter.next();
            CIMProperty cimProperty = new CIMProperty(property.getName());
            cimProperty.setName(property.getName());
            cimProperty.setType(property.getCIMDataType());
            cimProperty.setKey(property.isKey());
            Object propertyValue = null;
            if (property.isRandom() && !property.isRefer()) {
                propertyValue = IDGenerator.getRandomKey(property);
                propertyValue = SimProperty.getTypedValue(propertyValue, property.getDataType());
            } else {
                propertyValue = property.isIncremental() ? new Integer(property.getIncremental()) : property.getValue();
            }
            this.setPropertyValue(cimProperty, propertyValue);
            properties.add(cimProperty);
        }
        instance.setProperties(properties);
        this.setObjectPath(instance, simClass.getNamespace());
        return instance;
    }
}

