/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.security.Principal;
import java.util.Enumeration;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.connection.SourceConnection;

public class SourceCIMConnection
implements SourceConnection {
    private CIMClient cimClient;
    private CIMNameSpace cimNamespace;
    private UserPrincipal principal;
    private PasswordCredential credential;
    private String HostUrl;
    private String NameSpace;
    private String Protocol;
    private String UserName;
    private String PassWord;
    private String Port;

    private void initArguments() {
    }

    public void init() {
        this.connect();
    }

    public void connect() {
        this.initArguments();
        try {
            if (this.HostUrl != null && this.NameSpace != null) {
                try {
                    this.cimNamespace = new CIMNameSpace(this.Protocol + "://" + this.HostUrl + ":" + this.Port, this.NameSpace);
                    if (this.UserName != null) {
                        this.principal = new UserPrincipal(this.UserName);
                    }
                    if (this.PassWord != null) {
                        this.credential = new PasswordCredential(this.PassWord);
                    }
                    this.cimClient = new CIMClient(this.cimNamespace, (Principal)this.principal, (Object)this.credential);
                    System.out.println("CIMOM connection successful");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Unable To Connect to CIMOM [" + this.HostUrl + "]" + e.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CIMValue getPortWWN(int srcPort, String systemName) throws Exception {
        CIMInstance instance = null;
        boolean flag = false;
        CIMObjectPath oPath = new CIMObjectPath("Brocade_SwitchFCPort");
        Enumeration classList = this.cimClient.enumerateInstances(oPath, true, false, true);
        while (classList.hasMoreElements()) {
            CIMValue portNo;
            instance = (CIMInstance)classList.nextElement();
            CIMValue systemname = instance.getProperty("ElementName").getValue();
            if (!systemname.getValue().equals(systemName) || Integer.parseInt((portNo = instance.getProperty("PortNumber").getValue()).toString()) != srcPort) continue;
            flag = true;
            break;
        }
        if (flag) {
            CIMValue PortWWN = instance.getProperty("DeviceID").getValue();
            return PortWWN;
        }
        return null;
    }

    public CIMInstance getInstance(String className, String propName, CIMValue propValue) throws Exception {
        CIMValue resValue;
        CIMInstance resultInst = null;
        CIMObjectPath oPath = new CIMObjectPath(className);
        Enumeration classList = this.cimClient.enumerateInstances(oPath, true, false, true);
        while (classList.hasMoreElements() && !(resValue = (resultInst = (CIMInstance)classList.nextElement()).getProperty(propName).getValue()).equals((Object)propValue)) {
        }
        return resultInst;
    }

    public CIMValue getFabricId(String switchName) throws Exception {
        CIMObjectPath oPath = new CIMObjectPath("Brocade_Switch");
        Enumeration switchList = this.cimClient.enumerateInstances(oPath, true, false, true);
        CIMValue fabricId = null;
        while (switchList.hasMoreElements()) {
            CIMInstance switchInst = (CIMInstance)switchList.nextElement();
            if (!switchInst.getProperty("ElementName").getValue().getValue().equals(switchName)) continue;
            fabricId = switchInst.getProperty("Name").getValue();
            break;
        }
        return fabricId;
    }
}

