/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.ClassXMLParser;
import org.eclipse.aperi.simulator.cimom.common.generator.InstanceCreator;
import org.eclipse.aperi.simulator.cimom.common.generator.ParserRespose;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;

public final class DS6kExtrinsicMethods {
    private static final String NAMESPACE_ROOT_IBM = "/root/ibm";
    private static final String CLASS_IBMTSESS_STORAGE_SYSTEM = "IBMTSESS_StorageSystem";
    private static final String CLASS_IBMTSESS_PRIMORDIAL_STORAGE_POOL = "IBMTSESS_PrimordialStoragePool";
    private static final String DS6K_XML_FILE_PATH = "XML\\Storage\\IBM\\DS6K\\DS6K_Root_IBM.xml";
    private static final String CLASS_IBMTSESS_STORAGE_VOLUME = "IBMTSESS_Volume";
    private static final String CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL = "IBMTSESS_AllocatedFromStoragePool";
    private static final String CLASS_IBMTSESS_BASED_ON = "IBMTSESS_BasedOn";
    private static final String CLASS_IBMTSESS_STORAGE_POOL = "IBMTSESS_VolumeSpace";
    private static final String CLASS_IBMTSESS_COMPONENT = "IBMTSESS_Component";
    private static final String CLASS_IBMTSESS_STORAGE_EXTENT = "IBMTSESS_StorageExtent";
    private static final String CLASS_IBMTSESS_STORAGE_CAPABILITIES = "IBMTSESS_StorageCapabilities";
    private static final String CLASS_IBMTSESS_ELEMENT_CAPABILITIES = "IBMTSESS_ElementCapabilities";
    private static final String CLASS_IBMTSESS_HOSTED_STORAGE_POOL = "IBMTSESS_HostedStoragePool";

    public static CIMValue createOrModifyElementFromStoragePool(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (CreateOrModifyElementFromStoragePool) Called");
        try {
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            Iterator iter = storageSystemsOPs.iterator();
            CIMObjectPath storageSystemOp = null;
            String requiredSystemID = (String)op.getKey("SystemName").getValue().getValue();
            while (iter.hasNext()) {
                CIMObjectPath objectPath = (CIMObjectPath)iter.next();
                String systemName = (String)objectPath.getKey("Name").getValue().getValue();
                if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
                storageSystemOp = objectPath;
                break;
            }
            CIMObjectPath storagePoolOp = (CIMObjectPath)inArgs[3].getValue().getValue();
            CIMInstance poolInst = dbManager.getInstance(storagePoolOp);
            Boolean isPrimordial = (Boolean)poolInst.getProperty("Primordial").getValue().getValue();
            if (storageSystemOp != null && !isPrimordial.booleanValue()) {
                UnsignedInt64 requestedSize;
                UnsignedInt64 remainingSpace = (UnsignedInt64)poolInst.getProperty("RemainingManagedSpace").getValue().getValue();
                if (remainingSpace.compareTo((Object)(requestedSize = (UnsignedInt64)inArgs[4].getValue().getValue())) == 1) {
                    CIMArgument argumentJob;
                    ClassXMLParser parser = new ClassXMLParser();
                    ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
                    InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                    SimClass simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_STORAGE_VOLUME);
                    CIMInstance volumeInst = instanceCreator.createDefaultInstance(simClass);
                    volumeInst.setProperty("ElementName", inArgs[0].getValue());
                    volumeInst.setProperty("Name", new CIMValue((Object)("0000000000000000000000000000" + volumeInst.getProperty("DeviceID").getValue().getValue()), CIMDataType.getPredefinedType((int)8)));
                    volumeInst.setProperty("SystemName", new CIMValue((Object)requiredSystemID));
                    volumeInst.getObjectPath().getKey("DeviceID").setValue(volumeInst.getProperty("DeviceID").getValue());
                    volumeInst.getObjectPath().getKey("SystemName").setValue(volumeInst.getProperty("SystemName").getValue());
                    float sizeInGb = new Float(requestedSize.toString()).floatValue();
                    volumeInst.setProperty("cap", new CIMValue((Object)new Float(sizeInGb), CIMDataType.getPredefinedType((int)10)));
                    simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_VOLUME);
                    CIMInstance allocatedInstance = instanceCreator.createAssociationInstance(simClass, storagePoolOp, volumeInst.getObjectPath());
                    allocatedInstance.setProperty("SpaceConsumed", new CIMValue((Object)requestedSize));
                    remainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().subtract(requestedSize.bigIntValue()));
                    poolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                    poolInst.setProperty("LogicalFree", new CIMValue((Object)remainingSpace));
                    dbManager.createInstance(volumeInst);
                    dbManager.createInstance(allocatedInstance);
                    dbManager.updateInstance(poolInst.getObjectPath(), poolInst);
                    System.out.println("Volume Creation successful");
                    retValue = new CIMValue((Object)new UnsignedInt16(0));
                    outArgs[0] = argumentJob = new CIMArgument("Job");
                    outArgs[1] = inArgs[4];
                    CIMArgument argument = new CIMArgument("TheElement");
                    argument.setValue(new CIMValue((Object)volumeInst.getObjectPath()));
                    outArgs[2] = argument;
                } else {
                    System.out.println("Remaining space is not sufficient to create the requested volume");
                    retValue = new CIMValue((Object)new UnsignedInt16(8));
                }
            } else {
                System.out.println("Pool supplied is primordial or system path is null");
                retValue = new CIMValue((Object)new UnsignedInt16(4));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static CIMValue createOrModifyStoragePool(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (CreateOrModifyStoragePool) Called");
        try {
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            CIMObjectPath[] extentOps = null;
            UnsignedInt64 requestedSize = null;
            CIMValue elementName = null;
            CIMArgument sizeArg = null;
            for (int i = 0; i < inArgs.length; ++i) {
                if (inArgs[i].getName().equalsIgnoreCase("InExtents")) {
                    Vector extents = new Vector();
                    extents = (Vector)inArgs[i].getValue().getValue();
                    extentOps = new CIMObjectPath[extents.size()];
                    for (int j = 0; j < extents.size(); ++j) {
                        extentOps[j] = new CIMObjectPath((String)extents.get(j));
                    }
                    continue;
                }
                if (inArgs[i].getName().equalsIgnoreCase("Size")) {
                    requestedSize = (UnsignedInt64)inArgs[i].getValue().getValue();
                    sizeArg = inArgs[i];
                    continue;
                }
                if (!inArgs[i].getName().equalsIgnoreCase("ElementName")) continue;
                elementName = inArgs[i].getValue();
            }
            List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            Iterator iter = storageSystemsOPs.iterator();
            CIMObjectPath storageSystemOp = null;
            String requiredSystemID = (String)op.getKey("SystemName").getValue().getValue();
            while (iter.hasNext()) {
                CIMObjectPath objectPath = (CIMObjectPath)iter.next();
                String systemName = (String)objectPath.getKey("Name").getValue().getValue();
                if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
                storageSystemOp = objectPath;
                break;
            }
            if (storageSystemOp != null) {
                String instanceID;
                List primordialInstList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_PRIMORDIAL_STORAGE_POOL);
                iter = primordialInstList.iterator();
                CIMInstance primordialInst = null;
                while (iter.hasNext() && !(instanceID = (String)(primordialInst = (CIMInstance)iter.next()).getObjectPath().getKey("InstanceID").getValue().getValue()).equals(requiredSystemID)) {
                }
                UnsignedInt64 remainingSpace = (UnsignedInt64)primordialInst.getProperty("RemainingManagedSpace").getValue().getValue();
                if (remainingSpace.compareTo((Object)requestedSize) == 1) {
                    CIMArgument argumentJob;
                    ClassXMLParser parser = new ClassXMLParser();
                    ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
                    InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                    SimClass simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_STORAGE_POOL);
                    CIMInstance poolInst = instanceCreator.createDefaultInstance(simClass);
                    poolInst.setProperty("ElementName", elementName);
                    CIMValue instanceId = new CIMValue((Object)(requiredSystemID + "-" + elementName.getValue().toString()), CIMDataType.getPredefinedType((int)8));
                    poolInst.setProperty("InstanceID", instanceId);
                    poolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)requestedSize));
                    poolInst.setProperty("LogicalFree", new CIMValue((Object)requestedSize));
                    poolInst.setProperty("TotalManagedSpace", new CIMValue((Object)requestedSize));
                    poolInst.getObjectPath().getKey("InstanceID").setValue(instanceId);
                    remainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().subtract(requestedSize.bigIntValue()));
                    primordialInst.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                    CIMInstance[] components = new CIMInstance[extentOps.length];
                    simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_COMPONENT);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_EXTENT);
                    for (int i = 0; i < extentOps.length; ++i) {
                        components[i] = instanceCreator.createAssociationInstance(simClass, poolInst.getObjectPath(), extentOps[i]);
                    }
                    List storageCapabilitiest = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_CAPABILITIES);
                    iter = storageCapabilitiest.iterator();
                    CIMInstance storageCapabilitiesInst = null;
                    while (iter.hasNext()) {
                        storageCapabilitiesInst = (CIMInstance)iter.next();
                    }
                    simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_ELEMENT_CAPABILITIES);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_CAPABILITIES);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    CIMInstance elementCapabilities = instanceCreator.createAssociationInstance(simClass, storageCapabilitiesInst.getObjectPath(), poolInst.getObjectPath());
                    simClass = (SimClass)response.getClassMap().get(CLASS_IBMTSESS_HOSTED_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_SYSTEM);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    CIMInstance hostedPool = instanceCreator.createAssociationInstance(simClass, storageSystemOp, poolInst.getObjectPath());
                    dbManager.createInstance(poolInst);
                    dbManager.updateInstance(primordialInst.getObjectPath(), primordialInst);
                    for (int i = 0; i < components.length; ++i) {
                        dbManager.createInstance(components[i]);
                    }
                    dbManager.createInstance(elementCapabilities);
                    dbManager.createInstance(hostedPool);
                    outArgs[0] = argumentJob = new CIMArgument("Job");
                    CIMArgument argumentPool = new CIMArgument("Pool");
                    argumentPool.setValue(new CIMValue((Object)poolInst.getObjectPath()));
                    outArgs[1] = argumentPool;
                    outArgs[2] = sizeArg;
                    retValue = new CIMValue((Object)new UnsignedInt16(0));
                    System.out.println("Storage Pool Created Successfully");
                } else {
                    retValue = new CIMValue((Object)new UnsignedInt16(8));
                    System.out.println("Requested Size is not available for pool creation");
                }
            } else {
                retValue = new CIMValue((Object)new UnsignedInt16(4));
                System.out.println("Specified Storage System could not be found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static CIMValue createSetting(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (CreateSetting) Called");
        retValue = new CIMValue((Object)new UnsignedInt16(2));
        outArgs[0] = null;
        return retValue;
    }

    public static CIMValue deleteStoragePool(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (DeleteStoragePool) Called");
        try {
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            boolean hasVolume = false;
            CIMObjectPath poolToDeleteOp = (CIMObjectPath)inArgs[0].getValue().getValue();
            CIMInstance poolToDeleteInst = dbManager.getInstance(poolToDeleteOp);
            CIMObjectPath storageSystemOp = null;
            List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            Iterator iter = storageSystemsOPs.iterator();
            String requiredSystemID = (String)op.getKey("SystemName").getValue().getValue();
            while (iter.hasNext()) {
                CIMObjectPath objectPath = (CIMObjectPath)iter.next();
                String systemName = (String)objectPath.getKey("Name").getValue().getValue();
                if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
                storageSystemOp = objectPath;
                break;
            }
            if (storageSystemOp != null && poolToDeleteInst != null) {
                CIMObjectPath[] assoList = new CIMObjectPath[]{new CIMObjectPath(CLASS_IBMTSESS_COMPONENT, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_ELEMENT_CAPABILITIES, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_HOSTED_STORAGE_POOL, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL, NAMESPACE_ROOT_IBM)};
                ArrayList references = new ArrayList();
                for (int i = 0; i < 4; ++i) {
                    List ref = dbManager.references(assoList[i], poolToDeleteOp);
                    references.addAll(ref);
                }
                iter = references.iterator();
                while (iter.hasNext()) {
                    CIMInstance inst = (CIMInstance)iter.next();
                    if (!inst.getClassName().equalsIgnoreCase(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL)) continue;
                    hasVolume = true;
                }
                if (!hasVolume) {
                    CIMArgument argumentJob;
                    String instanceID;
                    iter = references.iterator();
                    while (iter.hasNext()) {
                        CIMInstance inst = (CIMInstance)iter.next();
                        String className = inst.getClassName();
                        if (!className.equalsIgnoreCase(CLASS_IBMTSESS_COMPONENT) && !className.equalsIgnoreCase(CLASS_IBMTSESS_ELEMENT_CAPABILITIES) && !className.equalsIgnoreCase(CLASS_IBMTSESS_HOSTED_STORAGE_POOL)) continue;
                        dbManager.deleteInstance(inst.getObjectPath());
                    }
                    List primordialInstList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_PRIMORDIAL_STORAGE_POOL);
                    iter = primordialInstList.iterator();
                    CIMInstance primordialInst = null;
                    while (iter.hasNext() && !(instanceID = (String)(primordialInst = (CIMInstance)iter.next()).getObjectPath().getKey("InstanceID").getValue().getValue()).equals(requiredSystemID)) {
                    }
                    UnsignedInt64 poolSize = (UnsignedInt64)poolToDeleteInst.getProperty("TotalManagedSpace").getValue().getValue();
                    UnsignedInt64 priRemainingSpace = (UnsignedInt64)primordialInst.getProperty("RemainingManagedSpace").getValue().getValue();
                    priRemainingSpace = new UnsignedInt64(priRemainingSpace.bigIntValue().add(poolSize.bigIntValue()));
                    primordialInst.setProperty("RemainingManagedSpace", new CIMValue((Object)priRemainingSpace));
                    dbManager.updateInstance(primordialInst.getObjectPath(), primordialInst);
                    dbManager.deleteInstance(poolToDeleteOp);
                    outArgs[0] = argumentJob = new CIMArgument("Job");
                    retValue = new CIMValue((Object)new UnsignedInt16(0));
                    System.out.println("Storage Pool deleted successfully");
                } else {
                    retValue = new CIMValue((Object)new UnsignedInt16(6));
                    System.out.println("Pool to be deleted in in use");
                }
            } else {
                retValue = new CIMValue((Object)new UnsignedInt16(4));
                System.out.println("Storage System or Pool does not exist");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static CIMValue returnToStoragePool(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (ReturnToStoragePool) Called");
        try {
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            CIMObjectPath volToDeleteOp = (CIMObjectPath)inArgs[0].getValue().getValue();
            CIMInstance volToDeleteInst = dbManager.getInstance(volToDeleteOp);
            CIMObjectPath storageSystemOp = null;
            CIMObjectPath parentPoolOp = null;
            CIMInstance parentPoolInst = null;
            List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            Iterator iter = storageSystemsOPs.iterator();
            String requiredSystemID = (String)op.getKey("SystemName").getValue().getValue();
            while (iter.hasNext()) {
                CIMObjectPath objectPath = (CIMObjectPath)iter.next();
                String systemName = (String)objectPath.getKey("Name").getValue().getValue();
                if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
                storageSystemOp = objectPath;
                break;
            }
            if (storageSystemOp != null && volToDeleteInst != null) {
                CIMArgument argumentJob;
                CIMObjectPath[] assoList = new CIMObjectPath[]{new CIMObjectPath(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_BASED_ON, NAMESPACE_ROOT_IBM)};
                ArrayList references = new ArrayList();
                for (int i = 0; i < 2; ++i) {
                    List ref = dbManager.references(assoList[i], volToDeleteOp);
                    references.addAll(ref);
                }
                iter = references.iterator();
                while (iter.hasNext()) {
                    CIMInstance inst = (CIMInstance)iter.next();
                    if (inst.getClassName().equalsIgnoreCase(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL)) {
                        Vector keys = inst.getKeys();
                        Iterator keyIter = keys.iterator();
                        while (keyIter.hasNext()) {
                            CIMProperty prop = (CIMProperty)keyIter.next();
                            CIMObjectPath keyOp = (CIMObjectPath)prop.getValue().getValue();
                            if (!keyOp.getObjectName().equalsIgnoreCase(CLASS_IBMTSESS_STORAGE_POOL)) continue;
                            parentPoolOp = keyOp;
                        }
                    }
                    dbManager.deleteInstance(inst.getObjectPath());
                }
                parentPoolInst = dbManager.getInstance(parentPoolOp);
                UnsignedInt64 remainingSpace = (UnsignedInt64)parentPoolInst.getProperty("RemainingManagedSpace").getValue().getValue();
                Float volSize = (Float)volToDeleteInst.getProperty("cap").getValue().getValue();
                BigInteger bigInt = new BigInteger(new Long(volSize.longValue()).toString());
                UnsignedInt64 newRemainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().add(bigInt));
                parentPoolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)newRemainingSpace));
                parentPoolInst.setProperty("LogicalFree", new CIMValue((Object)newRemainingSpace));
                dbManager.updateInstance(parentPoolOp, parentPoolInst);
                dbManager.deleteInstance(volToDeleteOp);
                outArgs[0] = argumentJob = new CIMArgument("Job");
                retValue = new CIMValue((Object)new UnsignedInt16(0));
                System.out.println("Volume deleted successfully");
            } else {
                retValue = new CIMValue((Object)new UnsignedInt16(4));
                System.out.println("Storage System or volume does not exist");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static CIMValue getSupportedSizeRange(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (GetSupportedSizeRange) Called");
        try {
            CIMInstance poolInst = DatabaseManager.getDbManager().getInstance(op);
            if (poolInst != null) {
                UnsignedInt64 maxVolSize = (UnsignedInt64)poolInst.getProperty("RemainingManagedSpace").getValue().getValue();
                CIMArgument maxVolSizeArg = new CIMArgument("MaximumVolumeSize");
                maxVolSizeArg.setValue(new CIMValue((Object)maxVolSize, CIMDataType.getPredefinedType((int)6)));
                outArgs[0] = maxVolSizeArg;
                UnsignedInt64 minVolSize = new UnsignedInt64("0");
                CIMArgument minVolSizeArg = new CIMArgument("MinimumVolumeSize");
                minVolSizeArg.setValue(new CIMValue((Object)minVolSize, CIMDataType.getPredefinedType((int)6)));
                outArgs[1] = minVolSizeArg;
                UnsignedInt64 volSizeDivisor = new UnsignedInt64("1024");
                CIMArgument volSizeDivArg = new CIMArgument("VolumeSizeDivisor");
                volSizeDivArg.setValue(new CIMValue((Object)volSizeDivisor, CIMDataType.getPredefinedType((int)6)));
                outArgs[2] = volSizeDivArg;
                retValue = new CIMValue((Object)new UnsignedInt16(0));
            } else {
                retValue = new CIMValue((Object)new UnsignedInt16(32792));
                System.out.println("Invalid Pool");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static CIMValue getSupportedSizes(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (GetSupportedSizes) Called");
        retValue = new CIMValue((Object)new UnsignedInt16(2));
        outArgs[0] = null;
        return retValue;
    }
}

