/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;

public class CIMArgument
extends CIMQualifiableElement
implements Cloneable {
    private CIMValue value;
    private CIMDataType type;

    public CIMArgument() {
    }

    public CIMArgument(String name) {
        super(name);
    }

    public CIMArgument(String name, CIMValue value) {
        super(name);
        this.value = value;
        this.type = value != null ? value.getType() : null;
    }

    public CIMArgument(String name, CIMDataType dataType) {
        super(name);
        this.value = null;
        if (dataType == null) {
            throw new IllegalArgumentException("Illegal argument - data type must not be null");
        }
        this.type = dataType;
    }

    public Object clone() {
        return this.clone(true);
    }

    public Object clone(boolean includeQualifier) {
        CIMArgument clone = new CIMArgument(this.name);
        clone.type = (CIMDataType)this.type.clone();
        clone.value = (CIMValue)this.value.clone();
        if (includeQualifier) {
            for (int i = 0; i < this.qualifiers.size(); ++i) {
                clone.qualifiers.add(((CIMQualifier)this.qualifiers.elementAt(i)).clone());
            }
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMArgument)) {
            return false;
        }
        CIMArgument that = (CIMArgument)o;
        if (!this.qualifiers.equals(that.qualifiers)) {
            return false;
        }
        if (!(this.type == null && that.type == null || this.type != null && this.type.equals(that.type))) {
            return false;
        }
        if (!(this.value == null && that.value == null || this.value != null && this.value.equals(that.value))) {
            return false;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    public int hashCode() {
        return this.qualifiers.hashCode() + (this.type != null ? this.type.hashCode() : 0) + (this.value != null ? this.value.hashCode() : 0) + this.name.hashCode();
    }

    public CIMValue getValue() {
        return this.value;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public void setType(CIMDataType type) {
        if (this.value == null) {
            this.type = type;
        } else if (this.value.getType() != null && this.value.getType().getType() != type.getType()) {
            throw new IllegalArgumentException("Specified data type does not match data type of argument value");
        }
    }

    public void setValue(CIMValue value) {
        if (this.type != null && value != null && value.getType().getType() != this.type.getType()) {
            throw new IllegalArgumentException("value type does not match property type");
        }
        this.value = value;
        if (this.type == null && value != null) {
            this.type = value.getType();
        }
    }

    public String toString() {
        return "CIMArgument(name=" + this.name + ", value=" + this.value + ")";
    }
}

