/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMObject;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMClass
extends CIMObject
implements Serializable,
Cloneable {
    private String superclass = null;
    private Vector allMethods = new Vector(0);
    private CIMObjectPath objectpath;

    public CIMClass() {
    }

    public CIMClass(String className) {
        super(className);
        this.objectpath = new CIMObjectPath(className);
    }

    public CIMClass(CIMObjectPath objectpath) {
        if (objectpath == null) {
            throw new IllegalArgumentException("null object path");
        }
        this.name = objectpath.getObjectName();
        if (this.name == null) {
            throw new IllegalArgumentException("null class name");
        }
        this.objectpath = new CIMObjectPath(this.name);
        this.objectpath.setHost(objectpath.getHost());
        this.objectpath.setNameSpace(objectpath.getNameSpace());
    }

    public void addMethod(CIMMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("null method argument");
        }
        if (this.getAllMethods(method) == null) {
            Utils.addSorted(this.allMethods, method);
        }
    }

    public Object clone() {
        CIMClass that = new CIMClass(this.name);
        that.superclass = this.superclass;
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            that.qualifiers.add(((CIMQualifier)iter.next()).clone());
        }
        iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            that.addProperty((CIMProperty)((CIMProperty)iter.next()).clone());
        }
        iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            that.addMethod((CIMMethod)((CIMMethod)iter.next()).clone());
        }
        return that;
    }

    public int hashCode() {
        return this.allProperties.hashCode() + this.allMethods.hashCode() + this.qualifiers.hashCode() + (this.superclass != null ? this.superclass.hashCode() : 0) + this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMClass)) {
            return false;
        }
        CIMClass that = (CIMClass)o;
        if (!(this.allProperties.equals(that.allProperties) && this.allMethods.equals(that.allMethods) && this.qualifiers.equals(that.qualifiers) && this.objectpath.equals(that.objectpath))) {
            return false;
        }
        if (!(this.superclass != null ? this.superclass.equalsIgnoreCase(that.superclass) : that.superclass == null)) {
            return false;
        }
        return this.name == null ? that.name == null : this.name.equalsIgnoreCase(that.name);
    }

    protected CIMMethod getMethod(CIMMethod methd) {
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(methd.getName())) continue;
            return method;
        }
        return null;
    }

    protected CIMMethod getAllMethods(CIMMethod methd) {
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(methd.getName())) continue;
            return method;
        }
        return null;
    }

    public CIMClass filterProperties(String[] propertyList) {
        CIMClass that = new CIMClass(this.name);
        that.superclass = this.superclass;
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            that.qualifiers.add(((CIMQualifier)iter.next()).clone());
        }
        iter = this.allProperties.iterator();
        block1: while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)((CIMProperty)iter.next()).clone();
            String propName = property.getName();
            for (int i = 0; i < propertyList.length; ++i) {
                if (!propName.equalsIgnoreCase(propertyList[i])) continue;
                that.addProperty(property);
                continue block1;
            }
        }
        iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            that.addMethod((CIMMethod)((CIMMethod)iter.next()).clone());
        }
        return that;
    }

    public Vector getAllMethods() {
        return this.allMethods;
    }

    public CIMMethod getMethod(String name) {
        if (name == null) {
            return null;
        }
        int delimiter = name.indexOf(46);
        if (delimiter > -1) {
            return this.getMethod(name.substring(delimiter + 1), name.substring(0, delimiter));
        }
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(name)) continue;
            String overridingMethod = method.getOverridingMethod();
            if (overridingMethod != null) {
                delimiter = overridingMethod.indexOf(46);
                if (delimiter > -1) {
                    return this.getMethod(overridingMethod.substring(delimiter + 1), overridingMethod.substring(0, delimiter));
                }
                return this.getMethod(overridingMethod);
            }
            return method;
        }
        return null;
    }

    public CIMMethod getMethod(String name, String originClass) {
        if (name == null) {
            return null;
        }
        if (originClass == null || originClass.length() == 0) {
            return this.getMethod(name);
        }
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getName().equalsIgnoreCase(name) || !method.getOriginClass().equalsIgnoreCase(originClass)) continue;
            String overridingMethod = method.getOverridingMethod();
            if (overridingMethod != null) {
                int delimiter = overridingMethod.indexOf(46);
                if (delimiter > -1) {
                    return this.getMethod(overridingMethod.substring(delimiter + 1), overridingMethod.substring(0, delimiter));
                }
                return this.getMethod(overridingMethod);
            }
            return method;
        }
        return null;
    }

    public Vector getMethods() {
        Vector<CIMMethod> methods = new Vector<CIMMethod>();
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (method.getOriginClass() != null) continue;
            methods.add(method);
        }
        return methods;
    }

    public String getSuperClass() {
        return this.superclass;
    }

    public boolean isAssociation() {
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase("Association") || qualifier.getValue() != null && !CIMValue.TRUE.equals(qualifier.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyed() {
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.isKey()) continue;
            return true;
        }
        return false;
    }

    public CIMClass localElements() {
        CIMClass that = new CIMClass(this.name);
        that.setObjectPath((CIMObjectPath)this.getObjectPath().clone());
        that.superclass = this.superclass;
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            CIMMethod method = (CIMMethod)iter.next();
            if (!method.getOriginClass().equalsIgnoreCase(this.name)) continue;
            that.addMethod((CIMMethod)method.clone());
        }
        iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (!property.getOriginClass().equalsIgnoreCase(this.name)) continue;
            that.addProperty((CIMProperty)property.clone());
        }
        iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifiers = (CIMQualifier)iter.next();
            that.qualifiers.add((CIMQualifier)qualifiers.clone());
        }
        return that;
    }

    public CIMInstance newInstance() {
        CIMInstance inst = new CIMInstance();
        inst.setName(this.getName());
        Vector<Object> newProperties = new Vector<Object>();
        for (int i = 0; i < this.allProperties.size(); ++i) {
            CIMProperty property = (CIMProperty)this.allProperties.elementAt(i);
            newProperties.add(property.clone());
        }
        inst.setProperties(newProperties);
        Vector<Object> newQualifiers = new Vector<Object>();
        for (int i = 0; i < this.qualifiers.size(); ++i) {
            CIMQualifier qualifier = (CIMQualifier)this.qualifiers.elementAt(i);
            newQualifiers.add(qualifier.clone());
        }
        inst.setQualifiers(newQualifiers);
        return inst;
    }

    public int numberOfProperties() {
        return this.getProperties().size();
    }

    public int numberOfQualifiers() {
        return this.qualifiers.size();
    }

    public void setSuperClass(String clazz) {
        this.superclass = clazz;
    }

    public void setIsAssociation(boolean association) {
        CIMQualifier associationQualifier = this.getQualifier("Association");
        if (associationQualifier == null && association) {
            Utils.addSorted(this.qualifiers, new CIMQualifier("Association"));
        } else if (associationQualifier != null && !association) {
            this.removeQualifier(associationQualifier.getName());
        }
    }

    public void setIsKeyed(boolean keyed) {
    }

    public void setMethods(Vector methods) {
        if (methods == null) {
            this.allMethods.setSize(0);
        } else {
            this.allMethods.setSize(0);
            Utils.addSorted(this.allMethods, methods);
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name argument");
        }
        super.setName(name);
        if (this.objectpath == null) {
            this.objectpath = new CIMObjectPath(name);
        } else {
            this.objectpath.setObjectName(name);
        }
    }

    public CIMObjectPath getObjectPath() {
        return this.objectpath;
    }

    public void setObjectPath(CIMObjectPath op) {
        if (op == null) {
            throw new IllegalArgumentException("null objectpath argument");
        }
        if (this.objectpath == null) {
            this.objectpath = new CIMObjectPath();
        }
        this.objectpath.setHost(op.getHost());
        this.objectpath.setNameSpace(op.getNameSpace());
        this.setName(op.getObjectName());
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        buf.append(CIMClass.vectorToMOFString(this.qualifiers, false, 1));
        buf.append("\nclass ");
        buf.append(this.getName());
        if (this.superclass != null && this.superclass.length() > 0) {
            buf.append(" : ");
            buf.append(this.superclass);
        }
        buf.append(" {\n");
        if (this.allProperties.size() > 0) {
            buf.append(CIMClass.vectorToMOFString(this.allProperties, true, 0, 0, false));
            buf.append("\n");
        }
        if (this.allMethods.size() > 0) {
            buf.append(CIMClass.vectorToMOFString(this.allMethods, true, 1, 0, false));
        }
        buf.append("};");
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public static void main(String[] args) {
        CIMClass cl1 = new CIMClass("CIM_ComputerSystem");
        CIMMethod m1 = new CIMMethod("AddProperty");
        m1.addQualifier(new CIMQualifier("Overridable"));
        m1.setType(new CIMDataType(5, 32));
        CIMParameter p1 = new CIMParameter("Arg1");
        p1.addQualifier(new CIMQualifier("IN"));
        m1.addParameter(p1);
        System.out.println(cl1);
    }
}

